/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.dto.v1_0.mapper;

import com.liferay.headless.delivery.dto.v1_0.ClassNameReference;
import com.liferay.headless.delivery.dto.v1_0.ClassPKReference;
import com.liferay.headless.delivery.dto.v1_0.CollectionConfig;
import com.liferay.headless.delivery.dto.v1_0.CollectionViewport;
import com.liferay.headless.delivery.dto.v1_0.CollectionViewportDefinition;
import com.liferay.headless.delivery.dto.v1_0.EmptyCollectionConfig;
import com.liferay.headless.delivery.dto.v1_0.PageCollectionDefinition;
import com.liferay.headless.delivery.dto.v1_0.PageElement;
import com.liferay.headless.delivery.internal.dto.v1_0.mapper.BaseStyledLayoutStructureItemMapper;
import com.liferay.headless.delivery.internal.dto.v1_0.mapper.LayoutStructureItemMapper;
import com.liferay.info.list.provider.item.selector.criterion.InfoListProviderItemSelectorReturnType;
import com.liferay.item.selector.criteria.InfoListItemSelectorReturnType;
import com.liferay.layout.responsive.ViewportSize;
import com.liferay.layout.util.structure.CollectionStyledLayoutStructureItem;
import com.liferay.layout.util.structure.LayoutStructureItem;
import com.liferay.layout.util.structure.collection.EmptyCollectionOptions;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;

@Component(service={LayoutStructureItemMapper.class})
public class CollectionLayoutStructureItemMapper
extends BaseStyledLayoutStructureItemMapper {
    @Override
    public String getClassName() {
        return CollectionStyledLayoutStructureItem.class.getName();
    }

    @Override
    public PageElement getPageElement(long groupId, LayoutStructureItem layoutStructureItem, boolean saveInlineContent, boolean saveMappingConfiguration) {
        final CollectionStyledLayoutStructureItem collectionStyledLayoutStructureItem = (CollectionStyledLayoutStructureItem)layoutStructureItem;
        return new PageElement(){
            {
                this.definition = new PageCollectionDefinition(){
                    {
                        this.collectionConfig = CollectionLayoutStructureItemMapper.this._getCollectionConfig(collectionStyledLayoutStructureItem);
                        this.displayAllItems = collectionStyledLayoutStructureItem.isDisplayAllItems();
                        this.displayAllPages = collectionStyledLayoutStructureItem.isDisplayAllPages();
                        this.emptyCollectionConfig = CollectionLayoutStructureItemMapper.this._getEmptyCollectionConfig(collectionStyledLayoutStructureItem);
                        this.listItemStyle = collectionStyledLayoutStructureItem.getListItemStyle();
                        this.listStyle = collectionStyledLayoutStructureItem.getListStyle();
                        this.numberOfColumns = collectionStyledLayoutStructureItem.getNumberOfColumns();
                        this.numberOfItems = collectionStyledLayoutStructureItem.getNumberOfItems();
                        this.numberOfItemsPerPage = collectionStyledLayoutStructureItem.getNumberOfItemsPerPage();
                        this.numberOfPages = collectionStyledLayoutStructureItem.getNumberOfPages();
                        this.paginationType = CollectionLayoutStructureItemMapper.this._getPaginationType(collectionStyledLayoutStructureItem.getPaginationType());
                        this.showAllItems = collectionStyledLayoutStructureItem.isShowAllItems();
                        this.templateKey = collectionStyledLayoutStructureItem.getTemplateKey();
                        this.setCollectionViewports(CollectionLayoutStructureItemMapper.this._getCollectionViewports(collectionStyledLayoutStructureItem));
                        this.setFragmentViewports(() -> CollectionLayoutStructureItemMapper.this.getFragmentViewPorts(collectionStyledLayoutStructureItem.getItemConfigJSONObject()));
                        this.setName(() -> ((CollectionStyledLayoutStructureItem)collectionStyledLayoutStructureItem).getName());
                    }
                };
                this.type = PageElement.Type.COLLECTION;
            }
        };
    }

    private CollectionConfig _getCollectionConfig(CollectionStyledLayoutStructureItem collectionStyledLayoutStructureItem) {
        final JSONObject jsonObject = collectionStyledLayoutStructureItem.getCollectionJSONObject();
        if (jsonObject == null) {
            return null;
        }
        String type = jsonObject.getString("type");
        if (Validator.isNull((String)type)) {
            return null;
        }
        if (Objects.equals(type, InfoListItemSelectorReturnType.class.getName())) {
            return new CollectionConfig(){
                {
                    this.collectionReference = new ClassPKReference(){
                        {
                            this.className = CollectionLayoutStructureItemMapper.this.portal.getClassName((long)jsonObject.getInt("classNameId"));
                            this.classPK = jsonObject.getLong("classPK");
                        }
                    };
                    this.collectionType = CollectionConfig.CollectionType.COLLECTION;
                }
            };
        }
        if (Objects.equals(type, InfoListProviderItemSelectorReturnType.class.getName())) {
            return new CollectionConfig(){
                {
                    this.collectionReference = new ClassNameReference(){
                        {
                            this.className = jsonObject.getString("key");
                        }
                    };
                    this.collectionType = CollectionConfig.CollectionType.COLLECTION_PROVIDER;
                }
            };
        }
        return null;
    }

    private CollectionViewport[] _getCollectionViewports(CollectionStyledLayoutStructureItem collectionStyledLayoutStructureItem) {
        final Map collectionViewportConfigurationJSONObjects = collectionStyledLayoutStructureItem.getViewportConfigurationJSONObjects();
        if (MapUtil.isEmpty((Map)collectionViewportConfigurationJSONObjects)) {
            return null;
        }
        ArrayList<CollectionViewport> collectionViewports = new ArrayList<CollectionViewport>();
        collectionViewports.add(new CollectionViewport(){
            {
                this.collectionViewportDefinition = CollectionLayoutStructureItemMapper.this._toCollectionViewportDefinition(collectionViewportConfigurationJSONObjects, ViewportSize.MOBILE_LANDSCAPE);
                this.id = ViewportSize.MOBILE_LANDSCAPE.getViewportSizeId();
            }
        });
        collectionViewports.add(new CollectionViewport(){
            {
                this.collectionViewportDefinition = CollectionLayoutStructureItemMapper.this._toCollectionViewportDefinition(collectionViewportConfigurationJSONObjects, ViewportSize.PORTRAIT_MOBILE);
                this.id = ViewportSize.PORTRAIT_MOBILE.getViewportSizeId();
            }
        });
        collectionViewports.add(new CollectionViewport(){
            {
                this.collectionViewportDefinition = CollectionLayoutStructureItemMapper.this._toCollectionViewportDefinition(collectionViewportConfigurationJSONObjects, ViewportSize.TABLET);
                this.id = ViewportSize.TABLET.getViewportSizeId();
            }
        });
        return collectionViewports.toArray(new CollectionViewport[0]);
    }

    private EmptyCollectionConfig _getEmptyCollectionConfig(CollectionStyledLayoutStructureItem collectionStyledLayoutStructureItem) {
        final EmptyCollectionOptions emptyCollectionOptions = collectionStyledLayoutStructureItem.getEmptyCollectionOptions();
        if (emptyCollectionOptions == null) {
            return null;
        }
        return new EmptyCollectionConfig(){
            {
                this.setDisplayMessage(() -> ((EmptyCollectionOptions)emptyCollectionOptions).isDisplayMessage());
                this.setMessage_i18n(() -> ((EmptyCollectionOptions)emptyCollectionOptions).getMessage());
            }
        };
    }

    private PageCollectionDefinition.PaginationType _getPaginationType(String paginationType) {
        if (Validator.isNull((String)paginationType)) {
            return null;
        }
        if (Objects.equals(paginationType, "none")) {
            return PageCollectionDefinition.PaginationType.NONE;
        }
        if (Objects.equals(paginationType, "numeric") || Objects.equals(paginationType, "regular")) {
            return PageCollectionDefinition.PaginationType.NUMERIC;
        }
        if (Objects.equals(paginationType, "simple")) {
            return PageCollectionDefinition.PaginationType.SIMPLE;
        }
        return null;
    }

    private CollectionViewportDefinition _toCollectionViewportDefinition(Map<String, JSONObject> collectionViewportConfigurationJSONObjects, ViewportSize viewportSize) {
        if (!collectionViewportConfigurationJSONObjects.containsKey(viewportSize.getViewportSizeId())) {
            return null;
        }
        final JSONObject jsonObject = collectionViewportConfigurationJSONObjects.get(viewportSize.getViewportSizeId());
        return new CollectionViewportDefinition(){
            {
                this.setNumberOfColumns(() -> {
                    if (!jsonObject.has("numberOfColumns")) {
                        return null;
                    }
                    return jsonObject.getInt("numberOfColumns");
                });
            }
        };
    }
}

