/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.dto.v1_0.mapper;

import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.headless.delivery.dto.v1_0.WidgetInstance;
import com.liferay.headless.delivery.dto.v1_0.WidgetPermission;
import com.liferay.layout.page.template.exporter.PortletConfigurationExporter;
import com.liferay.layout.page.template.exporter.PortletConfigurationExporterTracker;
import com.liferay.layout.page.template.exporter.PortletPreferencesPortletConfigurationExporter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.ResourceAction;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.Team;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.TeamLocalService;
import com.liferay.portal.kernel.service.permission.PortletPermission;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={WidgetInstanceMapper.class})
public class WidgetInstanceMapper {
    private static final Log _log = LogFactoryUtil.getLog(WidgetInstanceMapper.class);
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private PortletConfigurationExporterTracker _portletConfigurationExporterTracker;
    @Reference
    private PortletLocalService _portletLocalService;
    @Reference
    private PortletPermission _portletPermission;
    @Reference
    private PortletPreferencesPortletConfigurationExporter _portletPreferencesPortletConfigurationExporter;
    @Reference
    private ResourceActionLocalService _resourceActionLocalService;
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private TeamLocalService _teamLocalService;

    public WidgetInstance getWidgetInstance(final FragmentEntryLink fragmentEntryLink, final String portletId) {
        if (Validator.isNull((String)portletId)) {
            return null;
        }
        return new WidgetInstance(){
            {
                this.widgetConfig = WidgetInstanceMapper.this._getWidgetConfig(fragmentEntryLink.getPlid(), portletId);
                this.widgetInstanceId = WidgetInstanceMapper.this._getWidgetInstanceId(fragmentEntryLink, portletId);
                this.widgetName = PortletIdCodec.decodePortletName((String)portletId);
                this.widgetPermissions = WidgetInstanceMapper.this._getWidgetPermissions(fragmentEntryLink.getPlid(), portletId);
            }
        };
    }

    private Map<String, Object> _getWidgetConfig(long plid, String portletId) {
        Layout layout = this._layoutLocalService.fetchLayout(plid);
        if (layout == null) {
            return null;
        }
        String portletName = PortletIdCodec.decodePortletName((String)portletId);
        Portlet portlet = this._portletLocalService.getPortletById(portletName);
        if (portlet == null) {
            return null;
        }
        PortletConfigurationExporter portletConfigurationExporter = this._portletConfigurationExporterTracker.getPortletConfigurationExporter(portletName);
        if (portletConfigurationExporter != null) {
            return portletConfigurationExporter.getPortletConfiguration(plid, portletId);
        }
        return this._portletPreferencesPortletConfigurationExporter.getPortletConfiguration(plid, portletId);
    }

    private String _getWidgetInstanceId(FragmentEntryLink fragmentEntryLink, String portletId) {
        String instanceId = PortletIdCodec.decodeInstanceId((String)portletId);
        if (Validator.isNull((String)instanceId)) {
            return null;
        }
        String namespace = fragmentEntryLink.getNamespace();
        if (instanceId.startsWith(namespace)) {
            instanceId = instanceId.substring(namespace.length());
        }
        if (Validator.isNull((String)instanceId)) {
            return null;
        }
        return instanceId;
    }

    private WidgetPermission[] _getWidgetPermissions(long plid, String portletId) {
        Layout layout = this._layoutLocalService.fetchLayout(plid);
        if (layout == null) {
            return null;
        }
        String portletName = PortletIdCodec.decodePortletName((String)portletId);
        Portlet portlet = this._portletLocalService.getPortletById(portletName);
        if (portlet == null) {
            return null;
        }
        String resourcePrimKey = this._portletPermission.getPrimaryKey(plid, portletId);
        List resourcePermissions = this._resourcePermissionLocalService.getResourcePermissions(layout.getCompanyId(), portletName, 4, resourcePrimKey);
        if (ListUtil.isEmpty((List)resourcePermissions)) {
            return null;
        }
        List resourceActions = this._resourceActionLocalService.getResourceActions(portletName);
        if (ListUtil.isEmpty((List)resourceActions)) {
            return null;
        }
        ArrayList<2> widgetPermissions = new ArrayList<2>();
        for (ResourcePermission resourcePermission : resourcePermissions) {
            Team team;
            Role role = this._roleLocalService.fetchRole(resourcePermission.getRoleId());
            if (role == null) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)String.format("Resource permission %s will not be exported since no role was found with role ID %s", resourcePermission.getName(), resourcePermission.getRoleId()));
                continue;
            }
            final HashSet<String> actionIdsSet = new HashSet<String>();
            long actionIds = resourcePermission.getActionIds();
            for (ResourceAction resourceAction : resourceActions) {
                long bitwiseValue = resourceAction.getBitwiseValue();
                if ((actionIds & bitwiseValue) != bitwiseValue) continue;
                actionIdsSet.add(resourceAction.getActionId());
            }
            String roleKey = role.getName();
            if (role.getClassNameId() == this._portal.getClassNameId(Team.class) && (team = this._teamLocalService.fetchTeam(role.getClassPK())) != null) {
                roleKey = team.getName();
            }
            final String finalRoleKey = roleKey;
            widgetPermissions.add(new WidgetPermission(){
                {
                    this.actionKeys = actionIdsSet.toArray(new String[0]);
                    this.roleKey = finalRoleKey;
                }
            });
        }
        return widgetPermissions.toArray(new WidgetPermission[0]);
    }
}

