/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.dto.v1_0.util;

import com.liferay.headless.delivery.dto.v1_0.PageElement;
import com.liferay.headless.delivery.internal.dto.v1_0.mapper.LayoutStructureItemMapper;
import com.liferay.headless.delivery.internal.dto.v1_0.mapper.LayoutStructureItemMapperTracker;
import com.liferay.layout.util.structure.LayoutStructure;
import com.liferay.layout.util.structure.LayoutStructureItem;
import java.util.ArrayList;
import java.util.List;

public class PageElementUtil {
    public static PageElement toPageElement(long groupId, LayoutStructure layoutStructure, LayoutStructureItem layoutStructureItem, LayoutStructureItemMapperTracker layoutStructureItemMapperTracker, boolean saveInlineContent, boolean saveMappingConfiguration) {
        ArrayList<PageElement> pageElements = new ArrayList<PageElement>();
        List childrenItemIds = layoutStructureItem.getChildrenItemIds();
        for (String childItemId : childrenItemIds) {
            LayoutStructureItem childLayoutStructureItem = layoutStructure.getLayoutStructureItem(childItemId);
            List grandChildrenItemIds = childLayoutStructureItem.getChildrenItemIds();
            if (grandChildrenItemIds.isEmpty()) {
                pageElements.add(PageElementUtil._toPageElement(groupId, childLayoutStructureItem, layoutStructureItemMapperTracker, saveInlineContent, saveMappingConfiguration));
                continue;
            }
            pageElements.add(PageElementUtil.toPageElement(groupId, layoutStructure, childLayoutStructureItem, layoutStructureItemMapperTracker, saveInlineContent, saveMappingConfiguration));
        }
        PageElement pageElement = PageElementUtil._toPageElement(groupId, layoutStructureItem, layoutStructureItemMapperTracker, saveInlineContent, saveMappingConfiguration);
        if (pageElement != null && !pageElements.isEmpty()) {
            pageElement.setPageElements(pageElements.toArray(new PageElement[0]));
        }
        return pageElement;
    }

    private static PageElement _toPageElement(long groupId, LayoutStructureItem layoutStructureItem, LayoutStructureItemMapperTracker layoutStructureItemMapperTracker, boolean saveInlineContent, boolean saveMappingConfiguration) {
        Class<?> clazz = layoutStructureItem.getClass();
        LayoutStructureItemMapper layoutStructureItemMapper = layoutStructureItemMapperTracker.getLayoutStructureItemMapper(clazz.getName());
        if (layoutStructureItemMapper == null) {
            return null;
        }
        return layoutStructureItemMapper.getPageElement(groupId, layoutStructureItem, saveInlineContent, saveMappingConfiguration);
    }
}

