/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.dto.v1_0.util;

import com.liferay.headless.delivery.dto.v1_0.SEOSettings;
import com.liferay.layout.seo.model.LayoutSEOEntry;
import com.liferay.layout.seo.service.LayoutSEOEntryLocalService;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import java.util.Map;

public class SEOSettingsUtil {
    public static SEOSettings getSeoSettings(final DTOConverterContext dtoConverterContext, LayoutSEOEntryLocalService layoutSEOEntryLocalService, final Layout layout) {
        LayoutSEOEntry layoutSEOEntry = layoutSEOEntryLocalService.fetchLayoutSEOEntry(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId());
        SEOSettings seoSettings = new SEOSettings(){
            {
                this.description = layout.getDescription(dtoConverterContext.getLocale());
                this.description_i18n = LocalizedMapUtil.getI18nMap((boolean)dtoConverterContext.isAcceptAllLanguages(), (Map)layout.getDescriptionMap());
                this.htmlTitle = layout.getTitle(dtoConverterContext.getLocale());
                this.htmlTitle_i18n = LocalizedMapUtil.getI18nMap((boolean)dtoConverterContext.isAcceptAllLanguages(), (Map)layout.getTitleMap());
                this.robots = layout.getRobots(dtoConverterContext.getLocale());
                this.robots_i18n = LocalizedMapUtil.getI18nMap((boolean)dtoConverterContext.isAcceptAllLanguages(), (Map)layout.getRobotsMap());
                this.seoKeywords = layout.getKeywords(dtoConverterContext.getLocale());
                this.seoKeywords_i18n = LocalizedMapUtil.getI18nMap((boolean)dtoConverterContext.isAcceptAllLanguages(), (Map)layout.getKeywordsMap());
            }
        };
        if (layoutSEOEntry != null && layoutSEOEntry.isCanonicalURLEnabled()) {
            seoSettings.setCustomCanonicalURL(layoutSEOEntry.getCanonicalURL(dtoConverterContext.getLocale()));
            seoSettings.setCustomCanonicalURL_i18n(LocalizedMapUtil.getI18nMap((boolean)dtoConverterContext.isAcceptAllLanguages(), (Map)layoutSEOEntry.getCanonicalURLMap()));
        }
        return seoSettings;
    }
}

