/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.headless.delivery.dto.v1_0.Document;
import com.liferay.headless.delivery.dto.v1_0.Rating;
import com.liferay.headless.delivery.resource.v1_0.DocumentResource;
import com.liferay.petra.function.UnsafeBiConsumer;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.ExpressionConvert;
import com.liferay.portal.odata.filter.Filter;
import com.liferay.portal.odata.filter.FilterParser;
import com.liferay.portal.odata.filter.FilterParserProvider;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.batch.engine.VulcanBatchEngineTaskItemDelegate;
import com.liferay.portal.vulcan.batch.engine.resource.VulcanBatchEngineImportTaskResource;
import com.liferay.portal.vulcan.multipart.MultipartBody;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.permission.ModelPermissionsUtil;
import com.liferay.portal.vulcan.permission.Permission;
import com.liferay.portal.vulcan.permission.PermissionUtil;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.ActionUtil;
import com.liferay.portal.vulcan.util.TransformUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotSupportedException;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1.0")
public abstract class BaseDocumentResourceImpl
implements DocumentResource,
EntityModelResource,
VulcanBatchEngineTaskItemDelegate<Document> {
    protected AcceptLanguage contextAcceptLanguage;
    protected UnsafeBiConsumer<Collection<Document>, UnsafeConsumer<Document, Exception>, Exception> contextBatchUnsafeConsumer;
    protected Company contextCompany;
    protected HttpServletRequest contextHttpServletRequest;
    protected HttpServletResponse contextHttpServletResponse;
    protected Object contextScopeChecker;
    protected UriInfo contextUriInfo;
    protected User contextUser;
    protected ExpressionConvert<com.liferay.portal.kernel.search.filter.Filter> expressionConvert;
    protected FilterParserProvider filterParserProvider;
    protected GroupLocalService groupLocalService;
    protected ResourceActionLocalService resourceActionLocalService;
    protected ResourcePermissionLocalService resourcePermissionLocalService;
    protected RoleLocalService roleLocalService;
    protected VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource;
    private static final Log _log = LogFactoryUtil.getLog(BaseDocumentResourceImpl.class);

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="assetLibraryId"), @Parameter(in=ParameterIn.QUERY, name="aggregationTerms"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="flatten"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Tags(value={@Tag(name="Document")})
    @GET
    @Path(value="/asset-libraries/{assetLibraryId}/documents")
    @Produces(value={"application/json", "application/xml"})
    public Page<Document> getAssetLibraryDocumentsPage(@Parameter(hidden=true) @NotNull @PathParam(value="assetLibraryId") Long assetLibraryId, @Parameter(hidden=true) @QueryParam(value="flatten") Boolean flatten, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Aggregation aggregation, @Context com.liferay.portal.kernel.search.filter.Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="assetLibraryId")})
    @Tags(value={@Tag(name="Document")})
    @Consumes(value={"multipart/form-data"})
    @Path(value="/asset-libraries/{assetLibraryId}/documents")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public Document postAssetLibraryDocument(@Parameter(hidden=true) @NotNull @PathParam(value="assetLibraryId") Long assetLibraryId, MultipartBody multipartBody) throws Exception {
        return new Document();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="assetLibraryId"), @Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="Document")})
    @Consumes(value={"application/json"})
    @Path(value="/asset-libraries/{assetLibraryId}/documents/batch")
    @POST
    @Produces(value={"application/json"})
    public Response postAssetLibraryDocumentBatch(@Parameter(hidden=true) @NotNull @PathParam(value="assetLibraryId") Long assetLibraryId, MultipartBody multipartBody, @Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.postImportTask(Document.class.getName(), callbackURL, null, object)).build();
    }

    @Operation(description="Deletes the asset library's document by external reference code.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="assetLibraryId"), @Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="Document")})
    @DELETE
    @Path(value="/asset-libraries/{assetLibraryId}/documents/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    public void deleteAssetLibraryDocumentByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="assetLibraryId") Long assetLibraryId, @Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode) throws Exception {
    }

    @Operation(description="Retrieves the asset library's document by external reference code.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="assetLibraryId"), @Parameter(in=ParameterIn.PATH, name="externalReferenceCode"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields")})
    @Tags(value={@Tag(name="Document")})
    @GET
    @Path(value="/asset-libraries/{assetLibraryId}/documents/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    public Document getAssetLibraryDocumentByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="assetLibraryId") Long assetLibraryId, @Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode) throws Exception {
        return new Document();
    }

    @Operation(description="Replaces the document by external reference code with the information sent in the request body, or replaces it if it not exists. Any missing fields are deleted, unless they are required. The request body must be `multipart/form-data` with two parts, the file'sbytes (`file`), and an optional JSON string (`document`) with the metadata.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="assetLibraryId"), @Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="Document")})
    @Consumes(value={"multipart/form-data"})
    @Path(value="/asset-libraries/{assetLibraryId}/documents/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public Document putAssetLibraryDocumentByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="assetLibraryId") Long assetLibraryId, @Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode, MultipartBody multipartBody) throws Exception {
        return new Document();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="assetLibraryId"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields"), @Parameter(in=ParameterIn.QUERY, name="roleNames")})
    @Tags(value={@Tag(name="Document")})
    @GET
    @Path(value="/asset-libraries/{assetLibraryId}/documents/permissions")
    @Produces(value={"application/json", "application/xml"})
    public Page<Permission> getAssetLibraryDocumentPermissionsPage(@Parameter(hidden=true) @NotNull @PathParam(value="assetLibraryId") Long assetLibraryId, @Parameter(hidden=true) @QueryParam(value="roleNames") String roleNames) throws Exception {
        String portletName = this.getPermissionCheckerPortletName(assetLibraryId);
        PermissionUtil.checkPermission((String)"PERMISSIONS", (GroupLocalService)this.groupLocalService, (String)portletName, (long)assetLibraryId, (Long)assetLibraryId);
        return this.toPermissionPage(HashMapBuilder.put((Object)"get", this.addAction("PERMISSIONS", "getAssetLibraryDocumentPermissionsPage", portletName, assetLibraryId)).put((Object)"replace", this.addAction("PERMISSIONS", "putAssetLibraryDocumentPermissionsPage", portletName, assetLibraryId)).build(), assetLibraryId, portletName, roleNames);
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="assetLibraryId")})
    @Tags(value={@Tag(name="Document")})
    @Path(value="/asset-libraries/{assetLibraryId}/documents/permissions")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public Page<Permission> putAssetLibraryDocumentPermissionsPage(@Parameter(hidden=true) @NotNull @PathParam(value="assetLibraryId") Long assetLibraryId, Permission[] permissions) throws Exception {
        String portletName = this.getPermissionCheckerPortletName(assetLibraryId);
        PermissionUtil.checkPermission((String)"PERMISSIONS", (GroupLocalService)this.groupLocalService, (String)portletName, (long)assetLibraryId, (Long)assetLibraryId);
        this.resourcePermissionLocalService.updateResourcePermissions(this.contextCompany.getCompanyId(), assetLibraryId.longValue(), portletName, String.valueOf(assetLibraryId), ModelPermissionsUtil.toModelPermissions((long)this.contextCompany.getCompanyId(), (Permission[])permissions, (long)assetLibraryId, (String)portletName, (ResourceActionLocalService)this.resourceActionLocalService, (ResourcePermissionLocalService)this.resourcePermissionLocalService, (RoleLocalService)this.roleLocalService));
        return this.toPermissionPage(HashMapBuilder.put((Object)"get", this.addAction("PERMISSIONS", "getAssetLibraryDocumentPermissionsPage", portletName, assetLibraryId)).put((Object)"replace", this.addAction("PERMISSIONS", "putAssetLibraryDocumentPermissionsPage", portletName, assetLibraryId)).build(), assetLibraryId, portletName, null);
    }

    @Operation(description="Retrieves the folder's documents. Results can be paginated, filtered, searched, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="documentFolderId"), @Parameter(in=ParameterIn.QUERY, name="aggregationTerms"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="flatten"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Tags(value={@Tag(name="Document")})
    @GET
    @Path(value="/document-folders/{documentFolderId}/documents")
    @Produces(value={"application/json", "application/xml"})
    public Page<Document> getDocumentFolderDocumentsPage(@Parameter(hidden=true) @NotNull @PathParam(value="documentFolderId") Long documentFolderId, @Parameter(hidden=true) @QueryParam(value="flatten") Boolean flatten, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Aggregation aggregation, @Context com.liferay.portal.kernel.search.filter.Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Operation(description="Creates a new document inside the folder identified by `documentFolderId`. The request body must be `multipart/form-data` with two parts, the file's bytes (`file`), and an optional JSON string (`document`) with the metadata.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="documentFolderId")})
    @Tags(value={@Tag(name="Document")})
    @Consumes(value={"multipart/form-data"})
    @Path(value="/document-folders/{documentFolderId}/documents")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public Document postDocumentFolderDocument(@Parameter(hidden=true) @NotNull @PathParam(value="documentFolderId") Long documentFolderId, MultipartBody multipartBody) throws Exception {
        return new Document();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="documentFolderId"), @Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="Document")})
    @Consumes(value={"application/json"})
    @Path(value="/document-folders/{documentFolderId}/documents/batch")
    @POST
    @Produces(value={"application/json"})
    public Response postDocumentFolderDocumentBatch(@Parameter(hidden=true) @NotNull @PathParam(value="documentFolderId") Long documentFolderId, MultipartBody multipartBody, @Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.postImportTask(Document.class.getName(), callbackURL, null, object)).build();
    }

    @Operation(description="Deletes the document and returns a 204 if the operation succeeds.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="documentId")})
    @Tags(value={@Tag(name="Document")})
    @DELETE
    @Path(value="/documents/{documentId}")
    @Produces(value={"application/json", "application/xml"})
    public void deleteDocument(@Parameter(hidden=true) @NotNull @PathParam(value="documentId") Long documentId) throws Exception {
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="Document")})
    @Consumes(value={"application/json"})
    @DELETE
    @Path(value="/documents/batch")
    @Produces(value={"application/json"})
    public Response deleteDocumentBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.deleteImportTask(Document.class.getName(), callbackURL, object)).build();
    }

    @Operation(description="Retrieves the document.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="documentId"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields")})
    @Tags(value={@Tag(name="Document")})
    @GET
    @Path(value="/documents/{documentId}")
    @Produces(value={"application/json", "application/xml"})
    public Document getDocument(@Parameter(hidden=true) @NotNull @PathParam(value="documentId") Long documentId) throws Exception {
        return new Document();
    }

    @Operation(description="Updates only the fields received in the request body, leaving any other fields untouched. The request body must be `multipart/form-data` with two parts, the file's bytes (`file`), and an optional JSON string (`document`) with the metadata.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="documentId")})
    @Tags(value={@Tag(name="Document")})
    @Consumes(value={"multipart/form-data"})
    @PATCH
    @Path(value="/documents/{documentId}")
    @Produces(value={"application/json", "application/xml"})
    public Document patchDocument(@Parameter(hidden=true) @NotNull @PathParam(value="documentId") Long documentId, MultipartBody multipartBody) throws Exception {
        return new Document();
    }

    @Operation(description="Replaces the document with the information sent in the request body. Any missing fields are deleted, unless they are required. The request body must be `multipart/form-data` with two parts, the file's bytes (`file`), and an optional JSON string (`document`) with the metadata.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="documentId")})
    @Tags(value={@Tag(name="Document")})
    @Consumes(value={"multipart/form-data"})
    @Path(value="/documents/{documentId}")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public Document putDocument(@Parameter(hidden=true) @NotNull @PathParam(value="documentId") Long documentId, MultipartBody multipartBody) throws Exception {
        return new Document();
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="Document")})
    @Consumes(value={"application/json"})
    @Path(value="/documents/batch")
    @Produces(value={"application/json"})
    @PUT
    public Response putDocumentBatch(MultipartBody multipartBody, @Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.putImportTask(Document.class.getName(), callbackURL, object)).build();
    }

    @Operation(description="Deletes the document's rating and returns a 204 if the operation succeeded.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="documentId")})
    @Tags(value={@Tag(name="Document")})
    @DELETE
    @Path(value="/documents/{documentId}/my-rating")
    @Produces(value={"application/json", "application/xml"})
    public void deleteDocumentMyRating(@Parameter(hidden=true) @NotNull @PathParam(value="documentId") Long documentId) throws Exception {
    }

    @Operation(description="Retrieves the document's rating.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="documentId"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields")})
    @Tags(value={@Tag(name="Document")})
    @GET
    @Path(value="/documents/{documentId}/my-rating")
    @Produces(value={"application/json", "application/xml"})
    public Rating getDocumentMyRating(@Parameter(hidden=true) @NotNull @PathParam(value="documentId") Long documentId) throws Exception {
        return new Rating();
    }

    @Operation(description="Creates a new rating for the document, by the user who authenticated the request.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="documentId")})
    @Tags(value={@Tag(name="Document")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/documents/{documentId}/my-rating")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public Rating postDocumentMyRating(@Parameter(hidden=true) @NotNull @PathParam(value="documentId") Long documentId, Rating rating) throws Exception {
        return new Rating();
    }

    @Operation(description="Replaces the rating with the information sent in the request body. Any missing fields are deleted, unless they are required.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="documentId")})
    @Tags(value={@Tag(name="Document")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/documents/{documentId}/my-rating")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public Rating putDocumentMyRating(@Parameter(hidden=true) @NotNull @PathParam(value="documentId") Long documentId, Rating rating) throws Exception {
        return new Rating();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="documentId"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields"), @Parameter(in=ParameterIn.QUERY, name="roleNames")})
    @Tags(value={@Tag(name="Document")})
    @GET
    @Path(value="/documents/{documentId}/permissions")
    @Produces(value={"application/json", "application/xml"})
    public Page<Permission> getDocumentPermissionsPage(@Parameter(hidden=true) @NotNull @PathParam(value="documentId") Long documentId, @Parameter(hidden=true) @QueryParam(value="roleNames") String roleNames) throws Exception {
        String resourceName = this.getPermissionCheckerResourceName(documentId);
        Long resourceId = this.getPermissionCheckerResourceId(documentId);
        PermissionUtil.checkPermission((String)"PERMISSIONS", (GroupLocalService)this.groupLocalService, (String)resourceName, (long)resourceId, (Long)this.getPermissionCheckerGroupId(documentId));
        return this.toPermissionPage(HashMapBuilder.put((Object)"get", this.addAction("PERMISSIONS", "getDocumentPermissionsPage", resourceName, resourceId)).put((Object)"replace", this.addAction("PERMISSIONS", "putDocumentPermissionsPage", resourceName, resourceId)).build(), resourceId, resourceName, roleNames);
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="documentId")})
    @Tags(value={@Tag(name="Document")})
    @Path(value="/documents/{documentId}/permissions")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public Page<Permission> putDocumentPermissionsPage(@Parameter(hidden=true) @NotNull @PathParam(value="documentId") Long documentId, Permission[] permissions) throws Exception {
        String resourceName = this.getPermissionCheckerResourceName(documentId);
        Long resourceId = this.getPermissionCheckerResourceId(documentId);
        PermissionUtil.checkPermission((String)"PERMISSIONS", (GroupLocalService)this.groupLocalService, (String)resourceName, (long)resourceId, (Long)this.getPermissionCheckerGroupId(documentId));
        this.resourcePermissionLocalService.updateResourcePermissions(this.contextCompany.getCompanyId(), this.getPermissionCheckerGroupId(documentId).longValue(), resourceName, String.valueOf(resourceId), ModelPermissionsUtil.toModelPermissions((long)this.contextCompany.getCompanyId(), (Permission[])permissions, (long)resourceId, (String)resourceName, (ResourceActionLocalService)this.resourceActionLocalService, (ResourcePermissionLocalService)this.resourcePermissionLocalService, (RoleLocalService)this.roleLocalService));
        return this.toPermissionPage(HashMapBuilder.put((Object)"get", this.addAction("PERMISSIONS", "getDocumentPermissionsPage", resourceName, resourceId)).put((Object)"replace", this.addAction("PERMISSIONS", "putDocumentPermissionsPage", resourceName, resourceId)).build(), resourceId, resourceName, null);
    }

    @Operation(description="Retrieves the document's rendered display page")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="documentId"), @Parameter(in=ParameterIn.PATH, name="displayPageKey"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields")})
    @Tags(value={@Tag(name="Document")})
    @GET
    @Path(value="/documents/{documentId}/rendered-content-by-display-page/{displayPageKey}")
    @Produces(value={"text/html"})
    public String getDocumentRenderedContentByDisplayPageDisplayPageKey(@Parameter(hidden=true) @NotNull @PathParam(value="documentId") Long documentId, @Parameter(hidden=true) @NotNull @PathParam(value="displayPageKey") String displayPageKey) throws Exception {
        return "";
    }

    @Operation(description="Retrieves the documents in the site's root folder. Results can be paginated, filtered, searched, flattened, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.QUERY, name="aggregationTerms"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="flatten"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Tags(value={@Tag(name="Document")})
    @GET
    @Path(value="/sites/{siteId}/documents")
    @Produces(value={"application/json", "application/xml"})
    public Page<Document> getSiteDocumentsPage(@Parameter(hidden=true) @NotNull @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @QueryParam(value="flatten") Boolean flatten, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Aggregation aggregation, @Context com.liferay.portal.kernel.search.filter.Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Operation(description="Creates a new document. The request body must be `multipart/form-data` with two parts, the file's bytes (`file`), and an optional JSON string (`document`) with the metadata.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId")})
    @Tags(value={@Tag(name="Document")})
    @Consumes(value={"multipart/form-data"})
    @Path(value="/sites/{siteId}/documents")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public Document postSiteDocument(@Parameter(hidden=true) @NotNull @PathParam(value="siteId") Long siteId, MultipartBody multipartBody) throws Exception {
        return new Document();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="Document")})
    @Consumes(value={"application/json"})
    @Path(value="/sites/{siteId}/documents/batch")
    @POST
    @Produces(value={"application/json"})
    public Response postSiteDocumentBatch(@Parameter(hidden=true) @NotNull @PathParam(value="siteId") Long siteId, MultipartBody multipartBody, @Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.postImportTask(Document.class.getName(), callbackURL, null, object)).build();
    }

    @Operation(description="Deletes the site's document by external reference code returns a 204 if the operation succeeds.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="Document")})
    @DELETE
    @Path(value="/sites/{siteId}/documents/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    public void deleteSiteDocumentByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode) throws Exception {
    }

    @Operation(description="Retrieves the site's document by external reference code.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.PATH, name="externalReferenceCode"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields")})
    @Tags(value={@Tag(name="Document")})
    @GET
    @Path(value="/sites/{siteId}/documents/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    public Document getSiteDocumentByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode) throws Exception {
        return new Document();
    }

    @Operation(description="Replaces the document by external reference code with the information sent in the request body, or replaces it if it not exists. Any missing fields are deleted, unless they are required. The request body must be `multipart/form-data` with two parts, the file'sbytes (`file`), and an optional JSON string (`document`) with the metadata.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="Document")})
    @Consumes(value={"multipart/form-data"})
    @Path(value="/sites/{siteId}/documents/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public Document putSiteDocumentByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode, MultipartBody multipartBody) throws Exception {
        return new Document();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields"), @Parameter(in=ParameterIn.QUERY, name="roleNames")})
    @Tags(value={@Tag(name="Document")})
    @GET
    @Path(value="/sites/{siteId}/documents/permissions")
    @Produces(value={"application/json", "application/xml"})
    public Page<Permission> getSiteDocumentPermissionsPage(@Parameter(hidden=true) @NotNull @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @QueryParam(value="roleNames") String roleNames) throws Exception {
        String portletName = this.getPermissionCheckerPortletName(siteId);
        PermissionUtil.checkPermission((String)"PERMISSIONS", (GroupLocalService)this.groupLocalService, (String)portletName, (long)siteId, (Long)siteId);
        return this.toPermissionPage(HashMapBuilder.put((Object)"get", this.addAction("PERMISSIONS", "getSiteDocumentPermissionsPage", portletName, siteId)).put((Object)"replace", this.addAction("PERMISSIONS", "putSiteDocumentPermissionsPage", portletName, siteId)).build(), siteId, portletName, roleNames);
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId")})
    @Tags(value={@Tag(name="Document")})
    @Path(value="/sites/{siteId}/documents/permissions")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public Page<Permission> putSiteDocumentPermissionsPage(@Parameter(hidden=true) @NotNull @PathParam(value="siteId") Long siteId, Permission[] permissions) throws Exception {
        String portletName = this.getPermissionCheckerPortletName(siteId);
        PermissionUtil.checkPermission((String)"PERMISSIONS", (GroupLocalService)this.groupLocalService, (String)portletName, (long)siteId, (Long)siteId);
        this.resourcePermissionLocalService.updateResourcePermissions(this.contextCompany.getCompanyId(), siteId.longValue(), portletName, String.valueOf(siteId), ModelPermissionsUtil.toModelPermissions((long)this.contextCompany.getCompanyId(), (Permission[])permissions, (long)siteId, (String)portletName, (ResourceActionLocalService)this.resourceActionLocalService, (ResourcePermissionLocalService)this.resourcePermissionLocalService, (RoleLocalService)this.roleLocalService));
        return this.toPermissionPage(HashMapBuilder.put((Object)"get", this.addAction("PERMISSIONS", "getSiteDocumentPermissionsPage", portletName, siteId)).put((Object)"replace", this.addAction("PERMISSIONS", "putSiteDocumentPermissionsPage", portletName, siteId)).build(), siteId, portletName, null);
    }

    public void create(Collection<Document> documents, Map<String, Serializable> parameters) throws Exception {
        UnsafeConsumer documentUnsafeConsumer = null;
        String createStrategy = (String)((Object)parameters.getOrDefault("createStrategy", (Serializable)((Object)"INSERT")));
        if ("INSERT".equalsIgnoreCase(createStrategy)) {
            if (parameters.containsKey("documentFolderId")) {
                documentUnsafeConsumer = document -> this.postDocumentFolderDocument(Long.parseLong((String)parameters.get("documentFolderId")), (MultipartBody)parameters.get("multipartBody"));
            } else if (parameters.containsKey("assetLibraryId")) {
                documentUnsafeConsumer = document -> this.postAssetLibraryDocument((Long)parameters.get("assetLibraryId"), (MultipartBody)parameters.get("multipartBody"));
            } else if (parameters.containsKey("siteId")) {
                documentUnsafeConsumer = document -> this.postSiteDocument((Long)parameters.get("siteId"), (MultipartBody)parameters.get("multipartBody"));
            } else {
                throw new NotSupportedException("One of the following parameters must be specified: [documentFolderId, assetLibraryId, siteId]");
            }
        }
        if ("UPSERT".equalsIgnoreCase(createStrategy)) {
            documentUnsafeConsumer = document -> this.putSiteDocumentByExternalReferenceCode(document.getSiteId() != null ? document.getSiteId() : (Long)parameters.get("siteId"), document.getExternalReferenceCode(), null);
        }
        if (documentUnsafeConsumer == null) {
            throw new NotSupportedException("Create strategy \"" + createStrategy + "\" is not supported for Document");
        }
        if (this.contextBatchUnsafeConsumer != null) {
            this.contextBatchUnsafeConsumer.accept(documents, (Object)documentUnsafeConsumer);
        } else {
            for (Document document2 : documents) {
                documentUnsafeConsumer.accept((Object)document2);
            }
        }
    }

    public void delete(Collection<Document> documents, Map<String, Serializable> parameters) throws Exception {
        for (Document document : documents) {
            this.deleteDocument(document.getId());
        }
    }

    public Set<String> getAvailableCreateStrategies() {
        return SetUtil.fromArray((Object[])new String[]{"UPSERT", "INSERT"});
    }

    public Set<String> getAvailableUpdateStrategies() {
        return SetUtil.fromArray((Object[])new String[]{"PARTIAL_UPDATE", "UPDATE"});
    }

    public EntityModel getEntityModel(Map<String, List<String>> multivaluedMap) throws Exception {
        return this.getEntityModel((MultivaluedMap)new MultivaluedHashMap(multivaluedMap));
    }

    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return null;
    }

    public String getVersion() {
        return "v1.0";
    }

    public Page<Document> read(com.liferay.portal.kernel.search.filter.Filter filter, Pagination pagination, Sort[] sorts, Map<String, Serializable> parameters, String search) throws Exception {
        if (parameters.containsKey("assetLibraryId")) {
            return this.getAssetLibraryDocumentsPage((Long)parameters.get("assetLibraryId"), Boolean.parseBoolean((String)((Object)parameters.get("flatten"))), search, null, filter, pagination, sorts);
        }
        if (parameters.containsKey("siteId")) {
            return this.getSiteDocumentsPage((Long)parameters.get("siteId"), Boolean.parseBoolean((String)((Object)parameters.get("flatten"))), search, null, filter, pagination, sorts);
        }
        if (parameters.containsKey("documentFolderId")) {
            return this.getDocumentFolderDocumentsPage(Long.parseLong((String)((Object)parameters.get("documentFolderId"))), Boolean.parseBoolean((String)((Object)parameters.get("flatten"))), search, null, filter, pagination, sorts);
        }
        throw new NotSupportedException("One of the following parameters must be specified: [assetLibraryId, siteId, documentFolderId]");
    }

    public void setLanguageId(final String languageId) {
        this.contextAcceptLanguage = new AcceptLanguage(){

            public List<Locale> getLocales() {
                return null;
            }

            public String getPreferredLanguageId() {
                return languageId;
            }

            public Locale getPreferredLocale() {
                return LocaleUtil.fromLanguageId((String)languageId);
            }
        };
    }

    public void update(Collection<Document> documents, Map<String, Serializable> parameters) throws Exception {
        UnsafeConsumer documentUnsafeConsumer = null;
        String updateStrategy = (String)((Object)parameters.getOrDefault("updateStrategy", (Serializable)((Object)"UPDATE")));
        if ("PARTIAL_UPDATE".equalsIgnoreCase(updateStrategy)) {
            documentUnsafeConsumer = document -> this.patchDocument(document.getId() != null ? document.getId() : Long.parseLong((String)parameters.get("documentId")), null);
        }
        if ("UPDATE".equalsIgnoreCase(updateStrategy)) {
            documentUnsafeConsumer = document -> this.putDocument(document.getId() != null ? document.getId() : Long.parseLong((String)parameters.get("documentId")), null);
        }
        if (documentUnsafeConsumer == null) {
            throw new NotSupportedException("Update strategy \"" + updateStrategy + "\" is not supported for Document");
        }
        if (this.contextBatchUnsafeConsumer != null) {
            this.contextBatchUnsafeConsumer.accept(documents, (Object)documentUnsafeConsumer);
        } else {
            for (Document document2 : documents) {
                documentUnsafeConsumer.accept((Object)document2);
            }
        }
    }

    protected String getPermissionCheckerActionsResourceName(Object id) throws Exception {
        return this.getPermissionCheckerResourceName(id);
    }

    protected Long getPermissionCheckerGroupId(Object id) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    protected String getPermissionCheckerPortletName(Object id) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    protected Long getPermissionCheckerResourceId(Object id) throws Exception {
        return GetterUtil.getLong((Object)id);
    }

    protected String getPermissionCheckerResourceName(Object id) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    protected Page<Permission> toPermissionPage(Map<String, Map<String, String>> actions, long id, String resourceName, String roleNames) throws Exception {
        List resourceActions = this.resourceActionLocalService.getResourceActions(resourceName);
        if (Validator.isNotNull((String)roleNames)) {
            return Page.of(actions, this.transform(PermissionUtil.getRoles((Company)this.contextCompany, (RoleLocalService)this.roleLocalService, (String[])StringUtil.split((String)roleNames)), role -> PermissionUtil.toPermission((Long)this.contextCompany.getCompanyId(), (Long)id, (List)resourceActions, (String)resourceName, (ResourcePermissionLocalService)this.resourcePermissionLocalService, (Role)role)));
        }
        return Page.of(actions, this.transform(PermissionUtil.getResourcePermissions((long)this.contextCompany.getCompanyId(), (long)id, (String)resourceName, (ResourcePermissionLocalService)this.resourcePermissionLocalService), resourcePermission -> PermissionUtil.toPermission((List)resourceActions, (ResourcePermission)resourcePermission, (Role)this.roleLocalService.getRole(resourcePermission.getRoleId()))));
    }

    public void setContextAcceptLanguage(AcceptLanguage contextAcceptLanguage) {
        this.contextAcceptLanguage = contextAcceptLanguage;
    }

    public void setContextBatchUnsafeConsumer(UnsafeBiConsumer<Collection<Document>, UnsafeConsumer<Document, Exception>, Exception> contextBatchUnsafeConsumer) {
        this.contextBatchUnsafeConsumer = contextBatchUnsafeConsumer;
    }

    public void setContextCompany(Company contextCompany) {
        this.contextCompany = contextCompany;
    }

    public void setContextHttpServletRequest(HttpServletRequest contextHttpServletRequest) {
        this.contextHttpServletRequest = contextHttpServletRequest;
    }

    public void setContextHttpServletResponse(HttpServletResponse contextHttpServletResponse) {
        this.contextHttpServletResponse = contextHttpServletResponse;
    }

    public void setContextUriInfo(UriInfo contextUriInfo) {
        this.contextUriInfo = contextUriInfo;
    }

    public void setContextUser(User contextUser) {
        this.contextUser = contextUser;
    }

    public void setExpressionConvert(ExpressionConvert<com.liferay.portal.kernel.search.filter.Filter> expressionConvert) {
        this.expressionConvert = expressionConvert;
    }

    public void setFilterParserProvider(FilterParserProvider filterParserProvider) {
        this.filterParserProvider = filterParserProvider;
    }

    public void setGroupLocalService(GroupLocalService groupLocalService) {
        this.groupLocalService = groupLocalService;
    }

    public void setResourceActionLocalService(ResourceActionLocalService resourceActionLocalService) {
        this.resourceActionLocalService = resourceActionLocalService;
    }

    public void setResourcePermissionLocalService(ResourcePermissionLocalService resourcePermissionLocalService) {
        this.resourcePermissionLocalService = resourcePermissionLocalService;
    }

    public void setRoleLocalService(RoleLocalService roleLocalService) {
        this.roleLocalService = roleLocalService;
    }

    public void setVulcanBatchEngineImportTaskResource(VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource) {
        this.vulcanBatchEngineImportTaskResource = vulcanBatchEngineImportTaskResource;
    }

    public com.liferay.portal.kernel.search.filter.Filter toFilter(String filterString, Map<String, List<String>> multivaluedMap) {
        try {
            EntityModel entityModel = this.getEntityModel(multivaluedMap);
            FilterParser filterParser = this.filterParserProvider.provide(entityModel);
            Filter oDataFilter = new Filter(filterParser.parse(filterString));
            return (com.liferay.portal.kernel.search.filter.Filter)this.expressionConvert.convert(oDataFilter.getExpression(), this.contextAcceptLanguage.getPreferredLocale(), entityModel);
        }
        catch (Exception exception) {
            _log.error((Object)("Invalid filter " + filterString), (Throwable)exception);
            return null;
        }
    }

    protected Map<String, String> addAction(String actionName, GroupedModel groupedModel, String methodName) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (GroupedModel)groupedModel, (String)methodName, (Object)this.contextScopeChecker, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, Long ownerId, String permissionName, Long siteId) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (Long)ownerId, (String)permissionName, (Long)siteId, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, ModelResourcePermission modelResourcePermission) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (ModelResourcePermission)modelResourcePermission, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, String methodName, String permissionName, Long siteId) {
        return this.addAction(actionName, siteId, methodName, null, permissionName, siteId);
    }

    protected <T, R, E extends Throwable> List<R> transform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transform(collection, unsafeFunction);
    }

    protected <T, R, E extends Throwable> R[] transform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] transformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> List<R> transformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transformToList((Object[])array, unsafeFunction);
    }

    protected <T, R, E extends Throwable> List<R> unsafeTransform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransform(collection, unsafeFunction);
    }

    protected <T, R, E extends Throwable> R[] unsafeTransform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) throws E {
        return TransformUtil.unsafeTransform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] unsafeTransformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) throws E {
        return TransformUtil.unsafeTransformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> List<R> unsafeTransformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToList((Object[])array, unsafeFunction);
    }
}

