/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.headless.delivery.dto.v1_0.KnowledgeBaseArticle;
import com.liferay.headless.delivery.dto.v1_0.Rating;
import com.liferay.headless.delivery.resource.v1_0.KnowledgeBaseArticleResource;
import com.liferay.petra.function.UnsafeBiConsumer;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.ExpressionConvert;
import com.liferay.portal.odata.filter.Filter;
import com.liferay.portal.odata.filter.FilterParser;
import com.liferay.portal.odata.filter.FilterParserProvider;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.batch.engine.VulcanBatchEngineTaskItemDelegate;
import com.liferay.portal.vulcan.batch.engine.resource.VulcanBatchEngineImportTaskResource;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.permission.ModelPermissionsUtil;
import com.liferay.portal.vulcan.permission.Permission;
import com.liferay.portal.vulcan.permission.PermissionUtil;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.ActionUtil;
import com.liferay.portal.vulcan.util.TransformUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotSupportedException;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1.0")
public abstract class BaseKnowledgeBaseArticleResourceImpl
implements EntityModelResource,
KnowledgeBaseArticleResource,
VulcanBatchEngineTaskItemDelegate<KnowledgeBaseArticle> {
    protected AcceptLanguage contextAcceptLanguage;
    protected UnsafeBiConsumer<Collection<KnowledgeBaseArticle>, UnsafeConsumer<KnowledgeBaseArticle, Exception>, Exception> contextBatchUnsafeConsumer;
    protected Company contextCompany;
    protected HttpServletRequest contextHttpServletRequest;
    protected HttpServletResponse contextHttpServletResponse;
    protected Object contextScopeChecker;
    protected UriInfo contextUriInfo;
    protected User contextUser;
    protected ExpressionConvert<com.liferay.portal.kernel.search.filter.Filter> expressionConvert;
    protected FilterParserProvider filterParserProvider;
    protected GroupLocalService groupLocalService;
    protected ResourceActionLocalService resourceActionLocalService;
    protected ResourcePermissionLocalService resourcePermissionLocalService;
    protected RoleLocalService roleLocalService;
    protected VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource;
    private static final Log _log = LogFactoryUtil.getLog(BaseKnowledgeBaseArticleResourceImpl.class);

    @Operation(description="Deletes the knowledge base article and returns a 204 if the operation succeeds.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="knowledgeBaseArticleId")})
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    @DELETE
    @Path(value="/knowledge-base-articles/{knowledgeBaseArticleId}")
    @Produces(value={"application/json", "application/xml"})
    public void deleteKnowledgeBaseArticle(@Parameter(hidden=true) @NotNull @PathParam(value="knowledgeBaseArticleId") Long knowledgeBaseArticleId) throws Exception {
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    @Consumes(value={"application/json"})
    @DELETE
    @Path(value="/knowledge-base-articles/batch")
    @Produces(value={"application/json"})
    public Response deleteKnowledgeBaseArticleBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.deleteImportTask(KnowledgeBaseArticle.class.getName(), callbackURL, object)).build();
    }

    @Operation(description="Retrieves the knowledge base article.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="knowledgeBaseArticleId"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields")})
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    @GET
    @Path(value="/knowledge-base-articles/{knowledgeBaseArticleId}")
    @Produces(value={"application/json", "application/xml"})
    public KnowledgeBaseArticle getKnowledgeBaseArticle(@Parameter(hidden=true) @NotNull @PathParam(value="knowledgeBaseArticleId") Long knowledgeBaseArticleId) throws Exception {
        return new KnowledgeBaseArticle();
    }

    @Operation(description="Updates only the fields received in the request body, leaving any other fields untouched.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="knowledgeBaseArticleId")})
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    @Consumes(value={"application/json", "application/xml"})
    @PATCH
    @Path(value="/knowledge-base-articles/{knowledgeBaseArticleId}")
    @Produces(value={"application/json", "application/xml"})
    public KnowledgeBaseArticle patchKnowledgeBaseArticle(@Parameter(hidden=true) @NotNull @PathParam(value="knowledgeBaseArticleId") Long knowledgeBaseArticleId, KnowledgeBaseArticle knowledgeBaseArticle) throws Exception {
        KnowledgeBaseArticle existingKnowledgeBaseArticle = this.getKnowledgeBaseArticle(knowledgeBaseArticleId);
        if (knowledgeBaseArticle.getActions() != null) {
            existingKnowledgeBaseArticle.setActions(knowledgeBaseArticle.getActions());
        }
        if (knowledgeBaseArticle.getArticleBody() != null) {
            existingKnowledgeBaseArticle.setArticleBody(knowledgeBaseArticle.getArticleBody());
        }
        if (knowledgeBaseArticle.getDateCreated() != null) {
            existingKnowledgeBaseArticle.setDateCreated(knowledgeBaseArticle.getDateCreated());
        }
        if (knowledgeBaseArticle.getDateModified() != null) {
            existingKnowledgeBaseArticle.setDateModified(knowledgeBaseArticle.getDateModified());
        }
        if (knowledgeBaseArticle.getDescription() != null) {
            existingKnowledgeBaseArticle.setDescription(knowledgeBaseArticle.getDescription());
        }
        if (knowledgeBaseArticle.getEncodingFormat() != null) {
            existingKnowledgeBaseArticle.setEncodingFormat(knowledgeBaseArticle.getEncodingFormat());
        }
        if (knowledgeBaseArticle.getExternalReferenceCode() != null) {
            existingKnowledgeBaseArticle.setExternalReferenceCode(knowledgeBaseArticle.getExternalReferenceCode());
        }
        if (knowledgeBaseArticle.getFriendlyUrlPath() != null) {
            existingKnowledgeBaseArticle.setFriendlyUrlPath(knowledgeBaseArticle.getFriendlyUrlPath());
        }
        if (knowledgeBaseArticle.getKeywords() != null) {
            existingKnowledgeBaseArticle.setKeywords(knowledgeBaseArticle.getKeywords());
        }
        if (knowledgeBaseArticle.getNumberOfAttachments() != null) {
            existingKnowledgeBaseArticle.setNumberOfAttachments(knowledgeBaseArticle.getNumberOfAttachments());
        }
        if (knowledgeBaseArticle.getNumberOfKnowledgeBaseArticles() != null) {
            existingKnowledgeBaseArticle.setNumberOfKnowledgeBaseArticles(knowledgeBaseArticle.getNumberOfKnowledgeBaseArticles());
        }
        if (knowledgeBaseArticle.getParentKnowledgeBaseArticleId() != null) {
            existingKnowledgeBaseArticle.setParentKnowledgeBaseArticleId(knowledgeBaseArticle.getParentKnowledgeBaseArticleId());
        }
        if (knowledgeBaseArticle.getParentKnowledgeBaseFolderId() != null) {
            existingKnowledgeBaseArticle.setParentKnowledgeBaseFolderId(knowledgeBaseArticle.getParentKnowledgeBaseFolderId());
        }
        if (knowledgeBaseArticle.getSiteId() != null) {
            existingKnowledgeBaseArticle.setSiteId(knowledgeBaseArticle.getSiteId());
        }
        if (knowledgeBaseArticle.getSubscribed() != null) {
            existingKnowledgeBaseArticle.setSubscribed(knowledgeBaseArticle.getSubscribed());
        }
        if (knowledgeBaseArticle.getTaxonomyCategoryIds() != null) {
            existingKnowledgeBaseArticle.setTaxonomyCategoryIds(knowledgeBaseArticle.getTaxonomyCategoryIds());
        }
        if (knowledgeBaseArticle.getTitle() != null) {
            existingKnowledgeBaseArticle.setTitle(knowledgeBaseArticle.getTitle());
        }
        if (knowledgeBaseArticle.getViewableBy() != null) {
            existingKnowledgeBaseArticle.setViewableBy(knowledgeBaseArticle.getViewableBy());
        }
        this.preparePatch(knowledgeBaseArticle, existingKnowledgeBaseArticle);
        return this.putKnowledgeBaseArticle(knowledgeBaseArticleId, existingKnowledgeBaseArticle);
    }

    @Operation(description="Replaces the knowledge base article with the information sent in the request body. Any missing fields are deleted, unless they are required.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="knowledgeBaseArticleId")})
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/knowledge-base-articles/{knowledgeBaseArticleId}")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public KnowledgeBaseArticle putKnowledgeBaseArticle(@Parameter(hidden=true) @NotNull @PathParam(value="knowledgeBaseArticleId") Long knowledgeBaseArticleId, KnowledgeBaseArticle knowledgeBaseArticle) throws Exception {
        return new KnowledgeBaseArticle();
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    @Consumes(value={"application/json"})
    @Path(value="/knowledge-base-articles/batch")
    @Produces(value={"application/json"})
    @PUT
    public Response putKnowledgeBaseArticleBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.putImportTask(KnowledgeBaseArticle.class.getName(), callbackURL, object)).build();
    }

    @Operation(description="Deletes the knowledge base article's rating and returns a 204 if the operation succeeds.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="knowledgeBaseArticleId")})
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    @DELETE
    @Path(value="/knowledge-base-articles/{knowledgeBaseArticleId}/my-rating")
    @Produces(value={"application/json", "application/xml"})
    public void deleteKnowledgeBaseArticleMyRating(@Parameter(hidden=true) @NotNull @PathParam(value="knowledgeBaseArticleId") Long knowledgeBaseArticleId) throws Exception {
    }

    @Operation(description="Retrieves the knowledge base article's rating.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="knowledgeBaseArticleId"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields")})
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    @GET
    @Path(value="/knowledge-base-articles/{knowledgeBaseArticleId}/my-rating")
    @Produces(value={"application/json", "application/xml"})
    public Rating getKnowledgeBaseArticleMyRating(@Parameter(hidden=true) @NotNull @PathParam(value="knowledgeBaseArticleId") Long knowledgeBaseArticleId) throws Exception {
        return new Rating();
    }

    @Operation(description="Creates a rating for the knowledge base article.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="knowledgeBaseArticleId")})
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/knowledge-base-articles/{knowledgeBaseArticleId}/my-rating")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public Rating postKnowledgeBaseArticleMyRating(@Parameter(hidden=true) @NotNull @PathParam(value="knowledgeBaseArticleId") Long knowledgeBaseArticleId, Rating rating) throws Exception {
        return new Rating();
    }

    @Operation(description="Replaces the rating with the information sent in the request body. Any missing fields are deleted, unless they are required.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="knowledgeBaseArticleId")})
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/knowledge-base-articles/{knowledgeBaseArticleId}/my-rating")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public Rating putKnowledgeBaseArticleMyRating(@Parameter(hidden=true) @NotNull @PathParam(value="knowledgeBaseArticleId") Long knowledgeBaseArticleId, Rating rating) throws Exception {
        return new Rating();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="knowledgeBaseArticleId"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields"), @Parameter(in=ParameterIn.QUERY, name="roleNames")})
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    @GET
    @Path(value="/knowledge-base-articles/{knowledgeBaseArticleId}/permissions")
    @Produces(value={"application/json", "application/xml"})
    public Page<Permission> getKnowledgeBaseArticlePermissionsPage(@Parameter(hidden=true) @NotNull @PathParam(value="knowledgeBaseArticleId") Long knowledgeBaseArticleId, @Parameter(hidden=true) @QueryParam(value="roleNames") String roleNames) throws Exception {
        String resourceName = this.getPermissionCheckerResourceName(knowledgeBaseArticleId);
        Long resourceId = this.getPermissionCheckerResourceId(knowledgeBaseArticleId);
        PermissionUtil.checkPermission((String)"PERMISSIONS", (GroupLocalService)this.groupLocalService, (String)resourceName, (long)resourceId, (Long)this.getPermissionCheckerGroupId(knowledgeBaseArticleId));
        return this.toPermissionPage(HashMapBuilder.put((Object)"get", this.addAction("PERMISSIONS", "getKnowledgeBaseArticlePermissionsPage", resourceName, resourceId)).put((Object)"replace", this.addAction("PERMISSIONS", "putKnowledgeBaseArticlePermissionsPage", resourceName, resourceId)).build(), resourceId, resourceName, roleNames);
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="knowledgeBaseArticleId")})
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    @Path(value="/knowledge-base-articles/{knowledgeBaseArticleId}/permissions")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public Page<Permission> putKnowledgeBaseArticlePermissionsPage(@Parameter(hidden=true) @NotNull @PathParam(value="knowledgeBaseArticleId") Long knowledgeBaseArticleId, Permission[] permissions) throws Exception {
        String resourceName = this.getPermissionCheckerResourceName(knowledgeBaseArticleId);
        Long resourceId = this.getPermissionCheckerResourceId(knowledgeBaseArticleId);
        PermissionUtil.checkPermission((String)"PERMISSIONS", (GroupLocalService)this.groupLocalService, (String)resourceName, (long)resourceId, (Long)this.getPermissionCheckerGroupId(knowledgeBaseArticleId));
        this.resourcePermissionLocalService.updateResourcePermissions(this.contextCompany.getCompanyId(), this.getPermissionCheckerGroupId(knowledgeBaseArticleId).longValue(), resourceName, String.valueOf(resourceId), ModelPermissionsUtil.toModelPermissions((long)this.contextCompany.getCompanyId(), (Permission[])permissions, (long)resourceId, (String)resourceName, (ResourceActionLocalService)this.resourceActionLocalService, (ResourcePermissionLocalService)this.resourcePermissionLocalService, (RoleLocalService)this.roleLocalService));
        return this.toPermissionPage(HashMapBuilder.put((Object)"get", this.addAction("PERMISSIONS", "getKnowledgeBaseArticlePermissionsPage", resourceName, resourceId)).put((Object)"replace", this.addAction("PERMISSIONS", "putKnowledgeBaseArticlePermissionsPage", resourceName, resourceId)).build(), resourceId, resourceName, null);
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="knowledgeBaseArticleId")})
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    @Path(value="/knowledge-base-articles/{knowledgeBaseArticleId}/subscribe")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public void putKnowledgeBaseArticleSubscribe(@Parameter(hidden=true) @NotNull @PathParam(value="knowledgeBaseArticleId") Long knowledgeBaseArticleId) throws Exception {
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="knowledgeBaseArticleId")})
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    @Path(value="/knowledge-base-articles/{knowledgeBaseArticleId}/unsubscribe")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public void putKnowledgeBaseArticleUnsubscribe(@Parameter(hidden=true) @NotNull @PathParam(value="knowledgeBaseArticleId") Long knowledgeBaseArticleId) throws Exception {
    }

    @Operation(description="Retrieves the parent knowledge base article's child knowledge base articles. Results can be paginated, filtered, searched, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="parentKnowledgeBaseArticleId"), @Parameter(in=ParameterIn.QUERY, name="aggregationTerms"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="flatten"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    @GET
    @Path(value="/knowledge-base-articles/{parentKnowledgeBaseArticleId}/knowledge-base-articles")
    @Produces(value={"application/json", "application/xml"})
    public Page<KnowledgeBaseArticle> getKnowledgeBaseArticleKnowledgeBaseArticlesPage(@Parameter(hidden=true) @NotNull @PathParam(value="parentKnowledgeBaseArticleId") Long parentKnowledgeBaseArticleId, @Parameter(hidden=true) @QueryParam(value="flatten") Boolean flatten, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Aggregation aggregation, @Context com.liferay.portal.kernel.search.filter.Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Operation(description="Creates a child knowledge base article of the knowledge base article identified by `parentKnowledgeBaseArticleId`.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="parentKnowledgeBaseArticleId")})
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/knowledge-base-articles/{parentKnowledgeBaseArticleId}/knowledge-base-articles")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public KnowledgeBaseArticle postKnowledgeBaseArticleKnowledgeBaseArticle(@Parameter(hidden=true) @NotNull @PathParam(value="parentKnowledgeBaseArticleId") Long parentKnowledgeBaseArticleId, KnowledgeBaseArticle knowledgeBaseArticle) throws Exception {
        return new KnowledgeBaseArticle();
    }

    @Operation(description="Retrieves the folder's knowledge base articles. Results can be paginated, filtered, searched, flattened, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="knowledgeBaseFolderId"), @Parameter(in=ParameterIn.QUERY, name="aggregationTerms"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="flatten"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    @GET
    @Path(value="/knowledge-base-folders/{knowledgeBaseFolderId}/knowledge-base-articles")
    @Produces(value={"application/json", "application/xml"})
    public Page<KnowledgeBaseArticle> getKnowledgeBaseFolderKnowledgeBaseArticlesPage(@Parameter(hidden=true) @NotNull @PathParam(value="knowledgeBaseFolderId") Long knowledgeBaseFolderId, @Parameter(hidden=true) @QueryParam(value="flatten") Boolean flatten, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Aggregation aggregation, @Context com.liferay.portal.kernel.search.filter.Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Operation(description="Creates a new knowledge base article in the folder.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="knowledgeBaseFolderId")})
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/knowledge-base-folders/{knowledgeBaseFolderId}/knowledge-base-articles")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public KnowledgeBaseArticle postKnowledgeBaseFolderKnowledgeBaseArticle(@Parameter(hidden=true) @NotNull @PathParam(value="knowledgeBaseFolderId") Long knowledgeBaseFolderId, KnowledgeBaseArticle knowledgeBaseArticle) throws Exception {
        return new KnowledgeBaseArticle();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="knowledgeBaseFolderId"), @Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    @Consumes(value={"application/json"})
    @Path(value="/knowledge-base-folders/{knowledgeBaseFolderId}/knowledge-base-articles/batch")
    @POST
    @Produces(value={"application/json"})
    public Response postKnowledgeBaseFolderKnowledgeBaseArticleBatch(@Parameter(hidden=true) @NotNull @PathParam(value="knowledgeBaseFolderId") Long knowledgeBaseFolderId, @Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.postImportTask(KnowledgeBaseArticle.class.getName(), callbackURL, null, object)).build();
    }

    @Operation(description="Retrieves the site's knowledge base articles. Results can be paginated, filtered, searched, flattened, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.QUERY, name="aggregationTerms"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="flatten"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    @GET
    @Path(value="/sites/{siteId}/knowledge-base-articles")
    @Produces(value={"application/json", "application/xml"})
    public Page<KnowledgeBaseArticle> getSiteKnowledgeBaseArticlesPage(@Parameter(hidden=true) @NotNull @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @QueryParam(value="flatten") Boolean flatten, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Aggregation aggregation, @Context com.liferay.portal.kernel.search.filter.Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Operation(description="Creates a new knowledge base article.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId")})
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/sites/{siteId}/knowledge-base-articles")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public KnowledgeBaseArticle postSiteKnowledgeBaseArticle(@Parameter(hidden=true) @NotNull @PathParam(value="siteId") Long siteId, KnowledgeBaseArticle knowledgeBaseArticle) throws Exception {
        return new KnowledgeBaseArticle();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    @Consumes(value={"application/json"})
    @Path(value="/sites/{siteId}/knowledge-base-articles/batch")
    @POST
    @Produces(value={"application/json"})
    public Response postSiteKnowledgeBaseArticleBatch(@Parameter(hidden=true) @NotNull @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.postImportTask(KnowledgeBaseArticle.class.getName(), callbackURL, null, object)).build();
    }

    @Operation(description="Deletes the knowledge base article by external reference code.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    @DELETE
    @Path(value="/sites/{siteId}/knowledge-base-articles/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    public void deleteSiteKnowledgeBaseArticleByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode) throws Exception {
    }

    @Operation(description="Retrieves the site's knowledge base article by external reference code.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.PATH, name="externalReferenceCode"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields")})
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    @GET
    @Path(value="/sites/{siteId}/knowledge-base-articles/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    public KnowledgeBaseArticle getSiteKnowledgeBaseArticleByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode) throws Exception {
        return new KnowledgeBaseArticle();
    }

    @Operation(description="Updates the site's knowledge base article with the given external reference code, or creates it if it not exists.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/sites/{siteId}/knowledge-base-articles/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public KnowledgeBaseArticle putSiteKnowledgeBaseArticleByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode, KnowledgeBaseArticle knowledgeBaseArticle) throws Exception {
        return new KnowledgeBaseArticle();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields"), @Parameter(in=ParameterIn.QUERY, name="roleNames")})
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    @GET
    @Path(value="/sites/{siteId}/knowledge-base-articles/permissions")
    @Produces(value={"application/json", "application/xml"})
    public Page<Permission> getSiteKnowledgeBaseArticlePermissionsPage(@Parameter(hidden=true) @NotNull @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @QueryParam(value="roleNames") String roleNames) throws Exception {
        String portletName = this.getPermissionCheckerPortletName(siteId);
        PermissionUtil.checkPermission((String)"PERMISSIONS", (GroupLocalService)this.groupLocalService, (String)portletName, (long)siteId, (Long)siteId);
        return this.toPermissionPage(HashMapBuilder.put((Object)"get", this.addAction("PERMISSIONS", "getSiteKnowledgeBaseArticlePermissionsPage", portletName, siteId)).put((Object)"replace", this.addAction("PERMISSIONS", "putSiteKnowledgeBaseArticlePermissionsPage", portletName, siteId)).build(), siteId, portletName, roleNames);
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId")})
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    @Path(value="/sites/{siteId}/knowledge-base-articles/permissions")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public Page<Permission> putSiteKnowledgeBaseArticlePermissionsPage(@Parameter(hidden=true) @NotNull @PathParam(value="siteId") Long siteId, Permission[] permissions) throws Exception {
        String portletName = this.getPermissionCheckerPortletName(siteId);
        PermissionUtil.checkPermission((String)"PERMISSIONS", (GroupLocalService)this.groupLocalService, (String)portletName, (long)siteId, (Long)siteId);
        this.resourcePermissionLocalService.updateResourcePermissions(this.contextCompany.getCompanyId(), siteId.longValue(), portletName, String.valueOf(siteId), ModelPermissionsUtil.toModelPermissions((long)this.contextCompany.getCompanyId(), (Permission[])permissions, (long)siteId, (String)portletName, (ResourceActionLocalService)this.resourceActionLocalService, (ResourcePermissionLocalService)this.resourcePermissionLocalService, (RoleLocalService)this.roleLocalService));
        return this.toPermissionPage(HashMapBuilder.put((Object)"get", this.addAction("PERMISSIONS", "getSiteKnowledgeBaseArticlePermissionsPage", portletName, siteId)).put((Object)"replace", this.addAction("PERMISSIONS", "putSiteKnowledgeBaseArticlePermissionsPage", portletName, siteId)).build(), siteId, portletName, null);
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId")})
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    @Path(value="/sites/{siteId}/knowledge-base-articles/subscribe")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public void putSiteKnowledgeBaseArticleSubscribe(@Parameter(hidden=true) @NotNull @PathParam(value="siteId") Long siteId) throws Exception {
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId")})
    @Tags(value={@Tag(name="KnowledgeBaseArticle")})
    @Path(value="/sites/{siteId}/knowledge-base-articles/unsubscribe")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public void putSiteKnowledgeBaseArticleUnsubscribe(@Parameter(hidden=true) @NotNull @PathParam(value="siteId") Long siteId) throws Exception {
    }

    public void create(Collection<KnowledgeBaseArticle> knowledgeBaseArticles, Map<String, Serializable> parameters) throws Exception {
        UnsafeConsumer knowledgeBaseArticleUnsafeConsumer = null;
        String createStrategy = (String)((Object)parameters.getOrDefault("createStrategy", (Serializable)((Object)"INSERT")));
        if ("INSERT".equalsIgnoreCase(createStrategy)) {
            if (parameters.containsKey("knowledgeBaseFolderId")) {
                knowledgeBaseArticleUnsafeConsumer = knowledgeBaseArticle -> this.postKnowledgeBaseFolderKnowledgeBaseArticle(Long.parseLong((String)parameters.get("knowledgeBaseFolderId")), (KnowledgeBaseArticle)knowledgeBaseArticle);
            } else if (parameters.containsKey("siteId")) {
                knowledgeBaseArticleUnsafeConsumer = knowledgeBaseArticle -> this.postSiteKnowledgeBaseArticle((Long)parameters.get("siteId"), (KnowledgeBaseArticle)knowledgeBaseArticle);
            } else {
                throw new NotSupportedException("One of the following parameters must be specified: [knowledgeBaseFolderId, siteId]");
            }
        }
        if ("UPSERT".equalsIgnoreCase(createStrategy)) {
            knowledgeBaseArticleUnsafeConsumer = knowledgeBaseArticle -> this.putSiteKnowledgeBaseArticleByExternalReferenceCode(knowledgeBaseArticle.getSiteId() != null ? knowledgeBaseArticle.getSiteId() : (Long)parameters.get("siteId"), knowledgeBaseArticle.getExternalReferenceCode(), (KnowledgeBaseArticle)knowledgeBaseArticle);
        }
        if (knowledgeBaseArticleUnsafeConsumer == null) {
            throw new NotSupportedException("Create strategy \"" + createStrategy + "\" is not supported for KnowledgeBaseArticle");
        }
        if (this.contextBatchUnsafeConsumer != null) {
            this.contextBatchUnsafeConsumer.accept(knowledgeBaseArticles, (Object)knowledgeBaseArticleUnsafeConsumer);
        } else {
            for (KnowledgeBaseArticle knowledgeBaseArticle2 : knowledgeBaseArticles) {
                knowledgeBaseArticleUnsafeConsumer.accept((Object)knowledgeBaseArticle2);
            }
        }
    }

    public void delete(Collection<KnowledgeBaseArticle> knowledgeBaseArticles, Map<String, Serializable> parameters) throws Exception {
        for (KnowledgeBaseArticle knowledgeBaseArticle : knowledgeBaseArticles) {
            this.deleteKnowledgeBaseArticle(knowledgeBaseArticle.getId());
        }
    }

    public Set<String> getAvailableCreateStrategies() {
        return SetUtil.fromArray((Object[])new String[]{"UPSERT", "INSERT"});
    }

    public Set<String> getAvailableUpdateStrategies() {
        return SetUtil.fromArray((Object[])new String[]{"PARTIAL_UPDATE", "UPDATE"});
    }

    public EntityModel getEntityModel(Map<String, List<String>> multivaluedMap) throws Exception {
        return this.getEntityModel((MultivaluedMap)new MultivaluedHashMap(multivaluedMap));
    }

    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return null;
    }

    public String getVersion() {
        return "v1.0";
    }

    public Page<KnowledgeBaseArticle> read(com.liferay.portal.kernel.search.filter.Filter filter, Pagination pagination, Sort[] sorts, Map<String, Serializable> parameters, String search) throws Exception {
        if (parameters.containsKey("siteId")) {
            return this.getSiteKnowledgeBaseArticlesPage((Long)parameters.get("siteId"), Boolean.parseBoolean((String)((Object)parameters.get("flatten"))), search, null, filter, pagination, sorts);
        }
        if (parameters.containsKey("knowledgeBaseFolderId")) {
            return this.getKnowledgeBaseFolderKnowledgeBaseArticlesPage(Long.parseLong((String)((Object)parameters.get("knowledgeBaseFolderId"))), Boolean.parseBoolean((String)((Object)parameters.get("flatten"))), search, null, filter, pagination, sorts);
        }
        throw new NotSupportedException("One of the following parameters must be specified: [siteId, knowledgeBaseFolderId]");
    }

    public void setLanguageId(final String languageId) {
        this.contextAcceptLanguage = new AcceptLanguage(){

            public List<Locale> getLocales() {
                return null;
            }

            public String getPreferredLanguageId() {
                return languageId;
            }

            public Locale getPreferredLocale() {
                return LocaleUtil.fromLanguageId((String)languageId);
            }
        };
    }

    public void update(Collection<KnowledgeBaseArticle> knowledgeBaseArticles, Map<String, Serializable> parameters) throws Exception {
        UnsafeConsumer knowledgeBaseArticleUnsafeConsumer = null;
        String updateStrategy = (String)((Object)parameters.getOrDefault("updateStrategy", (Serializable)((Object)"UPDATE")));
        if ("PARTIAL_UPDATE".equalsIgnoreCase(updateStrategy)) {
            knowledgeBaseArticleUnsafeConsumer = knowledgeBaseArticle -> this.patchKnowledgeBaseArticle(knowledgeBaseArticle.getId() != null ? knowledgeBaseArticle.getId() : Long.parseLong((String)parameters.get("knowledgeBaseArticleId")), (KnowledgeBaseArticle)knowledgeBaseArticle);
        }
        if ("UPDATE".equalsIgnoreCase(updateStrategy)) {
            knowledgeBaseArticleUnsafeConsumer = knowledgeBaseArticle -> this.putKnowledgeBaseArticle(knowledgeBaseArticle.getId() != null ? knowledgeBaseArticle.getId() : Long.parseLong((String)parameters.get("knowledgeBaseArticleId")), (KnowledgeBaseArticle)knowledgeBaseArticle);
        }
        if (knowledgeBaseArticleUnsafeConsumer == null) {
            throw new NotSupportedException("Update strategy \"" + updateStrategy + "\" is not supported for KnowledgeBaseArticle");
        }
        if (this.contextBatchUnsafeConsumer != null) {
            this.contextBatchUnsafeConsumer.accept(knowledgeBaseArticles, (Object)knowledgeBaseArticleUnsafeConsumer);
        } else {
            for (KnowledgeBaseArticle knowledgeBaseArticle2 : knowledgeBaseArticles) {
                knowledgeBaseArticleUnsafeConsumer.accept((Object)knowledgeBaseArticle2);
            }
        }
    }

    protected String getPermissionCheckerActionsResourceName(Object id) throws Exception {
        return this.getPermissionCheckerResourceName(id);
    }

    protected Long getPermissionCheckerGroupId(Object id) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    protected String getPermissionCheckerPortletName(Object id) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    protected Long getPermissionCheckerResourceId(Object id) throws Exception {
        return GetterUtil.getLong((Object)id);
    }

    protected String getPermissionCheckerResourceName(Object id) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    protected Page<Permission> toPermissionPage(Map<String, Map<String, String>> actions, long id, String resourceName, String roleNames) throws Exception {
        List resourceActions = this.resourceActionLocalService.getResourceActions(resourceName);
        if (Validator.isNotNull((String)roleNames)) {
            return Page.of(actions, this.transform(PermissionUtil.getRoles((Company)this.contextCompany, (RoleLocalService)this.roleLocalService, (String[])StringUtil.split((String)roleNames)), role -> PermissionUtil.toPermission((Long)this.contextCompany.getCompanyId(), (Long)id, (List)resourceActions, (String)resourceName, (ResourcePermissionLocalService)this.resourcePermissionLocalService, (Role)role)));
        }
        return Page.of(actions, this.transform(PermissionUtil.getResourcePermissions((long)this.contextCompany.getCompanyId(), (long)id, (String)resourceName, (ResourcePermissionLocalService)this.resourcePermissionLocalService), resourcePermission -> PermissionUtil.toPermission((List)resourceActions, (ResourcePermission)resourcePermission, (Role)this.roleLocalService.getRole(resourcePermission.getRoleId()))));
    }

    public void setContextAcceptLanguage(AcceptLanguage contextAcceptLanguage) {
        this.contextAcceptLanguage = contextAcceptLanguage;
    }

    public void setContextBatchUnsafeConsumer(UnsafeBiConsumer<Collection<KnowledgeBaseArticle>, UnsafeConsumer<KnowledgeBaseArticle, Exception>, Exception> contextBatchUnsafeConsumer) {
        this.contextBatchUnsafeConsumer = contextBatchUnsafeConsumer;
    }

    public void setContextCompany(Company contextCompany) {
        this.contextCompany = contextCompany;
    }

    public void setContextHttpServletRequest(HttpServletRequest contextHttpServletRequest) {
        this.contextHttpServletRequest = contextHttpServletRequest;
    }

    public void setContextHttpServletResponse(HttpServletResponse contextHttpServletResponse) {
        this.contextHttpServletResponse = contextHttpServletResponse;
    }

    public void setContextUriInfo(UriInfo contextUriInfo) {
        this.contextUriInfo = contextUriInfo;
    }

    public void setContextUser(User contextUser) {
        this.contextUser = contextUser;
    }

    public void setExpressionConvert(ExpressionConvert<com.liferay.portal.kernel.search.filter.Filter> expressionConvert) {
        this.expressionConvert = expressionConvert;
    }

    public void setFilterParserProvider(FilterParserProvider filterParserProvider) {
        this.filterParserProvider = filterParserProvider;
    }

    public void setGroupLocalService(GroupLocalService groupLocalService) {
        this.groupLocalService = groupLocalService;
    }

    public void setResourceActionLocalService(ResourceActionLocalService resourceActionLocalService) {
        this.resourceActionLocalService = resourceActionLocalService;
    }

    public void setResourcePermissionLocalService(ResourcePermissionLocalService resourcePermissionLocalService) {
        this.resourcePermissionLocalService = resourcePermissionLocalService;
    }

    public void setRoleLocalService(RoleLocalService roleLocalService) {
        this.roleLocalService = roleLocalService;
    }

    public void setVulcanBatchEngineImportTaskResource(VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource) {
        this.vulcanBatchEngineImportTaskResource = vulcanBatchEngineImportTaskResource;
    }

    public com.liferay.portal.kernel.search.filter.Filter toFilter(String filterString, Map<String, List<String>> multivaluedMap) {
        try {
            EntityModel entityModel = this.getEntityModel(multivaluedMap);
            FilterParser filterParser = this.filterParserProvider.provide(entityModel);
            Filter oDataFilter = new Filter(filterParser.parse(filterString));
            return (com.liferay.portal.kernel.search.filter.Filter)this.expressionConvert.convert(oDataFilter.getExpression(), this.contextAcceptLanguage.getPreferredLocale(), entityModel);
        }
        catch (Exception exception) {
            _log.error((Object)("Invalid filter " + filterString), (Throwable)exception);
            return null;
        }
    }

    protected Map<String, String> addAction(String actionName, GroupedModel groupedModel, String methodName) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (GroupedModel)groupedModel, (String)methodName, (Object)this.contextScopeChecker, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, Long ownerId, String permissionName, Long siteId) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (Long)ownerId, (String)permissionName, (Long)siteId, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, ModelResourcePermission modelResourcePermission) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (ModelResourcePermission)modelResourcePermission, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, String methodName, String permissionName, Long siteId) {
        return this.addAction(actionName, siteId, methodName, null, permissionName, siteId);
    }

    protected void preparePatch(KnowledgeBaseArticle knowledgeBaseArticle, KnowledgeBaseArticle existingKnowledgeBaseArticle) {
    }

    protected <T, R, E extends Throwable> List<R> transform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transform(collection, unsafeFunction);
    }

    protected <T, R, E extends Throwable> R[] transform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] transformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> List<R> transformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transformToList((Object[])array, unsafeFunction);
    }

    protected <T, R, E extends Throwable> List<R> unsafeTransform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransform(collection, unsafeFunction);
    }

    protected <T, R, E extends Throwable> R[] unsafeTransform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) throws E {
        return TransformUtil.unsafeTransform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] unsafeTransformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) throws E {
        return TransformUtil.unsafeTransformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> List<R> unsafeTransformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToList((Object[])array, unsafeFunction);
    }
}

