/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.headless.delivery.dto.v1_0.MessageBoardMessage;
import com.liferay.headless.delivery.dto.v1_0.Rating;
import com.liferay.headless.delivery.resource.v1_0.MessageBoardMessageResource;
import com.liferay.petra.function.UnsafeBiConsumer;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.ExpressionConvert;
import com.liferay.portal.odata.filter.Filter;
import com.liferay.portal.odata.filter.FilterParser;
import com.liferay.portal.odata.filter.FilterParserProvider;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.batch.engine.VulcanBatchEngineTaskItemDelegate;
import com.liferay.portal.vulcan.batch.engine.resource.VulcanBatchEngineImportTaskResource;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.permission.ModelPermissionsUtil;
import com.liferay.portal.vulcan.permission.Permission;
import com.liferay.portal.vulcan.permission.PermissionUtil;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.ActionUtil;
import com.liferay.portal.vulcan.util.TransformUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotSupportedException;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1.0")
public abstract class BaseMessageBoardMessageResourceImpl
implements EntityModelResource,
MessageBoardMessageResource,
VulcanBatchEngineTaskItemDelegate<MessageBoardMessage> {
    protected AcceptLanguage contextAcceptLanguage;
    protected UnsafeBiConsumer<Collection<MessageBoardMessage>, UnsafeConsumer<MessageBoardMessage, Exception>, Exception> contextBatchUnsafeConsumer;
    protected Company contextCompany;
    protected HttpServletRequest contextHttpServletRequest;
    protected HttpServletResponse contextHttpServletResponse;
    protected Object contextScopeChecker;
    protected UriInfo contextUriInfo;
    protected User contextUser;
    protected ExpressionConvert<com.liferay.portal.kernel.search.filter.Filter> expressionConvert;
    protected FilterParserProvider filterParserProvider;
    protected GroupLocalService groupLocalService;
    protected ResourceActionLocalService resourceActionLocalService;
    protected ResourcePermissionLocalService resourcePermissionLocalService;
    protected RoleLocalService roleLocalService;
    protected VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource;
    private static final Log _log = LogFactoryUtil.getLog(BaseMessageBoardMessageResourceImpl.class);

    @Operation(description="Deletes the message board message and returns a 204 if the operation succeeds.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="messageBoardMessageId")})
    @Tags(value={@Tag(name="MessageBoardMessage")})
    @DELETE
    @Path(value="/message-board-messages/{messageBoardMessageId}")
    @Produces(value={"application/json", "application/xml"})
    public void deleteMessageBoardMessage(@Parameter(hidden=true) @NotNull @PathParam(value="messageBoardMessageId") Long messageBoardMessageId) throws Exception {
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="MessageBoardMessage")})
    @Consumes(value={"application/json"})
    @DELETE
    @Path(value="/message-board-messages/batch")
    @Produces(value={"application/json"})
    public Response deleteMessageBoardMessageBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.deleteImportTask(MessageBoardMessage.class.getName(), callbackURL, object)).build();
    }

    @Operation(description="Retrieves the message board message.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="messageBoardMessageId"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields")})
    @Tags(value={@Tag(name="MessageBoardMessage")})
    @GET
    @Path(value="/message-board-messages/{messageBoardMessageId}")
    @Produces(value={"application/json", "application/xml"})
    public MessageBoardMessage getMessageBoardMessage(@Parameter(hidden=true) @NotNull @PathParam(value="messageBoardMessageId") Long messageBoardMessageId) throws Exception {
        return new MessageBoardMessage();
    }

    @Operation(description="Updates only the fields received in the request body, leaving any other fields untouched.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="messageBoardMessageId")})
    @Tags(value={@Tag(name="MessageBoardMessage")})
    @Consumes(value={"application/json", "application/xml"})
    @PATCH
    @Path(value="/message-board-messages/{messageBoardMessageId}")
    @Produces(value={"application/json", "application/xml"})
    public MessageBoardMessage patchMessageBoardMessage(@Parameter(hidden=true) @NotNull @PathParam(value="messageBoardMessageId") Long messageBoardMessageId, MessageBoardMessage messageBoardMessage) throws Exception {
        MessageBoardMessage existingMessageBoardMessage = this.getMessageBoardMessage(messageBoardMessageId);
        if (messageBoardMessage.getActions() != null) {
            existingMessageBoardMessage.setActions(messageBoardMessage.getActions());
        }
        if (messageBoardMessage.getAnonymous() != null) {
            existingMessageBoardMessage.setAnonymous(messageBoardMessage.getAnonymous());
        }
        if (messageBoardMessage.getArticleBody() != null) {
            existingMessageBoardMessage.setArticleBody(messageBoardMessage.getArticleBody());
        }
        if (messageBoardMessage.getDateCreated() != null) {
            existingMessageBoardMessage.setDateCreated(messageBoardMessage.getDateCreated());
        }
        if (messageBoardMessage.getDateModified() != null) {
            existingMessageBoardMessage.setDateModified(messageBoardMessage.getDateModified());
        }
        if (messageBoardMessage.getEncodingFormat() != null) {
            existingMessageBoardMessage.setEncodingFormat(messageBoardMessage.getEncodingFormat());
        }
        if (messageBoardMessage.getExternalReferenceCode() != null) {
            existingMessageBoardMessage.setExternalReferenceCode(messageBoardMessage.getExternalReferenceCode());
        }
        if (messageBoardMessage.getFriendlyUrlPath() != null) {
            existingMessageBoardMessage.setFriendlyUrlPath(messageBoardMessage.getFriendlyUrlPath());
        }
        if (messageBoardMessage.getHeadline() != null) {
            existingMessageBoardMessage.setHeadline(messageBoardMessage.getHeadline());
        }
        if (messageBoardMessage.getKeywords() != null) {
            existingMessageBoardMessage.setKeywords(messageBoardMessage.getKeywords());
        }
        if (messageBoardMessage.getMessageBoardSectionId() != null) {
            existingMessageBoardMessage.setMessageBoardSectionId(messageBoardMessage.getMessageBoardSectionId());
        }
        if (messageBoardMessage.getMessageBoardThreadId() != null) {
            existingMessageBoardMessage.setMessageBoardThreadId(messageBoardMessage.getMessageBoardThreadId());
        }
        if (messageBoardMessage.getNumberOfMessageBoardAttachments() != null) {
            existingMessageBoardMessage.setNumberOfMessageBoardAttachments(messageBoardMessage.getNumberOfMessageBoardAttachments());
        }
        if (messageBoardMessage.getNumberOfMessageBoardMessages() != null) {
            existingMessageBoardMessage.setNumberOfMessageBoardMessages(messageBoardMessage.getNumberOfMessageBoardMessages());
        }
        if (messageBoardMessage.getParentMessageBoardMessageId() != null) {
            existingMessageBoardMessage.setParentMessageBoardMessageId(messageBoardMessage.getParentMessageBoardMessageId());
        }
        if (messageBoardMessage.getShowAsAnswer() != null) {
            existingMessageBoardMessage.setShowAsAnswer(messageBoardMessage.getShowAsAnswer());
        }
        if (messageBoardMessage.getSiteId() != null) {
            existingMessageBoardMessage.setSiteId(messageBoardMessage.getSiteId());
        }
        if (messageBoardMessage.getStatus() != null) {
            existingMessageBoardMessage.setStatus(messageBoardMessage.getStatus());
        }
        if (messageBoardMessage.getSubscribed() != null) {
            existingMessageBoardMessage.setSubscribed(messageBoardMessage.getSubscribed());
        }
        if (messageBoardMessage.getViewableBy() != null) {
            existingMessageBoardMessage.setViewableBy(messageBoardMessage.getViewableBy());
        }
        this.preparePatch(messageBoardMessage, existingMessageBoardMessage);
        return this.putMessageBoardMessage(messageBoardMessageId, existingMessageBoardMessage);
    }

    @Operation(description="Replaces the message board message with the information sent in the request body. Any missing fields are deleted, unless they are required.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="messageBoardMessageId")})
    @Tags(value={@Tag(name="MessageBoardMessage")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/message-board-messages/{messageBoardMessageId}")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public MessageBoardMessage putMessageBoardMessage(@Parameter(hidden=true) @NotNull @PathParam(value="messageBoardMessageId") Long messageBoardMessageId, MessageBoardMessage messageBoardMessage) throws Exception {
        return new MessageBoardMessage();
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="MessageBoardMessage")})
    @Consumes(value={"application/json"})
    @Path(value="/message-board-messages/batch")
    @Produces(value={"application/json"})
    @PUT
    public Response putMessageBoardMessageBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.putImportTask(MessageBoardMessage.class.getName(), callbackURL, object)).build();
    }

    @Operation(description="Deletes the message board message's rating and returns a 204 if the operation succeeds.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="messageBoardMessageId")})
    @Tags(value={@Tag(name="MessageBoardMessage")})
    @DELETE
    @Path(value="/message-board-messages/{messageBoardMessageId}/my-rating")
    @Produces(value={"application/json", "application/xml"})
    public void deleteMessageBoardMessageMyRating(@Parameter(hidden=true) @NotNull @PathParam(value="messageBoardMessageId") Long messageBoardMessageId) throws Exception {
    }

    @Operation(description="Retrieves the message board message's rating.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="messageBoardMessageId"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields")})
    @Tags(value={@Tag(name="MessageBoardMessage")})
    @GET
    @Path(value="/message-board-messages/{messageBoardMessageId}/my-rating")
    @Produces(value={"application/json", "application/xml"})
    public Rating getMessageBoardMessageMyRating(@Parameter(hidden=true) @NotNull @PathParam(value="messageBoardMessageId") Long messageBoardMessageId) throws Exception {
        return new Rating();
    }

    @Operation(description="Creates a rating for the message board message.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="messageBoardMessageId")})
    @Tags(value={@Tag(name="MessageBoardMessage")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/message-board-messages/{messageBoardMessageId}/my-rating")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public Rating postMessageBoardMessageMyRating(@Parameter(hidden=true) @NotNull @PathParam(value="messageBoardMessageId") Long messageBoardMessageId, Rating rating) throws Exception {
        return new Rating();
    }

    @Operation(description="Replaces the rating with the information sent in the request body. Any missing fields are deleted, unless they are required.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="messageBoardMessageId")})
    @Tags(value={@Tag(name="MessageBoardMessage")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/message-board-messages/{messageBoardMessageId}/my-rating")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public Rating putMessageBoardMessageMyRating(@Parameter(hidden=true) @NotNull @PathParam(value="messageBoardMessageId") Long messageBoardMessageId, Rating rating) throws Exception {
        return new Rating();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="messageBoardMessageId"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields"), @Parameter(in=ParameterIn.QUERY, name="roleNames")})
    @Tags(value={@Tag(name="MessageBoardMessage")})
    @GET
    @Path(value="/message-board-messages/{messageBoardMessageId}/permissions")
    @Produces(value={"application/json", "application/xml"})
    public Page<Permission> getMessageBoardMessagePermissionsPage(@Parameter(hidden=true) @NotNull @PathParam(value="messageBoardMessageId") Long messageBoardMessageId, @Parameter(hidden=true) @QueryParam(value="roleNames") String roleNames) throws Exception {
        String resourceName = this.getPermissionCheckerResourceName(messageBoardMessageId);
        Long resourceId = this.getPermissionCheckerResourceId(messageBoardMessageId);
        PermissionUtil.checkPermission((String)"PERMISSIONS", (GroupLocalService)this.groupLocalService, (String)resourceName, (long)resourceId, (Long)this.getPermissionCheckerGroupId(messageBoardMessageId));
        return this.toPermissionPage(HashMapBuilder.put((Object)"get", this.addAction("PERMISSIONS", "getMessageBoardMessagePermissionsPage", resourceName, resourceId)).put((Object)"replace", this.addAction("PERMISSIONS", "putMessageBoardMessagePermissionsPage", resourceName, resourceId)).build(), resourceId, resourceName, roleNames);
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="messageBoardMessageId")})
    @Tags(value={@Tag(name="MessageBoardMessage")})
    @Path(value="/message-board-messages/{messageBoardMessageId}/permissions")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public Page<Permission> putMessageBoardMessagePermissionsPage(@Parameter(hidden=true) @NotNull @PathParam(value="messageBoardMessageId") Long messageBoardMessageId, Permission[] permissions) throws Exception {
        String resourceName = this.getPermissionCheckerResourceName(messageBoardMessageId);
        Long resourceId = this.getPermissionCheckerResourceId(messageBoardMessageId);
        PermissionUtil.checkPermission((String)"PERMISSIONS", (GroupLocalService)this.groupLocalService, (String)resourceName, (long)resourceId, (Long)this.getPermissionCheckerGroupId(messageBoardMessageId));
        this.resourcePermissionLocalService.updateResourcePermissions(this.contextCompany.getCompanyId(), this.getPermissionCheckerGroupId(messageBoardMessageId).longValue(), resourceName, String.valueOf(resourceId), ModelPermissionsUtil.toModelPermissions((long)this.contextCompany.getCompanyId(), (Permission[])permissions, (long)resourceId, (String)resourceName, (ResourceActionLocalService)this.resourceActionLocalService, (ResourcePermissionLocalService)this.resourcePermissionLocalService, (RoleLocalService)this.roleLocalService));
        return this.toPermissionPage(HashMapBuilder.put((Object)"get", this.addAction("PERMISSIONS", "getMessageBoardMessagePermissionsPage", resourceName, resourceId)).put((Object)"replace", this.addAction("PERMISSIONS", "putMessageBoardMessagePermissionsPage", resourceName, resourceId)).build(), resourceId, resourceName, null);
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="messageBoardMessageId")})
    @Tags(value={@Tag(name="MessageBoardMessage")})
    @Path(value="/message-board-messages/{messageBoardMessageId}/subscribe")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public void putMessageBoardMessageSubscribe(@Parameter(hidden=true) @NotNull @PathParam(value="messageBoardMessageId") Long messageBoardMessageId) throws Exception {
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="messageBoardMessageId")})
    @Tags(value={@Tag(name="MessageBoardMessage")})
    @Path(value="/message-board-messages/{messageBoardMessageId}/unsubscribe")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public void putMessageBoardMessageUnsubscribe(@Parameter(hidden=true) @NotNull @PathParam(value="messageBoardMessageId") Long messageBoardMessageId) throws Exception {
    }

    @Operation(description="Retrieves the parent message board message's child messages. Results can be paginated, filtered, searched, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="parentMessageBoardMessageId"), @Parameter(in=ParameterIn.QUERY, name="aggregationTerms"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="flatten"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Tags(value={@Tag(name="MessageBoardMessage")})
    @GET
    @Path(value="/message-board-messages/{parentMessageBoardMessageId}/message-board-messages")
    @Produces(value={"application/json", "application/xml"})
    public Page<MessageBoardMessage> getMessageBoardMessageMessageBoardMessagesPage(@Parameter(hidden=true) @NotNull @PathParam(value="parentMessageBoardMessageId") Long parentMessageBoardMessageId, @Parameter(hidden=true) @QueryParam(value="flatten") Boolean flatten, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Aggregation aggregation, @Context com.liferay.portal.kernel.search.filter.Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Operation(description="Creates a child message board message of the parent message.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="parentMessageBoardMessageId")})
    @Tags(value={@Tag(name="MessageBoardMessage")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/message-board-messages/{parentMessageBoardMessageId}/message-board-messages")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public MessageBoardMessage postMessageBoardMessageMessageBoardMessage(@Parameter(hidden=true) @NotNull @PathParam(value="parentMessageBoardMessageId") Long parentMessageBoardMessageId, MessageBoardMessage messageBoardMessage) throws Exception {
        return new MessageBoardMessage();
    }

    @Operation(description="Retrieves the message board thread's messages. Results can be paginated, filtered, searched, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="messageBoardThreadId"), @Parameter(in=ParameterIn.QUERY, name="aggregationTerms"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Tags(value={@Tag(name="MessageBoardMessage")})
    @GET
    @Path(value="/message-board-threads/{messageBoardThreadId}/message-board-messages")
    @Produces(value={"application/json", "application/xml"})
    public Page<MessageBoardMessage> getMessageBoardThreadMessageBoardMessagesPage(@Parameter(hidden=true) @NotNull @PathParam(value="messageBoardThreadId") Long messageBoardThreadId, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Aggregation aggregation, @Context com.liferay.portal.kernel.search.filter.Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Operation(description="Creates a new message in the message board thread.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="messageBoardThreadId")})
    @Tags(value={@Tag(name="MessageBoardMessage")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/message-board-threads/{messageBoardThreadId}/message-board-messages")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public MessageBoardMessage postMessageBoardThreadMessageBoardMessage(@Parameter(hidden=true) @NotNull @PathParam(value="messageBoardThreadId") Long messageBoardThreadId, MessageBoardMessage messageBoardMessage) throws Exception {
        return new MessageBoardMessage();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="messageBoardThreadId"), @Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="MessageBoardMessage")})
    @Consumes(value={"application/json"})
    @Path(value="/message-board-threads/{messageBoardThreadId}/message-board-messages/batch")
    @POST
    @Produces(value={"application/json"})
    public Response postMessageBoardThreadMessageBoardMessageBatch(@Parameter(hidden=true) @NotNull @PathParam(value="messageBoardThreadId") Long messageBoardThreadId, @Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.postImportTask(MessageBoardMessage.class.getName(), callbackURL, null, object)).build();
    }

    @Operation(description="Retrieves the site's message board messages.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.QUERY, name="aggregationTerms"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="flatten"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Tags(value={@Tag(name="MessageBoardMessage")})
    @GET
    @Path(value="/sites/{siteId}/message-board-messages")
    @Produces(value={"application/json", "application/xml"})
    public Page<MessageBoardMessage> getSiteMessageBoardMessagesPage(@Parameter(hidden=true) @NotNull @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @QueryParam(value="flatten") Boolean flatten, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Aggregation aggregation, @Context com.liferay.portal.kernel.search.filter.Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Operation(description="Deletes the site's message board message by external reference code.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="MessageBoardMessage")})
    @DELETE
    @Path(value="/sites/{siteId}/message-board-messages/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    public void deleteSiteMessageBoardMessageByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode) throws Exception {
    }

    @Operation(description="Retrieves the site's message board message by external reference code.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.PATH, name="externalReferenceCode"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields")})
    @Tags(value={@Tag(name="MessageBoardMessage")})
    @GET
    @Path(value="/sites/{siteId}/message-board-messages/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    public MessageBoardMessage getSiteMessageBoardMessageByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode) throws Exception {
        return new MessageBoardMessage();
    }

    @Operation(description="Updates the site's message board message with the given external reference code, or creates it if it not exists.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="MessageBoardMessage")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/sites/{siteId}/message-board-messages/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public MessageBoardMessage putSiteMessageBoardMessageByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode, MessageBoardMessage messageBoardMessage) throws Exception {
        return new MessageBoardMessage();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.PATH, name="friendlyUrlPath"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields")})
    @Tags(value={@Tag(name="MessageBoardMessage")})
    @GET
    @Path(value="/sites/{siteId}/message-board-messages/by-friendly-url-path/{friendlyUrlPath}")
    @Produces(value={"application/json", "application/xml"})
    public MessageBoardMessage getSiteMessageBoardMessageByFriendlyUrlPath(@Parameter(hidden=true) @NotNull @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @NotNull @PathParam(value="friendlyUrlPath") String friendlyUrlPath) throws Exception {
        return new MessageBoardMessage();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields"), @Parameter(in=ParameterIn.QUERY, name="roleNames")})
    @Tags(value={@Tag(name="MessageBoardMessage")})
    @GET
    @Path(value="/sites/{siteId}/message-board-messages/permissions")
    @Produces(value={"application/json", "application/xml"})
    public Page<Permission> getSiteMessageBoardMessagePermissionsPage(@Parameter(hidden=true) @NotNull @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @QueryParam(value="roleNames") String roleNames) throws Exception {
        String portletName = this.getPermissionCheckerPortletName(siteId);
        PermissionUtil.checkPermission((String)"PERMISSIONS", (GroupLocalService)this.groupLocalService, (String)portletName, (long)siteId, (Long)siteId);
        return this.toPermissionPage(HashMapBuilder.put((Object)"get", this.addAction("PERMISSIONS", "getSiteMessageBoardMessagePermissionsPage", portletName, siteId)).put((Object)"replace", this.addAction("PERMISSIONS", "putSiteMessageBoardMessagePermissionsPage", portletName, siteId)).build(), siteId, portletName, roleNames);
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId")})
    @Tags(value={@Tag(name="MessageBoardMessage")})
    @Path(value="/sites/{siteId}/message-board-messages/permissions")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public Page<Permission> putSiteMessageBoardMessagePermissionsPage(@Parameter(hidden=true) @NotNull @PathParam(value="siteId") Long siteId, Permission[] permissions) throws Exception {
        String portletName = this.getPermissionCheckerPortletName(siteId);
        PermissionUtil.checkPermission((String)"PERMISSIONS", (GroupLocalService)this.groupLocalService, (String)portletName, (long)siteId, (Long)siteId);
        this.resourcePermissionLocalService.updateResourcePermissions(this.contextCompany.getCompanyId(), siteId.longValue(), portletName, String.valueOf(siteId), ModelPermissionsUtil.toModelPermissions((long)this.contextCompany.getCompanyId(), (Permission[])permissions, (long)siteId, (String)portletName, (ResourceActionLocalService)this.resourceActionLocalService, (ResourcePermissionLocalService)this.resourcePermissionLocalService, (RoleLocalService)this.roleLocalService));
        return this.toPermissionPage(HashMapBuilder.put((Object)"get", this.addAction("PERMISSIONS", "getSiteMessageBoardMessagePermissionsPage", portletName, siteId)).put((Object)"replace", this.addAction("PERMISSIONS", "putSiteMessageBoardMessagePermissionsPage", portletName, siteId)).build(), siteId, portletName, null);
    }

    public void create(Collection<MessageBoardMessage> messageBoardMessages, Map<String, Serializable> parameters) throws Exception {
        UnsafeConsumer messageBoardMessageUnsafeConsumer = null;
        String createStrategy = (String)((Object)parameters.getOrDefault("createStrategy", (Serializable)((Object)"INSERT")));
        if ("INSERT".equalsIgnoreCase(createStrategy)) {
            if (parameters.containsKey("messageBoardThreadId")) {
                messageBoardMessageUnsafeConsumer = messageBoardMessage -> this.postMessageBoardThreadMessageBoardMessage(Long.parseLong((String)parameters.get("messageBoardThreadId")), (MessageBoardMessage)messageBoardMessage);
            } else {
                throw new NotSupportedException("One of the following parameters must be specified: [messageBoardThreadId]");
            }
        }
        if ("UPSERT".equalsIgnoreCase(createStrategy)) {
            messageBoardMessageUnsafeConsumer = messageBoardMessage -> this.putSiteMessageBoardMessageByExternalReferenceCode(messageBoardMessage.getSiteId() != null ? messageBoardMessage.getSiteId() : (Long)parameters.get("siteId"), messageBoardMessage.getExternalReferenceCode(), (MessageBoardMessage)messageBoardMessage);
        }
        if (messageBoardMessageUnsafeConsumer == null) {
            throw new NotSupportedException("Create strategy \"" + createStrategy + "\" is not supported for MessageBoardMessage");
        }
        if (this.contextBatchUnsafeConsumer != null) {
            this.contextBatchUnsafeConsumer.accept(messageBoardMessages, (Object)messageBoardMessageUnsafeConsumer);
        } else {
            for (MessageBoardMessage messageBoardMessage2 : messageBoardMessages) {
                messageBoardMessageUnsafeConsumer.accept((Object)messageBoardMessage2);
            }
        }
    }

    public void delete(Collection<MessageBoardMessage> messageBoardMessages, Map<String, Serializable> parameters) throws Exception {
        for (MessageBoardMessage messageBoardMessage : messageBoardMessages) {
            this.deleteMessageBoardMessage(messageBoardMessage.getId());
        }
    }

    public Set<String> getAvailableCreateStrategies() {
        return SetUtil.fromArray((Object[])new String[]{"UPSERT", "INSERT"});
    }

    public Set<String> getAvailableUpdateStrategies() {
        return SetUtil.fromArray((Object[])new String[]{"PARTIAL_UPDATE", "UPDATE"});
    }

    public EntityModel getEntityModel(Map<String, List<String>> multivaluedMap) throws Exception {
        return this.getEntityModel((MultivaluedMap)new MultivaluedHashMap(multivaluedMap));
    }

    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return null;
    }

    public String getVersion() {
        return "v1.0";
    }

    public Page<MessageBoardMessage> read(com.liferay.portal.kernel.search.filter.Filter filter, Pagination pagination, Sort[] sorts, Map<String, Serializable> parameters, String search) throws Exception {
        if (parameters.containsKey("siteId")) {
            return this.getSiteMessageBoardMessagesPage((Long)parameters.get("siteId"), Boolean.parseBoolean((String)((Object)parameters.get("flatten"))), search, null, filter, pagination, sorts);
        }
        if (parameters.containsKey("messageBoardThreadId")) {
            return this.getMessageBoardThreadMessageBoardMessagesPage(Long.parseLong((String)((Object)parameters.get("messageBoardThreadId"))), search, null, filter, pagination, sorts);
        }
        throw new NotSupportedException("One of the following parameters must be specified: [siteId, messageBoardThreadId]");
    }

    public void setLanguageId(final String languageId) {
        this.contextAcceptLanguage = new AcceptLanguage(){

            public List<Locale> getLocales() {
                return null;
            }

            public String getPreferredLanguageId() {
                return languageId;
            }

            public Locale getPreferredLocale() {
                return LocaleUtil.fromLanguageId((String)languageId);
            }
        };
    }

    public void update(Collection<MessageBoardMessage> messageBoardMessages, Map<String, Serializable> parameters) throws Exception {
        UnsafeConsumer messageBoardMessageUnsafeConsumer = null;
        String updateStrategy = (String)((Object)parameters.getOrDefault("updateStrategy", (Serializable)((Object)"UPDATE")));
        if ("PARTIAL_UPDATE".equalsIgnoreCase(updateStrategy)) {
            messageBoardMessageUnsafeConsumer = messageBoardMessage -> this.patchMessageBoardMessage(messageBoardMessage.getId() != null ? messageBoardMessage.getId() : Long.parseLong((String)parameters.get("messageBoardMessageId")), (MessageBoardMessage)messageBoardMessage);
        }
        if ("UPDATE".equalsIgnoreCase(updateStrategy)) {
            messageBoardMessageUnsafeConsumer = messageBoardMessage -> this.putMessageBoardMessage(messageBoardMessage.getId() != null ? messageBoardMessage.getId() : Long.parseLong((String)parameters.get("messageBoardMessageId")), (MessageBoardMessage)messageBoardMessage);
        }
        if (messageBoardMessageUnsafeConsumer == null) {
            throw new NotSupportedException("Update strategy \"" + updateStrategy + "\" is not supported for MessageBoardMessage");
        }
        if (this.contextBatchUnsafeConsumer != null) {
            this.contextBatchUnsafeConsumer.accept(messageBoardMessages, (Object)messageBoardMessageUnsafeConsumer);
        } else {
            for (MessageBoardMessage messageBoardMessage2 : messageBoardMessages) {
                messageBoardMessageUnsafeConsumer.accept((Object)messageBoardMessage2);
            }
        }
    }

    protected String getPermissionCheckerActionsResourceName(Object id) throws Exception {
        return this.getPermissionCheckerResourceName(id);
    }

    protected Long getPermissionCheckerGroupId(Object id) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    protected String getPermissionCheckerPortletName(Object id) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    protected Long getPermissionCheckerResourceId(Object id) throws Exception {
        return GetterUtil.getLong((Object)id);
    }

    protected String getPermissionCheckerResourceName(Object id) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    protected Page<Permission> toPermissionPage(Map<String, Map<String, String>> actions, long id, String resourceName, String roleNames) throws Exception {
        List resourceActions = this.resourceActionLocalService.getResourceActions(resourceName);
        if (Validator.isNotNull((String)roleNames)) {
            return Page.of(actions, this.transform(PermissionUtil.getRoles((Company)this.contextCompany, (RoleLocalService)this.roleLocalService, (String[])StringUtil.split((String)roleNames)), role -> PermissionUtil.toPermission((Long)this.contextCompany.getCompanyId(), (Long)id, (List)resourceActions, (String)resourceName, (ResourcePermissionLocalService)this.resourcePermissionLocalService, (Role)role)));
        }
        return Page.of(actions, this.transform(PermissionUtil.getResourcePermissions((long)this.contextCompany.getCompanyId(), (long)id, (String)resourceName, (ResourcePermissionLocalService)this.resourcePermissionLocalService), resourcePermission -> PermissionUtil.toPermission((List)resourceActions, (ResourcePermission)resourcePermission, (Role)this.roleLocalService.getRole(resourcePermission.getRoleId()))));
    }

    public void setContextAcceptLanguage(AcceptLanguage contextAcceptLanguage) {
        this.contextAcceptLanguage = contextAcceptLanguage;
    }

    public void setContextBatchUnsafeConsumer(UnsafeBiConsumer<Collection<MessageBoardMessage>, UnsafeConsumer<MessageBoardMessage, Exception>, Exception> contextBatchUnsafeConsumer) {
        this.contextBatchUnsafeConsumer = contextBatchUnsafeConsumer;
    }

    public void setContextCompany(Company contextCompany) {
        this.contextCompany = contextCompany;
    }

    public void setContextHttpServletRequest(HttpServletRequest contextHttpServletRequest) {
        this.contextHttpServletRequest = contextHttpServletRequest;
    }

    public void setContextHttpServletResponse(HttpServletResponse contextHttpServletResponse) {
        this.contextHttpServletResponse = contextHttpServletResponse;
    }

    public void setContextUriInfo(UriInfo contextUriInfo) {
        this.contextUriInfo = contextUriInfo;
    }

    public void setContextUser(User contextUser) {
        this.contextUser = contextUser;
    }

    public void setExpressionConvert(ExpressionConvert<com.liferay.portal.kernel.search.filter.Filter> expressionConvert) {
        this.expressionConvert = expressionConvert;
    }

    public void setFilterParserProvider(FilterParserProvider filterParserProvider) {
        this.filterParserProvider = filterParserProvider;
    }

    public void setGroupLocalService(GroupLocalService groupLocalService) {
        this.groupLocalService = groupLocalService;
    }

    public void setResourceActionLocalService(ResourceActionLocalService resourceActionLocalService) {
        this.resourceActionLocalService = resourceActionLocalService;
    }

    public void setResourcePermissionLocalService(ResourcePermissionLocalService resourcePermissionLocalService) {
        this.resourcePermissionLocalService = resourcePermissionLocalService;
    }

    public void setRoleLocalService(RoleLocalService roleLocalService) {
        this.roleLocalService = roleLocalService;
    }

    public void setVulcanBatchEngineImportTaskResource(VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource) {
        this.vulcanBatchEngineImportTaskResource = vulcanBatchEngineImportTaskResource;
    }

    public com.liferay.portal.kernel.search.filter.Filter toFilter(String filterString, Map<String, List<String>> multivaluedMap) {
        try {
            EntityModel entityModel = this.getEntityModel(multivaluedMap);
            FilterParser filterParser = this.filterParserProvider.provide(entityModel);
            Filter oDataFilter = new Filter(filterParser.parse(filterString));
            return (com.liferay.portal.kernel.search.filter.Filter)this.expressionConvert.convert(oDataFilter.getExpression(), this.contextAcceptLanguage.getPreferredLocale(), entityModel);
        }
        catch (Exception exception) {
            _log.error((Object)("Invalid filter " + filterString), (Throwable)exception);
            return null;
        }
    }

    protected Map<String, String> addAction(String actionName, GroupedModel groupedModel, String methodName) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (GroupedModel)groupedModel, (String)methodName, (Object)this.contextScopeChecker, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, Long ownerId, String permissionName, Long siteId) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (Long)ownerId, (String)permissionName, (Long)siteId, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, ModelResourcePermission modelResourcePermission) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (ModelResourcePermission)modelResourcePermission, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, String methodName, String permissionName, Long siteId) {
        return this.addAction(actionName, siteId, methodName, null, permissionName, siteId);
    }

    protected void preparePatch(MessageBoardMessage messageBoardMessage, MessageBoardMessage existingMessageBoardMessage) {
    }

    protected <T, R, E extends Throwable> List<R> transform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transform(collection, unsafeFunction);
    }

    protected <T, R, E extends Throwable> R[] transform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] transformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> List<R> transformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transformToList((Object[])array, unsafeFunction);
    }

    protected <T, R, E extends Throwable> List<R> unsafeTransform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransform(collection, unsafeFunction);
    }

    protected <T, R, E extends Throwable> R[] unsafeTransform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) throws E {
        return TransformUtil.unsafeTransform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] unsafeTransformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) throws E {
        return TransformUtil.unsafeTransformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> List<R> unsafeTransformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToList((Object[])array, unsafeFunction);
    }
}

