/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.dynamic.data.mapping.util.DDMIndexer;
import com.liferay.expando.kernel.service.ExpandoColumnLocalService;
import com.liferay.expando.kernel.service.ExpandoTableLocalService;
import com.liferay.headless.common.spi.odata.entity.EntityFieldsUtil;
import com.liferay.headless.common.spi.resource.SPIRatingResource;
import com.liferay.headless.common.spi.service.context.ServiceContextRequestUtil;
import com.liferay.headless.delivery.dto.v1_0.CustomField;
import com.liferay.headless.delivery.dto.v1_0.MessageBoardMessage;
import com.liferay.headless.delivery.dto.v1_0.Rating;
import com.liferay.headless.delivery.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.converter.MessageBoardMessageDTOConverter;
import com.liferay.headless.delivery.internal.dto.v1_0.util.RatingUtil;
import com.liferay.headless.delivery.internal.odata.entity.v1_0.MessageBoardMessageEntityModel;
import com.liferay.headless.delivery.internal.resource.v1_0.BaseMessageBoardMessageResourceImpl;
import com.liferay.headless.delivery.resource.v1_0.MessageBoardMessageResource;
import com.liferay.headless.delivery.search.aggregation.AggregationUtil;
import com.liferay.headless.delivery.search.filter.FilterUtil;
import com.liferay.headless.delivery.search.sort.SortUtil;
import com.liferay.message.boards.constants.MBMessageConstants;
import com.liferay.message.boards.exception.NoSuchMessageException;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.model.MBThread;
import com.liferay.message.boards.service.MBMessageLocalService;
import com.liferay.message.boards.service.MBMessageService;
import com.liferay.message.boards.service.MBThreadLocalService;
import com.liferay.message.boards.util.comparator.MessageCreateDateComparator;
import com.liferay.message.boards.util.comparator.MessageModifiedDateComparator;
import com.liferay.message.boards.util.comparator.MessageSubjectComparator;
import com.liferay.message.boards.util.comparator.MessageURLSubjectComparator;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.search.aggregation.Aggregations;
import com.liferay.portal.search.expando.ExpandoBridgeIndexer;
import com.liferay.portal.search.legacy.searcher.SearchRequestBuilderFactory;
import com.liferay.portal.search.query.Queries;
import com.liferay.portal.search.searcher.SearchRequestBuilder;
import com.liferay.portal.search.sort.Sorts;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.SearchUtil;
import com.liferay.portal.vulcan.util.TransformUtil;
import com.liferay.portal.vulcan.util.UriInfoUtil;
import com.liferay.ratings.kernel.service.RatingsEntryLocalService;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/message-board-message.properties"}, scope=ServiceScope.PROTOTYPE, service={MessageBoardMessageResource.class})
public class MessageBoardMessageResourceImpl
extends BaseMessageBoardMessageResourceImpl {
    @Reference
    private Aggregations _aggregations;
    @Reference
    private DDMIndexer _ddmIndexer;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ExpandoBridgeIndexer _expandoBridgeIndexer;
    @Reference
    private ExpandoColumnLocalService _expandoColumnLocalService;
    @Reference
    private ExpandoTableLocalService _expandoTableLocalService;
    @Reference
    private MBMessageLocalService _mbMessageLocalService;
    @Reference
    private MBMessageService _mbMessageService;
    @Reference
    private MBThreadLocalService _mbThreadLocalService;
    @Reference
    private MessageBoardMessageDTOConverter _messageBoardMessageDTOConverter;
    @Reference
    private Portal _portal;
    @Reference
    private Queries _queries;
    @Reference
    private RatingsEntryLocalService _ratingsEntryLocalService;
    @Reference
    private SearchRequestBuilderFactory _searchRequestBuilderFactory;
    @Reference
    private Sorts _sorts;
    @Reference
    private UserLocalService _userLocalService;

    @Override
    public void deleteMessageBoardMessage(Long messageBoardMessageId) throws Exception {
        this._mbMessageService.deleteMessage(messageBoardMessageId.longValue());
    }

    @Override
    public void deleteMessageBoardMessageMyRating(Long messageBoardMessageId) throws Exception {
        SPIRatingResource<Rating> spiRatingResource = this._getSPIRatingResource();
        spiRatingResource.deleteRating(messageBoardMessageId);
    }

    @Override
    public void deleteSiteMessageBoardMessageByExternalReferenceCode(Long siteId, String externalReferenceCode) throws Exception {
        MBMessage mbMessage = this._mbMessageLocalService.getMBMessageByExternalReferenceCode(siteId.longValue(), externalReferenceCode);
        this._mbMessageService.deleteMessage(mbMessage.getMessageId());
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) {
        return new MessageBoardMessageEntityModel(EntityFieldsUtil.getEntityFields((long)this._portal.getClassNameId(MBMessage.class.getName()), (long)this.contextCompany.getCompanyId(), (ExpandoBridgeIndexer)this._expandoBridgeIndexer, (ExpandoColumnLocalService)this._expandoColumnLocalService, (ExpandoTableLocalService)this._expandoTableLocalService));
    }

    @Override
    public MessageBoardMessage getMessageBoardMessage(Long messageBoardMessageId) throws Exception {
        return this._toMessageBoardMessage(this._mbMessageService.getMessage(messageBoardMessageId.longValue()));
    }

    @Override
    public Page<MessageBoardMessage> getMessageBoardMessageMessageBoardMessagesPage(Long parentMessageBoardMessageId, Boolean flatten, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        MBMessage mbMessage = this._mbMessageService.getMessage(parentMessageBoardMessageId.longValue());
        HashMap actions = HashMapBuilder.put((Object)"get-child-messages", this.addAction("VIEW", mbMessage.getMessageId(), "getMessageBoardMessageMessageBoardMessagesPage", mbMessage.getUserId(), "com.liferay.message.boards", mbMessage.getGroupId())).put((Object)"reply-to-message", this.addAction("REPLY_TO_MESSAGE", mbMessage.getMessageId(), "postMessageBoardMessageMessageBoardMessage", mbMessage.getUserId(), "com.liferay.message.boards", mbMessage.getGroupId())).build();
        if (search == null && filter == null) {
            OrderByComparator<MBMessage> orderByComparator = this._getMBMessageOrderByComparator(sorts);
            int status = 0;
            PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
            if (permissionChecker.isContentReviewer(this.contextCompany.getCompanyId(), mbMessage.getGroupId())) {
                status = -1;
            }
            return Page.of((Map)actions, (Collection)TransformUtil.transform((Collection)this._mbMessageService.getChildMessages(mbMessage.getMessageId(), Optional.ofNullable(flatten).orElse(false).booleanValue(), new QueryDefinition(status, this.contextUser.getUserId(), true, pagination.getStartPosition(), pagination.getEndPosition(), orderByComparator)), this::_toMessageBoardMessage), (Pagination)pagination, (long)this._mbMessageService.getChildMessagesCount(mbMessage.getMessageId(), Optional.ofNullable(flatten).orElse(false).booleanValue(), new QueryDefinition(status, this.contextUser.getUserId(), true, pagination.getStartPosition(), pagination.getEndPosition(), orderByComparator)));
        }
        return this._getMessageBoardMessagesPage(actions, parentMessageBoardMessageId, null, flatten, search, aggregation, filter, pagination, sorts);
    }

    @Override
    public Rating getMessageBoardMessageMyRating(Long messageBoardMessageId) throws Exception {
        SPIRatingResource<Rating> spiRatingResource = this._getSPIRatingResource();
        return (Rating)spiRatingResource.getRating(messageBoardMessageId);
    }

    @Override
    public Page<MessageBoardMessage> getMessageBoardThreadMessageBoardMessagesPage(Long messageBoardThreadId, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        MBThread mbThread = this._mbThreadLocalService.getMBThread(messageBoardThreadId.longValue());
        HashMap actions = HashMapBuilder.put((Object)"create", this.addAction("ADD_MESSAGE", mbThread.getThreadId(), "postMessageBoardThreadMessageBoardMessage", mbThread.getUserId(), "com.liferay.message.boards", mbThread.getGroupId())).put((Object)"get", this.addAction("VIEW", mbThread.getThreadId(), "getMessageBoardThreadMessageBoardMessagesPage", mbThread.getUserId(), "com.liferay.message.boards", mbThread.getGroupId())).build();
        if (search == null && filter == null) {
            OrderByComparator<MBMessage> orderByComparator = this._getMBMessageOrderByComparator(sorts);
            int status = 0;
            PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
            if (permissionChecker.isContentReviewer(this.contextCompany.getCompanyId(), mbThread.getGroupId())) {
                status = -1;
            }
            return Page.of((Map)actions, (Collection)TransformUtil.transform((Collection)this._mbMessageService.getChildMessages(mbThread.getRootMessageId(), false, new QueryDefinition(status, this.contextUser.getUserId(), true, pagination.getStartPosition(), pagination.getEndPosition(), orderByComparator)), this::_toMessageBoardMessage), (Pagination)pagination, (long)this._mbMessageService.getChildMessagesCount(mbThread.getRootMessageId(), false, new QueryDefinition(status, this.contextUser.getUserId(), true, pagination.getStartPosition(), pagination.getEndPosition(), orderByComparator)));
        }
        return this._getMessageBoardMessagesPage(actions, mbThread.getRootMessageId(), null, false, search, aggregation, filter, pagination, sorts);
    }

    @Override
    public MessageBoardMessage getSiteMessageBoardMessageByExternalReferenceCode(Long siteId, String externalReferenceCode) throws Exception {
        return this._toMessageBoardMessage(this._mbMessageLocalService.getMBMessageByExternalReferenceCode(siteId.longValue(), externalReferenceCode));
    }

    @Override
    public MessageBoardMessage getSiteMessageBoardMessageByFriendlyUrlPath(Long siteId, String friendlyUrlPath) throws Exception {
        MBMessage mbMessage = this._mbMessageService.fetchMBMessageByUrlSubject(siteId.longValue(), friendlyUrlPath);
        if (mbMessage == null) {
            throw new NoSuchMessageException("No message exists with friendly URL path " + friendlyUrlPath);
        }
        return this._toMessageBoardMessage(mbMessage);
    }

    @Override
    public Page<MessageBoardMessage> getSiteMessageBoardMessagesPage(Long siteId, Boolean flatten, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return this._getMessageBoardMessagesPage(HashMapBuilder.put((Object)"get", this.addAction("VIEW", "getSiteMessageBoardMessagesPage", "com.liferay.message.boards", siteId)).build(), null, siteId, flatten, search, aggregation, filter, pagination, sorts);
    }

    @Override
    public MessageBoardMessage postMessageBoardMessageMessageBoardMessage(Long parentMessageBoardMessageId, MessageBoardMessage messageBoardMessage) throws Exception {
        MBMessage mbMessage = this._mbMessageLocalService.getMBMessage(parentMessageBoardMessageId.longValue());
        return this._addMessageBoardMessage(messageBoardMessage.getExternalReferenceCode(), mbMessage.getGroupId(), mbMessage.getMessageId(), messageBoardMessage);
    }

    @Override
    public Rating postMessageBoardMessageMyRating(Long messageBoardMessageId, Rating rating) throws Exception {
        SPIRatingResource<Rating> spiRatingResource = this._getSPIRatingResource();
        return (Rating)spiRatingResource.addOrUpdateRating((Number)rating.getRatingValue(), messageBoardMessageId.longValue());
    }

    @Override
    public MessageBoardMessage postMessageBoardThreadMessageBoardMessage(Long messageBoardThreadId, MessageBoardMessage messageBoardMessage) throws Exception {
        MBThread mbThread = this._mbThreadLocalService.getMBThread(messageBoardThreadId.longValue());
        return this._addMessageBoardMessage(messageBoardMessage.getExternalReferenceCode(), mbThread.getGroupId(), mbThread.getRootMessageId(), messageBoardMessage);
    }

    @Override
    public MessageBoardMessage putMessageBoardMessage(Long messageBoardMessageId, MessageBoardMessage messageBoardMessage) throws Exception {
        MBMessage mbMessage = this._mbMessageService.getMessage(messageBoardMessageId.longValue());
        return this._updateMessageBoardMessage(mbMessage, messageBoardMessage);
    }

    @Override
    public Rating putMessageBoardMessageMyRating(Long messageBoardMessageId, Rating rating) throws Exception {
        SPIRatingResource<Rating> spiRatingResource = this._getSPIRatingResource();
        return (Rating)spiRatingResource.addOrUpdateRating((Number)rating.getRatingValue(), messageBoardMessageId.longValue());
    }

    @Override
    public void putMessageBoardMessageSubscribe(Long messageBoardMessageId) throws Exception {
        this._mbMessageService.subscribeMessage(messageBoardMessageId.longValue());
    }

    @Override
    public void putMessageBoardMessageUnsubscribe(Long messageBoardMessageId) throws Exception {
        this._mbMessageService.unsubscribeMessage(messageBoardMessageId.longValue());
    }

    @Override
    public MessageBoardMessage putSiteMessageBoardMessageByExternalReferenceCode(Long siteId, String externalReferenceCode, MessageBoardMessage messageBoardMessage) throws Exception {
        MBMessage mbMessage = this._mbMessageLocalService.fetchMBMessageByExternalReferenceCode(siteId.longValue(), externalReferenceCode);
        if (mbMessage != null) {
            return this._updateMessageBoardMessage(mbMessage, messageBoardMessage);
        }
        return this._addMessageBoardMessage(externalReferenceCode, siteId, messageBoardMessage.getParentMessageBoardMessageId(), messageBoardMessage);
    }

    @Override
    protected Long getPermissionCheckerGroupId(Object id) throws Exception {
        MBMessage mbMessage = this._mbMessageService.getMessage(((Long)id).longValue());
        return mbMessage.getGroupId();
    }

    @Override
    protected String getPermissionCheckerPortletName(Object id) {
        return "com.liferay.message.boards";
    }

    @Override
    protected String getPermissionCheckerResourceName(Object id) {
        return MBMessage.class.getName();
    }

    private MessageBoardMessage _addMessageBoardMessage(String externalReferenceCode, Long groupId, Long parentMessageId, MessageBoardMessage messageBoardMessage) throws Exception {
        String encodingFormat;
        if (parentMessageId == null) {
            throw new BadRequestException("Parent message board ID is null");
        }
        String headline = messageBoardMessage.getHeadline();
        if (headline == null) {
            MBMessage parentMBMessage = this._mbMessageService.getMessage(parentMessageId.longValue());
            headline = "RE: " + parentMBMessage.getSubject();
        }
        if ((encodingFormat = messageBoardMessage.getEncodingFormat()) == null) {
            encodingFormat = MBMessageConstants.DEFAULT_FORMAT;
        }
        MBMessage mbMessage = this._mbMessageService.addMessage(externalReferenceCode, parentMessageId.longValue(), headline, messageBoardMessage.getArticleBody(), encodingFormat, Collections.emptyList(), GetterUtil.getBoolean((Object)messageBoardMessage.getAnonymous()), 0.0, false, this._createServiceContext(groupId, messageBoardMessage));
        this._updateAnswer(mbMessage, messageBoardMessage);
        return this._toMessageBoardMessage(mbMessage);
    }

    private ServiceContext _createServiceContext(long groupId, MessageBoardMessage messageBoardMessage) {
        ServiceContext serviceContext = ServiceContextRequestUtil.createServiceContext(this._getExpandoBridgeAttributes(messageBoardMessage), (long)groupId, (HttpServletRequest)this.contextHttpServletRequest, (String)messageBoardMessage.getViewableByAsString());
        String link = this.contextHttpServletRequest.getHeader("Link");
        if (link == null) {
            UriBuilder uriBuilder = UriInfoUtil.getBaseUriBuilder((UriInfo)this.contextUriInfo);
            link = String.valueOf(uriBuilder.replacePath("/").build(new Object[0]));
        }
        serviceContext.setAttribute("entryURL", (Serializable)((Object)link));
        if (messageBoardMessage.getId() == null) {
            serviceContext.setCommand("add");
        } else {
            serviceContext.setCommand("update");
        }
        return serviceContext;
    }

    private Map<String, Serializable> _getExpandoBridgeAttributes(MessageBoardMessage messageBoardMessage) {
        return CustomFieldsUtil.toMap((String)MBMessage.class.getName(), (long)this.contextCompany.getCompanyId(), (CustomField[])messageBoardMessage.getCustomFields(), (Locale)this.contextAcceptLanguage.getPreferredLocale());
    }

    private OrderByComparator<MBMessage> _getMBMessageOrderByComparator(Sort[] sorts) {
        MessageCreateDateComparator orderByComparator = null;
        if (sorts != null && sorts.length == 1) {
            Sort sort = sorts[0];
            String fieldName = sort.getFieldName();
            if (Objects.equals(fieldName, "createDate_sortable")) {
                orderByComparator = new MessageCreateDateComparator(!sort.isReverse());
            } else if (Objects.equals(fieldName, "modified_sortable")) {
                orderByComparator = new MessageModifiedDateComparator(!sort.isReverse());
            } else if (fieldName.contains("title")) {
                orderByComparator = new MessageSubjectComparator(!sort.isReverse());
            } else if (fieldName.contains("urlSubject")) {
                orderByComparator = new MessageURLSubjectComparator(!sort.isReverse());
            }
        }
        return orderByComparator;
    }

    private Page<MessageBoardMessage> _getMessageBoardMessagesPage(Map<String, Map<String, String>> actions, Long messageBoardMessageId, Long siteId, Boolean flatten, String keywords, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        if (messageBoardMessageId != null) {
            MBMessage mbMessage = this._mbMessageService.getMessage(messageBoardMessageId.longValue());
            siteId = mbMessage.getGroupId();
        }
        long messageBoardMessageSiteId = siteId;
        return SearchUtil.search(actions, booleanQuery -> {
            BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
            if (messageBoardMessageId != null) {
                booleanFilter.add((Filter)new TermFilter("entryClassPK", String.valueOf(messageBoardMessageId)), BooleanClauseOccur.MUST_NOT);
                String field = "parentMessageId";
                if (GetterUtil.getBoolean((Object)flatten)) {
                    field = "treePath";
                }
                booleanFilter.add((Filter)new TermFilter(field, String.valueOf(messageBoardMessageId)), BooleanClauseOccur.MUST);
            } else {
                if (!GetterUtil.getBoolean((Object)flatten)) {
                    booleanFilter.add((Filter)new TermFilter("categoryId", "0"), BooleanClauseOccur.MUST);
                }
                booleanFilter.add((Filter)new TermFilter("groupId", String.valueOf(messageBoardMessageSiteId)), BooleanClauseOccur.MUST);
            }
        }, (Filter)FilterUtil.processFilter((DDMIndexer)this._ddmIndexer, (Filter)filter), (String)MBMessage.class.getName(), (String)keywords, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> {
            searchContext.addVulcanAggregation(aggregation);
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
            SearchRequestBuilder searchRequestBuilder = this._searchRequestBuilderFactory.builder((SearchContext)searchContext);
            AggregationUtil.processVulcanAggregation((Aggregations)this._aggregations, (DDMIndexer)this._ddmIndexer, (Queries)this._queries, (SearchRequestBuilder)searchRequestBuilder, (Aggregation)aggregation);
            SortUtil.processSorts((DDMIndexer)this._ddmIndexer, (SearchRequestBuilder)searchRequestBuilder, (Sort[])searchContext.getSorts(), (Queries)this._queries, (Sorts)this._sorts);
        }, (Sort[])sorts, document -> this._toMessageBoardMessage(this._mbMessageService.getMessage(GetterUtil.getLong((String)document.get("entryClassPK")))));
    }

    private SPIRatingResource<Rating> _getSPIRatingResource() {
        return new SPIRatingResource(MBMessage.class.getName(), this._ratingsEntryLocalService, ratingsEntry -> {
            MBMessage mbMessage = this._mbMessageService.getMessage(ratingsEntry.getClassPK());
            return RatingUtil.toRating(HashMapBuilder.put((Object)"create", this.addAction("VIEW", (GroupedModel)mbMessage, "postMessageBoardMessageMyRating")).put((Object)"delete", this.addAction("VIEW", (GroupedModel)mbMessage, "deleteMessageBoardMessageMyRating")).put((Object)"get", this.addAction("VIEW", (GroupedModel)mbMessage, "getMessageBoardMessageMyRating")).put((Object)"replace", this.addAction("VIEW", (GroupedModel)mbMessage, "putMessageBoardMessageMyRating")).build(), this._portal, ratingsEntry, this._userLocalService);
        }, this.contextUser);
    }

    private MessageBoardMessage _toMessageBoardMessage(MBMessage mbMessage) throws Exception {
        return this._messageBoardMessageDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(false, (Map)HashMapBuilder.put((Object)"delete", this.addAction("DELETE", (GroupedModel)mbMessage, "deleteMessageBoardMessage")).put((Object)"get", this.addAction("VIEW", (GroupedModel)mbMessage, "getMessageBoardMessage")).put((Object)"replace", this.addAction("UPDATE", (GroupedModel)mbMessage, "putMessageBoardMessage")).put((Object)"reply-to-message", this.addAction("REPLY_TO_MESSAGE", mbMessage.getMessageId(), "postMessageBoardMessageMessageBoardMessage", mbMessage.getUserId(), "com.liferay.message.boards", mbMessage.getGroupId())).put((Object)"subscribe", this.addAction("SUBSCRIBE", (GroupedModel)mbMessage, "putMessageBoardMessageSubscribe")).put((Object)"unsubscribe", this.addAction("SUBSCRIBE", (GroupedModel)mbMessage, "putMessageBoardMessageSubscribe")).put((Object)"update", this.addAction("UPDATE", (GroupedModel)mbMessage, "patchMessageBoardMessage")).build(), this._dtoConverterRegistry, (Object)mbMessage.getPrimaryKey(), this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }

    private void _updateAnswer(MBMessage mbMessage, MessageBoardMessage messageBoardMessage) throws Exception {
        Boolean showAsAnswer = messageBoardMessage.getShowAsAnswer();
        if (showAsAnswer != null && showAsAnswer.booleanValue() != mbMessage.isAnswer()) {
            this._mbMessageService.updateAnswer(mbMessage.getMessageId(), showAsAnswer.booleanValue(), false);
            mbMessage.setAnswer(showAsAnswer.booleanValue());
        }
    }

    private MessageBoardMessage _updateMessageBoardMessage(MBMessage mbMessage, MessageBoardMessage messageBoardMessage) throws Exception {
        if (messageBoardMessage.getArticleBody() == null && messageBoardMessage.getHeadline() == null) {
            throw new BadRequestException("Article body and headline are both null");
        }
        String headline = messageBoardMessage.getHeadline();
        if (headline == null) {
            MBMessage parentMBMessage = this._mbMessageService.getMessage(mbMessage.getParentMessageId());
            headline = "RE: " + parentMBMessage.getSubject();
        }
        mbMessage = this._mbMessageService.updateDiscussionMessage(mbMessage.getClassName(), mbMessage.getClassPK(), mbMessage.getMessageId(), headline, messageBoardMessage.getArticleBody(), this._createServiceContext(mbMessage.getGroupId(), messageBoardMessage));
        this._updateAnswer(mbMessage, messageBoardMessage);
        return this._toMessageBoardMessage(mbMessage);
    }
}

