/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.friendly.url.model.FriendlyURLEntryLocalization;
import com.liferay.friendly.url.service.FriendlyURLEntryLocalService;
import com.liferay.headless.delivery.dto.v1_0.SitePage;
import com.liferay.headless.delivery.internal.dto.v1_0.converter.SitePageDTOConverter;
import com.liferay.headless.delivery.internal.odata.entity.v1_0.SitePageEntityModel;
import com.liferay.headless.delivery.internal.resource.v1_0.BaseSitePageResourceImpl;
import com.liferay.headless.delivery.resource.v1_0.SitePageResource;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.events.ServicePreAction;
import com.liferay.portal.events.ThemeServicePreAction;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.LayoutFriendlyURLLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutService;
import com.liferay.portal.kernel.servlet.DummyHttpServletResponse;
import com.liferay.portal.kernel.servlet.DynamicServletRequest;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.theme.ThemeUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.JaxRsLinkUtil;
import com.liferay.portal.vulcan.util.SearchUtil;
import com.liferay.portal.vulcan.util.TransformUtil;
import com.liferay.segments.SegmentsEntryRetriever;
import com.liferay.segments.context.RequestContextMapper;
import com.liferay.segments.model.SegmentsExperience;
import com.liferay.segments.processor.SegmentsExperienceRequestProcessorRegistry;
import com.liferay.segments.service.SegmentsExperienceLocalService;
import com.liferay.segments.service.SegmentsExperienceService;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/site-page.properties"}, scope=ServiceScope.PROTOTYPE, service={SitePageResource.class})
public class SitePageResourceImpl
extends BaseSitePageResourceImpl {
    private static final EntityModel _entityModel = new SitePageEntityModel();
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private FriendlyURLEntryLocalService _friendlyURLEntryLocalService;
    @Reference
    private LayoutFriendlyURLLocalService _layoutFriendlyURLLocalService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutService _layoutService;
    @Reference
    private Portal _portal;
    @Reference
    private RequestContextMapper _requestContextMapper;
    @Reference
    private SegmentsEntryRetriever _segmentsEntryRetriever;
    @Reference
    private SegmentsExperienceLocalService _segmentsExperienceLocalService;
    @Reference
    private SegmentsExperienceRequestProcessorRegistry _segmentsExperienceRequestProcessorRegistry;
    @Reference
    private SegmentsExperienceService _segmentsExperienceService;
    @Reference
    private SitePageDTOConverter _sitePageDTOConverter;

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) {
        return _entityModel;
    }

    @Override
    public SitePage getSiteSitePage(Long siteId, String friendlyUrlPath) throws Exception {
        return this._toSitePage(true, this._getLayout(siteId, friendlyUrlPath), null);
    }

    @Override
    public SitePage getSiteSitePageExperienceExperienceKey(Long siteId, String friendlyUrlPath, String experienceKey) throws Exception {
        return this._toSitePage(true, this._getLayout(siteId, friendlyUrlPath), experienceKey);
    }

    @Override
    public String getSiteSitePageExperienceExperienceKeyRenderedPage(Long siteId, String friendlyUrlPath, String experienceKey) throws Exception {
        return this._toHTML(friendlyUrlPath, siteId, experienceKey);
    }

    @Override
    public String getSiteSitePageRenderedPage(Long siteId, String friendlyUrlPath) throws Exception {
        return this._toHTML(friendlyUrlPath, siteId, null);
    }

    @Override
    public Page<SitePage> getSiteSitePagesExperiencesPage(Long siteId, String friendlyUrlPath) throws Exception {
        Layout layout = this._getLayout(siteId, friendlyUrlPath);
        return Page.of((Collection)TransformUtil.transform(this._getSegmentsExperiences(layout), segmentsExperience -> this._toSitePage(this._isEmbeddedPageDefinition(), layout, segmentsExperience.getSegmentsExperienceKey())));
    }

    @Override
    public Page<SitePage> getSiteSitePagesPage(Long siteId, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search((Map)HashMapBuilder.put((Object)"get", (Object)HashMapBuilder.put((Object)"href", (Object)JaxRsLinkUtil.getJaxRsLink((String)"headless-delivery", BaseSitePageResourceImpl.class, (String)"getSiteSitePagesPage", (UriInfo)this.contextUriInfo, (Object[])new Object[]{siteId})).put((Object)"method", (Object)"GET").build()).build(), booleanQuery -> {
            BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
            booleanFilter.add((Filter)new TermFilter("groupId", String.valueOf(siteId)), BooleanClauseOccur.MUST);
        }, (Filter)filter, (String)Layout.class.getName(), (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> {
            searchContext.addVulcanAggregation(aggregation);
            searchContext.setAttribute("title", (Serializable)((Object)search));
            searchContext.setAttribute("type", (Serializable)new String[]{"collection", "content", "embedded", "link_to_layout", "full_page_application", "panel", "portlet", "url"});
            searchContext.setAttribute("privateLayout", (Serializable)((Object)Boolean.FALSE.toString()));
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
            searchContext.setGroupIds(new long[]{siteId});
            searchContext.setKeywords(search);
        }, (Sort[])sorts, document -> {
            long plid = GetterUtil.getLong((String)document.get("entryClassPK"));
            return this._toSitePage(this._isEmbeddedPageDefinition(), this._layoutLocalService.getLayout(plid), null);
        });
    }

    private Map<String, Map<String, String>> _getBasicActions(Layout layout) {
        return HashMapBuilder.put((Object)"get", this.addAction("VIEW", layout.getPlid(), "getSiteSitePage", null, Layout.class.getName(), layout.getGroupId())).put((Object)"get-experiences", () -> {
            if (!layout.isTypeContent()) {
                return null;
            }
            return this.addAction("VIEW", "getSiteSitePagesExperiencesPage", Group.class.getName(), layout.getGroupId());
        }).put((Object)"get-rendered-page", this.addAction("VIEW", layout.getPlid(), "getSiteSitePageRenderedPage", null, Layout.class.getName(), layout.getGroupId())).build();
    }

    private Map<String, Map<String, String>> _getExperienceActions(Layout layout) {
        return HashMapBuilder.put((Object)"get", this.addAction("VIEW", "getSiteSitePageExperienceExperienceKey", Group.class.getName(), layout.getGroupId())).put((Object)"get-rendered-page", this.addAction("VIEW", "getSiteSitePageExperienceExperienceKeyRenderedPage", Group.class.getName(), layout.getGroupId())).build();
    }

    private Layout _getLayout(long groupId, String friendlyUrlPath) throws Exception {
        String resourceName = ResourceActionsUtil.getCompositeModelName((String[])new String[]{Layout.class.getName(), "false"});
        FriendlyURLEntryLocalization friendlyURLEntryLocalization = this._friendlyURLEntryLocalService.getFriendlyURLEntryLocalization(groupId, this._portal.getClassNameId(resourceName), "/" + friendlyUrlPath);
        return this._layoutLocalService.getLayout(friendlyURLEntryLocalization.getClassPK());
    }

    private SegmentsExperience _getSegmentsExperience(Layout layout, String segmentsExperienceKey) throws Exception {
        if (Validator.isNull((String)segmentsExperienceKey)) {
            return this._getUserSegmentsExperience(layout);
        }
        return this._segmentsExperienceService.fetchSegmentsExperience(layout.getGroupId(), segmentsExperienceKey, this._portal.getClassNameId(Layout.class), layout.getPlid());
    }

    private List<SegmentsExperience> _getSegmentsExperiences(Layout layout) throws Exception {
        if (!layout.isTypeContent()) {
            return Collections.emptyList();
        }
        return this._segmentsExperienceLocalService.getSegmentsExperiences(layout.getGroupId(), this._portal.getClassNameId(Layout.class.getName()), layout.getPlid(), true);
    }

    private ThemeDisplay _getThemeDisplay(Layout layout) throws Exception {
        ServicePreAction servicePreAction = new ServicePreAction();
        DummyHttpServletResponse httpServletResponse = new DummyHttpServletResponse();
        servicePreAction.servicePre(this.contextHttpServletRequest, (HttpServletResponse)httpServletResponse, false);
        ThemeServicePreAction themeServicePreAction = new ThemeServicePreAction();
        themeServicePreAction.run(this.contextHttpServletRequest, (HttpServletResponse)httpServletResponse);
        ThemeDisplay themeDisplay = (ThemeDisplay)this.contextHttpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        themeDisplay.setLayout(layout);
        themeDisplay.setScopeGroupId(layout.getGroupId());
        themeDisplay.setSiteGroupId(layout.getGroupId());
        return themeDisplay;
    }

    private SegmentsExperience _getUserSegmentsExperience(Layout layout) throws Exception {
        this.contextHttpServletRequest.setAttribute("LIFERAY_SHARED_THEME_DISPLAY", (Object)this._getThemeDisplay(layout));
        long[] segmentsEntryIds = this._segmentsEntryRetriever.getSegmentsEntryIds(layout.getGroupId(), this.contextUser.getUserId(), this._requestContextMapper.map(this.contextHttpServletRequest));
        long[] segmentsExperienceIds = this._segmentsExperienceRequestProcessorRegistry.getSegmentsExperienceIds(this.contextHttpServletRequest, null, layout.getGroupId(), this._portal.getClassNameId(Layout.class.getName()), layout.getPlid(), segmentsEntryIds);
        if (ArrayUtil.isEmpty((long[])segmentsExperienceIds)) {
            return this._segmentsExperienceLocalService.fetchSegmentsExperience(layout.getGroupId(), "DEFAULT", this._portal.getClassNameId(Layout.class.getName()), layout.getPlid());
        }
        return this._segmentsExperienceLocalService.getSegmentsExperience(segmentsExperienceIds[0]);
    }

    private boolean _isEmbeddedPageDefinition() {
        MultivaluedMap queryParameters = this.contextUriInfo.getQueryParameters();
        String nestedFields = (String)queryParameters.getFirst((Object)"nestedFields");
        if (nestedFields == null) {
            return false;
        }
        return nestedFields.contains("pageDefinition");
    }

    private String _toHTML(String friendlyUrlPath, long groupId, String segmentsExperienceKey) throws Exception {
        Layout layout = this._getLayout(groupId, friendlyUrlPath);
        this.contextHttpServletRequest = DynamicServletRequest.addQueryString((HttpServletRequest)this.contextHttpServletRequest, (String)("p_l_id=" + layout.getPlid()), (boolean)false);
        SegmentsExperience segmentsExperience = this._getSegmentsExperience(layout, segmentsExperienceKey);
        if (segmentsExperience != null) {
            this.contextHttpServletRequest.setAttribute("SEGMENTS_EXPERIENCE_IDS", (Object)new long[]{segmentsExperience.getSegmentsExperienceId()});
        }
        this.contextHttpServletRequest.setAttribute("LIFERAY_SHARED_THEME_DISPLAY", (Object)this._getThemeDisplay(layout));
        ServletContext servletContext = ServletContextPool.get((String)"");
        if (this.contextHttpServletRequest.getAttribute("CTX") == null) {
            this.contextHttpServletRequest.setAttribute("CTX", (Object)servletContext);
        }
        layout.includeLayoutContent(this.contextHttpServletRequest, this.contextHttpServletResponse);
        StringBundler sb = (StringBundler)this.contextHttpServletRequest.getAttribute("LAYOUT_CONTENT");
        LayoutSet layoutSet = layout.getLayoutSet();
        Document document = Jsoup.parse((String)ThemeUtil.include((ServletContext)servletContext, (HttpServletRequest)this.contextHttpServletRequest, (HttpServletResponse)this.contextHttpServletResponse, (String)"portal_normal.ftl", (Theme)layoutSet.getTheme(), (boolean)false));
        Element bodyElement = document.body();
        bodyElement.html(sb.toString());
        return document.html();
    }

    private SitePage _toSitePage(boolean embeddedPageDefinition, Layout layout, String segmentsExperienceKey) throws Exception {
        Map<String, Map<String, String>> actions = null;
        actions = Validator.isNotNull((String)segmentsExperienceKey) ? this._getExperienceActions(layout) : this._getBasicActions(layout);
        DefaultDTOConverterContext dtoConverterContext = new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), actions, this._dtoConverterRegistry, this.contextHttpServletRequest, (Object)layout.getPlid(), this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser);
        dtoConverterContext.setAttribute("embeddedPageDefinition", (Object)embeddedPageDefinition);
        if (Validator.isNotNull((String)segmentsExperienceKey)) {
            dtoConverterContext.setAttribute("segmentsExperience", (Object)this._getSegmentsExperience(layout, segmentsExperienceKey));
            dtoConverterContext.setAttribute("showExperience", (Object)Boolean.TRUE);
        } else {
            dtoConverterContext.setAttribute("segmentsExperience", (Object)this._getUserSegmentsExperience(layout));
        }
        return this._sitePageDTOConverter.toDTO((DTOConverterContext)dtoConverterContext, layout);
    }
}

