/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesSerializer;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.service.DDMStructureService;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.Field;
import com.liferay.dynamic.data.mapping.storage.Fields;
import com.liferay.dynamic.data.mapping.util.DDM;
import com.liferay.dynamic.data.mapping.util.DDMIndexer;
import com.liferay.dynamic.data.mapping.util.FieldsToDDMFormValuesConverter;
import com.liferay.dynamic.data.mapping.validator.DDMFormValuesValidator;
import com.liferay.expando.kernel.service.ExpandoColumnLocalService;
import com.liferay.expando.kernel.service.ExpandoTableLocalService;
import com.liferay.headless.common.spi.odata.entity.EntityFieldsUtil;
import com.liferay.headless.common.spi.resource.SPIRatingResource;
import com.liferay.headless.common.spi.service.context.ServiceContextRequestUtil;
import com.liferay.headless.delivery.dto.v1_0.ContentField;
import com.liferay.headless.delivery.dto.v1_0.CustomField;
import com.liferay.headless.delivery.dto.v1_0.Rating;
import com.liferay.headless.delivery.dto.v1_0.StructuredContent;
import com.liferay.headless.delivery.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.headless.delivery.dto.v1_0.util.DDMFormValuesUtil;
import com.liferay.headless.delivery.dto.v1_0.util.DDMValueUtil;
import com.liferay.headless.delivery.dto.v1_0.util.StructuredContentUtil;
import com.liferay.headless.delivery.dynamic.data.mapping.DDMFormFieldUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.converter.StructuredContentDTOConverter;
import com.liferay.headless.delivery.internal.dto.v1_0.util.DisplayPageRendererUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.RatingUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.RenderedContentValueUtil;
import com.liferay.headless.delivery.internal.odata.entity.v1_0.EntityFieldsProvider;
import com.liferay.headless.delivery.internal.odata.entity.v1_0.StructuredContentEntityModel;
import com.liferay.headless.delivery.internal.resource.v1_0.BaseStructuredContentResourceImpl;
import com.liferay.headless.delivery.resource.v1_0.StructuredContentResource;
import com.liferay.headless.delivery.search.aggregation.AggregationUtil;
import com.liferay.headless.delivery.search.filter.FilterUtil;
import com.liferay.headless.delivery.search.sort.SortUtil;
import com.liferay.info.item.InfoItemServiceTracker;
import com.liferay.journal.exception.NoSuchFolderException;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalFolder;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.journal.service.JournalArticleService;
import com.liferay.journal.service.JournalFolderService;
import com.liferay.journal.util.JournalContent;
import com.liferay.journal.util.JournalConverter;
import com.liferay.layout.display.page.LayoutDisplayPageProviderTracker;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryService;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.odata.entity.EntityField;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.search.aggregation.Aggregations;
import com.liferay.portal.search.expando.ExpandoBridgeIndexer;
import com.liferay.portal.search.legacy.searcher.SearchRequestBuilderFactory;
import com.liferay.portal.search.query.Queries;
import com.liferay.portal.search.searcher.SearchRequestBuilder;
import com.liferay.portal.search.sort.Sorts;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.ContentLanguageUtil;
import com.liferay.portal.vulcan.util.LocalDateTimeUtil;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import com.liferay.portal.vulcan.util.SearchUtil;
import com.liferay.portal.vulcan.util.TransformUtil;
import com.liferay.ratings.kernel.service.RatingsEntryLocalService;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/structured-content.properties"}, scope=ServiceScope.PROTOTYPE, service={StructuredContentResource.class})
public class StructuredContentResourceImpl
extends BaseStructuredContentResourceImpl {
    private static final Log _log = LogFactoryUtil.getLog(StructuredContentResourceImpl.class);
    @Reference
    private Aggregations _aggregations;
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private DDM _ddm;
    @Reference
    private DDMFormValuesValidator _ddmFormValuesValidator;
    @Reference
    private DDMIndexer _ddmIndexer;
    @Reference
    private DDMStructureService _ddmStructureService;
    @Reference
    private DDMTemplateLocalService _ddmTemplateLocalService;
    @Reference
    private DLAppService _dlAppService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private EntityFieldsProvider _entityFieldsProvider;
    @Reference
    private ExpandoBridgeIndexer _expandoBridgeIndexer;
    @Reference
    private ExpandoColumnLocalService _expandoColumnLocalService;
    @Reference
    private ExpandoTableLocalService _expandoTableLocalService;
    @Reference
    private FieldsToDDMFormValuesConverter _fieldsToDDMFormValuesConverter;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private InfoItemServiceTracker _infoItemServiceTracker;
    @Reference
    private JournalArticleLocalService _journalArticleLocalService;
    @Reference(target="(model.class.name=com.liferay.journal.model.JournalArticle)")
    private ModelResourcePermission<JournalArticle> _journalArticleModelResourcePermission;
    @Reference
    private JournalArticleService _journalArticleService;
    @Reference
    private JournalContent _journalContent;
    @Reference
    private JournalConverter _journalConverter;
    @Reference
    private JournalFolderService _journalFolderService;
    @Reference(target="(ddm.form.values.serializer.type=json)")
    private DDMFormValuesSerializer _jsonDDMFormValuesSerializer;
    @Reference
    private LayoutDisplayPageProviderTracker _layoutDisplayPageProviderTracker;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutPageTemplateEntryService _layoutPageTemplateEntryService;
    @Reference
    private Portal _portal;
    @Reference
    private Queries _queries;
    @Reference
    private RatingsEntryLocalService _ratingsEntryLocalService;
    @Reference
    private SearchRequestBuilderFactory _searchRequestBuilderFactory;
    @Reference
    private Sorts _sorts;
    @Reference
    private StructuredContentDTOConverter _structuredContentDTOConverter;
    @Reference
    private UserLocalService _userLocalService;

    @Override
    public void deleteAssetLibraryStructuredContentByExternalReferenceCode(Long assetLibraryId, String externalReferenceCode) throws Exception {
        JournalArticle journalArticle = this._journalArticleLocalService.getLatestArticleByExternalReferenceCode(assetLibraryId.longValue(), externalReferenceCode);
        this._journalArticleService.deleteArticle(journalArticle.getGroupId(), journalArticle.getArticleId(), journalArticle.getArticleResourceUuid(), new ServiceContext());
    }

    @Override
    public void deleteSiteStructuredContentByExternalReferenceCode(Long siteId, String externalReferenceCode) throws Exception {
        JournalArticle journalArticle = this._journalArticleLocalService.getLatestArticleByExternalReferenceCode(siteId.longValue(), externalReferenceCode);
        this._journalArticleService.deleteArticle(journalArticle.getGroupId(), journalArticle.getArticleId(), journalArticle.getArticleResourceUuid(), new ServiceContext());
    }

    @Override
    public void deleteStructuredContent(Long structuredContentId) throws Exception {
        JournalArticle journalArticle = this._journalArticleService.getLatestArticle(structuredContentId.longValue());
        this._journalArticleService.deleteArticle(journalArticle.getGroupId(), journalArticle.getArticleId(), journalArticle.getArticleResourceUuid(), new ServiceContext());
    }

    @Override
    public void deleteStructuredContentMyRating(Long structuredContentId) throws Exception {
        SPIRatingResource<Rating> spiRatingResource = this._getSPIRatingResource();
        spiRatingResource.deleteRating(structuredContentId);
    }

    @Override
    public StructuredContent getAssetLibraryStructuredContentByExternalReferenceCode(Long assetLibraryId, String externalReferenceCode) throws Exception {
        return this._getStructuredContent(this._journalArticleService.getLatestArticleByExternalReferenceCode(assetLibraryId.longValue(), externalReferenceCode));
    }

    @Override
    public Page<StructuredContent> getAssetLibraryStructuredContentsPage(Long assetLibraryId, Boolean flatten, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return this._getStructuredContentsPage(HashMapBuilder.put((Object)"create", this.addAction("ADD_ARTICLE", "postAssetLibraryStructuredContent", "com.liferay.journal", assetLibraryId)).put((Object)"get", this.addAction("VIEW", "getAssetLibraryStructuredContentsPage", "com.liferay.journal", assetLibraryId)).build(), this._createStructuredContentsPageBooleanQueryUnsafeConsumer(flatten), assetLibraryId, search, aggregation, filter, pagination, sorts);
    }

    @Override
    public Page<StructuredContent> getContentStructureStructuredContentsPage(Long contentStructureId, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        DDMStructure ddmStructure = this._ddmStructureService.getStructure(contentStructureId.longValue());
        return this._getStructuredContentsPage(HashMapBuilder.put((Object)"get", this.addAction("VIEW", ddmStructure.getStructureId(), "getContentStructureStructuredContentsPage", ddmStructure.getUserId(), "com.liferay.journal", ddmStructure.getGroupId())).build(), (UnsafeConsumer<BooleanQuery, Exception>)((UnsafeConsumer)booleanQuery -> {
            BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
            booleanFilter.add((Filter)new TermFilter("classTypeId", contentStructureId.toString()), BooleanClauseOccur.MUST);
        }), null, search, aggregation, filter, pagination, sorts);
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        List<EntityField> entityFields = null;
        long contentStructureId = GetterUtil.getLong((String)((String)multivaluedMap.getFirst((Object)"contentStructureId")));
        if (contentStructureId > 0L) {
            DDMStructure ddmStructure = this._ddmStructureService.getStructure(contentStructureId);
            entityFields = this._entityFieldsProvider.provide(ddmStructure);
        }
        return new StructuredContentEntityModel(entityFields, EntityFieldsUtil.getEntityFields((long)this._portal.getClassNameId(JournalArticle.class.getName()), (long)this.contextCompany.getCompanyId(), (ExpandoBridgeIndexer)this._expandoBridgeIndexer, (ExpandoColumnLocalService)this._expandoColumnLocalService, (ExpandoTableLocalService)this._expandoTableLocalService));
    }

    @Override
    public StructuredContent getSiteStructuredContentByExternalReferenceCode(Long siteId, String externalReferenceCode) throws Exception {
        return this._getStructuredContent(this._journalArticleService.getLatestArticleByExternalReferenceCode(siteId.longValue(), externalReferenceCode));
    }

    @Override
    public StructuredContent getSiteStructuredContentByKey(Long siteId, String key) throws Exception {
        JournalArticle journalArticle = this._journalArticleService.getArticle(siteId.longValue(), key);
        return this._getStructuredContent(journalArticle);
    }

    @Override
    public StructuredContent getSiteStructuredContentByUuid(Long siteId, String uuid) throws Exception {
        JournalArticle journalArticle = this._journalArticleLocalService.getJournalArticleByUuidAndGroupId(uuid, siteId.longValue());
        this._journalArticleModelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), journalArticle.getResourcePrimKey(), "VIEW");
        return this._getStructuredContent(journalArticle);
    }

    @Override
    public Page<StructuredContent> getSiteStructuredContentsPage(Long siteId, Boolean flatten, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return this._getStructuredContentsPage(HashMapBuilder.put((Object)"create", this.addAction("ADD_ARTICLE", "postSiteStructuredContent", "com.liferay.journal", siteId)).put((Object)"get", this.addAction("VIEW", "getSiteStructuredContentsPage", "com.liferay.journal", siteId)).build(), this._createStructuredContentsPageBooleanQueryUnsafeConsumer(flatten), siteId, search, aggregation, filter, pagination, sorts);
    }

    @Override
    public StructuredContent getStructuredContent(Long structuredContentId) throws Exception {
        JournalArticle journalArticle = this._journalArticleService.getLatestArticle(structuredContentId.longValue());
        return this._getStructuredContent(journalArticle);
    }

    @Override
    public Page<StructuredContent> getStructuredContentFolderStructuredContentsPage(Long structuredContentFolderId, Boolean flatten, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        JournalFolder journalFolder = this._journalFolderService.getFolder(structuredContentFolderId.longValue());
        return this._getStructuredContentsPage(HashMapBuilder.put((Object)"create", this.addAction("ADD_ARTICLE", journalFolder.getFolderId(), "postStructuredContentFolderStructuredContent", journalFolder.getUserId(), "com.liferay.journal", journalFolder.getGroupId())).put((Object)"get", this.addAction("VIEW", journalFolder.getFolderId(), "getStructuredContentFolderStructuredContentsPage", journalFolder.getUserId(), "com.liferay.journal", journalFolder.getGroupId())).build(), (UnsafeConsumer<BooleanQuery, Exception>)((UnsafeConsumer)booleanQuery -> {
            BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
            String field = "folderId";
            if (GetterUtil.getBoolean((Object)flatten)) {
                field = "treePath";
            }
            booleanFilter.add((Filter)new TermFilter(field, structuredContentFolderId.toString()), BooleanClauseOccur.MUST);
        }), journalFolder.getGroupId(), search, aggregation, filter, pagination, sorts);
    }

    @Override
    public Rating getStructuredContentMyRating(Long structuredContentId) throws Exception {
        SPIRatingResource<Rating> spiRatingResource = this._getSPIRatingResource();
        return (Rating)spiRatingResource.getRating(structuredContentId);
    }

    @Override
    public String getStructuredContentRenderedContentByDisplayPageDisplayPageKey(Long structuredContentId, String displayPageKey) throws Exception {
        JournalArticle journalArticle = this._journalArticleService.getLatestArticle(structuredContentId.longValue());
        DDMStructure ddmStructure = journalArticle.getDDMStructure();
        return DisplayPageRendererUtil.toHTML(JournalArticle.class.getName(), ddmStructure.getStructureId(), displayPageKey, journalArticle.getGroupId(), this.contextHttpServletRequest, this.contextHttpServletResponse, journalArticle, this._infoItemServiceTracker, this._layoutDisplayPageProviderTracker, this._layoutLocalService, this._layoutPageTemplateEntryService);
    }

    @Override
    public String getStructuredContentRenderedContentContentTemplate(Long structuredContentId, String templateId) throws Exception {
        return RenderedContentValueUtil.renderTemplate(this._classNameLocalService, this._ddmTemplateLocalService, this._groupLocalService, this.contextHttpServletRequest, this._journalArticleService, this._journalContent, this.contextAcceptLanguage.getPreferredLocale(), structuredContentId, templateId, this.contextUriInfo);
    }

    @Override
    public StructuredContent patchStructuredContent(Long structuredContentId, StructuredContent structuredContent) throws Exception {
        JournalArticle journalArticle = this._journalArticleService.getLatestArticle(structuredContentId.longValue());
        if (!ArrayUtil.contains((Object[])journalArticle.getAvailableLanguageIds(), (Object)this.contextAcceptLanguage.getPreferredLanguageId())) {
            throw new BadRequestException(StringBundler.concat((String[])new String[]{"Unable to patch structured content with language ", LocaleUtil.toW3cLanguageId((String)this.contextAcceptLanguage.getPreferredLanguageId()), " because it is only available in the following languages ", Arrays.toString(LocaleUtil.toW3cLanguageIds((String[])journalArticle.getAvailableLanguageIds()))}));
        }
        DDMStructure ddmStructure = journalArticle.getDDMStructure();
        this._validateContentFields(structuredContent.getContentFields(), ddmStructure);
        LocalDateTime localDateTime = LocalDateTimeUtil.toLocalDateTime((Date)structuredContent.getDatePublished(), (Date)journalArticle.getDisplayDate());
        return this._toStructuredContent(this._journalArticleService.updateArticle(journalArticle.getGroupId(), journalArticle.getFolderId(), journalArticle.getArticleId(), journalArticle.getVersion(), LocalizedMapUtil.patch((Map)journalArticle.getTitleMap(), (Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)structuredContent.getTitle(), (Map)structuredContent.getTitle_i18n()), LocalizedMapUtil.patch((Map)journalArticle.getDescriptionMap(), (Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)structuredContent.getDescription(), (Map)structuredContent.getDescription_i18n()), LocalizedMapUtil.patch((Map)journalArticle.getFriendlyURLMap(), (Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)structuredContent.getFriendlyUrlPath(), (Map)structuredContent.getFriendlyUrlPath_i18n()), this._journalConverter.getContent(ddmStructure, this._toPatchedFields(structuredContent.getContentFields(), journalArticle), journalArticle.getGroupId()), journalArticle.getDDMStructureKey(), this._getDDMTemplateKey(ddmStructure), journalArticle.getLayoutUuid(), localDateTime.getMonthValue() - 1, localDateTime.getDayOfMonth(), localDateTime.getYear(), localDateTime.getHour(), localDateTime.getMinute(), 0, 0, 0, 0, 0, true, 0, 0, 0, 0, 0, true, true, false, null, null, null, null, this._createServiceContext(journalArticle.getGroupId(), structuredContent)));
    }

    @Override
    public StructuredContent postAssetLibraryStructuredContent(Long assetLibraryId, StructuredContent structuredContent) throws Exception {
        return this.postSiteStructuredContent(assetLibraryId, structuredContent);
    }

    @Override
    public StructuredContent postSiteStructuredContent(Long siteId, StructuredContent structuredContent) throws Exception {
        return this._addStructuredContent(structuredContent.getExternalReferenceCode(), siteId, 0L, structuredContent);
    }

    @Override
    public StructuredContent postStructuredContentFolderStructuredContent(Long structuredContentFolderId, StructuredContent structuredContent) throws Exception {
        JournalFolder journalFolder = this._journalFolderService.getFolder(structuredContentFolderId.longValue());
        return this._addStructuredContent(structuredContent.getExternalReferenceCode(), journalFolder.getGroupId(), structuredContentFolderId, structuredContent);
    }

    @Override
    public Rating postStructuredContentMyRating(Long structuredContentId, Rating rating) throws Exception {
        SPIRatingResource<Rating> spiRatingResource = this._getSPIRatingResource();
        return (Rating)spiRatingResource.addOrUpdateRating((Number)rating.getRatingValue(), structuredContentId.longValue());
    }

    @Override
    public StructuredContent putAssetLibraryStructuredContentByExternalReferenceCode(Long assetLibraryId, String externalReferenceCode, StructuredContent structuredContent) throws Exception {
        JournalArticle journalArticle = this._journalArticleLocalService.fetchLatestArticleByExternalReferenceCode(assetLibraryId.longValue(), externalReferenceCode);
        if (journalArticle != null) {
            return this._updateStructuredContent(journalArticle, structuredContent);
        }
        return this._addStructuredContent(externalReferenceCode, assetLibraryId, 0L, structuredContent);
    }

    @Override
    public StructuredContent putSiteStructuredContentByExternalReferenceCode(Long siteId, String externalReferenceCode, StructuredContent structuredContent) throws Exception {
        JournalArticle journalArticle = this._journalArticleLocalService.fetchLatestArticleByExternalReferenceCode(siteId.longValue(), externalReferenceCode);
        if (journalArticle != null) {
            return this._updateStructuredContent(journalArticle, structuredContent);
        }
        return this._addStructuredContent(externalReferenceCode, siteId, 0L, structuredContent);
    }

    @Override
    public StructuredContent putStructuredContent(Long structuredContentId, StructuredContent structuredContent) throws Exception {
        JournalArticle journalArticle = this._journalArticleService.getLatestArticle(structuredContentId.longValue());
        return this._updateStructuredContent(journalArticle, structuredContent);
    }

    @Override
    public Rating putStructuredContentMyRating(Long structuredContentId, Rating rating) throws Exception {
        SPIRatingResource<Rating> spiRatingResource = this._getSPIRatingResource();
        return (Rating)spiRatingResource.addOrUpdateRating((Number)rating.getRatingValue(), structuredContentId.longValue());
    }

    @Override
    public void putStructuredContentSubscribe(Long structuredContentId) throws Exception {
        JournalArticle journalArticle = this._journalArticleService.getLatestArticle(structuredContentId.longValue());
        this._journalArticleService.subscribe(journalArticle.getGroupId(), journalArticle.getResourcePrimKey());
    }

    @Override
    public void putStructuredContentUnsubscribe(Long structuredContentId) throws Exception {
        JournalArticle journalArticle = this._journalArticleService.getLatestArticle(structuredContentId.longValue());
        this._journalArticleService.unsubscribe(journalArticle.getGroupId(), journalArticle.getResourcePrimKey());
    }

    @Override
    protected Long getPermissionCheckerGroupId(Object id) throws Exception {
        JournalArticle journalArticle = this._journalArticleLocalService.getLatestArticle(((Long)id).longValue());
        return journalArticle.getGroupId();
    }

    @Override
    protected String getPermissionCheckerPortletName(Object id) {
        return "com.liferay.journal";
    }

    @Override
    protected String getPermissionCheckerResourceName(Object id) {
        return JournalArticle.class.getName();
    }

    private StructuredContent _addStructuredContent(String externalReferenceCode, Long groupId, Long parentStructuredContentFolderId, StructuredContent structuredContent) throws Exception {
        DDMStructure ddmStructure = this._ddmStructureService.getStructure(structuredContent.getContentStructureId().longValue());
        LocalDateTime localDateTime = LocalDateTimeUtil.toLocalDateTime((Date)structuredContent.getDatePublished());
        Map titleMap = LocalizedMapUtil.getLocalizedMap((Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)structuredContent.getTitle(), (Map)structuredContent.getTitle_i18n());
        Map descriptionMap = LocalizedMapUtil.getLocalizedMap((Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)structuredContent.getDescription(), (Map)structuredContent.getDescription_i18n());
        HashSet notFoundLocales = new HashSet(descriptionMap.keySet());
        Map friendlyUrlMap = LocalizedMapUtil.getLocalizedMap((Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)structuredContent.getFriendlyUrlPath(), (Map)structuredContent.getFriendlyUrlPath_i18n(), (Map)titleMap);
        notFoundLocales.addAll(friendlyUrlMap.keySet());
        LocalizedMapUtil.validateI18n((boolean)true, (Locale)LocaleUtil.getSiteDefault(), (String)"Structured content", (Map)titleMap, notFoundLocales);
        this._validateContentFields(structuredContent.getContentFields(), ddmStructure);
        return this._toStructuredContent(this._journalArticleService.addArticle(externalReferenceCode, groupId.longValue(), parentStructuredContentFolderId.longValue(), 0L, 0L, null, true, titleMap, descriptionMap, friendlyUrlMap, StructuredContentUtil.getJournalArticleContent((DDM)this._ddm, (DDMFormValues)DDMFormValuesUtil.toDDMFormValues(titleMap.keySet(), (ContentField[])structuredContent.getContentFields(), (DDMForm)ddmStructure.getDDMForm(), (DLAppService)this._dlAppService, (long)groupId, (JournalArticleService)this._journalArticleService, (LayoutLocalService)this._layoutLocalService, (Locale)this.contextAcceptLanguage.getPreferredLocale(), this._getRootDDMFormFields(ddmStructure)), (DDMFormValuesSerializer)this._jsonDDMFormValuesSerializer, (DDMFormValuesValidator)this._ddmFormValuesValidator, (DDMStructure)ddmStructure, (JournalConverter)this._journalConverter), ddmStructure.getStructureKey(), this._getDDMTemplateKey(ddmStructure), null, localDateTime.getMonthValue() - 1, localDateTime.getDayOfMonth(), localDateTime.getYear(), localDateTime.getHour(), localDateTime.getMinute(), 0, 0, 0, 0, 0, true, 0, 0, 0, 0, 0, true, true, false, null, null, null, null, this._createServiceContext(groupId, structuredContent)));
    }

    private ServiceContext _createServiceContext(long groupId, StructuredContent structuredContent) {
        ServiceContext serviceContext = ServiceContextRequestUtil.createServiceContext((Long[])structuredContent.getTaxonomyCategoryIds(), (String[])structuredContent.getKeywords(), this._getExpandoBridgeAttributes(structuredContent), (Long)groupId, (HttpServletRequest)this.contextHttpServletRequest, (String)structuredContent.getViewableByAsString());
        Optional.ofNullable(structuredContent.getPriority()).ifPresent(arg_0 -> ((ServiceContext)serviceContext).setAssetPriority(arg_0));
        return serviceContext;
    }

    private UnsafeConsumer<BooleanQuery, Exception> _createStructuredContentsPageBooleanQueryUnsafeConsumer(Boolean flatten) {
        return booleanQuery -> {
            if (!GetterUtil.getBoolean((Object)flatten)) {
                BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
                booleanFilter.add((Filter)new TermFilter("folderId", String.valueOf(0L)), BooleanClauseOccur.MUST);
            }
        };
    }

    private String _getDDMTemplateKey(DDMStructure ddmStructure) {
        List ddmTemplates = ddmStructure.getTemplates();
        if (ddmTemplates.isEmpty()) {
            return "";
        }
        DDMTemplate ddmTemplate = (DDMTemplate)ddmTemplates.get(0);
        return ddmTemplate.getTemplateKey();
    }

    private Map<String, Serializable> _getExpandoBridgeAttributes(StructuredContent structuredContent) {
        return CustomFieldsUtil.toMap((String)JournalArticle.class.getName(), (long)this.contextCompany.getCompanyId(), (CustomField[])structuredContent.getCustomFields(), (Locale)this.contextAcceptLanguage.getPreferredLocale());
    }

    private List<DDMFormField> _getRootDDMFormFields(DDMStructure ddmStructure) {
        return TransformUtil.transform((Collection)ddmStructure.getRootFieldNames(), fieldName -> DDMFormFieldUtil.getDDMFormField((DDMStructureService)this._ddmStructureService, (DDMStructure)ddmStructure, (String)fieldName));
    }

    private SPIRatingResource<Rating> _getSPIRatingResource() {
        return new SPIRatingResource(JournalArticle.class.getName(), this._ratingsEntryLocalService, ratingsEntry -> {
            JournalArticle journalArticle = this._journalArticleService.getLatestArticle(ratingsEntry.getClassPK());
            return RatingUtil.toRating(HashMapBuilder.put((Object)"create", this.addAction("VIEW", journalArticle.getResourcePrimKey(), "postStructuredContentMyRating", journalArticle.getUserId(), JournalArticle.class.getName(), journalArticle.getGroupId())).put((Object)"delete", this.addAction("VIEW", journalArticle.getResourcePrimKey(), "deleteStructuredContentMyRating", journalArticle.getUserId(), JournalArticle.class.getName(), journalArticle.getGroupId())).put((Object)"get", this.addAction("VIEW", journalArticle.getResourcePrimKey(), "getStructuredContentMyRating", journalArticle.getUserId(), JournalArticle.class.getName(), journalArticle.getGroupId())).put((Object)"replace", this.addAction("VIEW", journalArticle.getResourcePrimKey(), "putStructuredContentMyRating", journalArticle.getUserId(), JournalArticle.class.getName(), journalArticle.getGroupId())).build(), this._portal, ratingsEntry, this._userLocalService);
        }, this.contextUser);
    }

    private StructuredContent _getStructuredContent(JournalArticle journalArticle) throws Exception {
        ContentLanguageUtil.addContentLanguageHeader((String[])journalArticle.getAvailableLanguageIds(), (String)journalArticle.getDefaultLanguageId(), (HttpServletResponse)this.contextHttpServletResponse, (Locale)this.contextAcceptLanguage.getPreferredLocale());
        return this._toStructuredContent(journalArticle);
    }

    private Page<StructuredContent> _getStructuredContentsPage(Map<String, Map<String, String>> actions, UnsafeConsumer<BooleanQuery, Exception> booleanQueryUnsafeConsumer, Long siteId, String keywords, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search(actions, booleanQueryUnsafeConsumer, (Filter)FilterUtil.processFilter((DDMIndexer)this._ddmIndexer, (Filter)filter), (String)JournalArticle.class.getName(), (String)keywords, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"articleId", "scopeGroupId"}), searchContext -> {
            searchContext.addVulcanAggregation(aggregation);
            searchContext.setAttribute("status", (Serializable)Integer.valueOf(0));
            searchContext.setAttribute("head", (Serializable)Boolean.TRUE);
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
            if (siteId != null) {
                searchContext.setGroupIds(new long[]{siteId});
            }
            SearchRequestBuilder searchRequestBuilder = this._searchRequestBuilderFactory.builder((SearchContext)searchContext);
            AggregationUtil.processVulcanAggregation((Aggregations)this._aggregations, (DDMIndexer)this._ddmIndexer, (Queries)this._queries, (SearchRequestBuilder)searchRequestBuilder, (Aggregation)aggregation);
            SortUtil.processSorts((DDMIndexer)this._ddmIndexer, (SearchRequestBuilder)searchRequestBuilder, (Sort[])searchContext.getSorts(), (Queries)this._queries, (Sorts)this._sorts);
        }, (Sort[])sorts, this::_toStructuredContent);
    }

    private Fields _toFields(Set<Locale> availableLocales, ContentField[] contentFields, JournalArticle journalArticle) throws Exception {
        DDMStructure ddmStructure = journalArticle.getDDMStructure();
        ServiceContext serviceContext = new ServiceContext();
        DDMFormValues ddmFormValues = DDMFormValuesUtil.toDDMFormValues(availableLocales, (ContentField[])contentFields, (DDMForm)ddmStructure.getDDMForm(), (DLAppService)this._dlAppService, (long)journalArticle.getGroupId(), (JournalArticleService)this._journalArticleService, (LayoutLocalService)this._layoutLocalService, (Locale)this.contextAcceptLanguage.getPreferredLocale(), this._getRootDDMFormFields(ddmStructure));
        serviceContext.setAttribute("ddmFormValues", (Serializable)((Object)DDMFormValuesUtil.getContent((DDMFormValuesSerializer)this._jsonDDMFormValuesSerializer, (DDMForm)ddmStructure.getDDMForm(), (List)ddmFormValues.getDDMFormFieldValues())));
        return this._ddm.getFields(ddmStructure.getStructureId(), serviceContext);
    }

    private Fields _toPatchedFields(ContentField[] contentFields, JournalArticle journalArticle) throws Exception {
        DDMStructure ddmStructure = journalArticle.getDDMStructure();
        Fields fields = this._journalConverter.getDDMFields(ddmStructure, journalArticle.getContent());
        if (ArrayUtil.isEmpty((Object[])contentFields)) {
            return fields;
        }
        for (Field field : fields) {
            if (!field.isRepeatable()) continue;
            throw new BadRequestException("Unable to patch a structured content with a repeatable field. Instead, update the structured content.");
        }
        DDMFormValues ddmFormValues = DDMFormValuesUtil.toDDMFormValues((Set)SetUtil.fromArray((Object[])LocaleUtil.fromLanguageIds((String[])journalArticle.getAvailableLanguageIds())), (ContentField[])contentFields, (DDMForm)ddmStructure.getDDMForm(), (DLAppService)this._dlAppService, (long)journalArticle.getGroupId(), (JournalArticleService)this._journalArticleService, (LayoutLocalService)this._layoutLocalService, (Locale)this.contextAcceptLanguage.getPreferredLocale(), this._getRootDDMFormFields(ddmStructure));
        List ddmFormFieldValues = ddmFormValues.getDDMFormFieldValues();
        Stream stream = ddmFormFieldValues.stream();
        Map ddmFormFieldValuesMap = stream.collect(Collectors.toMap(DDMFormFieldValue::getFieldReference, Function.identity()));
        for (ContentField contentField : contentFields) {
            DDMFormFieldValue ddmFormFieldValue = (DDMFormFieldValue)ddmFormFieldValuesMap.get(contentField.getName());
            if (ddmFormFieldValue == null) continue;
            Field field = fields.get(ddmFormFieldValue.getName());
            Value value = DDMValueUtil.toDDMValue((ContentField)contentField, (DDMFormField)DDMFormFieldUtil.getDDMFormField((DDMStructureService)this._ddmStructureService, (DDMStructure)ddmStructure, (String)contentField.getName()), (DLAppService)this._dlAppService, (long)journalArticle.getGroupId(), (JournalArticleService)this._journalArticleService, (LayoutLocalService)this._layoutLocalService, (Locale)this.contextAcceptLanguage.getPreferredLocale());
            field.setValue(this.contextAcceptLanguage.getPreferredLocale(), (Serializable)((Object)value.getString(this.contextAcceptLanguage.getPreferredLocale())));
            ContentField[] nestedContentFields = contentField.getNestedContentFields();
            if (nestedContentFields == null) continue;
            this._toPatchedFields(nestedContentFields, journalArticle);
        }
        ddmFormValues = this._fieldsToDDMFormValuesConverter.convert(ddmStructure, fields);
        this._ddmFormValuesValidator.validate(ddmFormValues);
        return fields;
    }

    private StructuredContent _toStructuredContent(Document document) throws Exception {
        try {
            return this._toStructuredContent(this._journalArticleService.getLatestArticle(GetterUtil.getLong((String)document.get("scopeGroupId")), document.get("articleId"), 0));
        }
        catch (NoSuchFolderException noSuchFolderException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)noSuchFolderException);
            }
            return null;
        }
    }

    private StructuredContent _toStructuredContent(JournalArticle journalArticle) throws Exception {
        return this._structuredContentDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), (Map)HashMapBuilder.put((Object)"delete", this.addAction("DELETE", journalArticle.getResourcePrimKey(), "deleteStructuredContent", journalArticle.getUserId(), JournalArticle.class.getName(), journalArticle.getGroupId())).put((Object)"get", this.addAction("VIEW", journalArticle.getResourcePrimKey(), "getStructuredContent", journalArticle.getUserId(), JournalArticle.class.getName(), journalArticle.getGroupId())).put((Object)"get-rendered-content", this.addAction("VIEW", journalArticle.getResourcePrimKey(), "getStructuredContentRenderedContentContentTemplate", journalArticle.getUserId(), JournalArticle.class.getName(), journalArticle.getGroupId())).put((Object)"get-rendered-content-by-display-page", this.addAction("VIEW", journalArticle.getResourcePrimKey(), "getStructuredContentRenderedContentByDisplayPageDisplayPageKey", journalArticle.getUserId(), JournalArticle.class.getName(), journalArticle.getGroupId())).put((Object)"replace", this.addAction("UPDATE", journalArticle.getResourcePrimKey(), "putStructuredContent", journalArticle.getUserId(), JournalArticle.class.getName(), journalArticle.getGroupId())).put((Object)"subscribe", this.addAction("SUBSCRIBE", journalArticle.getResourcePrimKey(), "putStructuredContentSubscribe", journalArticle.getUserId(), JournalArticle.class.getName(), journalArticle.getGroupId())).put((Object)"unsubscribe", this.addAction("SUBSCRIBE", journalArticle.getResourcePrimKey(), "putStructuredContentUnsubscribe", journalArticle.getUserId(), JournalArticle.class.getName(), journalArticle.getGroupId())).put((Object)"update", this.addAction("UPDATE", journalArticle.getResourcePrimKey(), "patchStructuredContent", journalArticle.getUserId(), JournalArticle.class.getName(), journalArticle.getGroupId())).build(), this._dtoConverterRegistry, this.contextHttpServletRequest, (Object)journalArticle.getResourcePrimKey(), this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser), journalArticle);
    }

    private StructuredContent _updateStructuredContent(JournalArticle journalArticle, StructuredContent structuredContent) throws Exception {
        DDMStructure ddmStructure = journalArticle.getDDMStructure();
        Map titleMap = LocalizedMapUtil.getLocalizedMap((Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)structuredContent.getTitle(), (Map)structuredContent.getTitle_i18n(), (Map)journalArticle.getTitleMap());
        Map descriptionMap = LocalizedMapUtil.getLocalizedMap((Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)structuredContent.getDescription(), (Map)structuredContent.getDescription_i18n(), (Map)journalArticle.getDescriptionMap());
        HashSet notFoundLocales = new HashSet(descriptionMap.keySet());
        Map friendlyUrlMap = LocalizedMapUtil.getLocalizedMap((Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)structuredContent.getFriendlyUrlPath(), (Map)structuredContent.getFriendlyUrlPath_i18n(), (Map)journalArticle.getFriendlyURLMap());
        friendlyUrlMap = friendlyUrlMap.isEmpty() ? journalArticle.getFriendlyURLMap() : friendlyUrlMap;
        notFoundLocales.addAll(friendlyUrlMap.keySet());
        LocalizedMapUtil.validateI18n((boolean)false, (Locale)LocaleUtil.getSiteDefault(), (String)"Structured content", (Map)titleMap, notFoundLocales);
        this._validateContentFields(structuredContent.getContentFields(), ddmStructure);
        LocalDateTime localDateTime = LocalDateTimeUtil.toLocalDateTime((Date)structuredContent.getDatePublished(), (Date)journalArticle.getDisplayDate());
        return this._toStructuredContent(this._journalArticleService.updateArticle(journalArticle.getGroupId(), journalArticle.getFolderId(), journalArticle.getArticleId(), journalArticle.getVersion(), titleMap, descriptionMap, friendlyUrlMap, this._journalConverter.getContent(ddmStructure, this._toFields(titleMap.keySet(), structuredContent.getContentFields(), journalArticle), journalArticle.getGroupId()), journalArticle.getDDMStructureKey(), this._getDDMTemplateKey(ddmStructure), journalArticle.getLayoutUuid(), localDateTime.getMonthValue() - 1, localDateTime.getDayOfMonth(), localDateTime.getYear(), localDateTime.getHour(), localDateTime.getMinute(), 0, 0, 0, 0, 0, true, 0, 0, 0, 0, 0, true, true, false, null, null, null, null, this._createServiceContext(journalArticle.getGroupId(), structuredContent)));
    }

    private void _validateContentFields(ContentField[] contentFields, DDMStructure ddmStructure) {
        if (ArrayUtil.isEmpty((Object[])contentFields)) {
            return;
        }
        for (ContentField contentField : contentFields) {
            DDMFormField ddmFormField = DDMFormFieldUtil.getDDMFormField((DDMStructureService)this._ddmStructureService, (DDMStructure)ddmStructure, (String)contentField.getName());
            if (ddmFormField == null) {
                throw new BadRequestException(StringBundler.concat((Object[])new Object[]{"Unable to get content field value for \"", contentField.getName(), "\" for content structure ", ddmStructure.getStructureId()}));
            }
            this._validateContentFields(contentField.getNestedContentFields(), ddmStructure);
        }
    }
}

