/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.headless.common.spi.service.context.ServiceContextRequestUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.converter.WikiNodeDTOConverter;
import com.liferay.headless.delivery.internal.odata.entity.v1_0.WikiNodeEntityModel;
import com.liferay.headless.delivery.internal.resource.v1_0.BaseWikiNodeResourceImpl;
import com.liferay.headless.delivery.resource.v1_0.WikiNodeResource;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.SearchUtil;
import com.liferay.wiki.model.WikiNode;
import com.liferay.wiki.service.WikiNodeLocalService;
import com.liferay.wiki.service.WikiNodeService;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/wiki-node.properties"}, scope=ServiceScope.PROTOTYPE, service={WikiNodeResource.class})
public class WikiNodeResourceImpl
extends BaseWikiNodeResourceImpl {
    private static final EntityModel _entityModel = new WikiNodeEntityModel();
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private WikiNodeDTOConverter _wikiNodeDTOConverter;
    @Reference
    private WikiNodeLocalService _wikiNodeLocalService;
    @Reference
    private WikiNodeService _wikiNodeService;

    @Override
    public void deleteSiteWikiNodeByExternalReferenceCode(Long siteId, String externalReferenceCode) throws Exception {
        WikiNode wikiNode = this._wikiNodeLocalService.getWikiNodeByExternalReferenceCode(siteId.longValue(), externalReferenceCode);
        this._wikiNodeService.deleteNode(wikiNode.getNodeId());
    }

    @Override
    public void deleteWikiNode(Long wikiNodeId) throws Exception {
        this._wikiNodeService.deleteNode(wikiNodeId.longValue());
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) {
        return _entityModel;
    }

    @Override
    public com.liferay.headless.delivery.dto.v1_0.WikiNode getSiteWikiNodeByExternalReferenceCode(Long siteId, String externalReferenceCode) throws Exception {
        return this._toWikiNode(this._wikiNodeService.getWikiNodeByExternalReferenceCode(siteId.longValue(), externalReferenceCode));
    }

    @Override
    public Page<com.liferay.headless.delivery.dto.v1_0.WikiNode> getSiteWikiNodesPage(Long siteId, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search((Map)HashMapBuilder.put((Object)"create", this.addAction("ADD_NODE", "postSiteWikiNode", "com.liferay.wiki", siteId)).build(), booleanQuery -> {
            BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
            booleanFilter.add((Filter)new TermFilter("groupId", String.valueOf(siteId)), BooleanClauseOccur.MUST);
        }, (Filter)filter, (String)WikiNode.class.getName(), (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> {
            searchContext.addVulcanAggregation(aggregation);
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
        }, (Sort[])sorts, document -> this._toWikiNode(this._wikiNodeService.getNode(GetterUtil.getLong((String)document.get("entryClassPK")))));
    }

    @Override
    public com.liferay.headless.delivery.dto.v1_0.WikiNode getWikiNode(Long wikiNodeId) throws Exception {
        return this._toWikiNode(this._wikiNodeService.getNode(wikiNodeId.longValue()));
    }

    @Override
    public com.liferay.headless.delivery.dto.v1_0.WikiNode postSiteWikiNode(Long siteId, com.liferay.headless.delivery.dto.v1_0.WikiNode wikiNode) throws Exception {
        return this._addWikiNode(wikiNode.getExternalReferenceCode(), siteId, wikiNode);
    }

    @Override
    public com.liferay.headless.delivery.dto.v1_0.WikiNode putSiteWikiNodeByExternalReferenceCode(Long siteId, String externalReferenceCode, com.liferay.headless.delivery.dto.v1_0.WikiNode wikiNode) throws Exception {
        WikiNode serviceBuilderWikiNode = this._wikiNodeLocalService.fetchWikiNodeByExternalReferenceCode(siteId.longValue(), externalReferenceCode);
        if (serviceBuilderWikiNode != null) {
            return this._updateWikiNode(serviceBuilderWikiNode, wikiNode);
        }
        return this._addWikiNode(externalReferenceCode, siteId, wikiNode);
    }

    @Override
    public com.liferay.headless.delivery.dto.v1_0.WikiNode putWikiNode(Long wikiNodeId, com.liferay.headless.delivery.dto.v1_0.WikiNode wikiNode) throws Exception {
        WikiNode serviceBuilderWikiNode = this._wikiNodeService.getNode(wikiNodeId.longValue());
        return this._updateWikiNode(serviceBuilderWikiNode, wikiNode);
    }

    @Override
    public void putWikiNodeSubscribe(Long wikiNodeId) throws Exception {
        this._wikiNodeService.subscribeNode(wikiNodeId.longValue());
    }

    @Override
    public void putWikiNodeUnsubscribe(Long wikiNodeId) throws Exception {
        this._wikiNodeService.unsubscribeNode(wikiNodeId.longValue());
    }

    @Override
    protected Long getPermissionCheckerGroupId(Object id) throws Exception {
        WikiNode wikiNode = this._wikiNodeService.getNode(((Long)id).longValue());
        return wikiNode.getGroupId();
    }

    @Override
    protected String getPermissionCheckerPortletName(Object id) {
        return "com.liferay.wiki";
    }

    @Override
    protected String getPermissionCheckerResourceName(Object id) {
        return WikiNode.class.getName();
    }

    private com.liferay.headless.delivery.dto.v1_0.WikiNode _addWikiNode(String externalReferenceCode, Long groupId, com.liferay.headless.delivery.dto.v1_0.WikiNode wikiNode) throws Exception {
        return this._toWikiNode(this._wikiNodeService.addNode(externalReferenceCode, wikiNode.getName(), wikiNode.getDescription(), ServiceContextRequestUtil.createServiceContext((long)groupId, (HttpServletRequest)this.contextHttpServletRequest, (String)wikiNode.getViewableByAsString())));
    }

    private com.liferay.headless.delivery.dto.v1_0.WikiNode _toWikiNode(WikiNode wikiNode) throws Exception {
        return this._wikiNodeDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), (Map)HashMapBuilder.put((Object)"delete", this.addAction("DELETE", (GroupedModel)wikiNode, "deleteWikiNode")).put((Object)"get", this.addAction("VIEW", (GroupedModel)wikiNode, "getWikiNode")).put((Object)"replace", this.addAction("UPDATE", (GroupedModel)wikiNode, "putWikiNode")).put((Object)"subscribe", this.addAction("SUBSCRIBE", (GroupedModel)wikiNode, "putWikiNodeSubscribe")).put((Object)"unsubscribe", this.addAction("SUBSCRIBE", (GroupedModel)wikiNode, "putWikiNodeUnsubscribe")).build(), this._dtoConverterRegistry, (Object)wikiNode.getNodeId(), this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser), wikiNode);
    }

    private com.liferay.headless.delivery.dto.v1_0.WikiNode _updateWikiNode(WikiNode serviceBuilderWikiNode, com.liferay.headless.delivery.dto.v1_0.WikiNode wikiNode) throws Exception {
        return this._toWikiNode(this._wikiNodeService.updateNode(serviceBuilderWikiNode.getNodeId(), wikiNode.getName(), wikiNode.getDescription(), ServiceContextRequestUtil.createServiceContext((long)serviceBuilderWikiNode.getGroupId(), (HttpServletRequest)this.contextHttpServletRequest, (String)wikiNode.getViewableByAsString())));
    }
}

