/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.site.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(description="Represents the site being created.", value="Site")
@JsonFilter(value="Liferay.Vulcan")
@Schema(description="Represents the site being created.", requiredProperties={"name"})
@XmlRootElement(name="Site")
public class Site
implements Serializable {
    @GraphQLField(description="The site's external reference code.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The site's external reference code.") String externalReferenceCode;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected String friendlyUrlPath;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Long id;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected String key;
    @GraphQLField(description="The default value is open.")
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    protected @GraphQLField(description="The default value is open.") MembershipType membershipType;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @NotEmpty
    protected String name;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    protected String parentSiteKey;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    protected String templateKey;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    protected TemplateType templateType;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.site.dto.v1_0.Site", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static Site toDTO(String json) {
        return (Site)ObjectMapperUtil.readValue(Site.class, (String)json);
    }

    public static Site unsafeToDTO(String json) {
        return (Site)ObjectMapperUtil.unsafeReadValue(Site.class, (String)json);
    }

    @Schema(description="The site's external reference code.")
    public String getExternalReferenceCode() {
        return this.externalReferenceCode;
    }

    public void setExternalReferenceCode(String externalReferenceCode) {
        this.externalReferenceCode = externalReferenceCode;
    }

    @JsonIgnore
    public void setExternalReferenceCode(UnsafeSupplier<String, Exception> externalReferenceCodeUnsafeSupplier) {
        try {
            this.externalReferenceCode = (String)externalReferenceCodeUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    public String getFriendlyUrlPath() {
        return this.friendlyUrlPath;
    }

    public void setFriendlyUrlPath(String friendlyUrlPath) {
        this.friendlyUrlPath = friendlyUrlPath;
    }

    @JsonIgnore
    public void setFriendlyUrlPath(UnsafeSupplier<String, Exception> friendlyUrlPathUnsafeSupplier) {
        try {
            this.friendlyUrlPath = (String)friendlyUrlPathUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @JsonIgnore
    public void setId(UnsafeSupplier<Long, Exception> idUnsafeSupplier) {
        try {
            this.id = (Long)idUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    @JsonIgnore
    public void setKey(UnsafeSupplier<String, Exception> keyUnsafeSupplier) {
        try {
            this.key = (String)keyUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The default value is open.")
    @Valid
    public MembershipType getMembershipType() {
        return this.membershipType;
    }

    @JsonIgnore
    public String getMembershipTypeAsString() {
        if (this.membershipType == null) {
            return null;
        }
        return this.membershipType.toString();
    }

    public void setMembershipType(MembershipType membershipType) {
        this.membershipType = membershipType;
    }

    @JsonIgnore
    public void setMembershipType(UnsafeSupplier<MembershipType, Exception> membershipTypeUnsafeSupplier) {
        try {
            this.membershipType = (MembershipType)((Object)membershipTypeUnsafeSupplier.get());
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonIgnore
    public void setName(UnsafeSupplier<String, Exception> nameUnsafeSupplier) {
        try {
            this.name = (String)nameUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    public String getParentSiteKey() {
        return this.parentSiteKey;
    }

    public void setParentSiteKey(String parentSiteKey) {
        this.parentSiteKey = parentSiteKey;
    }

    @JsonIgnore
    public void setParentSiteKey(UnsafeSupplier<String, Exception> parentSiteKeyUnsafeSupplier) {
        try {
            this.parentSiteKey = (String)parentSiteKeyUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    public String getTemplateKey() {
        return this.templateKey;
    }

    public void setTemplateKey(String templateKey) {
        this.templateKey = templateKey;
    }

    @JsonIgnore
    public void setTemplateKey(UnsafeSupplier<String, Exception> templateKeyUnsafeSupplier) {
        try {
            this.templateKey = (String)templateKeyUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    @Valid
    public TemplateType getTemplateType() {
        return this.templateType;
    }

    @JsonIgnore
    public String getTemplateTypeAsString() {
        if (this.templateType == null) {
            return null;
        }
        return this.templateType.toString();
    }

    public void setTemplateType(TemplateType templateType) {
        this.templateType = templateType;
    }

    @JsonIgnore
    public void setTemplateType(UnsafeSupplier<TemplateType, Exception> templateTypeUnsafeSupplier) {
        try {
            this.templateType = (TemplateType)((Object)templateTypeUnsafeSupplier.get());
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Site)) {
            return false;
        }
        Site site = (Site)object;
        return Objects.equals(this.toString(), site.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        StringBundler sb = new StringBundler();
        sb.append("{");
        if (this.externalReferenceCode != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"externalReferenceCode\": ");
            sb.append("\"");
            sb.append(Site._escape(this.externalReferenceCode));
            sb.append("\"");
        }
        if (this.friendlyUrlPath != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"friendlyUrlPath\": ");
            sb.append("\"");
            sb.append(Site._escape(this.friendlyUrlPath));
            sb.append("\"");
        }
        if (this.id != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"id\": ");
            sb.append((Object)this.id);
        }
        if (this.key != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"key\": ");
            sb.append("\"");
            sb.append(Site._escape(this.key));
            sb.append("\"");
        }
        if (this.membershipType != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"membershipType\": ");
            sb.append("\"");
            sb.append((Object)this.membershipType);
            sb.append("\"");
        }
        if (this.name != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"name\": ");
            sb.append("\"");
            sb.append(Site._escape(this.name));
            sb.append("\"");
        }
        if (this.parentSiteKey != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"parentSiteKey\": ");
            sb.append("\"");
            sb.append(Site._escape(this.parentSiteKey));
            sb.append("\"");
        }
        if (this.templateKey != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"templateKey\": ");
            sb.append("\"");
            sb.append(Site._escape(this.templateKey));
            sb.append("\"");
        }
        if (this.templateType != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"templateType\": ");
            sb.append("\"");
            sb.append((Object)this.templateType);
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(Site._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (Site._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(Site._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(Site._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    @GraphQLName(value="TemplateType")
    public static enum TemplateType {
        SITE_INITIALIZER("site-initializer"),
        SITE_TEMPLATE("site-template");

        private final String _value;

        @JsonCreator
        public static TemplateType create(String value) {
            if (value == null || value.equals("")) {
                return null;
            }
            for (TemplateType templateType : TemplateType.values()) {
                if (!Objects.equals(templateType.getValue(), value)) continue;
                return templateType;
            }
            throw new IllegalArgumentException("Invalid enum value: " + value);
        }

        @JsonValue
        public String getValue() {
            return this._value;
        }

        public String toString() {
            return this._value;
        }

        private TemplateType(String value) {
            this._value = value;
        }
    }

    @GraphQLName(value="MembershipType")
    public static enum MembershipType {
        OPEN("open"),
        PRIVATE("private"),
        RESTRICTED("restricted");

        private final String _value;

        @JsonCreator
        public static MembershipType create(String value) {
            if (value == null || value.equals("")) {
                return null;
            }
            for (MembershipType membershipType : MembershipType.values()) {
                if (!Objects.equals(membershipType.getValue(), value)) continue;
                return membershipType;
            }
            throw new IllegalArgumentException("Invalid enum value: " + value);
        }

        @JsonValue
        public String getValue() {
            return this._value;
        }

        public String toString() {
            return this._value;
        }

        private MembershipType(String value) {
            this._value = value;
        }
    }
}

