/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.site.client.serdes.v1_0;

import com.liferay.headless.site.client.dto.v1_0.Site;
import com.liferay.headless.site.client.json.BaseJSONParser;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;

public class SiteSerDes {
    public static Site toDTO(String json) {
        SiteJSONParser siteJSONParser = new SiteJSONParser();
        return (Site)siteJSONParser.parseToDTO(json);
    }

    public static Site[] toDTOs(String json) {
        SiteJSONParser siteJSONParser = new SiteJSONParser();
        return (Site[])siteJSONParser.parseToDTOs(json);
    }

    public static String toJSON(Site site) {
        if (site == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (site.getExternalReferenceCode() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"externalReferenceCode\": ");
            sb.append("\"");
            sb.append(SiteSerDes._escape(site.getExternalReferenceCode()));
            sb.append("\"");
        }
        if (site.getFriendlyUrlPath() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"friendlyUrlPath\": ");
            sb.append("\"");
            sb.append(SiteSerDes._escape(site.getFriendlyUrlPath()));
            sb.append("\"");
        }
        if (site.getId() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"id\": ");
            sb.append(site.getId());
        }
        if (site.getKey() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"key\": ");
            sb.append("\"");
            sb.append(SiteSerDes._escape(site.getKey()));
            sb.append("\"");
        }
        if (site.getMembershipType() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"membershipType\": ");
            sb.append("\"");
            sb.append((Object)site.getMembershipType());
            sb.append("\"");
        }
        if (site.getName() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"name\": ");
            sb.append("\"");
            sb.append(SiteSerDes._escape(site.getName()));
            sb.append("\"");
        }
        if (site.getParentSiteKey() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"parentSiteKey\": ");
            sb.append("\"");
            sb.append(SiteSerDes._escape(site.getParentSiteKey()));
            sb.append("\"");
        }
        if (site.getTemplateKey() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"templateKey\": ");
            sb.append("\"");
            sb.append(SiteSerDes._escape(site.getTemplateKey()));
            sb.append("\"");
        }
        if (site.getTemplateType() != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"templateType\": ");
            sb.append("\"");
            sb.append((Object)site.getTemplateType());
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    public static Map<String, Object> toMap(String json) {
        SiteJSONParser siteJSONParser = new SiteJSONParser();
        return siteJSONParser.parseToMap(json);
    }

    public static Map<String, String> toMap(Site site) {
        if (site == null) {
            return null;
        }
        TreeMap<String, String> map = new TreeMap<String, String>();
        if (site.getExternalReferenceCode() == null) {
            map.put("externalReferenceCode", null);
        } else {
            map.put("externalReferenceCode", String.valueOf(site.getExternalReferenceCode()));
        }
        if (site.getFriendlyUrlPath() == null) {
            map.put("friendlyUrlPath", null);
        } else {
            map.put("friendlyUrlPath", String.valueOf(site.getFriendlyUrlPath()));
        }
        if (site.getId() == null) {
            map.put("id", null);
        } else {
            map.put("id", String.valueOf(site.getId()));
        }
        if (site.getKey() == null) {
            map.put("key", null);
        } else {
            map.put("key", String.valueOf(site.getKey()));
        }
        if (site.getMembershipType() == null) {
            map.put("membershipType", null);
        } else {
            map.put("membershipType", String.valueOf((Object)site.getMembershipType()));
        }
        if (site.getName() == null) {
            map.put("name", null);
        } else {
            map.put("name", String.valueOf(site.getName()));
        }
        if (site.getParentSiteKey() == null) {
            map.put("parentSiteKey", null);
        } else {
            map.put("parentSiteKey", String.valueOf(site.getParentSiteKey()));
        }
        if (site.getTemplateKey() == null) {
            map.put("templateKey", null);
        } else {
            map.put("templateKey", String.valueOf(site.getTemplateKey()));
        }
        if (site.getTemplateType() == null) {
            map.put("templateType", null);
        } else {
            map.put("templateType", String.valueOf((Object)site.getTemplateType()));
        }
        return map;
    }

    private static String _escape(Object object) {
        String string = String.valueOf(object);
        for (String[] strings : BaseJSONParser.JSON_ESCAPE_STRINGS) {
            string = string.replace(strings[0], strings[1]);
        }
        return string;
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(entry.getKey());
            sb.append("\": ");
            Object value = entry.getValue();
            Class<?> valueClass = value.getClass();
            if (value instanceof Map) {
                sb.append(SiteSerDes._toJSON((Map)value));
            } else if (valueClass.isArray()) {
                Object[] values = (Object[])value;
                sb.append("[");
                for (int i = 0; i < values.length; ++i) {
                    sb.append("\"");
                    sb.append(SiteSerDes._escape(values[i]));
                    sb.append("\"");
                    if (i + 1 >= values.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(SiteSerDes._escape(entry.getValue()));
                sb.append("\"");
            } else {
                sb.append(String.valueOf(entry.getValue()));
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public static class SiteJSONParser
    extends BaseJSONParser<Site> {
        @Override
        protected Site createDTO() {
            return new Site();
        }

        protected Site[] createDTOArray(int size) {
            return new Site[size];
        }

        @Override
        protected void setField(Site site, String jsonParserFieldName, Object jsonParserFieldValue) {
            if (Objects.equals(jsonParserFieldName, "externalReferenceCode")) {
                if (jsonParserFieldValue != null) {
                    site.setExternalReferenceCode((String)jsonParserFieldValue);
                }
            } else if (Objects.equals(jsonParserFieldName, "friendlyUrlPath")) {
                if (jsonParserFieldValue != null) {
                    site.setFriendlyUrlPath((String)jsonParserFieldValue);
                }
            } else if (Objects.equals(jsonParserFieldName, "id")) {
                if (jsonParserFieldValue != null) {
                    site.setId(Long.valueOf((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "key")) {
                if (jsonParserFieldValue != null) {
                    site.setKey((String)jsonParserFieldValue);
                }
            } else if (Objects.equals(jsonParserFieldName, "membershipType")) {
                if (jsonParserFieldValue != null) {
                    site.setMembershipType(Site.MembershipType.create((String)jsonParserFieldValue));
                }
            } else if (Objects.equals(jsonParserFieldName, "name")) {
                if (jsonParserFieldValue != null) {
                    site.setName((String)jsonParserFieldValue);
                }
            } else if (Objects.equals(jsonParserFieldName, "parentSiteKey")) {
                if (jsonParserFieldValue != null) {
                    site.setParentSiteKey((String)jsonParserFieldValue);
                }
            } else if (Objects.equals(jsonParserFieldName, "templateKey")) {
                if (jsonParserFieldValue != null) {
                    site.setTemplateKey((String)jsonParserFieldValue);
                }
            } else if (Objects.equals(jsonParserFieldName, "templateType") && jsonParserFieldValue != null) {
                site.setTemplateType(Site.TemplateType.create((String)jsonParserFieldValue));
            }
        }
    }
}

