/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.user.notification.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.validation.Valid;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(description="Represents the current user notification.", value="UserNotification")
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="UserNotification")
public class UserNotification
implements Serializable {
    @GraphQLField(description="Block of actions allowed by the user making the request.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="Block of actions allowed by the user making the request.") Map<String, Map<String, String>> actions;
    @GraphQLField(description="The user notification's creation date.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The user notification's creation date.") Date dateCreated;
    @GraphQLField(description="The user notification's identifier.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The user notification's identifier.") Long id;
    @GraphQLField(description="The user notification's message.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The user notification's message.") String message;
    @GraphQLField(description="A flag that indicates whether this user notification has been read.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="A flag that indicates whether this user notification has been read.") Boolean read;
    @GraphQLField(description="User notification's type.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="User notification's type.") Integer type;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.user.notification.dto.v1_0.UserNotification", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static UserNotification toDTO(String json) {
        return (UserNotification)ObjectMapperUtil.readValue(UserNotification.class, (String)json);
    }

    public static UserNotification unsafeToDTO(String json) {
        return (UserNotification)ObjectMapperUtil.unsafeReadValue(UserNotification.class, (String)json);
    }

    @Schema(description="Block of actions allowed by the user making the request.")
    @Valid
    public Map<String, Map<String, String>> getActions() {
        return this.actions;
    }

    public void setActions(Map<String, Map<String, String>> actions) {
        this.actions = actions;
    }

    @JsonIgnore
    public void setActions(UnsafeSupplier<Map<String, Map<String, String>>, Exception> actionsUnsafeSupplier) {
        try {
            this.actions = (Map)actionsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The user notification's creation date.")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    @JsonIgnore
    public void setDateCreated(UnsafeSupplier<Date, Exception> dateCreatedUnsafeSupplier) {
        try {
            this.dateCreated = (Date)dateCreatedUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The user notification's identifier.")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @JsonIgnore
    public void setId(UnsafeSupplier<Long, Exception> idUnsafeSupplier) {
        try {
            this.id = (Long)idUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The user notification's message.")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @JsonIgnore
    public void setMessage(UnsafeSupplier<String, Exception> messageUnsafeSupplier) {
        try {
            this.message = (String)messageUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="A flag that indicates whether this user notification has been read.")
    public Boolean getRead() {
        return this.read;
    }

    public void setRead(Boolean read) {
        this.read = read;
    }

    @JsonIgnore
    public void setRead(UnsafeSupplier<Boolean, Exception> readUnsafeSupplier) {
        try {
            this.read = (Boolean)readUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="User notification's type.")
    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    @JsonIgnore
    public void setType(UnsafeSupplier<Integer, Exception> typeUnsafeSupplier) {
        try {
            this.type = (Integer)typeUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof UserNotification)) {
            return false;
        }
        UserNotification userNotification = (UserNotification)object;
        return Objects.equals(this.toString(), userNotification.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        StringBundler sb = new StringBundler();
        sb.append("{");
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        if (this.actions != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"actions\": ");
            sb.append(UserNotification._toJSON(this.actions));
        }
        if (this.dateCreated != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateCreated\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(this.dateCreated));
            sb.append("\"");
        }
        if (this.id != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"id\": ");
            sb.append((Object)this.id);
        }
        if (this.message != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"message\": ");
            sb.append("\"");
            sb.append(UserNotification._escape(this.message));
            sb.append("\"");
        }
        if (this.read != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"read\": ");
            sb.append((Object)this.read);
        }
        if (this.type != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"type\": ");
            sb.append((Object)this.type);
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(UserNotification._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (UserNotification._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(UserNotification._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(UserNotification._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

