/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.image.upgrade;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.function.Function;
import java.util.function.Supplier;

public class ImageCompanyIdUpgradeProcess<T>
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog((String)ImageCompanyIdUpgradeProcess.class.getName());
    private final Supplier<ActionableDynamicQuery> _actionableDynamicQuerySupplier;
    private final Function<T, Long> _companyIdFunction;
    private final Function<T, Long> _imageIdFunction;

    public ImageCompanyIdUpgradeProcess(Supplier<ActionableDynamicQuery> actionableDynamicQuerySupplier, Function<T, Long> companyIdFunction, Function<T, Long> imageIdFunction) {
        this._actionableDynamicQuerySupplier = actionableDynamicQuerySupplier;
        this._companyIdFunction = companyIdFunction;
        this._imageIdFunction = imageIdFunction;
    }

    protected void doUpgrade() throws Exception {
        try (PreparedStatement preparedStatement = AutoBatchPreparedStatementUtil.autoBatch((Connection)this.connection, (String)"update Image set companyId = ? where imageId = ?");){
            ActionableDynamicQuery actionableDynamicQuery = this._actionableDynamicQuerySupplier.get();
            actionableDynamicQuery.setPerformActionMethod(model -> {
                try {
                    preparedStatement.setLong(1, this._companyIdFunction.apply(model));
                    preparedStatement.setLong(2, this._imageIdFunction.apply(model));
                    preparedStatement.addBatch();
                }
                catch (Exception exception) {
                    _log.error((Object)StringBundler.concat((Object[])new Object[]{"Cannot update image ", this._imageIdFunction.apply(model), " to company ID", this._companyIdFunction.apply(model)}), (Throwable)exception);
                }
            });
            actionableDynamicQuery.performActions();
            preparedStatement.executeBatch();
        }
    }
}

