/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.image.service.internal.upgrade;

import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.model.DDMTemplateModel;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService;
import com.liferay.image.service.internal.upgrade.v1_0_0.ImageCompanyIdUpgradeProcess;
import com.liferay.image.service.internal.upgrade.v1_0_0.ImageStorageUpgradeProcess;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalArticleModel;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.CompanyModel;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutModel;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutSetBranch;
import com.liferay.portal.kernel.model.LayoutSetBranchModel;
import com.liferay.portal.kernel.model.LayoutSetModel;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ImageLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutSetBranchLocalService;
import com.liferay.portal.kernel.service.LayoutSetLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeStep;
import com.liferay.portal.upgrade.registry.UpgradeStepRegistrator;
import com.liferay.portlet.documentlibrary.store.StoreFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={UpgradeStepRegistrator.class})
public class ImageServiceUpgrade
implements UpgradeStepRegistrator {
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private DDMTemplateLocalService _ddmTemplateLocalService;
    @Reference
    private ImageLocalService _imageLocalService;
    @Reference
    private JournalArticleLocalService _journalArticleLocalService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutSetBranchLocalService _layoutSetBranchLocalService;
    @Reference
    private LayoutSetLocalService _layoutSetLocalService;
    @Reference(target="(dl.store.impl.enabled=true)")
    private StoreFactory _storeFactory;

    public void register(UpgradeStepRegistrator.Registry registry) {
        UpgradeStep[] upgradeStepArray = new UpgradeStep[8];
        upgradeStepArray[0] = new ImageCompanyIdUpgradeProcess<Company>(() -> ((CompanyLocalService)this._companyLocalService).getActionableDynamicQuery(), CompanyModel::getCompanyId, CompanyModel::getLogoId);
        upgradeStepArray[1] = new ImageCompanyIdUpgradeProcess<DDMTemplate>(() -> ((DDMTemplateLocalService)this._ddmTemplateLocalService).getActionableDynamicQuery(), DDMTemplateModel::getCompanyId, DDMTemplateModel::getSmallImageId);
        upgradeStepArray[2] = new ImageCompanyIdUpgradeProcess<JournalArticle>(() -> ((JournalArticleLocalService)this._journalArticleLocalService).getActionableDynamicQuery(), JournalArticleModel::getCompanyId, JournalArticleModel::getSmallImageId);
        upgradeStepArray[3] = new ImageCompanyIdUpgradeProcess<Layout>(() -> ((LayoutLocalService)this._layoutLocalService).getActionableDynamicQuery(), LayoutModel::getCompanyId, LayoutModel::getIconImageId);
        upgradeStepArray[4] = new ImageCompanyIdUpgradeProcess<LayoutSet>(() -> ((LayoutSetLocalService)this._layoutSetLocalService).getActionableDynamicQuery(), LayoutSetModel::getCompanyId, LayoutSetModel::getLogoId);
        upgradeStepArray[5] = new ImageCompanyIdUpgradeProcess<LayoutSetBranch>(() -> ((LayoutSetBranchLocalService)this._layoutSetBranchLocalService).getActionableDynamicQuery(), LayoutSetBranchModel::getCompanyId, LayoutSetBranchModel::getLogoId);
        upgradeStepArray[6] = new ImageCompanyIdUpgradeProcess<LayoutSetBranch>(() -> ((LayoutSetBranchLocalService)this._layoutSetBranchLocalService).getActionableDynamicQuery(), LayoutSetBranchModel::getCompanyId, LayoutSetBranch::getLiveLogoId);
        upgradeStepArray[7] = new ImageStorageUpgradeProcess(this._imageLocalService, this._storeFactory);
        registry.register("0.0.0", "1.0.0", upgradeStepArray);
    }
}

