/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.image.service.internal.upgrade.v1_0_0;

import com.liferay.document.library.kernel.store.Store;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Image;
import com.liferay.portal.kernel.service.ImageLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portlet.documentlibrary.store.StoreFactory;
import java.io.InputStream;

public class ImageStorageUpgradeProcess
extends UpgradeProcess {
    private static final long _REPOSITORY_ID = 0L;
    private static final Log _log = LogFactoryUtil.getLog(ImageStorageUpgradeProcess.class);
    private final ImageLocalService _imageLocalService;
    private final StoreFactory _storeFactory;

    public ImageStorageUpgradeProcess(ImageLocalService imageLocalService, StoreFactory storeFactory) {
        this._imageLocalService = imageLocalService;
        this._storeFactory = storeFactory;
    }

    protected void doUpgrade() throws PortalException {
        Store store = this._storeFactory.getStore();
        ActionableDynamicQuery actionableDynamicQuery = this._imageLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setPerformActionMethod(image -> {
            String fileName = this._getFileName((Image)image);
            try (InputStream inputStream = store.getFileAsStream(0L, 0L, fileName, "");){
                store.addFile(image.getCompanyId(), 0L, fileName, "1.0", inputStream);
                store.deleteFile(0L, 0L, fileName, "1.0");
            }
            catch (Exception exception) {
                _log.error((Object)exception, (Throwable)exception);
            }
        });
        actionableDynamicQuery.performActions();
    }

    private String _getFileName(Image image) {
        return image.getImageId() + "." + image.getType();
    }
}

