/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.info.field;

import com.liferay.info.field.InfoField;
import com.liferay.info.field.InfoFieldSetEntry;
import com.liferay.info.localized.InfoLocalizedValue;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.lang.HashUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.MapUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class InfoFieldSet
implements InfoFieldSetEntry {
    private final Builder _builder;

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public InfoFieldSet(InfoLocalizedValue<String> labelInfoLocalizedValue, String name) {
        this(InfoFieldSet.builder().labelInfoLocalizedValue(labelInfoLocalizedValue).name(name));
    }

    @Deprecated
    public InfoFieldSet add(InfoFieldSetEntry infoFieldSetEntry) {
        this._builder.infoFieldSetEntry(infoFieldSetEntry);
        return this;
    }

    @Deprecated
    public InfoFieldSet addAll(Collection<InfoFieldSetEntry> infoFieldSetEntries) {
        this._builder.infoFieldSetEntries(infoFieldSetEntries);
        return this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof InfoFieldSet)) {
            return false;
        }
        InfoFieldSet infoFieldSet = (InfoFieldSet)object;
        return Objects.equals(this._builder._labelInfoLocalizedValue, infoFieldSet._builder._labelInfoLocalizedValue) && Objects.equals(this._builder._name, infoFieldSet._builder._name);
    }

    public List<InfoField> getAllInfoFields() {
        ArrayList<InfoField> allInfoFields = new ArrayList<InfoField>();
        for (InfoFieldSetEntry infoFieldSetEntry : this._builder._infoFieldSetEntries.values()) {
            if (infoFieldSetEntry instanceof InfoField) {
                allInfoFields.add((InfoField)infoFieldSetEntry);
                continue;
            }
            if (!(infoFieldSetEntry instanceof InfoFieldSet)) continue;
            InfoFieldSet infoFieldSet = (InfoFieldSet)infoFieldSetEntry;
            allInfoFields.addAll(infoFieldSet.getAllInfoFields());
        }
        return allInfoFields;
    }

    public List<InfoFieldSetEntry> getInfoFieldSetEntries() {
        return new ArrayList<InfoFieldSetEntry>(this._builder._infoFieldSetEntries.values());
    }

    public InfoFieldSetEntry getInfoFieldSetEntry(String name) {
        return (InfoFieldSetEntry)this._builder._infoFieldSetEntries.get(name);
    }

    @Override
    public String getLabel(Locale locale) {
        return (String)this._builder._labelInfoLocalizedValue.getValue(locale);
    }

    @Override
    public InfoLocalizedValue<String> getLabelInfoLocalizedValue() {
        return this._builder._labelInfoLocalizedValue;
    }

    @Override
    public String getName() {
        return this._builder._name;
    }

    public int hashCode() {
        int hash = HashUtil.hash((int)0, (Object)this._builder._labelInfoLocalizedValue);
        return HashUtil.hash((int)hash, (Object)this._builder._name);
    }

    public String toString() {
        StringBundler sb = new StringBundler(5);
        sb.append("{_infoFieldSetEntries: ");
        sb.append(MapUtil.toString((Map)this._builder._infoFieldSetEntries));
        sb.append(", name: ");
        sb.append(this._builder._name);
        sb.append("}");
        return sb.toString();
    }

    private InfoFieldSet(Builder builder) {
        this._builder = builder;
    }

    public static class Builder {
        private final Map<String, InfoFieldSetEntry> _infoFieldSetEntries = new LinkedHashMap<String, InfoFieldSetEntry>();
        private InfoLocalizedValue<String> _labelInfoLocalizedValue;
        private String _name;

        public InfoFieldSet build() {
            return new InfoFieldSet(this);
        }

        public Builder infoFieldSetEntries(Collection<InfoFieldSetEntry> infoFieldSetEntries) {
            for (InfoFieldSetEntry infoFieldSetEntry : infoFieldSetEntries) {
                this.infoFieldSetEntry(infoFieldSetEntry);
            }
            return this;
        }

        public Builder infoFieldSetEntry(InfoFieldSetEntry infoFieldSetEntry) {
            this._infoFieldSetEntries.put(infoFieldSetEntry.getName(), infoFieldSetEntry);
            return this;
        }

        public <T extends Throwable> Builder infoFieldSetEntry(UnsafeConsumer<UnsafeConsumer<InfoFieldSetEntry, T>, T> consumer) throws T {
            consumer.accept(this::infoFieldSetEntry);
            return this;
        }

        public Builder labelInfoLocalizedValue(InfoLocalizedValue<String> labelInfoLocalizedValue) {
            this._labelInfoLocalizedValue = labelInfoLocalizedValue;
            return this;
        }

        public Builder name(String name) {
            this._name = name;
            return this;
        }
    }
}

