/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.info.collection.provider.item.selector.web.internal;

import com.liferay.info.collection.provider.InfoCollectionProvider;
import com.liferay.info.collection.provider.SingleFormVariationInfoCollectionProvider;
import com.liferay.info.collection.provider.item.selector.criterion.InfoCollectionProviderItemSelectorCriterion;
import com.liferay.info.item.InfoItemServiceTracker;
import com.liferay.info.list.provider.item.selector.criterion.InfoListProviderItemSelectorReturnType;
import com.liferay.item.selector.ItemSelectorReturnType;
import com.liferay.item.selector.ItemSelectorView;
import com.liferay.item.selector.ItemSelectorViewDescriptor;
import com.liferay.item.selector.ItemSelectorViewDescriptorRenderer;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ItemSelectorView.class})
public class InfoCollectionProviderItemSelectorView
implements ItemSelectorView<InfoCollectionProviderItemSelectorCriterion> {
    private static final Log _log = LogFactoryUtil.getLog(InfoCollectionProviderItemSelectorView.class);
    private static final List<ItemSelectorReturnType> _supportedItemSelectorReturnTypes = Collections.singletonList(new InfoListProviderItemSelectorReturnType());
    @Reference
    private InfoItemServiceTracker _infoItemServiceTracker;
    @Reference
    private ItemSelectorViewDescriptorRenderer<InfoCollectionProviderItemSelectorCriterion> _itemSelectorViewDescriptorRenderer;
    @Reference
    private Language _language;
    @Reference(target="(osgi.web.symbolicname=com.liferay.info.list.provider.item.selector.web)")
    private ServletContext _servletContext;

    public Class<? extends InfoCollectionProviderItemSelectorCriterion> getItemSelectorCriterionClass() {
        return InfoCollectionProviderItemSelectorCriterion.class;
    }

    public List<ItemSelectorReturnType> getSupportedItemSelectorReturnTypes() {
        return _supportedItemSelectorReturnTypes;
    }

    public String getTitle(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, this.getClass());
        return this._language.get(resourceBundle, "collection-providers");
    }

    public void renderHTML(ServletRequest servletRequest, ServletResponse servletResponse, InfoCollectionProviderItemSelectorCriterion infoCollectionProviderItemSelectorCriterion, PortletURL portletURL, String itemSelectedEventName, boolean search) throws IOException, ServletException {
        this._itemSelectorViewDescriptorRenderer.renderHTML(servletRequest, servletResponse, (Object)infoCollectionProviderItemSelectorCriterion, portletURL, itemSelectedEventName, search, (ItemSelectorViewDescriptor)new InfoCollectionProviderItemSelectorViewDescriptor((HttpServletRequest)servletRequest, infoCollectionProviderItemSelectorCriterion, portletURL));
    }

    private class InfoCollectionProviderItemSelectorViewDescriptor
    implements ItemSelectorViewDescriptor<InfoCollectionProvider<?>> {
        private final HttpServletRequest _httpServletRequest;
        private final InfoCollectionProviderItemSelectorCriterion _infoCollectionProviderItemSelectorCriterion;
        private final PortletURL _portletURL;

        public InfoCollectionProviderItemSelectorViewDescriptor(HttpServletRequest httpServletRequest, InfoCollectionProviderItemSelectorCriterion infoCollectionProviderItemSelectorCriterion, PortletURL portletURL) {
            this._httpServletRequest = httpServletRequest;
            this._infoCollectionProviderItemSelectorCriterion = infoCollectionProviderItemSelectorCriterion;
            this._portletURL = portletURL;
        }

        public ItemSelectorViewDescriptor.ItemDescriptor getItemDescriptor(final InfoCollectionProvider<?> infoCollectionProvider) {
            return new ItemSelectorViewDescriptor.ItemDescriptor(){

                public String getIcon() {
                    return "list";
                }

                public String getImageURL() {
                    return "";
                }

                public String getPayload() {
                    ThemeDisplay themeDisplay = (ThemeDisplay)InfoCollectionProviderItemSelectorViewDescriptor.this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
                    JSONObject jsonObject = JSONUtil.put((String)"itemType", (Object)infoCollectionProvider.getCollectionItemClassName()).put("key", infoCollectionProvider.getKey()).put("title", infoCollectionProvider.getLabel(themeDisplay.getLocale()));
                    if (infoCollectionProvider instanceof SingleFormVariationInfoCollectionProvider) {
                        SingleFormVariationInfoCollectionProvider singleFormVariationInfoCollectionProvider = (SingleFormVariationInfoCollectionProvider)infoCollectionProvider;
                        jsonObject.put("itemSubtype", singleFormVariationInfoCollectionProvider.getFormVariationKey());
                    }
                    return jsonObject.toString();
                }

                public String getSubtitle(Locale locale) {
                    String className = infoCollectionProvider.getCollectionItemClassName();
                    if (Validator.isNotNull((String)className)) {
                        return ResourceActionsUtil.getModelResource((Locale)locale, (String)className);
                    }
                    return "";
                }

                public String getTitle(Locale locale) {
                    return infoCollectionProvider.getLabel(locale);
                }
            };
        }

        public ItemSelectorReturnType getItemSelectorReturnType() {
            return new InfoListProviderItemSelectorReturnType();
        }

        public SearchContainer<InfoCollectionProvider<?>> getSearchContainer() {
            PortletRequest portletRequest = (PortletRequest)this._httpServletRequest.getAttribute("javax.portlet.request");
            ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)themeDisplay.getLocale(), this.getClass());
            SearchContainer searchContainer = new SearchContainer(portletRequest, this._portletURL, null, InfoCollectionProviderItemSelectorView.this._language.get(resourceBundle, "there-are-no-collection-providers"));
            List infoCollectionProviders = new ArrayList();
            List itemTypes = this._infoCollectionProviderItemSelectorCriterion.getItemTypes();
            if (ListUtil.isNotEmpty((List)itemTypes)) {
                for (String itemType : itemTypes) {
                    infoCollectionProviders.addAll(InfoCollectionProviderItemSelectorView.this._infoItemServiceTracker.getAllInfoItemServices(InfoCollectionProvider.class, itemType));
                }
            } else {
                infoCollectionProviders = InfoCollectionProviderItemSelectorView.this._infoItemServiceTracker.getAllInfoItemServices(InfoCollectionProvider.class);
            }
            infoCollectionProviders = ListUtil.filter(infoCollectionProviders, infoCollectionProvider -> {
                try {
                    String label = infoCollectionProvider.getLabel(themeDisplay.getLocale());
                    return Validator.isNotNull((String)label) && infoCollectionProvider.isAvailable();
                }
                catch (Exception exception) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)"Unable to get info list provider label", (Throwable)exception);
                    }
                    return false;
                }
            });
            searchContainer.setResults(ListUtil.subList(infoCollectionProviders, (int)searchContainer.getStart(), (int)searchContainer.getEnd()));
            searchContainer.setTotal(infoCollectionProviders.size());
            return searchContainer;
        }

        public boolean isShowBreadcrumb() {
            return false;
        }
    }
}

