/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.info.collection.provider.item.selector.web.internal.layout.list.retriever;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.info.collection.provider.CollectionQuery;
import com.liferay.info.collection.provider.FilteredInfoCollectionProvider;
import com.liferay.info.collection.provider.InfoCollectionProvider;
import com.liferay.info.collection.provider.RelatedInfoItemCollectionProvider;
import com.liferay.info.filter.InfoFilter;
import com.liferay.info.filter.InfoRequestItemProvider;
import com.liferay.info.item.ClassPKInfoItemIdentifier;
import com.liferay.info.item.InfoItemFieldValues;
import com.liferay.info.item.InfoItemIdentifier;
import com.liferay.info.item.InfoItemReference;
import com.liferay.info.item.InfoItemServiceTracker;
import com.liferay.info.item.provider.InfoItemFieldValuesProvider;
import com.liferay.info.item.provider.filter.InfoItemServiceFilter;
import com.liferay.info.item.provider.filter.PropertyInfoItemServiceFilter;
import com.liferay.info.list.provider.item.selector.criterion.InfoListProviderItemSelectorReturnType;
import com.liferay.info.pagination.InfoPage;
import com.liferay.info.pagination.Pagination;
import com.liferay.layout.list.retriever.KeyListObjectReference;
import com.liferay.layout.list.retriever.LayoutListRetriever;
import com.liferay.layout.list.retriever.LayoutListRetrieverContext;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={LayoutListRetriever.class})
public class InfoCollectionProviderLayoutListRetriever
implements LayoutListRetriever<InfoListProviderItemSelectorReturnType, KeyListObjectReference> {
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private InfoItemServiceTracker _infoItemServiceTracker;
    @Reference
    private UserLocalService _userLocalService;

    public List<Object> getList(KeyListObjectReference keyListObjectReference, LayoutListRetrieverContext layoutListRetrieverContext) {
        InfoCollectionProvider infoCollectionProvider = (InfoCollectionProvider)this._infoItemServiceTracker.getInfoItemService(InfoCollectionProvider.class, keyListObjectReference.getKey());
        if (infoCollectionProvider == null) {
            infoCollectionProvider = (InfoCollectionProvider)this._infoItemServiceTracker.getInfoItemService(RelatedInfoItemCollectionProvider.class, keyListObjectReference.getKey());
        }
        if (infoCollectionProvider == null) {
            return Collections.emptyList();
        }
        CollectionQuery collectionQuery = new CollectionQuery();
        if (infoCollectionProvider instanceof RelatedInfoItemCollectionProvider) {
            Optional contextObjectOptional = layoutListRetrieverContext.getContextObjectOptional();
            AssetEntry relatedItem = contextObjectOptional.orElse(null);
            if (relatedItem == null) {
                return Collections.emptyList();
            }
            RelatedInfoItemCollectionProvider relatedInfoItemCollectionProvider = (RelatedInfoItemCollectionProvider)infoCollectionProvider;
            if (Objects.equals(relatedInfoItemCollectionProvider.getSourceItemClass(), AssetEntry.class)) {
                relatedItem = this._getAssetEntryOptional(relatedItem);
            }
            collectionQuery.setRelatedItemObject(relatedItem);
        }
        Optional paginationOptional = layoutListRetrieverContext.getPaginationOptional();
        collectionQuery.setPagination((Pagination)paginationOptional.orElse(null));
        if (infoCollectionProvider instanceof FilteredInfoCollectionProvider) {
            FilteredInfoCollectionProvider filteredInfoCollectionProvider = (FilteredInfoCollectionProvider)infoCollectionProvider;
            collectionQuery.setInfoFilter(this._getInfoFilter((FilteredInfoCollectionProvider<Object, InfoFilter>)filteredInfoCollectionProvider, layoutListRetrieverContext));
        }
        InfoPage infoPage = infoCollectionProvider.getCollectionInfoPage(collectionQuery);
        return infoPage.getPageItems();
    }

    public int getListCount(KeyListObjectReference keyListObjectReference, LayoutListRetrieverContext layoutListRetrieverContext) {
        InfoCollectionProvider infoCollectionProvider = (InfoCollectionProvider)this._infoItemServiceTracker.getInfoItemService(InfoCollectionProvider.class, keyListObjectReference.getKey());
        if (infoCollectionProvider == null) {
            infoCollectionProvider = (InfoCollectionProvider)this._infoItemServiceTracker.getInfoItemService(RelatedInfoItemCollectionProvider.class, keyListObjectReference.getKey());
        }
        if (infoCollectionProvider == null) {
            return 0;
        }
        CollectionQuery collectionQuery = new CollectionQuery();
        if (infoCollectionProvider instanceof RelatedInfoItemCollectionProvider) {
            Optional contextObjectOptional = layoutListRetrieverContext.getContextObjectOptional();
            AssetEntry relatedItem = contextObjectOptional.orElse(null);
            if (relatedItem == null) {
                return 0;
            }
            RelatedInfoItemCollectionProvider relatedInfoItemCollectionProvider = (RelatedInfoItemCollectionProvider)infoCollectionProvider;
            if (Objects.equals(relatedInfoItemCollectionProvider.getSourceItemClass(), AssetEntry.class)) {
                relatedItem = this._getAssetEntryOptional(relatedItem);
            }
            collectionQuery.setRelatedItemObject(relatedItem);
        }
        if (infoCollectionProvider instanceof FilteredInfoCollectionProvider) {
            FilteredInfoCollectionProvider filteredInfoCollectionProvider = (FilteredInfoCollectionProvider)infoCollectionProvider;
            collectionQuery.setInfoFilter(this._getInfoFilter((FilteredInfoCollectionProvider<Object, InfoFilter>)filteredInfoCollectionProvider, layoutListRetrieverContext));
        }
        InfoPage infoPage = infoCollectionProvider.getCollectionInfoPage(collectionQuery);
        return infoPage.getTotalCount();
    }

    private AssetEntry _getAssetEntryOptional(Object contextObject) {
        if (contextObject instanceof AssetEntry) {
            return (AssetEntry)contextObject;
        }
        if (!(contextObject instanceof ClassedModel)) {
            return null;
        }
        InfoItemFieldValuesProvider infoItemFieldValuesProvider = (InfoItemFieldValuesProvider)this._infoItemServiceTracker.getFirstInfoItemService(InfoItemFieldValuesProvider.class, this._getModelClassName(contextObject));
        InfoItemFieldValues infoItemFieldValues = infoItemFieldValuesProvider.getInfoItemFieldValues(contextObject);
        InfoItemReference infoItemReference = infoItemFieldValues.getInfoItemReference();
        InfoItemIdentifier infoItemIdentifier = infoItemReference.getInfoItemIdentifier();
        if (!(infoItemIdentifier instanceof ClassPKInfoItemIdentifier)) {
            return null;
        }
        ClassPKInfoItemIdentifier classPKInfoItemIdentifier = (ClassPKInfoItemIdentifier)infoItemIdentifier;
        String className = infoItemReference.getClassName();
        if (Objects.equals(className, FileEntry.class.getName())) {
            className = DLFileEntry.class.getName();
        }
        return this._assetEntryLocalService.fetchEntry(className, classPKInfoItemIdentifier.getClassPK());
    }

    private InfoFilter _getInfoFilter(FilteredInfoCollectionProvider<Object, InfoFilter> filteredInfoCollectionProvider, LayoutListRetrieverContext layoutListRetrieverContext) {
        Optional httpServletRequestOptional = layoutListRetrieverContext.getHttpServletRequestOptional();
        HttpServletRequest httpServletRequest = httpServletRequestOptional.orElse(null);
        if (!httpServletRequestOptional.isPresent()) {
            return null;
        }
        Class infoFilterClass = filteredInfoCollectionProvider.getInfoFilterClass();
        InfoRequestItemProvider infoRequestItemProvider = (InfoRequestItemProvider)this._infoItemServiceTracker.getFirstInfoItemService(InfoRequestItemProvider.class, InfoFilter.class.getName(), (InfoItemServiceFilter)new PropertyInfoItemServiceFilter("infoFilterKey", infoFilterClass.getName()));
        return (InfoFilter)infoRequestItemProvider.create(httpServletRequest);
    }

    private String _getModelClassName(Object contextObject) {
        if (contextObject instanceof FileEntry) {
            return FileEntry.class.getName();
        }
        ClassedModel classedModel = (ClassedModel)contextObject;
        return classedModel.getModelClassName();
    }
}

