/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.info.internal.item;

import com.liferay.info.collection.provider.InfoCollectionProvider;
import com.liferay.info.collection.provider.RelatedInfoItemCollectionProvider;
import com.liferay.info.exception.CapabilityVerificationException;
import com.liferay.info.filter.InfoRequestItemProvider;
import com.liferay.info.formatter.InfoCollectionTextFormatter;
import com.liferay.info.formatter.InfoTextFormatter;
import com.liferay.info.internal.util.ItemClassNameServiceReferenceMapper;
import com.liferay.info.item.InfoItemClassDetails;
import com.liferay.info.item.InfoItemServiceTracker;
import com.liferay.info.item.capability.InfoItemCapability;
import com.liferay.info.item.provider.InfoItemCapabilitiesProvider;
import com.liferay.info.item.provider.InfoItemDetailsProvider;
import com.liferay.info.item.provider.InfoItemFieldValuesProvider;
import com.liferay.info.item.provider.InfoItemFormProvider;
import com.liferay.info.item.provider.InfoItemFormVariationsProvider;
import com.liferay.info.item.provider.InfoItemObjectProvider;
import com.liferay.info.item.provider.InfoItemPermissionProvider;
import com.liferay.info.item.provider.InfoItemWorkflowProvider;
import com.liferay.info.item.provider.filter.InfoItemServiceFilter;
import com.liferay.info.item.renderer.InfoItemRenderer;
import com.liferay.info.item.selector.InfoItemSelector;
import com.liferay.info.item.updater.InfoItemFieldValuesUpdater;
import com.liferay.info.list.provider.InfoListProvider;
import com.liferay.info.list.renderer.InfoListRenderer;
import com.liferay.info.localized.InfoLocalizedValue;
import com.liferay.info.type.Keyed;
import com.liferay.osgi.service.tracker.collections.ServiceReferenceServiceTuple;
import com.liferay.osgi.service.tracker.collections.map.PropertyServiceReferenceComparator;
import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapperFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerCustomizerFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.translation.info.item.provider.InfoItemLanguagesProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(immediate=true, service={InfoItemServiceTracker.class})
public class InfoItemServiceTrackerImpl
implements InfoItemServiceTracker {
    private ServiceTrackerMap<String, InfoItemCapability> _infoItemCapabilityServiceTrackerMap;
    private final Map<String, ServiceTrackerMap<String, List<ServiceReferenceServiceTuple<Object, Object>>>> _itemClassNameInfoItemServiceTrackerMap = new HashMap<String, ServiceTrackerMap<String, List<ServiceReferenceServiceTuple<Object, Object>>>>();
    private final Map<String, ServiceTrackerMap<String, ?>> _keyedInfoItemServiceTrackerMap = new HashMap();

    public <P> List<P> getAllInfoItemServices(Class<P> serviceClass) {
        ServiceTrackerMap<String, ?> serviceTrackerMap = this._keyedInfoItemServiceTrackerMap.get(serviceClass.getName());
        return new ArrayList(serviceTrackerMap.values());
    }

    public <P> List<P> getAllInfoItemServices(Class<P> serviceClass, String itemClassName, InfoItemServiceFilter infoItemServiceFilter) {
        ServiceTrackerMap<String, List<ServiceReferenceServiceTuple<Object, Object>>> infoItemServiceTrackerMap = this._itemClassNameInfoItemServiceTrackerMap.get(serviceClass.getName());
        List serviceReferenceServiceTuples = (List)infoItemServiceTrackerMap.getService((Object)itemClassName);
        if (serviceReferenceServiceTuples != null) {
            Stream<Object> stream = serviceReferenceServiceTuples.stream();
            if (infoItemServiceFilter != null) {
                try {
                    Filter filter = FrameworkUtil.createFilter((String)infoItemServiceFilter.getFilterString());
                    stream = stream.filter(srst -> filter.match(srst.getServiceReference()));
                }
                catch (InvalidSyntaxException invalidSyntaxException) {
                    throw new RuntimeException("Incorrect filter string", invalidSyntaxException);
                }
            }
            return stream.map(ServiceReferenceServiceTuple::getService).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public <P> P getFirstInfoItemService(Class<P> serviceClass, String itemClassName, InfoItemServiceFilter infoItemServiceFilter) {
        List<P> infoItemServices = this.getAllInfoItemServices(serviceClass, itemClassName, infoItemServiceFilter);
        if (ListUtil.isEmpty(infoItemServices)) {
            return null;
        }
        return infoItemServices.get(0);
    }

    public List<InfoItemCapability> getInfoItemCapabilities(String itemClassName) {
        InfoItemCapabilitiesProvider infoItemCapabilitiesProvider = this.getFirstInfoItemService(InfoItemCapabilitiesProvider.class, itemClassName, null);
        return infoItemCapabilitiesProvider.getInfoItemCapabilities();
    }

    public InfoItemCapability getInfoItemCapability(String infoItemCapabilityKey) {
        return (InfoItemCapability)this._infoItemCapabilityServiceTrackerMap.getService((Object)infoItemCapabilityKey);
    }

    public <P> List<InfoItemClassDetails> getInfoItemClassDetails(Class<P> serviceClass) {
        List<String> infoItemClassNames = this.getInfoItemClassNames(serviceClass);
        Stream infoItemClassNamesStream = infoItemClassNames.stream();
        return infoItemClassNamesStream.map(itemClassName -> this._getInfoItemClassDetails((String)itemClassName)).collect(Collectors.toList());
    }

    public List<InfoItemClassDetails> getInfoItemClassDetails(InfoItemCapability infoItemCapability) throws CapabilityVerificationException {
        ArrayList<InfoItemClassDetails> infoItemClassDetailsList = new ArrayList<InfoItemClassDetails>();
        for (InfoItemClassDetails curInfoItemClassDetails : this.getInfoItemClassDetails(InfoItemCapabilitiesProvider.class)) {
            InfoItemCapabilitiesProvider infoItemCapabilitiesProvider = this.getFirstInfoItemService(InfoItemCapabilitiesProvider.class, curInfoItemClassDetails.getClassName(), null);
            List infoItemCapabilities = infoItemCapabilitiesProvider.getInfoItemCapabilities();
            if (infoItemCapabilities.contains(infoItemCapability)) {
                infoItemCapability.verify(curInfoItemClassDetails.getClassName());
            }
            infoItemClassDetailsList.add(curInfoItemClassDetails);
        }
        return infoItemClassDetailsList;
    }

    public List<InfoItemClassDetails> getInfoItemClassDetails(String infoItemCapabilityKey) throws CapabilityVerificationException {
        InfoItemCapability infoItemCapability = (InfoItemCapability)this._infoItemCapabilityServiceTrackerMap.getService((Object)infoItemCapabilityKey);
        if (infoItemCapability == null) {
            throw new RuntimeException("Unable to find info item capability with key " + infoItemCapabilityKey);
        }
        return this.getInfoItemClassDetails(infoItemCapability);
    }

    public <P> List<String> getInfoItemClassNames(Class<P> serviceClass) {
        ServiceTrackerMap<String, List<ServiceReferenceServiceTuple<Object, Object>>> infoItemServiceTrackerMap = this._itemClassNameInfoItemServiceTrackerMap.get(serviceClass.getName());
        return new ArrayList<String>(infoItemServiceTrackerMap.keySet());
    }

    public <P> P getInfoItemService(Class<P> serviceClass, String serviceKey) {
        if (Validator.isNull((String)serviceKey)) {
            return null;
        }
        ServiceTrackerMap<String, ?> infoItemServiceTrackerMap = this._keyedInfoItemServiceTrackerMap.get(serviceClass.getName());
        return (P)infoItemServiceTrackerMap.getService((Object)serviceKey);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        Class[] serviceClasses;
        this._infoItemCapabilityServiceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, InfoItemCapability.class, null, (ServiceReferenceMapper)ServiceReferenceMapperFactory.create((BundleContext)bundleContext, (service, emitter) -> emitter.emit((Object)service.getKey())));
        for (Class serviceClass : serviceClasses = new Class[]{InfoCollectionProvider.class, InfoCollectionTextFormatter.class, InfoTextFormatter.class, InfoItemCapabilitiesProvider.class, InfoItemDetailsProvider.class, InfoItemFieldValuesProvider.class, InfoItemFieldValuesUpdater.class, InfoItemFormProvider.class, InfoItemFormVariationsProvider.class, InfoItemLanguagesProvider.class, InfoItemObjectProvider.class, InfoItemPermissionProvider.class, InfoItemRenderer.class, InfoItemSelector.class, InfoItemWorkflowProvider.class, InfoListRenderer.class, InfoListProvider.class, InfoRequestItemProvider.class, RelatedInfoItemCollectionProvider.class}) {
            ServiceTrackerMap itemClassNameInfoItemServiceTrackerMap = ServiceTrackerMapFactory.openMultiValueMap((BundleContext)bundleContext, (Class)serviceClass, null, (ServiceReferenceMapper)new ItemClassNameServiceReferenceMapper(bundleContext), (ServiceTrackerCustomizer)ServiceTrackerCustomizerFactory.serviceReferenceServiceTuple((BundleContext)bundleContext));
            this._itemClassNameInfoItemServiceTrackerMap.put(serviceClass.getName(), (ServiceTrackerMap<String, List<ServiceReferenceServiceTuple<Object, Object>>>)itemClassNameInfoItemServiceTrackerMap);
            ServiceTrackerMap infoItemServiceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, (Class)serviceClass, null, (ServiceReferenceMapper)ServiceReferenceMapperFactory.create((BundleContext)bundleContext, (service, emitter) -> {
                String key = serviceClass.getName();
                if (service instanceof Keyed) {
                    Keyed keyedService = (Keyed)service;
                    key = keyedService.getKey();
                }
                emitter.emit((Object)key);
            }), (Comparator)new PropertyServiceReferenceComparator("service.ranking"));
            this._keyedInfoItemServiceTrackerMap.put(serviceClass.getName(), infoItemServiceTrackerMap);
        }
    }

    private InfoItemClassDetails _getInfoItemClassDetails(String itemClassName) {
        InfoItemDetailsProvider infoItemDetailsProvider = this.getFirstInfoItemService(InfoItemDetailsProvider.class, itemClassName, null);
        InfoItemClassDetails infoItemClassDetails = null;
        infoItemClassDetails = infoItemDetailsProvider != null ? infoItemDetailsProvider.getInfoItemClassDetails() : new InfoItemClassDetails(itemClassName, InfoLocalizedValue.modelResource((String)itemClassName));
        return infoItemClassDetails;
    }
}

