/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.info.internal.list.provider;

import com.liferay.info.collection.provider.CollectionQuery;
import com.liferay.info.collection.provider.InfoCollectionProvider;
import com.liferay.info.item.InfoItemServiceTracker;
import com.liferay.info.list.provider.DefaultInfoListProviderContext;
import com.liferay.info.list.provider.InfoListProvider;
import com.liferay.info.list.provider.InfoListProviderContext;
import com.liferay.info.list.provider.InfoListProviderTracker;
import com.liferay.info.pagination.InfoPage;
import com.liferay.info.pagination.Pagination;
import com.liferay.info.sort.Sort;
import com.liferay.osgi.util.ServiceTrackerFactory;
import com.liferay.petra.reflect.GenericUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HashMapDictionary;
import java.util.Dictionary;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(immediate=true, service={InfoListProviderTracker.class})
public class InfoListProviderTrackerImpl
implements InfoListProviderTracker {
    private static final Log _log = LogFactoryUtil.getLog(InfoListProviderTrackerImpl.class);
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private InfoItemServiceTracker _infoItemServiceTracker;
    @Reference
    private LayoutLocalService _layoutLocalService;
    private final Map<ServiceReference<InfoListProvider<?>>, ServiceRegistration<InfoCollectionProvider<?>>> _serviceRegistrations = new ConcurrentHashMap();
    private ServiceTracker<InfoListProvider<?>, InfoCollectionProvider<?>> _serviceTracker;
    @Reference
    private UserLocalService _userLocalService;

    public InfoListProvider<?> getInfoListProvider(String key) {
        return (InfoListProvider)this._infoItemServiceTracker.getInfoItemService(InfoListProvider.class, key);
    }

    public List<InfoListProvider<?>> getInfoListProviders() {
        return this._infoItemServiceTracker.getAllInfoItemServices(InfoListProvider.class);
    }

    public List<InfoListProvider<?>> getInfoListProviders(Class<?> itemClass) {
        return this.getInfoListProviders(itemClass.getName());
    }

    public List<InfoListProvider<?>> getInfoListProviders(String itemClassName) {
        return this._infoItemServiceTracker.getAllInfoItemServices(InfoListProvider.class, itemClassName);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTracker = ServiceTrackerFactory.open((BundleContext)bundleContext, InfoListProvider.class, (ServiceTrackerCustomizer)new InfoListProviderAdapterServiceTrackerCustomizer(bundleContext, this._serviceRegistrations));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTracker.close();
        for (ServiceRegistration<InfoCollectionProvider<?>> serviceRegistration : this._serviceRegistrations.values()) {
            try {
                serviceRegistration.unregister();
            }
            catch (IllegalStateException illegalStateException) {
                _log.error((Object)illegalStateException, (Throwable)illegalStateException);
            }
        }
        this._serviceRegistrations.clear();
    }

    private class InfoListProviderInfoCollectionProviderWrapper
    implements InfoCollectionProvider {
        private final InfoListProvider<?> _infoListProvider;

        public InfoListProviderInfoCollectionProviderWrapper(InfoListProvider<?> infoListProvider) {
            this._infoListProvider = infoListProvider;
        }

        public InfoPage<?> getCollectionInfoPage(CollectionQuery collectionQuery) {
            InfoListProviderContext infoListProviderContext = this._getInfoListProviderContext();
            Optional optionalSort = collectionQuery.getSortOptional();
            return InfoPage.of((List)this._infoListProvider.getInfoList(infoListProviderContext, collectionQuery.getPagination(), (Sort)optionalSort.orElse(null)), (Pagination)collectionQuery.getPagination(), (int)this._infoListProvider.getInfoListCount(infoListProviderContext));
        }

        public Class<?> getCollectionItemClass() {
            return GenericUtil.getGenericClass(this._infoListProvider);
        }

        public String getKey() {
            return this._infoListProvider.getKey();
        }

        public String getLabel(Locale locale) {
            return this._infoListProvider.getLabel(locale);
        }

        public boolean isAvailable() {
            return this._infoListProvider.isAvailable(this._getInfoListProviderContext());
        }

        private InfoListProviderContext _getInfoListProviderContext() {
            ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
            Group group = InfoListProviderTrackerImpl.this._groupLocalService.fetchGroup(serviceContext.getScopeGroupId());
            User user = InfoListProviderTrackerImpl.this._userLocalService.fetchUser(serviceContext.getUserId());
            DefaultInfoListProviderContext defaultInfoListProviderContext = new DefaultInfoListProviderContext(group, user);
            ThemeDisplay themeDisplay = serviceContext.getThemeDisplay();
            Layout layout = themeDisplay.getLayout();
            if (layout.isTypeControlPanel()) {
                layout = InfoListProviderTrackerImpl.this._layoutLocalService.fetchLayout(themeDisplay.getRefererPlid());
            }
            defaultInfoListProviderContext.setLayout(layout);
            return defaultInfoListProviderContext;
        }
    }

    private class InfoListProviderAdapterServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<InfoListProvider<?>, InfoCollectionProvider<?>> {
        private final BundleContext _bundleContext;
        private final Map<ServiceReference<InfoListProvider<?>>, ServiceRegistration<InfoCollectionProvider<?>>> _serviceRegistrations;

        public InfoListProviderAdapterServiceTrackerCustomizer(BundleContext bundleContext, Map<ServiceReference<InfoListProvider<?>>, ServiceRegistration<InfoCollectionProvider<?>>> serviceRegistrations) {
            this._bundleContext = bundleContext;
            this._serviceRegistrations = serviceRegistrations;
        }

        public InfoCollectionProvider<?> addingService(ServiceReference<InfoListProvider<?>> serviceReference) {
            InfoListProvider infoListProvider = (InfoListProvider)this._bundleContext.getService(serviceReference);
            InfoListProviderInfoCollectionProviderWrapper infoListProviderInfoCollectionProviderAdapter = new InfoListProviderInfoCollectionProviderWrapper(infoListProvider);
            ServiceRegistration serviceRegistration = this._bundleContext.registerService(InfoCollectionProvider.class, (Object)infoListProviderInfoCollectionProviderAdapter, this._getServiceReferenceProperties(serviceReference));
            this._serviceRegistrations.put(serviceReference, serviceRegistration);
            return infoListProviderInfoCollectionProviderAdapter;
        }

        public void modifiedService(ServiceReference<InfoListProvider<?>> serviceReference, InfoCollectionProvider<?> infoCollectionProvider) {
            this.removedService(serviceReference, infoCollectionProvider);
            this.addingService(serviceReference);
        }

        public void removedService(ServiceReference<InfoListProvider<?>> serviceReference, InfoCollectionProvider<?> infoCollectionProvider) {
            ServiceRegistration<InfoCollectionProvider<?>> serviceRegistration = this._serviceRegistrations.remove(serviceReference);
            serviceRegistration.unregister();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Dictionary<String, Object> _getServiceReferenceProperties(ServiceReference<InfoListProvider<?>> serviceReference) {
            HashMapDictionary dictionary = new HashMapDictionary();
            for (String key : serviceReference.getPropertyKeys()) {
                dictionary.put(key, serviceReference.getProperty(key));
            }
            InfoListProvider infoListProvider = (InfoListProvider)this._bundleContext.getService(serviceReference);
            try {
                dictionary.put("item.class.name", GenericUtil.getGenericClassName((Object)infoListProvider));
            }
            finally {
                this._bundleContext.ungetService(serviceReference);
            }
            return dictionary;
        }
    }
}

