/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.invitation.invite.members.internal.model.listener;

import com.liferay.invitation.invite.members.service.MemberRequestLocalService;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ModelListener.class})
public class UserModelListener
extends BaseModelListener<User> {
    @Reference
    private Http _http;
    private MemberRequestLocalService _memberRequestLocalService;
    private Portal _portal;

    public void onAfterCreate(User user) {
        try {
            String portletId;
            ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
            if (serviceContext == null) {
                return;
            }
            Map headers = serviceContext.getHeaders();
            if (headers == null) {
                return;
            }
            String refererURL = (String)headers.get("referer");
            String redirectURL = this._http.getParameter(refererURL, this._portal.getPortletNamespace(portletId = this._http.getParameter(refererURL, "p_p_id", false)) + "redirectURL", false);
            String key = this._http.getParameter(redirectURL, this._portal.getPortletNamespace(portletId) + "key", false);
            if (Validator.isNotNull((String)key)) {
                this._memberRequestLocalService.updateMemberRequest(key, user.getUserId());
            }
        }
        catch (Exception exception) {
            throw new ModelListenerException((Throwable)exception);
        }
    }

    @Reference(unbind="-")
    protected void setMemberRequestLocalService(MemberRequestLocalService memberRequestLocalService) {
        this._memberRequestLocalService = memberRequestLocalService;
    }

    @Reference(unbind="-")
    protected void setPortal(Portal portal) {
        this._portal = portal;
    }
}

