/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.invitation.invite.members.service.impl;

import com.liferay.invitation.invite.members.exception.MemberRequestAlreadyUsedException;
import com.liferay.invitation.invite.members.exception.MemberRequestInvalidUserException;
import com.liferay.invitation.invite.members.model.MemberRequest;
import com.liferay.invitation.invite.members.service.base.MemberRequestLocalServiceBaseImpl;
import com.liferay.mail.kernel.model.MailMessage;
import com.liferay.mail.kernel.service.MailService;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.NoSuchUserException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.notifications.NotificationEvent;
import com.liferay.portal.kernel.notifications.NotificationEventFactoryUtil;
import com.liferay.portal.kernel.notifications.UserNotificationManagerUtil;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserNotificationEventLocalService;
import com.liferay.portal.kernel.service.WorkflowDefinitionLinkLocalService;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import java.util.Date;
import java.util.List;
import javax.mail.internet.InternetAddress;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.invitation.invite.members.model.MemberRequest"}, service={AopService.class})
public class MemberRequestLocalServiceImpl
extends MemberRequestLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(MemberRequestLocalServiceImpl.class);
    @Reference
    private Http _http;
    @Reference
    private MailService _mailService;
    @Reference
    private UserNotificationEventLocalService _userNotificationEventLocalService;
    @Reference
    private WorkflowDefinitionLinkLocalService _workflowDefinitionLinkLocalService;

    public MemberRequest addMemberRequest(long userId, long groupId, long receiverUserId, String receiverEmailAddress, long invitedRoleId, long invitedTeamId, ServiceContext serviceContext) throws PortalException {
        User user;
        block5: {
            user = this.userLocalService.getUserById(userId);
            try {
                User receiverUser = this.userLocalService.getUserByEmailAddress(serviceContext.getCompanyId(), receiverEmailAddress);
                receiverUserId = receiverUser.getUserId();
            }
            catch (NoSuchUserException noSuchUserException) {
                if (!_log.isDebugEnabled()) break block5;
                _log.debug((Object)noSuchUserException, (Throwable)noSuchUserException);
            }
        }
        Date now = new Date();
        long memberRequestId = this.counterLocalService.increment();
        MemberRequest memberRequest = this.memberRequestPersistence.create(memberRequestId);
        memberRequest.setGroupId(groupId);
        memberRequest.setCompanyId(user.getCompanyId());
        memberRequest.setUserId(userId);
        memberRequest.setUserName(user.getFullName());
        memberRequest.setCreateDate(now);
        memberRequest.setModifiedDate(now);
        memberRequest.setKey(PortalUUIDUtil.generate());
        memberRequest.setReceiverUserId(receiverUserId);
        memberRequest.setInvitedRoleId(invitedRoleId);
        memberRequest.setInvitedTeamId(invitedTeamId);
        memberRequest.setStatus(0);
        memberRequest = (MemberRequest)this.memberRequestPersistence.update((BaseModel)memberRequest);
        try {
            this.sendEmail(receiverEmailAddress, memberRequest, serviceContext);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        if (receiverUserId > 0L) {
            this.sendNotificationEvent(memberRequest);
        }
        return memberRequest;
    }

    public void addMemberRequests(long userId, long groupId, long[] receiverUserIds, long invitedRoleId, long invitedTeamId, ServiceContext serviceContext) throws PortalException {
        for (long receiverUserId : receiverUserIds) {
            if (this.hasPendingMemberRequest(groupId, receiverUserId)) continue;
            User user = this.userLocalService.getUser(receiverUserId);
            this.addMemberRequest(userId, groupId, receiverUserId, user.getEmailAddress(), invitedRoleId, invitedTeamId, serviceContext);
        }
    }

    public void addMemberRequests(long userId, long groupId, String[] emailAddresses, long invitedRoleId, long invitedTeamId, ServiceContext serviceContext) throws PortalException {
        for (String emailAddress : emailAddresses) {
            if (!Validator.isEmailAddress((String)emailAddress)) continue;
            this.addMemberRequest(userId, groupId, 0L, emailAddress, invitedRoleId, invitedTeamId, serviceContext);
        }
    }

    public MemberRequest getMemberRequest(long groupId, long receiverUserId, int status) throws PortalException {
        return this.memberRequestPersistence.findByG_R_S(groupId, receiverUserId, status);
    }

    public List<MemberRequest> getReceiverMemberRequest(long receiverUserId, int start, int end) {
        return this.memberRequestPersistence.findByReceiverUserId(receiverUserId);
    }

    public int getReceiverMemberRequestCount(long receiverUserId) {
        return this.memberRequestPersistence.countByReceiverUserId(receiverUserId);
    }

    public List<MemberRequest> getReceiverStatusMemberRequest(long receiverUserId, int status, int start, int end) {
        return this.memberRequestPersistence.findByR_S(receiverUserId, status, start, end);
    }

    public int getReceiverStatusMemberRequestCount(long receiverUserId, int status) {
        return this.memberRequestPersistence.countByR_S(receiverUserId, status);
    }

    public boolean hasPendingMemberRequest(long groupId, long receiverUserId) {
        MemberRequest memberRequest = this.memberRequestPersistence.fetchByG_R_S(groupId, receiverUserId, 0);
        return memberRequest != null;
    }

    public MemberRequest updateMemberRequest(long userId, long memberRequestId, int status) throws Exception {
        MemberRequest memberRequest = this.memberRequestPersistence.findByPrimaryKey(memberRequestId);
        this.validate(memberRequest, userId);
        memberRequest.setModifiedDate(new Date());
        memberRequest.setStatus(status);
        memberRequest = (MemberRequest)this.memberRequestPersistence.update((BaseModel)memberRequest);
        if (status == 1) {
            this.userLocalService.addGroupUsers(memberRequest.getGroupId(), new long[]{memberRequest.getReceiverUserId()});
            if (memberRequest.getInvitedRoleId() > 0L) {
                this.userGroupRoleLocalService.addUserGroupRoles(new long[]{memberRequest.getReceiverUserId()}, memberRequest.getGroupId(), memberRequest.getInvitedRoleId());
            }
            if (memberRequest.getInvitedTeamId() > 0L) {
                this.userLocalService.addTeamUsers(memberRequest.getInvitedTeamId(), new long[]{memberRequest.getReceiverUserId()});
            }
        }
        return memberRequest;
    }

    public MemberRequest updateMemberRequest(String key, long receiverUserId) throws PortalException {
        MemberRequest memberRequest = this.memberRequestPersistence.findByKey(key);
        this.validate(memberRequest, 0L);
        memberRequest.setModifiedDate(new Date());
        memberRequest.setReceiverUserId(receiverUserId);
        memberRequest = (MemberRequest)this.memberRequestPersistence.update((BaseModel)memberRequest);
        if (receiverUserId > 0L) {
            this.sendNotificationEvent(memberRequest);
        }
        return memberRequest;
    }

    protected static String addParameterWithPortletNamespace(String url, String name, String value) {
        String portletId = HttpUtil.getParameter((String)url, (String)"p_p_id", (boolean)false);
        if (Validator.isNotNull((String)portletId)) {
            name = PortalUtil.getPortletNamespace((String)portletId) + name;
        }
        return HttpUtil.addParameter((String)url, (String)name, (String)value);
    }

    protected String getCreateAccountURL(MemberRequest memberRequest, ServiceContext serviceContext) throws PortalException {
        String createAccountURL = (String)((Object)serviceContext.getAttribute("createAccountURL"));
        if (Validator.isNull((String)createAccountURL)) {
            createAccountURL = serviceContext.getPortalURL();
        }
        if (!this._workflowDefinitionLinkLocalService.hasWorkflowDefinitionLink(memberRequest.getCompanyId(), 0L, User.class.getName(), 0L)) {
            String redirectURL = this.getRedirectURL(serviceContext);
            redirectURL = MemberRequestLocalServiceImpl.addParameterWithPortletNamespace(redirectURL, "actionRequired", "true");
            redirectURL = MemberRequestLocalServiceImpl.addParameterWithPortletNamespace(redirectURL, "key", memberRequest.getKey());
            createAccountURL = MemberRequestLocalServiceImpl.addParameterWithPortletNamespace(createAccountURL, "redirect", redirectURL);
        }
        return createAccountURL;
    }

    protected String getLoginURL(MemberRequest memberRequest, ServiceContext serviceContext) {
        String loginURL = (String)((Object)serviceContext.getAttribute("loginURL"));
        if (Validator.isNull((String)loginURL)) {
            loginURL = serviceContext.getPortalURL();
        }
        String redirectURL = this.getRedirectURL(serviceContext);
        redirectURL = MemberRequestLocalServiceImpl.addParameterWithPortletNamespace(redirectURL, "actionRequired", "true");
        redirectURL = MemberRequestLocalServiceImpl.addParameterWithPortletNamespace(redirectURL, "key", memberRequest.getKey());
        return this._http.addParameter(loginURL, "redirect", redirectURL);
    }

    protected String getRedirectURL(ServiceContext serviceContext) {
        String redirectURL = (String)((Object)serviceContext.getAttribute("redirectURL"));
        if (Validator.isNull((String)redirectURL)) {
            redirectURL = serviceContext.getCurrentURL();
        }
        return redirectURL;
    }

    protected void sendEmail(String emailAddress, MemberRequest memberRequest, ServiceContext serviceContext) throws Exception {
        long companyId = memberRequest.getCompanyId();
        Group group = this.groupLocalService.getGroup(memberRequest.getGroupId());
        User user = this.userLocalService.getUser(memberRequest.getUserId());
        User receiverUser = null;
        if (memberRequest.getReceiverUserId() > 0L) {
            receiverUser = this.userLocalService.getUser(memberRequest.getReceiverUserId());
        }
        String fromName = PrefsPropsUtil.getString((long)companyId, (String)"admin.email.from.name");
        String fromAddress = PrefsPropsUtil.getString((long)companyId, (String)"admin.email.from.address");
        String toName = "";
        String toAddress = emailAddress;
        if (receiverUser != null) {
            toName = receiverUser.getFullName();
        }
        String subject = StringUtil.read((ClassLoader)this.getClassLoader(), (String)"com/liferay/invitation/invite/members/dependencies/subject.tmpl");
        String body = "";
        body = memberRequest.getReceiverUserId() > 0L ? StringUtil.read((ClassLoader)this.getClassLoader(), (String)"com/liferay/invitation/invite/members/dependencies/existing_user_body.tmpl") : StringUtil.read((ClassLoader)this.getClassLoader(), (String)"com/liferay/invitation/invite/members/dependencies/new_user_body.tmpl");
        subject = StringUtil.replace((String)subject, (String[])new String[]{"[$MEMBER_REQUEST_GROUP$]", "[$MEMBER_REQUEST_USER$]"}, (String[])new String[]{group.getDescriptiveName(serviceContext.getLocale()), user.getFullName()});
        body = StringUtil.replace((String)body, (String[])new String[]{"[$ADMIN_ADDRESS$]", "[$ADMIN_NAME$]", "[$MEMBER_REQUEST_CREATE_ACCOUNT_URL$]", "[$MEMBER_REQUEST_GROUP$]", "[$MEMBER_REQUEST_LOGIN_URL$]", "[$MEMBER_REQUEST_USER$]"}, (String[])new String[]{fromAddress, fromName, this.getCreateAccountURL(memberRequest, serviceContext), group.getDescriptiveName(serviceContext.getLocale()), this.getLoginURL(memberRequest, serviceContext), user.getFullName()});
        InternetAddress from = new InternetAddress(fromAddress, fromName);
        InternetAddress to = new InternetAddress(toAddress, toName);
        MailMessage mailMessage = new MailMessage(from, to, subject, body, true);
        this._mailService.sendEmail(mailMessage);
    }

    protected void sendNotificationEvent(MemberRequest memberRequest) throws PortalException {
        String portletId = PortletProviderUtil.getPortletId((String)MemberRequest.class.getName(), (PortletProvider.Action)PortletProvider.Action.EDIT);
        if (UserNotificationManagerUtil.isDeliver((long)memberRequest.getReceiverUserId(), (String)portletId, (long)0L, (int)0, (int)10002)) {
            NotificationEvent notificationEvent = NotificationEventFactoryUtil.createNotificationEvent((long)System.currentTimeMillis(), (String)portletId, (JSONObject)JSONUtil.put((String)"classPK", (Object)memberRequest.getMemberRequestId()).put("userId", memberRequest.getUserId()));
            notificationEvent.setDeliveryRequired(0L);
            notificationEvent.setDeliveryType(10002);
            this._userNotificationEventLocalService.addUserNotificationEvent(memberRequest.getReceiverUserId(), true, notificationEvent);
        }
    }

    protected void validate(MemberRequest memberRequest, long userId) throws PortalException {
        if (memberRequest.getStatus() != 0) {
            throw new MemberRequestAlreadyUsedException();
        }
        if (memberRequest.getReceiverUserId() != userId) {
            throw new MemberRequestInvalidUserException();
        }
    }
}

