/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.invitation.invite.members.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.invitation.invite.members.model.MemberRequest;
import com.liferay.invitation.invite.members.model.MemberRequestModel;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the MemberRequest service. Represents a row in the &quot;IM_MemberRequest&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>MemberRequestModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link MemberRequestImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see MemberRequestImpl
 * @generated
 */
public class MemberRequestModelImpl
	extends BaseModelImpl<MemberRequest> implements MemberRequestModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a member request model instance should use the <code>MemberRequest</code> interface instead.
	 */
	public static final String TABLE_NAME = "IM_MemberRequest";

	public static final Object[][] TABLE_COLUMNS = {
		{"memberRequestId", Types.BIGINT}, {"groupId", Types.BIGINT},
		{"companyId", Types.BIGINT}, {"userId", Types.BIGINT},
		{"userName", Types.VARCHAR}, {"createDate", Types.TIMESTAMP},
		{"modifiedDate", Types.TIMESTAMP}, {"key_", Types.VARCHAR},
		{"receiverUserId", Types.BIGINT}, {"invitedRoleId", Types.BIGINT},
		{"invitedTeamId", Types.BIGINT}, {"status", Types.INTEGER}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("memberRequestId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("key_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("receiverUserId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("invitedRoleId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("invitedTeamId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("status", Types.INTEGER);
	}

	public static final String TABLE_SQL_CREATE =
		"create table IM_MemberRequest (memberRequestId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,key_ VARCHAR(75) null,receiverUserId LONG,invitedRoleId LONG,invitedTeamId LONG,status INTEGER)";

	public static final String TABLE_SQL_DROP = "drop table IM_MemberRequest";

	public static final String ORDER_BY_JPQL =
		" ORDER BY memberRequest.createDate DESC";

	public static final String ORDER_BY_SQL =
		" ORDER BY IM_MemberRequest.createDate DESC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long GROUPID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long KEY_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long RECEIVERUSERID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long STATUS_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CREATEDATE_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public MemberRequestModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _memberRequestId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setMemberRequestId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _memberRequestId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return MemberRequest.class;
	}

	@Override
	public String getModelClassName() {
		return MemberRequest.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<MemberRequest, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		for (Map.Entry<String, Function<MemberRequest, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<MemberRequest, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((MemberRequest)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<MemberRequest, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<MemberRequest, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(MemberRequest)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<MemberRequest, Object>>
		getAttributeGetterFunctions() {

		return AttributeGetterFunctionsHolder._attributeGetterFunctions;
	}

	public Map<String, BiConsumer<MemberRequest, Object>>
		getAttributeSetterBiConsumers() {

		return AttributeSetterBiConsumersHolder._attributeSetterBiConsumers;
	}

	private static class AttributeGetterFunctionsHolder {

		private static final Map<String, Function<MemberRequest, Object>>
			_attributeGetterFunctions;

		static {
			Map<String, Function<MemberRequest, Object>>
				attributeGetterFunctions =
					new LinkedHashMap
						<String, Function<MemberRequest, Object>>();

			attributeGetterFunctions.put(
				"memberRequestId", MemberRequest::getMemberRequestId);
			attributeGetterFunctions.put("groupId", MemberRequest::getGroupId);
			attributeGetterFunctions.put(
				"companyId", MemberRequest::getCompanyId);
			attributeGetterFunctions.put("userId", MemberRequest::getUserId);
			attributeGetterFunctions.put(
				"userName", MemberRequest::getUserName);
			attributeGetterFunctions.put(
				"createDate", MemberRequest::getCreateDate);
			attributeGetterFunctions.put(
				"modifiedDate", MemberRequest::getModifiedDate);
			attributeGetterFunctions.put("key", MemberRequest::getKey);
			attributeGetterFunctions.put(
				"receiverUserId", MemberRequest::getReceiverUserId);
			attributeGetterFunctions.put(
				"invitedRoleId", MemberRequest::getInvitedRoleId);
			attributeGetterFunctions.put(
				"invitedTeamId", MemberRequest::getInvitedTeamId);
			attributeGetterFunctions.put("status", MemberRequest::getStatus);

			_attributeGetterFunctions = Collections.unmodifiableMap(
				attributeGetterFunctions);
		}

	}

	private static class AttributeSetterBiConsumersHolder {

		private static final Map<String, BiConsumer<MemberRequest, Object>>
			_attributeSetterBiConsumers;

		static {
			Map<String, BiConsumer<MemberRequest, ?>>
				attributeSetterBiConsumers =
					new LinkedHashMap<String, BiConsumer<MemberRequest, ?>>();

			attributeSetterBiConsumers.put(
				"memberRequestId",
				(BiConsumer<MemberRequest, Long>)
					MemberRequest::setMemberRequestId);
			attributeSetterBiConsumers.put(
				"groupId",
				(BiConsumer<MemberRequest, Long>)MemberRequest::setGroupId);
			attributeSetterBiConsumers.put(
				"companyId",
				(BiConsumer<MemberRequest, Long>)MemberRequest::setCompanyId);
			attributeSetterBiConsumers.put(
				"userId",
				(BiConsumer<MemberRequest, Long>)MemberRequest::setUserId);
			attributeSetterBiConsumers.put(
				"userName",
				(BiConsumer<MemberRequest, String>)MemberRequest::setUserName);
			attributeSetterBiConsumers.put(
				"createDate",
				(BiConsumer<MemberRequest, Date>)MemberRequest::setCreateDate);
			attributeSetterBiConsumers.put(
				"modifiedDate",
				(BiConsumer<MemberRequest, Date>)
					MemberRequest::setModifiedDate);
			attributeSetterBiConsumers.put(
				"key",
				(BiConsumer<MemberRequest, String>)MemberRequest::setKey);
			attributeSetterBiConsumers.put(
				"receiverUserId",
				(BiConsumer<MemberRequest, Long>)
					MemberRequest::setReceiverUserId);
			attributeSetterBiConsumers.put(
				"invitedRoleId",
				(BiConsumer<MemberRequest, Long>)
					MemberRequest::setInvitedRoleId);
			attributeSetterBiConsumers.put(
				"invitedTeamId",
				(BiConsumer<MemberRequest, Long>)
					MemberRequest::setInvitedTeamId);
			attributeSetterBiConsumers.put(
				"status",
				(BiConsumer<MemberRequest, Integer>)MemberRequest::setStatus);

			_attributeSetterBiConsumers = Collections.unmodifiableMap(
				(Map)attributeSetterBiConsumers);
		}

	}

	@Override
	public long getMemberRequestId() {
		return _memberRequestId;
	}

	@Override
	public void setMemberRequestId(long memberRequestId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_memberRequestId = memberRequestId;
	}

	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_groupId = groupId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalGroupId() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("groupId"));
	}

	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@Override
	public String getKey() {
		if (_key == null) {
			return "";
		}
		else {
			return _key;
		}
	}

	@Override
	public void setKey(String key) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_key = key;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalKey() {
		return getColumnOriginalValue("key_");
	}

	@Override
	public long getReceiverUserId() {
		return _receiverUserId;
	}

	@Override
	public void setReceiverUserId(long receiverUserId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_receiverUserId = receiverUserId;
	}

	@Override
	public String getReceiverUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getReceiverUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setReceiverUserUuid(String receiverUserUuid) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalReceiverUserId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("receiverUserId"));
	}

	@Override
	public long getInvitedRoleId() {
		return _invitedRoleId;
	}

	@Override
	public void setInvitedRoleId(long invitedRoleId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_invitedRoleId = invitedRoleId;
	}

	@Override
	public long getInvitedTeamId() {
		return _invitedTeamId;
	}

	@Override
	public void setInvitedTeamId(long invitedTeamId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_invitedTeamId = invitedTeamId;
	}

	@Override
	public int getStatus() {
		return _status;
	}

	@Override
	public void setStatus(int status) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_status = status;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public int getOriginalStatus() {
		return GetterUtil.getInteger(
			this.<Integer>getColumnOriginalValue("status"));
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), MemberRequest.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public MemberRequest toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, MemberRequest>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		MemberRequestImpl memberRequestImpl = new MemberRequestImpl();

		memberRequestImpl.setMemberRequestId(getMemberRequestId());
		memberRequestImpl.setGroupId(getGroupId());
		memberRequestImpl.setCompanyId(getCompanyId());
		memberRequestImpl.setUserId(getUserId());
		memberRequestImpl.setUserName(getUserName());
		memberRequestImpl.setCreateDate(getCreateDate());
		memberRequestImpl.setModifiedDate(getModifiedDate());
		memberRequestImpl.setKey(getKey());
		memberRequestImpl.setReceiverUserId(getReceiverUserId());
		memberRequestImpl.setInvitedRoleId(getInvitedRoleId());
		memberRequestImpl.setInvitedTeamId(getInvitedTeamId());
		memberRequestImpl.setStatus(getStatus());

		memberRequestImpl.resetOriginalValues();

		return memberRequestImpl;
	}

	@Override
	public MemberRequest cloneWithOriginalValues() {
		MemberRequestImpl memberRequestImpl = new MemberRequestImpl();

		memberRequestImpl.setMemberRequestId(
			this.<Long>getColumnOriginalValue("memberRequestId"));
		memberRequestImpl.setGroupId(
			this.<Long>getColumnOriginalValue("groupId"));
		memberRequestImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		memberRequestImpl.setUserId(
			this.<Long>getColumnOriginalValue("userId"));
		memberRequestImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		memberRequestImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		memberRequestImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		memberRequestImpl.setKey(this.<String>getColumnOriginalValue("key_"));
		memberRequestImpl.setReceiverUserId(
			this.<Long>getColumnOriginalValue("receiverUserId"));
		memberRequestImpl.setInvitedRoleId(
			this.<Long>getColumnOriginalValue("invitedRoleId"));
		memberRequestImpl.setInvitedTeamId(
			this.<Long>getColumnOriginalValue("invitedTeamId"));
		memberRequestImpl.setStatus(
			this.<Integer>getColumnOriginalValue("status"));

		return memberRequestImpl;
	}

	@Override
	public int compareTo(MemberRequest memberRequest) {
		int value = 0;

		value = DateUtil.compareTo(
			getCreateDate(), memberRequest.getCreateDate());

		value = value * -1;

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof MemberRequest)) {
			return false;
		}

		MemberRequest memberRequest = (MemberRequest)object;

		long primaryKey = memberRequest.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<MemberRequest> toCacheModel() {
		MemberRequestCacheModel memberRequestCacheModel =
			new MemberRequestCacheModel();

		memberRequestCacheModel.memberRequestId = getMemberRequestId();

		memberRequestCacheModel.groupId = getGroupId();

		memberRequestCacheModel.companyId = getCompanyId();

		memberRequestCacheModel.userId = getUserId();

		memberRequestCacheModel.userName = getUserName();

		String userName = memberRequestCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			memberRequestCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			memberRequestCacheModel.createDate = createDate.getTime();
		}
		else {
			memberRequestCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			memberRequestCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			memberRequestCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		memberRequestCacheModel.key = getKey();

		String key = memberRequestCacheModel.key;

		if ((key != null) && (key.length() == 0)) {
			memberRequestCacheModel.key = null;
		}

		memberRequestCacheModel.receiverUserId = getReceiverUserId();

		memberRequestCacheModel.invitedRoleId = getInvitedRoleId();

		memberRequestCacheModel.invitedTeamId = getInvitedTeamId();

		memberRequestCacheModel.status = getStatus();

		return memberRequestCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<MemberRequest, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<MemberRequest, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<MemberRequest, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply((MemberRequest)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, MemberRequest>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					MemberRequest.class, ModelWrapper.class);

	}

	private long _memberRequestId;
	private long _groupId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private String _key;
	private long _receiverUserId;
	private long _invitedRoleId;
	private long _invitedTeamId;
	private int _status;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<MemberRequest, Object> function =
			AttributeGetterFunctionsHolder._attributeGetterFunctions.get(
				columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((MemberRequest)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("memberRequestId", _memberRequestId);
		_columnOriginalValues.put("groupId", _groupId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("key_", _key);
		_columnOriginalValues.put("receiverUserId", _receiverUserId);
		_columnOriginalValues.put("invitedRoleId", _invitedRoleId);
		_columnOriginalValues.put("invitedTeamId", _invitedTeamId);
		_columnOriginalValues.put("status", _status);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("key_", "key");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("memberRequestId", 1L);

		columnBitmasks.put("groupId", 2L);

		columnBitmasks.put("companyId", 4L);

		columnBitmasks.put("userId", 8L);

		columnBitmasks.put("userName", 16L);

		columnBitmasks.put("createDate", 32L);

		columnBitmasks.put("modifiedDate", 64L);

		columnBitmasks.put("key_", 128L);

		columnBitmasks.put("receiverUserId", 256L);

		columnBitmasks.put("invitedRoleId", 512L);

		columnBitmasks.put("invitedTeamId", 1024L);

		columnBitmasks.put("status", 2048L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private MemberRequest _escapedModel;

}