/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.invitation.invite.members.internal.upgrade.v1_0_0;

import com.liferay.invitation.invite.members.internal.upgrade.v1_0_0.util.MemberRequestTable;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.util.UpgradeColumn;
import com.liferay.portal.kernel.upgrade.util.UpgradeTable;
import com.liferay.portal.kernel.upgrade.util.UpgradeTableFactoryUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringUtil;

public class NamespaceUpgradeProcess
extends UpgradeProcess {
    private static final String _NEW_NAMESPACE = "IM_";
    private static final String _OLD_NAMESPACE = "SO_";
    private static final Log _log = LogFactoryUtil.getLog(NamespaceUpgradeProcess.class);

    protected void doUpgrade() throws Exception {
        this._renameTable(this._getOldTableName(), "IM_MemberRequest", MemberRequestTable.TABLE_COLUMNS, "create table IM_MemberRequest (memberRequestId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,key_ VARCHAR(75) null,receiverUserId LONG,invitedRoleId LONG,invitedTeamId LONG,status INTEGER)", "drop table IM_MemberRequest");
    }

    private String _getOldTableName() {
        if ("IM_MemberRequest".startsWith(_NEW_NAMESPACE)) {
            return StringUtil.replaceFirst((String)"IM_MemberRequest", (String)_NEW_NAMESPACE, (String)_OLD_NAMESPACE);
        }
        return "SO_IM_MemberRequest";
    }

    private void _renameTable(String oldTableName, String newTableName, Object[][] tableColumns, String tableSqlCreate, String tableSqlDrop) throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer(newTableName);){
            boolean hasNewTable = this.hasTable(newTableName);
            if (hasNewTable && this.hasRows(newTableName)) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)StringBundler.concat((String[])new String[]{"Not renaming ", oldTableName, " to ", newTableName, " because ", newTableName, " has data"}));
                }
                return;
            }
            boolean hasOldTable = this.hasTable(oldTableName);
            if (!hasNewTable && !hasOldTable) {
                this.runSQL(tableSqlCreate);
                return;
            }
            if (hasNewTable) {
                this.runSQL(tableSqlDrop);
            }
            UpgradeTable upgradeTable = UpgradeTableFactoryUtil.getUpgradeTable((String)oldTableName, (Object[][])tableColumns, (UpgradeColumn[])new UpgradeColumn[0]);
            upgradeTable.setCreateSQL(tableSqlCreate);
            upgradeTable.updateTable();
        }
    }
}

