/**
 * SPDX-FileCopyrightText: © 2020 Liferay, Inc. <https://liferay.com>
 * SPDX-License-Identifier: BSD-3-Clause
 */

import ClayLabel from '@clayui/label';
import classNames from 'classnames';
import React from 'react';

export interface IProps extends React.ComponentProps<typeof ClayLabel> {}

const Label: React.FunctionComponent<IProps> = ({
	children,
	className,
	...otherProps
}: IProps) => (
	<ClayLabel
		className={classNames(className, 'component-label tbar-label')}
		{...otherProps}
	>
		{children}
	</ClayLabel>
);

Label.displayName = 'ClayToolbarLabel';

export default Label;
