/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.Dom4JUtil;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.ParentBuild;
import com.liferay.jenkins.results.parser.PullRequest;
import com.liferay.jenkins.results.parser.SourceFormatBuild;
import com.liferay.jenkins.results.parser.TestResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class AutoCloseUtil {
    public static boolean debug = false;
    private static final List<String> _autoCloseGitHubCommentMentionUsernames = AutoCloseUtil._getBuildPropertyAsList("auto.close.github.comment.mention.usernames");
    private static final List<String> _autoCloseReceiverUsernames = AutoCloseUtil._getBuildPropertyAsList("auto.close.receiver.usernames");

    public static void autoClose(PullRequest pullRequest, Build build) throws Exception {
        if (pullRequest.isAutoCloseCommentAvailable()) {
            return;
        }
        String gitHubReceiverUsername = pullRequest.getOwnerUsername();
        String gitHubSenderUsername = pullRequest.getSenderUsername();
        if (gitHubReceiverUsername == null || gitHubSenderUsername == null || !_autoCloseReceiverUsernames.contains(gitHubReceiverUsername) || gitHubReceiverUsername.equals(gitHubSenderUsername)) {
            return;
        }
        pullRequest.close();
        StringBuilder sb = new StringBuilder();
        sb.append("<h1>The pull request tester is still running.</h1>");
        sb.append("<p>Please wait until you get the ");
        sb.append("<i><b>final report</b></i> before running 'ci:retest'.");
        sb.append("</p><p>See this link to check on the status of your ");
        sb.append("test:</p>");
        sb.append("<ul><li><a href=\"");
        sb.append(build.getBuildURL());
        sb.append("\">");
        sb.append(build.getJobName());
        sb.append("</a></li></ul><p>@");
        sb.append(pullRequest.getSenderUsername());
        sb.append("</p><hr />");
        sb.append("<h1>However, the pull request was closed.</h1>");
        sb.append("<p>The pull request was closed because the following ");
        sb.append("critical builds had failed:</p><ul>");
        sb.append("<li><a href=\"");
        sb.append(build.getBuildURL());
        sb.append("\">");
        String jobVariant = build.getJobVariant();
        if (jobVariant != null && !jobVariant.isEmpty()) {
            sb.append(jobVariant);
        } else {
            sb.append(build.getJobName());
        }
        sb.append("</a></li></ul><p>For information as to why we ");
        sb.append("automatically close out certain pull requests see this ");
        sb.append("<a href=\"https://in.liferay.com/web/global.");
        sb.append("engineering/wiki/-/wiki/Quality+Assurance+Main/Test");
        sb.append("+Batch+Automatic+Close+List\">article</a>.</p><p");
        boolean sourceFormatBuild = build instanceof SourceFormatBuild;
        if (sourceFormatBuild) {
            sb.append("><strong><em>*");
        } else {
            sb.append(" auto-close=\"false\"><strong><em>*This pull will ");
            sb.append("no longer automatically close if this comment is ");
            sb.append("available. ");
        }
        sb.append("If you believe this is a mistake please reopen this ");
        sb.append("pull by entering the following command as a comment.");
        sb.append("</em></strong><pre>ci&#58;reopen</pre></p>");
        if (sourceFormatBuild) {
            sb.append("<strong><em>*The reopened pull request may ");
            sb.append("be automatically closed again if other critical ");
            sb.append("batches or tests fail.</em></strong>");
        }
        sb.append("<hr /><h3>Critical Failure Details:</h3>");
        try {
            sb.append(Dom4JUtil.format(build.getGitHubMessageElement(), false));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        if (!_autoCloseGitHubCommentMentionUsernames.isEmpty()) {
            sb.append("<div>cc");
            for (String autoCloseGitHubCommentMentionUsername : _autoCloseGitHubCommentMentionUsernames) {
                sb.append(" @");
                sb.append(autoCloseGitHubCommentMentionUsername);
            }
            sb.append("</div>");
        }
        pullRequest.addComment(sb.toString());
    }

    public static boolean autoCloseOnCriticalBatchFailures(PullRequest pullRequest, Build topLevelBuild) throws Exception {
        if (pullRequest.isAutoCloseCommentAvailable()) {
            return false;
        }
        String gitHubReceiverUsername = pullRequest.getOwnerUsername();
        String gitHubSenderUsername = pullRequest.getSenderUsername();
        if (gitHubReceiverUsername == null || gitHubSenderUsername == null || !_autoCloseReceiverUsernames.contains(gitHubReceiverUsername) || gitHubReceiverUsername.equals(gitHubSenderUsername)) {
            return false;
        }
        List<AutoCloseRule> autoCloseRules = AutoCloseUtil.getAutoCloseRules(pullRequest);
        for (AutoCloseRule autoCloseRule : autoCloseRules) {
            List<Build> failedDownstreamBuilds;
            ArrayList<Build> downstreamBuilds = new ArrayList<Build>();
            if (topLevelBuild instanceof ParentBuild) {
                ParentBuild parentBuild = (ParentBuild)topLevelBuild;
                downstreamBuilds.addAll(parentBuild.getDownstreamBuilds(null));
            }
            if (downstreamBuilds.isEmpty()) {
                downstreamBuilds = new ArrayList();
                downstreamBuilds.add(topLevelBuild);
            }
            if ((failedDownstreamBuilds = autoCloseRule.evaluate(downstreamBuilds)).isEmpty()) continue;
            pullRequest.close();
            StringBuilder sb = new StringBuilder();
            sb.append("<h1>The pull request tester is still running.</h1>");
            sb.append("<p>Please wait until you get the ");
            sb.append("<i><b>final report</b></i> before running 'ci:retest'.");
            sb.append("</p><p>See this link to check on the status of your ");
            sb.append("test:</p>");
            sb.append("<ul><li><a href=\"");
            sb.append(topLevelBuild.getBuildURL());
            sb.append("\">");
            sb.append(topLevelBuild.getJobName());
            sb.append("</a></li></ul><p>@");
            sb.append(gitHubSenderUsername);
            sb.append("</p><hr />");
            sb.append("<h1>However, the pull request was closed.</h1>");
            sb.append("<p>The pull request was closed because the following ");
            sb.append("critical batches had failed:</p><ul>");
            String failureBuildURL = "";
            for (Build failedDownstreamBuild : failedDownstreamBuilds) {
                failureBuildURL = failedDownstreamBuild.getBuildURL();
                sb.append("<li><a href=\"");
                sb.append(failureBuildURL);
                sb.append("\">");
                String jobVariant = failedDownstreamBuild.getJobVariant();
                if (jobVariant != null && !jobVariant.isEmpty()) {
                    sb.append(jobVariant);
                } else {
                    sb.append(failedDownstreamBuild.getJobName());
                }
                sb.append("</a></li>");
            }
            sb.append("</ul><p>For information as to why we automatically ");
            sb.append("close out certain pull requests see this ");
            sb.append("<a href=\"https://in.liferay.com/web/global.");
            sb.append("engineering/wiki/-/wiki/Quality+Assurance+Main/Test");
            sb.append("+Batch+Automatic+Close+List\">article</a>.</p><p");
            boolean sourceFormatBuild = topLevelBuild instanceof SourceFormatBuild;
            if (sourceFormatBuild) {
                sb.append("><strong><em>*");
            } else {
                sb.append(" auto-close=\"false\"><strong><em>*This pull will ");
                sb.append("no longer automatically close if this comment is ");
                sb.append("available. ");
            }
            sb.append("If you believe this is a mistake please reopen this ");
            sb.append("pull by entering the following command as a comment.");
            sb.append("</em></strong><pre>ci&#58;reopen</pre></p>");
            if (sourceFormatBuild) {
                sb.append("<strong><em>*The reopened pull request may ");
                sb.append("be automatically closed again if other critical ");
                sb.append("batches or tests fail.</em></strong>");
            }
            sb.append("<hr /><h3>Critical Failure Details:</h3>");
            for (Build failedDownstreamBuild : failedDownstreamBuilds) {
                try {
                    sb.append(Dom4JUtil.format(failedDownstreamBuild.getGitHubMessageElement(), false));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw exception;
                }
            }
            if (!_autoCloseGitHubCommentMentionUsernames.isEmpty()) {
                sb.append("<div>cc");
                for (String autoCloseGitHubCommentMentionUsername : _autoCloseGitHubCommentMentionUsernames) {
                    sb.append(" @");
                    sb.append(autoCloseGitHubCommentMentionUsername);
                }
                sb.append("</div>");
            }
            pullRequest.addComment(sb.toString());
            return true;
        }
        return false;
    }

    public static boolean autoCloseOnCriticalTestFailures(PullRequest pullRequest, Build topLevelBuild) throws Exception {
        if (pullRequest.isAutoCloseCommentAvailable() || !AutoCloseUtil.isAutoCloseOnCriticalTestFailuresActive(pullRequest)) {
            return false;
        }
        String gitHubReceiverUsername = pullRequest.getOwnerUsername();
        String gitHubSenderUsername = pullRequest.getSenderUsername();
        if (gitHubReceiverUsername == null || gitHubSenderUsername == null || !_autoCloseReceiverUsernames.contains(gitHubReceiverUsername) || gitHubReceiverUsername.equals(gitHubSenderUsername)) {
            return false;
        }
        Build failedDownstreamBuild = null;
        ArrayList<String> jenkinsJobFailureURLs = new ArrayList<String>();
        ArrayList<Build> downstreamBuilds = new ArrayList<Build>();
        if (topLevelBuild instanceof ParentBuild) {
            ParentBuild parentBuild = (ParentBuild)topLevelBuild;
            downstreamBuilds.addAll(parentBuild.getDownstreamBuilds(null));
        }
        Properties localLiferayJenkinsEEBuildProperties = JenkinsResultsParserUtil.getLocalLiferayJenkinsEEBuildProperties();
        block2: for (Build build : downstreamBuilds) {
            String gitSubrepositoryPackageNames;
            String result;
            String status;
            String batchName = build.getJobVariant();
            if (batchName == null || !batchName.contains("integration") && !batchName.contains("unit") || !(status = build.getStatus()).equals("completed") || (result = build.getResult()) == null || !result.equals("UNSTABLE") || (gitSubrepositoryPackageNames = JenkinsResultsParserUtil.getProperty(localLiferayJenkinsEEBuildProperties, "subrepository.package.names")) == null) continue;
            for (String gitSubrepositoryPackageName : gitSubrepositoryPackageNames.split(",")) {
                if (!jenkinsJobFailureURLs.isEmpty()) continue block2;
                ArrayList<TestResult> testResults = new ArrayList<TestResult>();
                testResults.addAll(build.getTestResults("FAILED"));
                testResults.addAll(build.getTestResults("REGRESSION"));
                for (TestResult testResult : testResults) {
                    if (!testResult.isUniqueFailure() || !gitSubrepositoryPackageName.equals(testResult.getPackageName())) continue;
                    failedDownstreamBuild = build;
                    StringBuilder sb = new StringBuilder();
                    sb.append("<a href=\"");
                    sb.append(testResult.getTestReportURL());
                    sb.append("\">");
                    sb.append(testResult.getClassName());
                    sb.append("</a>");
                    jenkinsJobFailureURLs.add(sb.toString());
                }
            }
        }
        if (!jenkinsJobFailureURLs.isEmpty()) {
            pullRequest.close();
            StringBuilder sb = new StringBuilder();
            sb.append("<h1>The pull request tester is still running.</h1>");
            sb.append("<p>Please wait until you get the <i><b>final report");
            sb.append("</b></i> before running 'ci:retest'.</p><p>See this ");
            sb.append("link to check on the status of your test:</p>");
            sb.append("<ul><li><a href=\"");
            sb.append(topLevelBuild.getBuildURL());
            sb.append("\">");
            sb.append(topLevelBuild.getJobName());
            sb.append("</a></li></ul>@");
            sb.append(gitHubSenderUsername);
            sb.append("</p><hr />");
            sb.append("<h1>However, the pull request was closed.</h1>");
            sb.append("<p>The pull request was closed due to the following ");
            sb.append("integration/unit test failures:</p><ul>");
            for (String jenkinsJobFailureURL : jenkinsJobFailureURLs) {
                sb.append("<li>");
                sb.append(jenkinsJobFailureURL);
                sb.append("</li>");
            }
            sb.append("</ul><p>These test failures are a part of a ");
            sb.append("'module group'/'subrepository' that was changed in ");
            sb.append("this pull request.</p>");
            sb.append("<p auto-close=\"false\"><strong><em>*This pull will ");
            sb.append("no longer automatically close if this comment is ");
            sb.append("available. If you believe this is a mistake please ");
            sb.append("reopen this pull by entering the following command ");
            sb.append("as a comment.</em></strong></p><pre>ci&#58;reopen");
            sb.append("</pre><hr /><h3>Critical Failure Details:</h3>");
            try {
                sb.append(Dom4JUtil.format(failedDownstreamBuild.getGitHubMessageElement(), false));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw exception;
            }
            if (!_autoCloseGitHubCommentMentionUsernames.isEmpty()) {
                sb.append("<div>cc");
                for (String autoCloseGithubCommentMentionUsername : _autoCloseGitHubCommentMentionUsernames) {
                    sb.append(" @");
                    sb.append(autoCloseGithubCommentMentionUsername);
                }
                sb.append("</div>");
            }
            pullRequest.addComment(sb.toString());
            return true;
        }
        return false;
    }

    public static List<AutoCloseRule> getAutoCloseRules(PullRequest pullRequest) throws Exception {
        ArrayList<AutoCloseRule> list = new ArrayList<AutoCloseRule>();
        String propertyNameTemplate = JenkinsResultsParserUtil.combine("test.batch.names.auto.close[", pullRequest.getGitHubRemoteGitRepositoryName(), "?]");
        String gitRepositoryBranchAutoClosePropertyName = propertyNameTemplate.replace("?", "-" + pullRequest.getUpstreamRemoteGitBranchName());
        Properties localLiferayJenkinsEEBuildProperties = JenkinsResultsParserUtil.getLocalLiferayJenkinsEEBuildProperties();
        String testBatchNamesAutoClose = JenkinsResultsParserUtil.getProperty(localLiferayJenkinsEEBuildProperties, gitRepositoryBranchAutoClosePropertyName);
        if (testBatchNamesAutoClose == null) {
            String gitRepositoryAutoClosePropertyName = propertyNameTemplate.replace("?", "");
            testBatchNamesAutoClose = JenkinsResultsParserUtil.getProperty(localLiferayJenkinsEEBuildProperties, gitRepositoryAutoClosePropertyName);
        }
        if (testBatchNamesAutoClose != null) {
            String[] autoCloseRuleDataArray;
            if (debug) {
                System.out.println(JenkinsResultsParserUtil.combine("Finding auto-close rules for ", gitRepositoryBranchAutoClosePropertyName, "."));
            }
            for (String autoCloseRuleData : autoCloseRuleDataArray = StringUtils.split((String)testBatchNamesAutoClose, (String)",")) {
                if (autoCloseRuleData.startsWith("#") || autoCloseRuleData.startsWith("static_")) continue;
                AutoCloseRule newAutoCloseRule = new AutoCloseRule(autoCloseRuleData);
                if (debug) {
                    System.out.println("\t" + newAutoCloseRule.toString());
                }
                list.add(newAutoCloseRule);
            }
            if (debug) {
                System.out.println(JenkinsResultsParserUtil.combine("Finished finding ", gitRepositoryBranchAutoClosePropertyName, " auto-close rules.\n"));
            }
        }
        return list;
    }

    public static boolean isAutoCloseBranch(PullRequest pullRequest) {
        String gitHubRemoteGitRepositoryName = pullRequest.getGitHubRemoteGitRepositoryName();
        String testBranchNamesAutoClose = JenkinsResultsParserUtil.getProperty(JenkinsResultsParserUtil.getLocalLiferayJenkinsEEBuildProperties(), JenkinsResultsParserUtil.combine("test.branch.names.auto.close[", gitHubRemoteGitRepositoryName, "]"));
        String branchName = pullRequest.getUpstreamRemoteGitBranchName();
        if (testBranchNamesAutoClose == null) {
            if (debug) {
                System.out.println(JenkinsResultsParserUtil.combine("Auto-close rules are deactivated for ", gitHubRemoteGitRepositoryName, "(", branchName, ")."));
            }
            return false;
        }
        List<String> testBranchNamesAutoCloseList = Arrays.asList(testBranchNamesAutoClose.split(","));
        return testBranchNamesAutoCloseList.contains(branchName);
    }

    public static boolean isAutoCloseOnCriticalTestFailuresActive(PullRequest pullRequest) {
        String[] criticalTestBranches;
        String criticalTestBranchesString = JenkinsResultsParserUtil.getProperty(JenkinsResultsParserUtil.getLocalLiferayJenkinsEEBuildProperties(), JenkinsResultsParserUtil.combine("test.branch.names.critical.test[", pullRequest.getGitHubRemoteGitRepositoryName(), "]"));
        if (criticalTestBranchesString == null || criticalTestBranchesString.isEmpty()) {
            return false;
        }
        for (String criticalTestBranch : criticalTestBranches = StringUtils.split((String)criticalTestBranchesString, (String)",")) {
            if (!criticalTestBranch.equals(pullRequest.getUpstreamRemoteGitBranchName())) continue;
            return true;
        }
        return false;
    }

    private static List<String> _getBuildPropertyAsList(String propertyName) {
        try {
            return JenkinsResultsParserUtil.getBuildPropertyAsList(true, propertyName);
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to get property " + propertyName, ioException);
        }
    }

    private static class AutoCloseRule {
        protected int maxFailCount = -1;
        protected float maxFailPercentage = -1.0f;
        protected String ruleData;
        protected Pattern rulePattern;

        public AutoCloseRule(String ruleData) {
            this.ruleData = ruleData;
            String[] ruleDataArray = ruleData.split("\\|");
            this.rulePattern = Pattern.compile(ruleDataArray[0]);
            if (ruleDataArray[1].endsWith("%")) {
                String percentageRule = ruleDataArray[1];
                int i = Integer.parseInt(percentageRule.substring(0, percentageRule.length() - 1));
                this.maxFailPercentage = i / 100;
            } else {
                this.maxFailCount = Integer.parseInt(ruleDataArray[1]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<Build> evaluate(List<Build> downstreamBuilds) {
            List<Build> list;
            block23: {
                ArrayList<Build> failedDownstreamBuilds;
                block21: {
                    block22: {
                        block19: {
                            List list2;
                            block20: {
                                if (debug) {
                                    System.out.println(JenkinsResultsParserUtil.combine("Evaluating auto-close rule ", this.toString(), "."));
                                }
                                downstreamBuilds = this.getMatchingBuilds(downstreamBuilds);
                                if (debug) {
                                    System.out.println(JenkinsResultsParserUtil.combine("Found ", String.valueOf(downstreamBuilds.size()), " builds that match this rule."));
                                }
                                ArrayList<Build> failingInUpstreamJobDownstreamBuilds = new ArrayList<Build>(downstreamBuilds.size());
                                for (Build downstreamBuild : downstreamBuilds) {
                                    if (downstreamBuild.isFailing()) {
                                        failingInUpstreamJobDownstreamBuilds.add(downstreamBuild);
                                        continue;
                                    }
                                    List<TestResult> uniqueFailureTestResults = downstreamBuild.getUniqueFailureTestResults();
                                    if (!uniqueFailureTestResults.isEmpty()) continue;
                                    failingInUpstreamJobDownstreamBuilds.add(downstreamBuild);
                                }
                                if (debug) {
                                    System.out.println(JenkinsResultsParserUtil.combine(String.valueOf(failingInUpstreamJobDownstreamBuilds.size()), " downstream builds are also failing in ", "upstream."));
                                }
                                downstreamBuilds.removeAll(failingInUpstreamJobDownstreamBuilds);
                                if (!downstreamBuilds.isEmpty()) break block19;
                                if (debug) {
                                    System.out.println(this.toString() + " has PASSED.");
                                }
                                list2 = Collections.emptyList();
                                if (!debug) break block20;
                                System.out.println(JenkinsResultsParserUtil.combine("Finished evaluating rule ", this.toString(), "\n"));
                            }
                            return list2;
                        }
                        try {
                            failedDownstreamBuilds = new ArrayList<Build>(downstreamBuilds.size());
                            int failLimit = 0;
                            if (this.maxFailPercentage != -1.0f) {
                                failLimit = (int)(this.maxFailPercentage * (float)downstreamBuilds.size());
                                if (failLimit > 0) {
                                    --failLimit;
                                }
                            } else {
                                failLimit = this.maxFailCount;
                            }
                            if (debug) {
                                System.out.println(JenkinsResultsParserUtil.combine(this.toString(), " fail limit is ", String.valueOf(failLimit)));
                            }
                            for (Build downstreamBuild : downstreamBuilds) {
                                String result;
                                String status = downstreamBuild.getStatus();
                                if (!status.equals("completed") || (result = downstreamBuild.getResult()) == null || result.equals("SUCCESS")) continue;
                                if (debug) {
                                    System.out.println(JenkinsResultsParserUtil.combine("Found a matching failed build. ", downstreamBuild.getDisplayName(), " has failed."));
                                }
                                failedDownstreamBuilds.add(downstreamBuild);
                            }
                            if (failedDownstreamBuilds.size() <= failLimit) break block21;
                            if (debug) {
                                System.out.println(JenkinsResultsParserUtil.combine("Found ", String.valueOf(failedDownstreamBuilds.size()), " matching failed builds.\n", this.toString(), " has FAILED."));
                            }
                            list = failedDownstreamBuilds;
                            if (!debug) break block22;
                        }
                        catch (Throwable throwable) {
                            if (debug) {
                                System.out.println(JenkinsResultsParserUtil.combine("Finished evaluating rule ", this.toString(), "\n"));
                            }
                            throw throwable;
                        }
                        System.out.println(JenkinsResultsParserUtil.combine("Finished evaluating rule ", this.toString(), "\n"));
                    }
                    return list;
                }
                if (debug) {
                    System.out.println(JenkinsResultsParserUtil.combine("Found ", String.valueOf(failedDownstreamBuilds.size()), " matching failed builds.\n", this.toString(), " has PASSED."));
                }
                list = Collections.emptyList();
                if (!debug) break block23;
                System.out.println(JenkinsResultsParserUtil.combine("Finished evaluating rule ", this.toString(), "\n"));
            }
            return list;
        }

        public String toString() {
            return this.ruleData;
        }

        protected List<Build> getMatchingBuilds(List<Build> downstreamBuilds) {
            ArrayList<Build> filteredDownstreamBuilds = new ArrayList<Build>(downstreamBuilds.size());
            for (Build downstreamBuild : downstreamBuilds) {
                Matcher matcher;
                Matcher matcher2;
                String jobVariant = downstreamBuild.getJobVariant();
                if (jobVariant != null && !jobVariant.isEmpty() && (matcher2 = this.rulePattern.matcher(jobVariant)).matches()) {
                    filteredDownstreamBuilds.add(downstreamBuild);
                    continue;
                }
                String jobName = downstreamBuild.getJobName();
                if (jobName == null || jobName.isEmpty() || !(matcher = this.rulePattern.matcher(jobName)).matches()) continue;
                filteredDownstreamBuilds.add(downstreamBuild);
            }
            return filteredDownstreamBuilds;
        }
    }
}

