/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class BalancedListSplitter<T> {
    private final long _maxListWeight;

    public BalancedListSplitter(long maxListWeight) {
        this._maxListWeight = maxListWeight;
    }

    public long getWeight(ListItemList listItemList) {
        long weight = 0L;
        for (ListItem listItem : listItemList) {
            weight += listItem.getWeight(null);
        }
        return weight;
    }

    public abstract long getWeight(T var1);

    public List<List<T>> split(List<T> list) {
        ListItemList listItems = new ListItemList(this);
        for (T item : list) {
            listItems.add(new ListItem(this, item));
        }
        Collections.sort(listItems);
        long totalWeight = listItems.getWeight();
        int minNumberOfLists = (int)(totalWeight / this._maxListWeight);
        if (totalWeight % this._maxListWeight >= 0L) {
            ++minNumberOfLists;
        }
        List<ListItemList> listItemLists = this._createListItemSortedSetList(minNumberOfLists);
        for (ListItem listItem : listItems) {
            Collections.sort(listItemLists);
            ListItemList emptiestListItemList = listItemLists.get(0);
            if (emptiestListItemList.isEmpty() || emptiestListItemList.getAvailableWeight() >= listItem.getWeight(emptiestListItemList)) {
                emptiestListItemList.add(listItem);
                continue;
            }
            ListItemList newListItemList = new ListItemList(this, this._maxListWeight);
            newListItemList.add(listItem);
            listItemLists.add(newListItemList);
        }
        ArrayList<List<T>> lists = new ArrayList<List<T>>(listItemLists.size());
        for (ListItemList listItemList : listItemLists) {
            List newList = listItemList.toList();
            if (newList == null || newList.isEmpty()) continue;
            lists.add(newList);
        }
        return lists;
    }

    protected long getMaxListWeight() {
        return this._maxListWeight;
    }

    private List<ListItemList> _createListItemSortedSetList(int size) {
        ArrayList<ListItemList> listItemSortedSetList = new ArrayList<ListItemList>();
        for (int i = 0; i < size; ++i) {
            listItemSortedSetList.add(new ListItemList(this, this._maxListWeight));
        }
        return listItemSortedSetList;
    }

    protected class ListItemList
    extends ArrayList<ListItem>
    implements Comparable<ListItemList> {
        private BalancedListSplitter<T> _balancedListSplitter;
        private Long _targetWeight;

        public ListItemList(BalancedListSplitter<T> balancedListSplitter) {
            this._balancedListSplitter = balancedListSplitter;
        }

        public ListItemList(BalancedListSplitter<T> balancedListSplitter, Long targetWeight) {
            this(balancedListSplitter);
            this._targetWeight = targetWeight;
        }

        @Override
        public int compareTo(ListItemList otherListItemSortedSet) {
            Long availableWeight = this.getAvailableWeight();
            Long otherAvailableWeight = otherListItemSortedSet.getAvailableWeight();
            if (availableWeight == null && otherAvailableWeight == null) {
                return 0;
            }
            if (availableWeight == null) {
                return 1;
            }
            if (otherAvailableWeight == null) {
                return -1;
            }
            return -1 * availableWeight.compareTo(otherAvailableWeight);
        }

        public Long getAvailableWeight() {
            if (this._targetWeight == null) {
                return null;
            }
            long availableWeight = this._targetWeight - this.getWeight();
            if (availableWeight <= 0L) {
                return 0L;
            }
            return availableWeight;
        }

        public long getWeight() {
            return this._balancedListSplitter.getWeight(this);
        }

        public List<T> toList() {
            ArrayList<Object> list = new ArrayList<Object>(this.size());
            for (ListItem listItem : this) {
                list.add(listItem._item);
            }
            return list;
        }
    }

    protected class ListItem
    implements Comparable<ListItem> {
        private BalancedListSplitter<T> _balancedListSplitter;
        private final T _item;

        public ListItem(BalancedListSplitter<T> balancedListSplitter, T item) {
            this._balancedListSplitter = balancedListSplitter;
            this._item = item;
        }

        @Override
        public int compareTo(ListItem otherListItem) {
            Long weight = this.getWeight(null);
            return -1 * weight.compareTo(otherListItem.getWeight(null));
        }

        public T getItem() {
            return this._item;
        }

        public long getWeight(ListItemList listItemList) {
            if (listItemList == null) {
                return this._getWeight();
            }
            ListItemList tempListItemList = new ListItemList(this._balancedListSplitter);
            tempListItemList.addAll(listItemList);
            long originalWeight = tempListItemList.getWeight();
            tempListItemList.add(this);
            return tempListItemList.getWeight() - originalWeight;
        }

        private long _getWeight() {
            return this._balancedListSplitter.getWeight(this._item);
        }
    }
}

