/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.AxisBuild;
import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.BuildDatabase;
import com.liferay.jenkins.results.parser.BuildDatabaseUtil;
import com.liferay.jenkins.results.parser.BuildUpdater;
import com.liferay.jenkins.results.parser.BuildUpdaterFactory;
import com.liferay.jenkins.results.parser.Dom4JUtil;
import com.liferay.jenkins.results.parser.DownstreamBuild;
import com.liferay.jenkins.results.parser.GitUtil;
import com.liferay.jenkins.results.parser.JenkinsAPIUtil;
import com.liferay.jenkins.results.parser.JenkinsCohort;
import com.liferay.jenkins.results.parser.JenkinsConsoleTextLoader;
import com.liferay.jenkins.results.parser.JenkinsMaster;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.JenkinsSlave;
import com.liferay.jenkins.results.parser.JenkinsTopLevelBuild;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.JobFactory;
import com.liferay.jenkins.results.parser.MultiPattern;
import com.liferay.jenkins.results.parser.NotificationUtil;
import com.liferay.jenkins.results.parser.ParallelExecutor;
import com.liferay.jenkins.results.parser.RemoteGitRef;
import com.liferay.jenkins.results.parser.SlaveOfflineRule;
import com.liferay.jenkins.results.parser.StopWatchRecord;
import com.liferay.jenkins.results.parser.StopWatchRecordsGroup;
import com.liferay.jenkins.results.parser.TestClassResult;
import com.liferay.jenkins.results.parser.TestClassResultFactory;
import com.liferay.jenkins.results.parser.TestResult;
import com.liferay.jenkins.results.parser.TestResultFactory;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import com.liferay.jenkins.results.parser.URLCompareUtil;
import com.liferay.jenkins.results.parser.Workspace;
import com.liferay.jenkins.results.parser.WorkspaceBuild;
import com.liferay.jenkins.results.parser.WorkspaceGitRepository;
import com.liferay.jenkins.results.parser.failure.message.generator.FailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.GenericFailureMessageGenerator;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class BaseBuild
implements Build {
    protected static final String BUILD_URLS_PROPERTIES_KEY = "build-urls.properties";
    protected static final int PIXELS_WIDTH_INDENT = 35;
    protected static final Pattern jobNamePattern = Pattern.compile("(?<baseJob>[^\\(]+)\\((?<branchName>[^\\)]+)\\)");
    protected static final Pattern stopWatchPattern = Pattern.compile(JenkinsResultsParserUtil.combine("\\s*(\\[beanshell\\])?\\s*\\[stopwatch\\]\\s*\\[(?<name>[^:]+): ", "((?<minutes>\\d+):)?((?<seconds>\\d+))?\\.", "(?<milliseconds>\\d+) sec\\]"));
    protected static final Pattern stopWatchStartTimestampPattern = Pattern.compile(JenkinsResultsParserUtil.combine("\\s*(\\[beanshell\\])?\\s*\\[echo\\] (?<name>.*)\\.start\\.timestamp: (?<timestamp>.*)$"));
    protected static final SimpleDateFormat stopWatchTimestampSimpleDateFormat = new SimpleDateFormat("MM-dd-yyyy HH:mm:ss:SSS z");
    protected int consoleReadCursor;
    protected boolean fromArchive;
    protected boolean fromCompletedBuild;
    protected String gitRepositoryName;
    protected Long invokedTime;
    protected Long startTime;
    protected Element upstreamJobFailureMessageElement;
    private static final FailureMessageGenerator[] _FAILURE_MESSAGE_GENERATORS = new FailureMessageGenerator[]{new GenericFailureMessageGenerator()};
    private static final Integer _INVOKED_BATCH_SIZE_DEFAULT = 1;
    private static final int _MAXIMUM_INVOCATION_COUNT = 2;
    private static final Integer _MAXIMUM_SLAVES_PER_HOST = 2;
    private static final Integer _MINIMUM_SLAVE_RAM_DEFAULT = 12;
    private static final String _NAME_JENKINS_REPORT_TIME_ZONE;
    private static final int _PIXELS_WIDTH_EXPANDER = 20;
    private static final String[] _TOKENS_HIGH_PRIORITY_CONTENT;
    private static final MultiPattern _buildURLMultiPattern;
    private static final Pattern _invocationURLPattern;
    private static final Pattern _testrayAttachmentURLPattern;
    private static final Pattern _testrayS3ObjectURLPattern;
    private String _archiveName = "archive";
    private File _archiveRootDir = new File(JenkinsResultsParserUtil.urlDependenciesFile.substring("file:".length()));
    private final Map<String, Build.BranchInformation> _branchInformationMap = new HashMap<String, Build.BranchInformation>();
    private String _branchName;
    private BuildDatabase _buildDatabase;
    private String _buildDescription;
    private Boolean _buildDurationsEnabled;
    private final BuildUpdater _buildUpdater;
    private String _buildURL;
    private Long _duration;
    private Element _gitHubMessageElement;
    private final List<Build.Invocation> _invocations = new ArrayList<Build.Invocation>();
    private int _invokedBatchSize;
    private JenkinsCohort _jenkinsCohort;
    private JenkinsConsoleTextLoader _jenkinsConsoleTextLoader;
    private JenkinsMaster _jenkinsMaster;
    private JenkinsSlave _jenkinsSlave;
    private Job _job;
    private String _jobName;
    private int _maximumSlavesPerHost;
    private int _minimumSlaveRAM;
    private Map<String, String> _parameters = new HashMap<String, String>();
    private final Build _parentBuild;
    private String _previousStatus;
    private String _result;
    private String _status;
    private final Map<String, Long> _statusDurations = new HashMap<String, Long>();
    private long _statusModifiedTime;
    private StopWatchRecordsGroup _stopWatchRecordsGroup;
    private Map<String, TestClassResult> _testClassResults;
    private List<URL> _testrayAttachmentURLs;
    private List<URL> _testrayS3AttachmentURLs;

    @Override
    public void addInvocation(Build.Invocation invocation) {
        this._invocations.add(invocation);
    }

    @Override
    public void archive() {
        this.archive(this.getArchiveName());
    }

    @Override
    public void archive(String archiveName) {
        this.setArchiveName(archiveName);
        if (this.fromArchive) {
            return;
        }
        File archiveDir = new File(this.getArchiveRootDir(), this.getArchivePath());
        if (!archiveDir.exists()) {
            archiveDir.mkdirs();
        }
        ParallelExecutor parallelExecutor = new ParallelExecutor(this.getArchiveCallables(), this.getExecutorService(), "archive");
        try {
            parallelExecutor.execute();
        }
        catch (TimeoutException timeoutException) {
            throw new RuntimeException(timeoutException);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BaseBuild)) {
            return false;
        }
        BaseBuild baseBuild = (BaseBuild)object;
        return Objects.equals(this.getBuildURL(), baseBuild.getBuildURL());
    }

    @Override
    public String getArchiveName() {
        if (this.getParentBuild() == null) {
            return this._archiveName;
        }
        TopLevelBuild topLevelBuild = this.getTopLevelBuild();
        if (this == topLevelBuild) {
            return this._archiveName;
        }
        return topLevelBuild.getArchiveName();
    }

    @Override
    public String getArchivePath() {
        String archiveName = this.getArchiveName();
        StringBuilder sb = new StringBuilder(archiveName);
        if (!archiveName.endsWith("/")) {
            sb.append("/");
        }
        JenkinsMaster jenkinsMaster = this.getJenkinsMaster();
        sb.append(jenkinsMaster.getName());
        sb.append("/");
        sb.append(this.getJobName());
        sb.append("/");
        sb.append(this.getBuildNumber());
        return sb.toString();
    }

    @Override
    public File getArchiveRootDir() {
        Build parentBuild = this.getParentBuild();
        if (parentBuild == null) {
            return this._archiveRootDir;
        }
        if (this.equals(parentBuild)) {
            System.out.println("STACKOVERFLOW CATCH");
            return this._archiveRootDir;
        }
        return parentBuild.getArchiveRootDir();
    }

    @Override
    public List<String> getBadBuildURLs() {
        if (this._invocations.size() <= 1) {
            return Collections.emptyList();
        }
        ArrayList<String> badBuildURLs = new ArrayList<String>();
        for (Build.Invocation invocation : this._invocations.subList(0, this._invocations.size() - 2)) {
            badBuildURLs.add(invocation.getBuildURL());
        }
        return badBuildURLs;
    }

    @Override
    public String getBaseGitRepositoryName() {
        if (this.gitRepositoryName == null) {
            Properties buildProperties = null;
            try {
                buildProperties = JenkinsResultsParserUtil.getBuildProperties();
            }
            catch (IOException ioException) {
                throw new RuntimeException("Unable to get build.properties", ioException);
            }
            TopLevelBuild topLevelBuild = this.getTopLevelBuild();
            this.gitRepositoryName = topLevelBuild.getParameterValue("REPOSITORY_NAME");
            if (this.gitRepositoryName != null && !this.gitRepositoryName.isEmpty()) {
                return this.gitRepositoryName;
            }
            this.gitRepositoryName = buildProperties.getProperty(JenkinsResultsParserUtil.combine("repository[", topLevelBuild.getJobName(), "]"));
            if (this.gitRepositoryName == null) {
                throw new RuntimeException("Unable to get Git repository name for job " + topLevelBuild.getJobName());
            }
        }
        return this.gitRepositoryName;
    }

    @Override
    public String getBaseGitRepositorySHA(String gitRepositoryName) {
        TopLevelBuild topLevelBuild = this.getTopLevelBuild();
        if (topLevelBuild instanceof WorkspaceBuild && !this.fromArchive) {
            WorkspaceBuild workspaceBuild = (WorkspaceBuild)((Object)topLevelBuild);
            Workspace workspace = workspaceBuild.getWorkspace();
            WorkspaceGitRepository workspaceGitRepository = workspace.getPrimaryWorkspaceGitRepository();
            return workspaceGitRepository.getBaseBranchSHA();
        }
        if (gitRepositoryName.equals("liferay-jenkins-ee")) {
            Map<String, String> topLevelBuildStartPropertiesTempMap = topLevelBuild.getStartPropertiesTempMap();
            return topLevelBuildStartPropertiesTempMap.get("JENKINS_GITHUB_UPSTREAM_BRANCH_SHA");
        }
        Map<String, String> gitRepositoryGitDetailsTempMap = topLevelBuild.getBaseGitRepositoryDetailsTempMap();
        return gitRepositoryGitDetailsTempMap.get("github.upstream.branch.sha");
    }

    @Override
    public String getBatchName(String jobVariant) {
        jobVariant = jobVariant.replaceAll("(.*)/.*", "$1");
        return jobVariant.replaceAll("_stable$", "");
    }

    @Override
    public String getBranchName() {
        return this._branchName;
    }

    @Override
    public BuildDatabase getBuildDatabase() {
        if (this._buildDatabase != null) {
            return this._buildDatabase;
        }
        TopLevelBuild topLevelBuild = this.getTopLevelBuild();
        this._buildDatabase = topLevelBuild != null && topLevelBuild != this ? topLevelBuild.getBuildDatabase() : BuildDatabaseUtil.getBuildDatabase(this);
        return this._buildDatabase;
    }

    @Override
    public String getBuildDescription() {
        if (this._buildDescription == null && this.getBuildURL() != null) {
            JSONObject descriptionJSONObject = this.getBuildJSONObject("description");
            if (descriptionJSONObject == null) {
                return null;
            }
            String description = descriptionJSONObject.optString("description");
            if (description.equals("")) {
                description = null;
            }
            this._buildDescription = description;
        }
        return this._buildDescription;
    }

    @Override
    public String getBuildDirPath() {
        StringBuilder sb = new StringBuilder();
        if (JenkinsResultsParserUtil.isWindows()) {
            sb.append("C:");
        }
        sb.append("/tmp/jenkins/");
        JenkinsMaster jenkinsMaster = this.getJenkinsMaster();
        sb.append(jenkinsMaster.getName());
        sb.append("/");
        sb.append(this.getJobName());
        if (this instanceof AxisBuild) {
            sb.append("/");
            AxisBuild axisBuild = (AxisBuild)this;
            sb.append(axisBuild.getAxisNumber());
        }
        sb.append("/");
        sb.append(this.getBuildNumber());
        return sb.toString();
    }

    @Override
    public JSONObject getBuildJSONObject() {
        String archiveFileContent = this.getArchiveFileContent("api/json");
        if (!JenkinsResultsParserUtil.isNullOrEmpty(archiveFileContent)) {
            return new JSONObject(archiveFileContent);
        }
        try {
            return JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil.getLocalURL(this.getBuildURL() + "api/json"), false);
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to get build JSON object", ioException);
        }
    }

    @Override
    public JSONObject getBuildJSONObject(String tree) {
        String archiveFileContent = this.getArchiveFileContent("api/json");
        if (!JenkinsResultsParserUtil.isNullOrEmpty(archiveFileContent)) {
            return new JSONObject(archiveFileContent);
        }
        String buildURL = this.getBuildURL();
        if (JenkinsResultsParserUtil.isNullOrEmpty(buildURL)) {
            return null;
        }
        return JenkinsAPIUtil.getAPIJSONObject(buildURL, tree);
    }

    @Override
    public int getBuildNumber() {
        String buildURL = this.getBuildURL();
        if (!JenkinsResultsParserUtil.isURL(buildURL)) {
            return -1;
        }
        MultiPattern buildURLMultiPattern = this.getBuildURLMultiPattern();
        Matcher matcher = buildURLMultiPattern.find(buildURL);
        if (matcher == null) {
            return -1;
        }
        return Integer.parseInt(matcher.group("buildNumber"));
    }

    @Override
    public Job.BuildProfile getBuildProfile() {
        String buildProfile = this.getParameterValue("TEST_PORTAL_BUILD_PROFILE");
        if (JenkinsResultsParserUtil.isNullOrEmpty(buildProfile)) {
            buildProfile = System.getenv("TEST_PORTAL_BUILD_PROFILE");
        }
        if (!JenkinsResultsParserUtil.isNullOrEmpty(buildProfile)) {
            if (buildProfile.equals("dxp")) {
                return Job.BuildProfile.DXP;
            }
            return Job.BuildProfile.PORTAL;
        }
        String branchName = this.getBranchName();
        if (!branchName.equals("master") && !branchName.startsWith("ee-")) {
            return Job.BuildProfile.DXP;
        }
        return Job.BuildProfile.PORTAL;
    }

    @Override
    public String getBuildURL() {
        return this._buildURL;
    }

    @Override
    public String getBuildURLRegex() {
        StringBuffer sb = new StringBuffer();
        sb.append("http[s]*:\\/\\/");
        JenkinsMaster jenkinsMaster = this.getJenkinsMaster();
        sb.append(JenkinsResultsParserUtil.getRegexLiteral(jenkinsMaster.getName()));
        sb.append("[^\\/]*");
        sb.append("[\\/]+job[\\/]+");
        String jobNameRegexLiteral = JenkinsResultsParserUtil.getRegexLiteral(this.getJobName());
        jobNameRegexLiteral = jobNameRegexLiteral.replace("\\(", "(\\(|%28)");
        jobNameRegexLiteral = jobNameRegexLiteral.replace("\\)", "(\\)|%29)");
        sb.append(jobNameRegexLiteral);
        sb.append("[\\/]+");
        sb.append(this.getBuildNumber());
        sb.append("[\\/]*");
        return sb.toString();
    }

    @Override
    public String getConsoleText() {
        String archiveFileContent = this.getArchiveFileContent("consoleText");
        if (!JenkinsResultsParserUtil.isNullOrEmpty(archiveFileContent)) {
            return archiveFileContent;
        }
        String buildURL = this.getBuildURL();
        if (buildURL == null) {
            return "";
        }
        if (this._jenkinsConsoleTextLoader == null) {
            this._jenkinsConsoleTextLoader = new JenkinsConsoleTextLoader(this.getBuildURL(), this instanceof TopLevelBuild);
        }
        return this._jenkinsConsoleTextLoader.getConsoleText();
    }

    @Override
    public Build.Invocation getCurrentInvocation() {
        if (this._invocations.isEmpty()) {
            return null;
        }
        return this._invocations.get(this._invocations.size() - 1);
    }

    @Override
    public Long getDelayTime() {
        Long invokedTime;
        Long startTime = this.getStartTime();
        long currentTime = JenkinsResultsParserUtil.getCurrentTimeMillis();
        if (startTime == null) {
            startTime = currentTime;
        }
        if ((invokedTime = this.getInvokedTime()) == null) {
            invokedTime = currentTime;
        }
        return startTime - invokedTime + this.getQueuingDuration();
    }

    @Override
    public int getDepth() {
        Build parentBuild = this.getParentBuild();
        if (parentBuild == null) {
            return 0;
        }
        return parentBuild.getDepth() + 1;
    }

    @Override
    public String getDisplayName() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getJobName());
        String jobVariant = this.getParameterValue("JOB_VARIANT");
        if (jobVariant != null && !jobVariant.isEmpty()) {
            sb.append("/");
            sb.append(jobVariant);
        }
        return sb.toString();
    }

    @Override
    public long getDuration() {
        if (this._duration != null) {
            return this._duration;
        }
        JSONObject buildJSONObject = this.getBuildJSONObject("duration,timestamp");
        if (buildJSONObject == null) {
            return 0L;
        }
        long duration = buildJSONObject.getLong("duration");
        if (duration == 0L) {
            long timestamp = buildJSONObject.getLong("timestamp");
            return JenkinsResultsParserUtil.getCurrentTimeMillis() - timestamp;
        }
        this._duration = duration;
        return this._duration;
    }

    @Override
    public String getFailureMessage() {
        for (FailureMessageGenerator failureMessageGenerator : this.getFailureMessageGenerators()) {
            try {
                String failureMessage = failureMessageGenerator.getMessage(this);
                if (failureMessage == null) continue;
                return failureMessage;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Class<?> clazz = failureMessageGenerator.getClass();
                String className = clazz.getName();
                StringBuilder sb = new StringBuilder();
                sb.append("Unable to get failure message from " + className);
                sb.append(className);
                sb.append("\n");
                sb.append(this.getBuildURL());
                NotificationUtil.sendEmail(sb.toString(), "jenkins", "Unable to get failure message", "calum.ragan@liferay.com");
            }
        }
        return null;
    }

    @Override
    public Element getGitHubMessageBuildAnchorElement() {
        this.getResult();
        int i = 0;
        String result = this.getResult();
        while (result == null) {
            if (i == 2) {
                System.out.println(JenkinsResultsParserUtil.combine("Unable to create build anchor element. The process ", "timed out while waiting for a build result for ", this.getBuildURL(), "."));
                break;
            }
            JenkinsResultsParserUtil.sleep(5000L);
            result = this.getResult();
            ++i;
        }
        if (Objects.equals(result, "SUCCESS")) {
            return Dom4JUtil.getNewAnchorElement(this.getBuildURL(), this.getDisplayName());
        }
        return Dom4JUtil.getNewAnchorElement(this.getBuildURL(), null, Dom4JUtil.getNewElement("strike", null, this.getDisplayName()));
    }

    @Override
    public Element getGitHubMessageElement() {
        return this.getGitHubMessageElement(false);
    }

    public Element getGitHubMessageElement(boolean showCommonFailuresCount) {
        if (this._gitHubMessageElement != null) {
            return this._gitHubMessageElement;
        }
        if (!Objects.equals(this.getStatus(), "completed") && this.getParentBuild() != null) {
            return null;
        }
        String result = this.getResult();
        if (result.equals("SUCCESS")) {
            return null;
        }
        Element messageElement = Dom4JUtil.getNewElement("div");
        Dom4JUtil.addToElement(messageElement, Dom4JUtil.getNewElement("h5", null, Dom4JUtil.getNewAnchorElement(this.getBuildURL(), this.getDisplayName())));
        if (showCommonFailuresCount) {
            Dom4JUtil.addToElement(messageElement, this.getGitHubMessageJobResultsElement(showCommonFailuresCount));
        } else {
            Dom4JUtil.addToElement(messageElement, this.getGitHubMessageJobResultsElement());
        }
        if (result.equals("ABORTED") && !this.hasDownstreamBuilds()) {
            messageElement.add(Dom4JUtil.toCodeSnippetElement("Build was aborted"));
            return messageElement;
        }
        Element failureMessageElement = this.getFailureMessageElement();
        if (failureMessageElement != null) {
            messageElement.add(failureMessageElement);
        }
        this._gitHubMessageElement = messageElement;
        return this._gitHubMessageElement;
    }

    @Override
    public Element getGitHubMessageUpstreamJobFailureElement() {
        return this.upstreamJobFailureMessageElement;
    }

    @Override
    public Map<String, String> getInjectedEnvironmentVariablesMap() throws IOException {
        HashMap<String, String> injectedEnvironmentVariablesMap = new HashMap<String, String>();
        String localBuildURL = JenkinsResultsParserUtil.getLocalURL(this.getBuildURL());
        JSONObject jsonObject = JenkinsResultsParserUtil.toJSONObject(localBuildURL + "/injectedEnvVars/api/json", false);
        JSONObject envMapJSONObject = jsonObject.getJSONObject("envMap");
        Set envMapJSONObjectKeySet = envMapJSONObject.keySet();
        for (String key : envMapJSONObjectKeySet) {
            injectedEnvironmentVariablesMap.put(key, envMapJSONObject.getString(key));
        }
        return injectedEnvironmentVariablesMap;
    }

    @Override
    public String getInvocationURL() {
        String jobURL = this.getJobURL();
        if (jobURL == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(jobURL);
        sb.append("/buildWithParameters?");
        HashMap<String, String> parameters = new HashMap<String, String>(this.getParameters());
        try {
            parameters.put("token", JenkinsResultsParserUtil.getBuildProperty("jenkins.authentication.token"));
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to get Jenkins authentication token", ioException);
        }
        for (Map.Entry parameter : parameters.entrySet()) {
            sb.append((String)parameter.getKey());
            sb.append("=");
            sb.append((String)parameter.getValue());
            sb.append("&");
        }
        sb.deleteCharAt(sb.length() - 1);
        return JenkinsResultsParserUtil.fixURL(sb.toString());
    }

    @Override
    public int getInvokedBatchSize() {
        if (this._invokedBatchSize > 0) {
            return this._invokedBatchSize;
        }
        String invokedJobBatchSize = this.getParameterValue("INVOKED_JOB_BATCH_SIZE");
        if (JenkinsResultsParserUtil.isInteger(invokedJobBatchSize)) {
            this._invokedBatchSize = Integer.parseInt(invokedJobBatchSize);
            return this._invokedBatchSize;
        }
        String testBatchSize = this.getParameterValue("TEST_BATCH_SIZE");
        this._invokedBatchSize = JenkinsResultsParserUtil.isInteger(testBatchSize) ? Integer.parseInt(testBatchSize) : _INVOKED_BATCH_SIZE_DEFAULT;
        return this._invokedBatchSize;
    }

    @Override
    public Long getInvokedTime() {
        if (this.invokedTime != null) {
            return this.invokedTime;
        }
        this.invokedTime = this.getStartTime();
        return this.invokedTime;
    }

    @Override
    public JenkinsCohort getJenkinsCohort() {
        if (this._jenkinsCohort != null) {
            return this._jenkinsCohort;
        }
        TopLevelBuild topLevelBuild = this.getTopLevelBuild();
        if (topLevelBuild != null) {
            this._jenkinsCohort = topLevelBuild.getJenkinsCohort();
            return this._jenkinsCohort;
        }
        String cohortName = JenkinsResultsParserUtil.getCohortName();
        if (!JenkinsResultsParserUtil.isNullOrEmpty(cohortName)) {
            this._jenkinsCohort = JenkinsCohort.getInstance(cohortName);
            return this._jenkinsCohort;
        }
        return null;
    }

    @Override
    public JenkinsMaster getJenkinsMaster() {
        if (this._jenkinsMaster != null) {
            return this._jenkinsMaster;
        }
        Build.Invocation currentInvocation = this.getCurrentInvocation();
        if (currentInvocation != null) {
            this._jenkinsMaster = currentInvocation.getJenkinsMaster();
            return this._jenkinsMaster;
        }
        String buildURL = this.getBuildURL();
        if (!JenkinsResultsParserUtil.isURL(buildURL)) {
            return null;
        }
        MultiPattern buildURLMultiPattern = this.getBuildURLMultiPattern();
        Matcher matcher = buildURLMultiPattern.find(buildURL);
        if (matcher == null) {
            return null;
        }
        this._jenkinsMaster = JenkinsMaster.getInstance(matcher.group("master"));
        return this._jenkinsMaster;
    }

    @Override
    public JenkinsSlave getJenkinsSlave() {
        if (this._jenkinsSlave != null) {
            return this._jenkinsSlave;
        }
        String buildURL = this.getBuildURL();
        JenkinsMaster jenkinsMaster = this.getJenkinsMaster();
        if (buildURL == null || jenkinsMaster == null) {
            return null;
        }
        JSONObject builtOnJSONObject = this.getBuildJSONObject("builtOn");
        if (builtOnJSONObject == null) {
            return null;
        }
        String slaveName = builtOnJSONObject.optString("builtOn");
        if (slaveName.equals("")) {
            slaveName = "master";
        }
        this._jenkinsSlave = jenkinsMaster.getJenkinsSlave(slaveName);
        return this._jenkinsSlave;
    }

    @Override
    public Job getJob() {
        if (this._job != null) {
            return this._job;
        }
        this._job = JobFactory.newJob(this);
        return this._job;
    }

    @Override
    public String getJobName() {
        return this._jobName;
    }

    @Override
    public String getJobURL() {
        JenkinsMaster jenkinsMaster = this.getJenkinsMaster();
        if (jenkinsMaster == null || this._jobName == null) {
            return null;
        }
        if (this.fromArchive) {
            return JenkinsResultsParserUtil.combine("${dependencies.url}", "/", this.getArchiveName(), "/", jenkinsMaster.getName(), "/", this._jobName);
        }
        String jobURL = JenkinsResultsParserUtil.combine("https://", jenkinsMaster.getName(), ".liferay.com/job/", this._jobName);
        try {
            return JenkinsResultsParserUtil.encode(jobURL);
        }
        catch (MalformedURLException | URISyntaxException exception) {
            throw new RuntimeException("Unable to encode job URL " + jobURL, exception);
        }
    }

    @Override
    public String getJobVariant() {
        String jobVariant = this.getParameterValue("JOB_VARIANT");
        if (jobVariant == null || jobVariant.isEmpty()) {
            jobVariant = this.getParameterValue("JENKINS_JOB_VARIANT");
        }
        return jobVariant;
    }

    @Override
    public TestResult getLongestRunningTest() {
        TestResult longestRunningTest = null;
        List<TestResult> testResults = this.getTestResults(null);
        long longestTestDuration = 0L;
        for (TestResult testResult : testResults) {
            long testDuration = testResult.getDuration();
            if (testDuration <= longestTestDuration) continue;
            longestTestDuration = testDuration;
            longestRunningTest = testResult;
        }
        return longestRunningTest;
    }

    @Override
    public int getMaximumSlavesPerHost() {
        if (this._maximumSlavesPerHost > 0) {
            return this._maximumSlavesPerHost;
        }
        String maximumSlavesPerHost = this.getParameterValue("MAXIMUM_SLAVES_PER_HOST");
        this._maximumSlavesPerHost = JenkinsResultsParserUtil.isInteger(maximumSlavesPerHost) ? Integer.parseInt(maximumSlavesPerHost) : _MAXIMUM_SLAVES_PER_HOST;
        return this._maximumSlavesPerHost;
    }

    @Override
    public Map<String, String> getMetricLabels() {
        if (this._parentBuild != null) {
            return this._parentBuild.getMetricLabels();
        }
        return new TreeMap<String, String>();
    }

    @Override
    public int getMinimumSlaveRAM() {
        if (this._minimumSlaveRAM > 0) {
            return this._minimumSlaveRAM;
        }
        String minimumSlaveRAM = this.getParameterValue("MINIMUM_SLAVE_RAM");
        this._minimumSlaveRAM = JenkinsResultsParserUtil.isInteger(minimumSlaveRAM) ? Integer.parseInt(minimumSlaveRAM) : _MINIMUM_SLAVE_RAM_DEFAULT;
        return this._minimumSlaveRAM;
    }

    @Override
    public Map<String, String> getParameters() {
        return new HashMap<String, String>(this._parameters);
    }

    @Override
    public String getParameterValue(String name) {
        return this._parameters.get(name);
    }

    @Override
    public Build getParentBuild() {
        return this._parentBuild;
    }

    @Override
    public Build.Invocation getPreviousInvocation() {
        if (this._invocations.size() <= 1) {
            return null;
        }
        return this._invocations.get(this._invocations.size() - 2);
    }

    public long getQueuingDuration() {
        JSONObject buildJSONObject = this.getBuildJSONObject("actions[queuingDurationMillis]");
        if (buildJSONObject == null) {
            return 0L;
        }
        JSONArray actionsJSONArray = buildJSONObject.getJSONArray("actions");
        for (int i = 0; i < actionsJSONArray.length(); ++i) {
            JSONObject actionJSONObject;
            Object actions = actionsJSONArray.get(i);
            if (actions == JSONObject.NULL || !(actionJSONObject = actionsJSONArray.getJSONObject(i)).has("queuingDurationMillis")) continue;
            return actionJSONObject.getLong("queuingDurationMillis");
        }
        return 0L;
    }

    @Override
    public String getResult() {
        if (!JenkinsResultsParserUtil.isNullOrEmpty(this._result)) {
            return this._result;
        }
        String status = this.getStatus();
        if (!Objects.equals(status, "reported") && !Objects.equals(status, "completed")) {
            return null;
        }
        JSONObject buildJSONObject = this.getBuildJSONObject("result");
        if (buildJSONObject == null) {
            return "MISSING";
        }
        String result = buildJSONObject.optString("result");
        if (JenkinsResultsParserUtil.isNullOrEmpty(result)) {
            return "MISSING";
        }
        this._result = result;
        return this._result;
    }

    @Override
    public Map<String, String> getStartPropertiesTempMap() {
        return this.getTempMap("start.properties");
    }

    @Override
    public Long getStartTime() {
        if (this.startTime != null) {
            return this.startTime;
        }
        JSONObject buildJSONObject = this.getBuildJSONObject("timestamp");
        if (buildJSONObject == null) {
            return null;
        }
        long timestamp = buildJSONObject.getLong("timestamp");
        if (timestamp != 0L) {
            this.startTime = timestamp;
        }
        return this.startTime;
    }

    @Override
    public String getStatus() {
        return this._status;
    }

    @Override
    public long getStatusAge() {
        return JenkinsResultsParserUtil.getCurrentTimeMillis() - this._statusModifiedTime;
    }

    @Override
    public long getStatusDuration(String status) {
        if (this._statusDurations.containsKey(status)) {
            return this._statusDurations.get(status);
        }
        return 0L;
    }

    @Override
    public Map<String, String> getStopPropertiesTempMap() {
        return this.getTempMap("stop.properties");
    }

    @Override
    public StopWatchRecordsGroup getStopWatchRecordsGroup() {
        if (!(this instanceof TopLevelBuild)) {
            if (!Objects.equals(this.getStatus(), "completed")) {
                this._stopWatchRecordsGroup = null;
                return new StopWatchRecordsGroup();
            }
            if (this._stopWatchRecordsGroup != null) {
                return this._stopWatchRecordsGroup;
            }
        }
        this._stopWatchRecordsGroup = new StopWatchRecordsGroup();
        String consoleText = this.getConsoleText();
        for (String line : consoleText.split("\n")) {
            String stopWatchName;
            StopWatchRecord stopWatchRecord;
            String minutes;
            Matcher matcher = stopWatchStartTimestampPattern.matcher(line);
            if (matcher.matches()) {
                Date timestamp = null;
                try {
                    timestamp = stopWatchTimestampSimpleDateFormat.parse(matcher.group("timestamp"));
                }
                catch (ParseException parseException) {
                    throw new RuntimeException("Unable to parse timestamp in " + line, parseException);
                }
                String stopWatchName2 = matcher.group("name");
                this._stopWatchRecordsGroup.add(new StopWatchRecord(stopWatchName2, timestamp.getTime()));
                continue;
            }
            matcher = stopWatchPattern.matcher(line);
            if (!matcher.matches()) continue;
            long duration = Long.parseLong(matcher.group("milliseconds"));
            String seconds = matcher.group("seconds");
            if (seconds != null) {
                duration += Long.parseLong(seconds) * 1000L;
            }
            if ((minutes = matcher.group("minutes")) != null) {
                duration += Long.parseLong(minutes) * 60L * 1000L;
            }
            if ((stopWatchRecord = this._stopWatchRecordsGroup.get(stopWatchName = matcher.group("name"))) == null) continue;
            stopWatchRecord.setDuration(duration);
        }
        return this._stopWatchRecordsGroup;
    }

    @Override
    public TestClassResult getTestClassResult(String testClassName) {
        if (!this.isCompleted()) {
            return null;
        }
        this._initTestClassResults();
        if (this._testClassResults == null) {
            return null;
        }
        return this._testClassResults.get(testClassName);
    }

    @Override
    public List<TestClassResult> getTestClassResults() {
        if (!this.isCompleted()) {
            return new ArrayList<TestClassResult>();
        }
        this._initTestClassResults();
        if (this._testClassResults == null) {
            return new ArrayList<TestClassResult>();
        }
        return new ArrayList<TestClassResult>(this._testClassResults.values());
    }

    @Override
    public synchronized List<URL> getTestrayAttachmentURLs() {
        if (this._testrayAttachmentURLs != null) {
            return this._testrayAttachmentURLs;
        }
        this._testrayAttachmentURLs = new ArrayList<URL>();
        String consoleText = this.getConsoleText();
        for (String line : consoleText.split("\\n")) {
            Matcher matcher = _testrayAttachmentURLPattern.matcher(line);
            if (!matcher.find()) continue;
            try {
                this._testrayAttachmentURLs.add(new URL(matcher.group("url")));
            }
            catch (MalformedURLException malformedURLException) {
                throw new RuntimeException(malformedURLException);
            }
        }
        return this._testrayAttachmentURLs;
    }

    @Override
    public String getTestrayBuildDateString() {
        return JenkinsResultsParserUtil.toDateString(new Date(this.getStartTime()), "yyyy-MM-dd HH:mm:ss", "America/Los_Angeles");
    }

    @Override
    public synchronized List<URL> getTestrayS3AttachmentURLs() {
        if (this._testrayS3AttachmentURLs != null) {
            return this._testrayS3AttachmentURLs;
        }
        this._testrayS3AttachmentURLs = new ArrayList<URL>();
        String consoleText = this.getConsoleText();
        for (String line : consoleText.split("\\n")) {
            Matcher matcher = _testrayS3ObjectURLPattern.matcher(line);
            if (!matcher.find()) continue;
            try {
                this._testrayS3AttachmentURLs.add(new URL(matcher.group("url")));
            }
            catch (MalformedURLException malformedURLException) {
                throw new RuntimeException(malformedURLException);
            }
        }
        return this._testrayS3AttachmentURLs;
    }

    @Override
    public JSONObject getTestReportJSONObject(boolean checkCache) {
        String result = this.getResult();
        if (result == null) {
            return null;
        }
        String urlSuffix = "testReport/api/json";
        String archiveFileContent = this.getArchiveFileContent(urlSuffix);
        if (!JenkinsResultsParserUtil.isNullOrEmpty(archiveFileContent)) {
            return new JSONObject(archiveFileContent);
        }
        try {
            return JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil.getLocalURL(this.getBuildURL() + urlSuffix), checkCache, 5000);
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to get test report JSON object", ioException);
        }
    }

    @Override
    public List<TestResult> getTestResults() {
        if (!this.isCompleted()) {
            return new ArrayList<TestResult>();
        }
        ArrayList<TestResult> testResults = new ArrayList<TestResult>();
        for (TestClassResult testClassResult : this.getTestClassResults()) {
            testResults.addAll(testClassResult.getTestResults());
        }
        return testResults;
    }

    @Override
    public List<TestResult> getTestResults(String testStatus) {
        return Collections.emptyList();
    }

    @Override
    public String getTestSuiteName() {
        Build parentBuild = this.getParentBuild();
        if (parentBuild == null) {
            return "default";
        }
        return parentBuild.getTestSuiteName();
    }

    @Override
    public TopLevelBuild getTopLevelBuild() {
        Build topLevelBuild = this;
        Build parentBuild = topLevelBuild.getParentBuild();
        if (parentBuild instanceof JenkinsTopLevelBuild) {
            return (TopLevelBuild)parentBuild;
        }
        while (topLevelBuild != null && !(topLevelBuild instanceof TopLevelBuild)) {
            topLevelBuild = topLevelBuild.getParentBuild();
        }
        return (TopLevelBuild)topLevelBuild;
    }

    @Override
    public List<TestResult> getUniqueFailureTestResults() {
        return Collections.emptyList();
    }

    @Override
    public List<TestResult> getUpstreamJobFailureTestResults() {
        return Collections.emptyList();
    }

    @Override
    public boolean hasBuildURL(String buildURL) {
        try {
            buildURL = JenkinsResultsParserUtil.decode(buildURL);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Unable to decode " + buildURL, unsupportedEncodingException);
        }
        buildURL = JenkinsResultsParserUtil.getLocalURL(buildURL);
        String thisBuildURL = this.getBuildURL();
        if (thisBuildURL != null) {
            thisBuildURL = JenkinsResultsParserUtil.getLocalURL(thisBuildURL);
            try {
                if (URLCompareUtil.matches(new URL(buildURL), new URL(thisBuildURL))) {
                    return true;
                }
            }
            catch (MalformedURLException malformedURLException) {
                throw new RuntimeException(JenkinsResultsParserUtil.combine("Unable to compare urls ", buildURL, " and ", thisBuildURL), malformedURLException);
            }
        }
        return false;
    }

    @Override
    public boolean hasDownstreamBuilds() {
        return false;
    }

    @Override
    public boolean hasGenericCIFailure() {
        for (FailureMessageGenerator failureMessageGenerator : this.getFailureMessageGenerators()) {
            Element failureMessage = failureMessageGenerator.getMessageElement(this);
            if (failureMessage == null) continue;
            return failureMessageGenerator.isGenericCIFailure();
        }
        return false;
    }

    public int hashCode() {
        String key = this.getBuildURL();
        if (key != null) {
            return key.hashCode();
        }
        return super.hashCode();
    }

    @Override
    public boolean hasMaximumInvocationCount() {
        return this._invocations.size() >= 2;
    }

    @Override
    public boolean isBuildModified() {
        return this._isDifferent(this._status, this._previousStatus);
    }

    @Override
    public boolean isCompareToUpstream() {
        TopLevelBuild topLevelBuild = this.getTopLevelBuild();
        return topLevelBuild.isCompareToUpstream();
    }

    @Override
    public boolean isCompleted() {
        String status = this.getStatus();
        return Objects.equals(status, "completed") || Objects.equals(status, "reporting");
    }

    @Override
    public boolean isFailing() {
        return !Objects.equals(this.getResult(), "SUCCESS");
    }

    @Override
    public boolean isFromArchive() {
        return this.fromArchive;
    }

    @Override
    public boolean isFromCompletedBuild() {
        Build parentBuild = this.getParentBuild();
        if (parentBuild != null) {
            return parentBuild.isFromCompletedBuild();
        }
        return this.fromCompletedBuild;
    }

    @Override
    public boolean isUniqueFailure() {
        if (!this.isFailing()) {
            return false;
        }
        ArrayList<TestResult> testResults = new ArrayList<TestResult>();
        testResults.addAll(this.getTestResults("FAILED"));
        testResults.addAll(this.getTestResults("REGRESSION"));
        List<TestResult> passedTestResults = this.getTestResults("PASSED");
        if (passedTestResults.size() == 1) {
            testResults.addAll(passedTestResults);
        }
        if (testResults.isEmpty()) {
            return true;
        }
        for (TestResult testResult : testResults) {
            if (!testResult.isUniqueFailure()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String replaceBuildURL(String text) {
        if (JenkinsResultsParserUtil.isNullOrEmpty(text)) {
            return text;
        }
        text = text.replaceAll(this.getBuildURLRegex(), Matcher.quoteReplacement(JenkinsResultsParserUtil.combine("${dependencies.url}", "/", this.getArchivePath())));
        for (Build parentBuild = this.getParentBuild(); parentBuild != null; parentBuild = parentBuild.getParentBuild()) {
            text = text.replaceAll(parentBuild.getBuildURLRegex(), Matcher.quoteReplacement("${dependencies.url}" + parentBuild.getArchivePath()));
        }
        return text;
    }

    @Override
    public void reset() {
        this.consoleReadCursor = 0;
        this._duration = null;
        this._jenkinsConsoleTextLoader = null;
        this._jenkinsMaster = null;
        this._jenkinsSlave = null;
        this._result = null;
        this._statusModifiedTime = JenkinsResultsParserUtil.getCurrentTimeMillis();
        if (this._buildUpdater != null) {
            this._buildUpdater.reset();
        }
    }

    @Override
    public void saveBuildURLInBuildDatabase() {
        BuildDatabase buildDatabase = this.getBuildDatabase();
        buildDatabase.putProperty(BUILD_URLS_PROPERTIES_KEY, this.getJobVariant(), this.getBuildURL(), false);
    }

    @Override
    public void setArchiveName(String archiveName) {
        this._archiveName = archiveName;
    }

    @Override
    public void setArchiveRootDir(File archiveRootDir) {
        if (archiveRootDir == null) {
            archiveRootDir = new File(JenkinsResultsParserUtil.urlDependenciesFile.substring("file:".length()));
        }
        if (!archiveRootDir.exists()) {
            throw new IllegalArgumentException(archiveRootDir.getPath() + " does not exist");
        }
        this._archiveRootDir = archiveRootDir;
    }

    @Override
    public void setBuildURL(String buildURL) {
        this._buildURL = buildURL;
    }

    @Override
    public void setCompareToUpstream(boolean compareToUpstream) {
    }

    @Override
    public void setJenkinsCohort(JenkinsCohort jenkinsCohort) {
        this._jenkinsCohort = jenkinsCohort;
    }

    @Override
    public void setJenkinsMaster(JenkinsMaster jenkinsMaster) {
        this._jenkinsMaster = jenkinsMaster;
    }

    @Override
    public void setResult(String result) {
        this._result = result;
    }

    @Override
    public void setStatus(String status) {
        boolean different = this._isDifferent(status, this._status);
        this._previousStatus = this._status;
        this._status = status;
        long previousStatusModifiedTime = this._statusModifiedTime;
        this._statusModifiedTime = JenkinsResultsParserUtil.getCurrentTimeMillis();
        this._statusDurations.put(this._previousStatus, this._statusModifiedTime - previousStatusModifiedTime);
        if (different && this.isParentBuildRoot()) {
            System.out.println(this.getBuildMessage());
        }
    }

    @Override
    public void takeSlaveOffline(SlaveOfflineRule slaveOfflineRule) {
        if (slaveOfflineRule == null || this.fromArchive) {
            return;
        }
        slaveOfflineRule.takeSlaveOffline(this);
    }

    @Override
    public synchronized void update() {
        if (this.skipUpdate()) {
            System.out.println("Skipping build status: " + this.getStatus());
            return;
        }
        this._buildUpdater.update();
    }

    protected static boolean isHighPriorityBuildFailureElement(Element gitHubMessage) {
        String content = null;
        try {
            content = Dom4JUtil.format(gitHubMessage, false);
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to format github message", ioException);
        }
        for (String highPriorityContentToken : _TOKENS_HIGH_PRIORITY_CONTENT) {
            if (!content.contains(highPriorityContentToken)) continue;
            return true;
        }
        return false;
    }

    protected BaseBuild(String url) {
        this(url, null);
    }

    protected BaseBuild(String url, Build parentBuild) {
        this._parentBuild = parentBuild;
        if (url.contains("buildWithParameters")) {
            this._setInvocationURL(url);
        } else {
            this._setBuildURL(url);
        }
        if (!this.fromArchive && JenkinsResultsParserUtil.isCINode()) {
            TopLevelBuild topLevelBuild = this.getTopLevelBuild();
            this._archiveRootDir = topLevelBuild != null ? new File(topLevelBuild.getBuildDirPath()) : new File(this.getBuildDirPath());
        }
        this._buildUpdater = BuildUpdaterFactory.newBuildUpdater(this);
        if (this.fromArchive || this.isFromCompletedBuild()) {
            this.update();
        }
    }

    protected void archiveFileElements(String urlSuffix, List<Element> elements) {
        Element rootElement = Dom4JUtil.getNewElement("root");
        for (Element element : elements) {
            rootElement.add(element);
        }
        try {
            this._archive(Dom4JUtil.format(rootElement), true, urlSuffix);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    protected boolean archiveFileExists(String urlSuffix) {
        File archiveFile = this.getArchiveFile(urlSuffix);
        if (archiveFile == null) {
            return false;
        }
        return archiveFile.exists();
    }

    protected boolean buildDurationsEnabled() {
        if (this._buildDurationsEnabled != null) {
            return this._buildDurationsEnabled;
        }
        String buildDurationsEnabled = null;
        try {
            TopLevelBuild topLevelBuild = this.getTopLevelBuild();
            String topLevelBranchName = null;
            String topLevelJobName = null;
            String topLevelTestSuiteName = null;
            if (topLevelBuild != null) {
                topLevelBranchName = topLevelBuild.getBranchName();
                topLevelJobName = topLevelBuild.getJobName();
                topLevelTestSuiteName = topLevelBuild.getTestSuiteName();
            }
            if (Objects.equals(buildDurationsEnabled = JenkinsResultsParserUtil.getProperty(JenkinsResultsParserUtil.getBuildProperties(), "build.durations.enabled", topLevelBranchName, topLevelJobName, topLevelTestSuiteName), "true")) {
                this._buildDurationsEnabled = true;
                return this._buildDurationsEnabled;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._buildDurationsEnabled = false;
        return this._buildDurationsEnabled;
    }

    protected Pattern getArchiveBuildURLPattern() {
        return Pattern.compile(JenkinsResultsParserUtil.combine("(", Pattern.quote("${dependencies.url}"), "|", Pattern.quote(JenkinsResultsParserUtil.urlDependenciesFile), "|", Pattern.quote(JenkinsResultsParserUtil.urlDependenciesHttp), ")/*(?<archiveName>.*)/(?<master>[^/]+)/+(?<jobName>[^/]+)", ".*/(?<buildNumber>\\d+)/?"));
    }

    protected List<Callable<Object>> getArchiveCallables() {
        ArrayList<Callable<Object>> archiveCallables = new ArrayList<Callable<Object>>();
        JenkinsMaster jenkinsMaster = this.getJenkinsMaster();
        archiveCallables.add(new ParallelExecutor.SequentialCallable<Object>(jenkinsMaster.getName()){

            @Override
            public Object call() {
                BaseBuild.this._archiveBuildJSON();
                return null;
            }
        });
        archiveCallables.add(new ParallelExecutor.SequentialCallable<Object>(jenkinsMaster.getName()){

            @Override
            public Object call() {
                BaseBuild.this._archiveConsoleLog();
                return null;
            }
        });
        archiveCallables.add(new ParallelExecutor.SequentialCallable<Object>(jenkinsMaster.getName()){

            @Override
            public Object call() {
                BaseBuild.this._archiveMarkerFile();
                return null;
            }
        });
        archiveCallables.add(new ParallelExecutor.SequentialCallable<Object>(jenkinsMaster.getName()){

            @Override
            public Object call() {
                BaseBuild.this._archiveTestReportJSON();
                return null;
            }
        });
        return archiveCallables;
    }

    protected File getArchiveFile(String urlSuffix) {
        JenkinsMaster jenkinsMaster = this.getJenkinsMaster();
        if (jenkinsMaster == null) {
            return null;
        }
        return new File(this.getArchiveRootDir(), this.getArchivePath() + "/" + urlSuffix);
    }

    protected String getArchiveFileContent(String urlSuffix) {
        if (!Objects.equals(this.getStatus(), "completed")) {
            return null;
        }
        File archiveFile = this.getArchiveFile(urlSuffix);
        if (archiveFile == null || !archiveFile.exists()) {
            return null;
        }
        try {
            return JenkinsResultsParserUtil.read(archiveFile);
        }
        catch (IOException ioException) {
            return null;
        }
    }

    protected List<Element> getArchiveFileElements(String urlSuffix) {
        String archiveFileContent = this.getArchiveFileContent(urlSuffix);
        if (JenkinsResultsParserUtil.isNullOrEmpty(archiveFileContent)) {
            return new ArrayList<Element>();
        }
        try {
            Document document = Dom4JUtil.parse(archiveFileContent);
            Element rootElement = document.getRootElement();
            ArrayList<Element> elements = new ArrayList<Element>();
            for (Element element : rootElement.elements()) {
                element.detach();
                elements.add(element);
            }
            return elements;
        }
        catch (DocumentException documentException) {
            throw new RuntimeException(documentException);
        }
    }

    protected String getBaseGitRepositoryType() {
        if (this._jobName.startsWith("test-subrepository-acceptance-pullrequest")) {
            return this.getBaseGitRepositoryName();
        }
        if (this._jobName.contains("portal")) {
            return "portal";
        }
        if (this._jobName.contains("plugins")) {
            return "plugins";
        }
        return "jenkins";
    }

    protected Build.BranchInformation getBranchInformation(String repositoryType) {
        Build.BranchInformation branchInformation = this._branchInformationMap.get(repositoryType);
        if (branchInformation == null) {
            branchInformation = new DefaultBranchInformation(this, repositoryType);
            String repositoryName = branchInformation.getRepositoryName();
            if (repositoryName == null) {
                return null;
            }
            this._branchInformationMap.put(repositoryType, branchInformation);
        }
        return this._branchInformationMap.get(repositoryType);
    }

    protected String getBuildMessage() {
        if (this._jobName != null) {
            String status = this.getStatus();
            StringBuilder sb = new StringBuilder();
            sb.append("Build \"");
            sb.append(this.getBuildName());
            sb.append("\"");
            if (status.equals("completed")) {
                sb.append(" completed at ");
                sb.append(this.getBuildURL());
                sb.append(". ");
                sb.append(this.getResult());
                return sb.toString();
            }
            if (status.equals("missing")) {
                sb.append(" is missing ");
                sb.append(this.getJobURL());
                sb.append("/.");
                return sb.toString();
            }
            if (status.equals("queued")) {
                sb.append(" is queued at ");
                sb.append(this.getJobURL());
                sb.append("/.");
                return sb.toString();
            }
            if (status.equals("reporting")) {
                sb.append(" reporting at ");
                sb.append(this.getBuildURL());
                sb.append(".");
                return sb.toString();
            }
            if (status.equals("running")) {
                Build.Invocation previousInvocation = this.getPreviousInvocation();
                if (previousInvocation != null) {
                    sb.append(" ");
                    sb.append(previousInvocation.getBuildURL());
                    sb.append(" restarted at ");
                } else {
                    sb.append(" started at ");
                }
                sb.append(this.getBuildURL());
                sb.append(".");
                return sb.toString();
            }
            if (status.equals("starting")) {
                String jobURL = this.getJobURL();
                if (JenkinsResultsParserUtil.isNullOrEmpty(jobURL)) {
                    JenkinsCohort jenkinsCohort = this.getJenkinsCohort();
                    jobURL = JenkinsResultsParserUtil.combine("https://", jenkinsCohort.getName(), ".liferay.com/job/", this.getJobName());
                }
                sb.append(" invoked at ");
                sb.append(jobURL);
                sb.append("/.");
                return sb.toString();
            }
            throw new RuntimeException("Unknown status: " + status);
        }
        return "";
    }

    protected Element getBuildTimeElement() {
        return Dom4JUtil.getNewElement("p", null, "Build Time: ", JenkinsResultsParserUtil.toDurationString(this.getDuration()));
    }

    protected MultiPattern getBuildURLMultiPattern() {
        return _buildURLMultiPattern;
    }

    protected String getDiffDurationString(long diffDuration) {
        String diffDurationPrefix = "";
        if (diffDuration < 0L) {
            diffDurationPrefix = "-";
            diffDuration *= -1L;
        } else if (diffDuration > 0L) {
            diffDurationPrefix = "+";
        }
        return JenkinsResultsParserUtil.combine(diffDurationPrefix, JenkinsResultsParserUtil.toDurationString(diffDuration));
    }

    protected ExecutorService getExecutorService() {
        return null;
    }

    protected Element getExpanderAnchorElement(String expanderName, String namespace) {
        Element expanderAnchorElement = Dom4JUtil.getNewAnchorElement("", "+ ");
        expanderAnchorElement.addAttribute("id", JenkinsResultsParserUtil.combine(namespace, "-expander-anchor-", expanderName));
        expanderAnchorElement.addAttribute("onClick", JenkinsResultsParserUtil.combine("return toggleStopWatchRecordExpander('", namespace, "', '", expanderName, "')"));
        expanderAnchorElement.addAttribute("style", "font-family: monospace, monospace; text-decoration: none");
        return expanderAnchorElement;
    }

    protected Element getFailureMessageElement() {
        for (FailureMessageGenerator failureMessageGenerator : this.getFailureMessageGenerators()) {
            Element failureMessage = failureMessageGenerator.getMessageElement(this);
            if (failureMessage == null) continue;
            return failureMessage;
        }
        return null;
    }

    protected FailureMessageGenerator[] getFailureMessageGenerators() {
        return _FAILURE_MESSAGE_GENERATORS;
    }

    protected Element getFullConsoleClickHereElement() {
        return Dom4JUtil.getNewElement("h5", null, "For full console, click ", Dom4JUtil.getNewAnchorElement(this.getBuildURL() + "/consoleText", "here"), ".");
    }

    protected abstract Element getGitHubMessageJobResultsElement();

    protected Element getGitHubMessageJobResultsElement(boolean showCommonFailuresCount) {
        return this.getGitHubMessageJobResultsElement();
    }

    protected List<Element> getJenkinsReportBuildDurationsElements() {
        return new ArrayList<Element>();
    }

    protected String getJenkinsReportBuildInfoCellElementTagName() {
        return "td";
    }

    protected List<Element> getJenkinsReportStopWatchRecordElements() {
        String urlSuffix = "stopWatchRecordElements";
        if (this.archiveFileExists(urlSuffix)) {
            return this.getArchiveFileElements(urlSuffix);
        }
        ArrayList<Element> jenkinsReportStopWatchRecordTableRowElements = new ArrayList<Element>();
        Element stopWatchRecordHeaderRowElement = Dom4JUtil.getNewElement("tr");
        stopWatchRecordHeaderRowElement.addAttribute("id", this.hashCode() + "-stop-watch-record-header");
        stopWatchRecordHeaderRowElement.addAttribute("style", "display: none");
        Element headerDataElement = Dom4JUtil.getNewElement("td", stopWatchRecordHeaderRowElement, this.getExpanderAnchorElement("stop-watch-record-header", String.valueOf(this.hashCode())), Dom4JUtil.getNewElement("u", null, "Stop Watch Record"));
        headerDataElement.addAttribute("style", JenkinsResultsParserUtil.combine("text-indent: ", String.valueOf(this.getDepth() * 35), "px"));
        jenkinsReportStopWatchRecordTableRowElements.add(stopWatchRecordHeaderRowElement);
        StopWatchRecordsGroup stopWatchRecordsGroup = this.getStopWatchRecordsGroup();
        if (!stopWatchRecordsGroup.isEmpty()) {
            ArrayList<String> childStopWatchRecordNames = new ArrayList<String>(stopWatchRecordsGroup.size());
            for (StopWatchRecord stopWatchRecord : stopWatchRecordsGroup) {
                childStopWatchRecordNames.add(stopWatchRecord.getName());
            }
            stopWatchRecordHeaderRowElement.addAttribute("child-stopwatch-rows", JenkinsResultsParserUtil.join(",", childStopWatchRecordNames));
        }
        for (StopWatchRecord stopWatchRecord : this.getStopWatchRecordsGroup()) {
            jenkinsReportStopWatchRecordTableRowElements.addAll(this._getStopWatchRecordTableRowElements(stopWatchRecord));
        }
        this.archiveFileElements(urlSuffix, jenkinsReportStopWatchRecordTableRowElements);
        return jenkinsReportStopWatchRecordTableRowElements;
    }

    protected Element getJenkinsReportTableRowElement() {
        String cellElementTagName = this.getJenkinsReportBuildInfoCellElementTagName();
        Element stopWatchRecordsExpanderAnchorElement = this.getStopWatchRecordsExpanderAnchorElement();
        Element nameCellElement = Dom4JUtil.getNewElement(cellElementTagName, null, stopWatchRecordsExpanderAnchorElement, Dom4JUtil.getNewAnchorElement(this.getBuildURL(), null, this.getDisplayName()));
        int indent = this.getDepth() * 35;
        if (stopWatchRecordsExpanderAnchorElement != null) {
            indent -= 20;
        }
        nameCellElement.addAttribute("style", "text-indent: " + indent);
        Element buildInfoElement = Dom4JUtil.getNewElement("tr", null, nameCellElement, Dom4JUtil.getNewElement(cellElementTagName, null, Dom4JUtil.getNewAnchorElement(this.getBuildURL() + "console", null, "Console")), Dom4JUtil.getNewElement(cellElementTagName, null, Dom4JUtil.getNewAnchorElement(this.getBuildURL() + "testReport", "Test Report")));
        ArrayList<String> childStopWatchRows = new ArrayList<String>();
        if (this.buildDurationsEnabled()) {
            childStopWatchRows.add("build-durations-header");
            childStopWatchRows.add("test-durations-header");
        }
        childStopWatchRows.add("stop-watch-record-header");
        buildInfoElement.addAttribute("child-stopwatch-rows", JenkinsResultsParserUtil.join(",", childStopWatchRows));
        buildInfoElement.addAttribute("id", String.valueOf(this.hashCode()) + "-");
        this.getStartTime();
        if (this.startTime == null) {
            Dom4JUtil.addToElement(buildInfoElement, Dom4JUtil.getNewElement(cellElementTagName, null, "", this.getJenkinsReportTimeZoneName()));
        } else {
            Dom4JUtil.addToElement(buildInfoElement, Dom4JUtil.getNewElement(cellElementTagName, null, this.toJenkinsReportDateString(new Date(this.startTime), this.getJenkinsReportTimeZoneName())));
        }
        long duration = this.getDuration();
        Dom4JUtil.addToElement(buildInfoElement, Dom4JUtil.getNewElement(cellElementTagName, null, JenkinsResultsParserUtil.toDurationString(duration)));
        Element estimatedDurationElement = null;
        Element diffDurationElement = null;
        if (this.buildDurationsEnabled()) {
            String estimatedDurationString = "n/a";
            String diffDurationString = "n/a";
            if (this instanceof DownstreamBuild) {
                DownstreamBuild downstreamBuild = (DownstreamBuild)this;
                long averageDuration = downstreamBuild.getAverageDuration();
                estimatedDurationString = JenkinsResultsParserUtil.toDurationString(averageDuration);
                diffDurationString = this.getDiffDurationString(duration - averageDuration);
            }
            estimatedDurationElement = Dom4JUtil.getNewElement(cellElementTagName, null, estimatedDurationString);
            diffDurationElement = Dom4JUtil.getNewElement(cellElementTagName, null, diffDurationString);
        }
        Dom4JUtil.addToElement(buildInfoElement, estimatedDurationElement);
        Dom4JUtil.addToElement(buildInfoElement, diffDurationElement);
        String currentStatus = this.getStatus();
        currentStatus = currentStatus != null ? StringUtils.upperCase((String)currentStatus) : "";
        Dom4JUtil.getNewElement(cellElementTagName, buildInfoElement, currentStatus);
        String result = this.getResult();
        if (result == null) {
            result = "";
        }
        Dom4JUtil.getNewElement(cellElementTagName, buildInfoElement, result);
        return buildInfoElement;
    }

    protected List<Element> getJenkinsReportTableRowElements(String result, String status) {
        ArrayList<Element> tableRowElements = new ArrayList<Element>();
        if (this.getParentBuild() != null && (result == null || result.equals(this.getResult())) && (status == null || status.equals(this.getStatus()))) {
            tableRowElements.add(this.getJenkinsReportTableRowElement());
            if (this.buildDurationsEnabled()) {
                tableRowElements.addAll(this.getJenkinsReportBuildDurationsElements());
                tableRowElements.addAll(this.getJenkinsReportTestDurationsElements());
            }
            tableRowElements.addAll(this.getJenkinsReportStopWatchRecordElements());
        }
        return tableRowElements;
    }

    protected List<Element> getJenkinsReportTestDurationsElements() {
        return new ArrayList<Element>();
    }

    protected String getJenkinsReportTimeZoneName() {
        return _NAME_JENKINS_REPORT_TIME_ZONE;
    }

    protected Map<String, String> getParameters(JSONArray jsonArray) {
        HashMap<String, String> parameters = new HashMap<String, String>(jsonArray.length());
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            parameters.put(jsonObject.getString("name"), jsonObject.optString("value"));
        }
        return parameters;
    }

    protected Map<String, String> getParameters(JSONObject buildJSONObject) {
        JSONArray actionsJSONArray = buildJSONObject.getJSONArray("actions");
        if (actionsJSONArray.length() == 0) {
            return new HashMap<String, String>();
        }
        JSONObject parametersActionsJSONObject = null;
        for (int i = 0; i < actionsJSONArray.length(); ++i) {
            JSONObject actionsJSONObject = actionsJSONArray.getJSONObject(i);
            if (!Objects.equals(actionsJSONObject.optString("_class"), "hudson.model.ParametersAction")) continue;
            parametersActionsJSONObject = actionsJSONObject;
            break;
        }
        if (parametersActionsJSONObject != null && parametersActionsJSONObject.has("parameters")) {
            JSONArray parametersJSONArray = parametersActionsJSONObject.getJSONArray("parameters");
            return this.getParameters(parametersJSONArray);
        }
        return new HashMap<String, String>();
    }

    protected String getStartPropertiesTempMapURL() {
        if (this.fromArchive) {
            return this.getBuildURL() + "/start.properties.json";
        }
        return this.getParameterValue("JSON_MAP_URL");
    }

    protected String getStopPropertiesTempMapURL() {
        return null;
    }

    protected Element getStopWatchRecordExpanderAnchorElement(StopWatchRecord stopWatchRecord, String namespace) {
        Set<StopWatchRecord> childStopWatchRecords = stopWatchRecord.getChildStopWatchRecords();
        if (childStopWatchRecords == null) {
            return null;
        }
        return this.getExpanderAnchorElement(stopWatchRecord.getName(), namespace);
    }

    protected Element getStopWatchRecordsExpanderAnchorElement() {
        StopWatchRecordsGroup stopWatchRecordsGroup = this.getStopWatchRecordsGroup();
        if (stopWatchRecordsGroup.isEmpty()) {
            return null;
        }
        Element stopWatchRecordsExpanderAnchorElement = Dom4JUtil.getNewAnchorElement("", "+ ");
        String hashCode = String.valueOf(this.hashCode());
        stopWatchRecordsExpanderAnchorElement.addAttribute("id", JenkinsResultsParserUtil.combine(hashCode, "-expander-anchor-"));
        stopWatchRecordsExpanderAnchorElement.addAttribute("onClick", JenkinsResultsParserUtil.combine("return toggleStopWatchRecordExpander('", hashCode, "', '')"));
        stopWatchRecordsExpanderAnchorElement.addAttribute("style", "font-family: monospace, monospace; text-decoration: none");
        return stopWatchRecordsExpanderAnchorElement;
    }

    protected Map<String, String> getTempMap(String tempMapName) {
        String tempMapURL = this.getTempMapURL(tempMapName);
        if (tempMapURL == null) {
            return this.getTempMapFromBuildDatabase(tempMapName);
        }
        JSONObject tempMapJSONObject = null;
        try {
            tempMapJSONObject = JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil.getLocalURL(tempMapURL), false, 0, 0, 0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (tempMapJSONObject == null || !tempMapJSONObject.has("properties")) {
            return this.getTempMapFromBuildDatabase(tempMapName);
        }
        JSONArray propertiesJSONArray = tempMapJSONObject.getJSONArray("properties");
        HashMap<String, String> tempMap = new HashMap<String, String>(propertiesJSONArray.length());
        for (int i = 0; i < propertiesJSONArray.length(); ++i) {
            JSONObject propertyJSONObject = propertiesJSONArray.getJSONObject(i);
            String key = propertyJSONObject.getString("name");
            String value = propertyJSONObject.optString("value");
            if (value == null || value.isEmpty()) continue;
            tempMap.put(key, value);
        }
        return tempMap;
    }

    protected Map<String, String> getTempMapFromBuildDatabase(String tempMapName) {
        HashMap<String, String> tempMap = new HashMap<String, String>();
        if (!this.fromArchive) {
            BuildDatabase buildDatabase = this.getBuildDatabase();
            Properties properties = buildDatabase.getProperties(tempMapName);
            for (String propertyName : properties.stringPropertyNames()) {
                tempMap.put(propertyName, properties.getProperty(propertyName));
            }
        }
        return tempMap;
    }

    protected String getTempMapURL(String tempMapName) {
        if (tempMapName.equals("start.properties")) {
            return this.getStartPropertiesTempMapURL();
        }
        if (tempMapName.equals("stop.properties")) {
            return this.getStopPropertiesTempMapURL();
        }
        return null;
    }

    protected int getTestCountByStatus(String status) {
        JSONObject testReportJSONObject = this.getTestReportJSONObject(false);
        if (testReportJSONObject == null) {
            return 0;
        }
        if (status.equals("FAILURE")) {
            return testReportJSONObject.getInt("failCount");
        }
        if (status.equals("SUCCESS")) {
            return testReportJSONObject.getInt("passCount");
        }
        throw new IllegalArgumentException("Invalid status: " + status);
    }

    protected List<TestResult> getTestResults(Build build, JSONArray suitesJSONArray, String testStatus) {
        ArrayList<TestResult> testResults = new ArrayList<TestResult>();
        for (int i = 0; i < suitesJSONArray.length(); ++i) {
            JSONObject suiteJSONObject = suitesJSONArray.getJSONObject(i);
            JSONArray casesJSONArray = suiteJSONObject.getJSONArray("cases");
            for (int j = 0; j < casesJSONArray.length(); ++j) {
                TestResult testResult = TestResultFactory.newTestResult(build, casesJSONArray.getJSONObject(j));
                if (testStatus != null && !testStatus.equals(testResult.getStatus())) continue;
                testResults.add(testResult);
            }
        }
        return testResults;
    }

    protected boolean isParentBuildRoot() {
        if (this._parentBuild == null) {
            return false;
        }
        return this._parentBuild.getParentBuild() == null && this._parentBuild instanceof TopLevelBuild;
    }

    protected void loadParametersFromBuildJSONObject() {
        if (this.getBuildURL() == null) {
            return;
        }
        JSONObject buildJSONObject = this.getBuildJSONObject("actions[parameters[*]]");
        JSONArray actionsJSONArray = buildJSONObject.getJSONArray("actions");
        if (actionsJSONArray.length() == 0) {
            this._parameters = new HashMap<String, String>();
            return;
        }
        for (int i = 0; i < actionsJSONArray.length(); ++i) {
            JSONObject actionJSONObject = actionsJSONArray.getJSONObject(i);
            if (!actionJSONObject.has("parameters")) continue;
            JSONArray parametersJSONArray = actionJSONObject.getJSONArray("parameters");
            this._parameters = new HashMap<String, String>(parametersJSONArray.length());
            for (int j = 0; j < parametersJSONArray.length(); ++j) {
                String valueString;
                JSONObject parameterJSONObject = parametersJSONArray.getJSONObject(j);
                Object value = parameterJSONObject.opt("value");
                if (!(value instanceof String) || (valueString = value.toString()).isEmpty()) continue;
                this._parameters.put(parameterJSONObject.getString("name"), value.toString());
            }
            return;
        }
        this._parameters = Collections.emptyMap();
    }

    protected void loadParametersFromQueryString(String queryString) {
        for (String parameter : queryString.split("&")) {
            if (!parameter.contains("=")) continue;
            String[] nameValueArray = parameter.split("=");
            if (nameValueArray.length == 2) {
                this._parameters.put(nameValueArray[0], nameValueArray[1]);
                continue;
            }
            if (nameValueArray.length != 1) continue;
            this._parameters.put(nameValueArray[0], "");
        }
    }

    protected void setJobName(String jobName) {
        this._jobName = jobName;
        Matcher matcher = jobNamePattern.matcher(jobName);
        if (matcher.find()) {
            this._branchName = matcher.group("branchName");
            return;
        }
        this._branchName = "master";
    }

    protected boolean skipUpdate() {
        return !this.isBuildModified() && Objects.equals(this.getStatus(), "completed");
    }

    protected String toJenkinsReportDateString(Date date, String timeZoneName) {
        Properties buildProperties = null;
        try {
            buildProperties = JenkinsResultsParserUtil.getBuildProperties();
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to get build properties", ioException);
        }
        return JenkinsResultsParserUtil.toDateString(date, buildProperties.getProperty("jenkins.report.date.format"), timeZoneName);
    }

    protected void writeArchiveFile(String content, String path) throws IOException {
        JenkinsResultsParserUtil.write(new File(this.getArchiveRootDir(), path), JenkinsResultsParserUtil.redact(this.replaceBuildURL(content)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void _archive(String content, boolean required, String urlSuffix) {
        boolean readyToArchive = true;
        if (!Objects.equals(this.getStatus(), "completed")) {
            readyToArchive = false;
        } else if (!(this instanceof TopLevelBuild)) {
            JSONObject buildJSONObject = JenkinsAPIUtil.getAPIJSONObject(this.getBuildURL(), "duration");
            if (buildJSONObject != null) {
                long duration = buildJSONObject.optLong("duration", 0L);
                if (duration == 0L) {
                    readyToArchive = false;
                }
            } else {
                readyToArchive = false;
            }
        }
        JenkinsMaster jenkinsMaster = this.getJenkinsMaster();
        if (jenkinsMaster == null) {
            return;
        }
        File archiveFile = this.getArchiveFile(urlSuffix);
        if (!readyToArchive) {
            if (!archiveFile.exists()) return;
            JenkinsResultsParserUtil.delete(archiveFile);
            return;
        }
        if (archiveFile.exists()) {
            return;
        }
        long start = JenkinsResultsParserUtil.getCurrentTimeMillis();
        String urlString = this.getBuildURL() + urlSuffix;
        if (urlString.endsWith("json")) {
            urlString = urlString + "?pretty";
        }
        urlSuffix = JenkinsResultsParserUtil.fixFileName(urlSuffix);
        if (JenkinsResultsParserUtil.isNullOrEmpty(content)) {
            try {
                int maxRetries = 0;
                int retryPeriodSeconds = 0;
                if (required) {
                    maxRetries = 2;
                    retryPeriodSeconds = 5;
                }
                content = JenkinsResultsParserUtil.toString(JenkinsResultsParserUtil.getLocalURL(urlString), false, maxRetries, retryPeriodSeconds, 0, true);
            }
            catch (IOException ioException) {
                if (!required) return;
                throw new RuntimeException("Unable to archive " + urlString, ioException);
            }
        }
        if (JenkinsResultsParserUtil.isNullOrEmpty(content)) {
            return;
        }
        try {
            this.writeArchiveFile(content, this.getArchivePath() + "/" + urlSuffix);
            if (!JenkinsResultsParserUtil.debug) return;
        }
        catch (IOException ioException) {
            try {
                throw new RuntimeException("Unable to write file", ioException);
            }
            catch (Throwable throwable) {
                if (!JenkinsResultsParserUtil.debug) throw throwable;
                System.out.println(JenkinsResultsParserUtil.combine("Archived ", String.valueOf(this.getArchiveFile(urlSuffix)), " in ", JenkinsResultsParserUtil.toDurationString(JenkinsResultsParserUtil.getCurrentTimeMillis() - start)));
                throw throwable;
            }
        }
        System.out.println(JenkinsResultsParserUtil.combine("Archived ", String.valueOf(this.getArchiveFile(urlSuffix)), " in ", JenkinsResultsParserUtil.toDurationString(JenkinsResultsParserUtil.getCurrentTimeMillis() - start)));
        return;
    }

    private void _archiveBuildJSON() {
        this._archive(null, true, "api/json");
    }

    private void _archiveConsoleLog() {
        this._archive(this.getConsoleText(), true, "consoleText");
    }

    private void _archiveMarkerFile() {
        this._archive(String.valueOf(JenkinsResultsParserUtil.getCurrentTimeMillis()), true, "archive-marker");
    }

    private void _archiveTestReportJSON() {
        this._archive(null, false, "testReport/api/json");
    }

    private List<Element> _getStopWatchRecordTableRowElements(StopWatchRecord stopWatchRecord) {
        Element buildInfoElement = Dom4JUtil.getNewElement("tr", null, new Object[0]);
        String buildHashCode = String.valueOf(this.hashCode());
        buildInfoElement.addAttribute("id", buildHashCode + "-" + stopWatchRecord.getName());
        buildInfoElement.addAttribute("style", "display: none");
        Element expanderAnchorElement = this.getStopWatchRecordExpanderAnchorElement(stopWatchRecord, buildHashCode);
        Element nameElement = Dom4JUtil.getNewElement("td", buildInfoElement, expanderAnchorElement, stopWatchRecord.getShortName());
        int indent = (this.getDepth() + stopWatchRecord.getDepth() + 1) * 35;
        if (expanderAnchorElement != null) {
            indent -= 20;
        }
        nameElement.addAttribute("style", JenkinsResultsParserUtil.combine("text-indent: ", String.valueOf(indent), "px"));
        Dom4JUtil.getNewElement("td", buildInfoElement, "&nbsp;");
        Dom4JUtil.getNewElement("td", buildInfoElement, "&nbsp;");
        Dom4JUtil.getNewElement("td", buildInfoElement, this.toJenkinsReportDateString(new Date(stopWatchRecord.getStartTimestamp()), this.getJenkinsReportTimeZoneName()));
        Long duration = stopWatchRecord.getDuration();
        if (duration == null) {
            Dom4JUtil.getNewElement("td", buildInfoElement, "&nbsp;");
        } else {
            Dom4JUtil.getNewElement("td", buildInfoElement, JenkinsResultsParserUtil.toDurationString(stopWatchRecord.getDuration()));
        }
        Dom4JUtil.getNewElement("td", buildInfoElement, "&nbsp;");
        Dom4JUtil.getNewElement("td", buildInfoElement, "&nbsp;");
        ArrayList<Element> jenkinsReportTableRowElements = new ArrayList<Element>();
        jenkinsReportTableRowElements.add(buildInfoElement);
        Set<StopWatchRecord> childStopWatchRecords = stopWatchRecord.getChildStopWatchRecords();
        if (childStopWatchRecords != null) {
            ArrayList<String> childStopWatchRecordNames = new ArrayList<String>(childStopWatchRecords.size());
            for (StopWatchRecord childStopWatchRecord : childStopWatchRecords) {
                childStopWatchRecordNames.add(childStopWatchRecord.getName());
                List<Element> childJenkinsReportTableRowElements = this._getStopWatchRecordTableRowElements(childStopWatchRecord);
                for (Element childJenkinsReportTableRowElement : childJenkinsReportTableRowElements) {
                    childJenkinsReportTableRowElement.addAttribute("style", "display: none");
                }
                jenkinsReportTableRowElements.addAll(childJenkinsReportTableRowElements);
            }
            buildInfoElement.addAttribute("child-stopwatch-rows", JenkinsResultsParserUtil.join(",", childStopWatchRecordNames));
        }
        return jenkinsReportTableRowElements;
    }

    private synchronized void _initTestClassResults() {
        if (!this.isCompleted() || this._testClassResults != null) {
            return;
        }
        JSONObject testReportJSONObject = null;
        try {
            testReportJSONObject = this.getTestReportJSONObject(true);
        }
        catch (RuntimeException runtimeException) {
            this._testClassResults = new ConcurrentHashMap<String, TestClassResult>();
            return;
        }
        this._testClassResults = new ConcurrentHashMap<String, TestClassResult>();
        if (testReportJSONObject == null || testReportJSONObject.isEmpty()) {
            return;
        }
        ArrayList<JSONArray> suitesJSONArrays = new ArrayList<JSONArray>();
        if (testReportJSONObject.has("suites")) {
            suitesJSONArrays.add(testReportJSONObject.getJSONArray("suites"));
        } else if (testReportJSONObject.has("childReports")) {
            JSONArray childReportsJSONArray = testReportJSONObject.getJSONArray("childReports");
            for (int i = 0; i < childReportsJSONArray.length(); ++i) {
                JSONObject resultJSONObject;
                JSONObject childReportJSONObject = childReportsJSONArray.getJSONObject(i);
                if (!childReportJSONObject.has("result") || !(resultJSONObject = childReportJSONObject.getJSONObject("result")).has("suites")) continue;
                suitesJSONArrays.add(resultJSONObject.getJSONArray("suites"));
            }
        }
        for (JSONArray suitesJSONArray : suitesJSONArrays) {
            for (int i = 0; i < suitesJSONArray.length(); ++i) {
                JSONObject suiteJSONObject = suitesJSONArray.getJSONObject(i);
                TestClassResult testClassResult = TestClassResultFactory.newTestClassResult(this, suiteJSONObject);
                this._testClassResults.put(testClassResult.getClassName(), testClassResult);
            }
        }
    }

    private boolean _isDifferent(String newValue, String oldValue) {
        if (oldValue == null) {
            return newValue != null;
        }
        return !oldValue.equals(newValue);
    }

    private void _setBuildURL(String buildURL) {
        try {
            buildURL = JenkinsResultsParserUtil.decode(buildURL);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException("Unable to decode " + buildURL, unsupportedEncodingException);
        }
        Build parentBuild = this.getParentBuild();
        try {
            String archiveMarkerContent;
            this.fromArchive = parentBuild != null ? parentBuild.isFromArchive() : (archiveMarkerContent = JenkinsResultsParserUtil.toString(buildURL + "/archive-marker", false, 0, 0, 0)) != null && !archiveMarkerContent.isEmpty();
        }
        catch (IOException ioException) {
            this.fromArchive = false;
        }
        MultiPattern buildURLMultiPattern = this.getBuildURLMultiPattern();
        Matcher matcher = buildURLMultiPattern.find(buildURL);
        if (matcher == null) {
            Pattern archiveBuildURLPattern = this.getArchiveBuildURLPattern();
            matcher = archiveBuildURLPattern.matcher(buildURL);
            if (!matcher.find()) {
                throw new IllegalArgumentException("Invalid build URL " + buildURL);
            }
            this.setArchiveName(matcher.group("archiveName"));
        }
        this.setBuildURL(JenkinsResultsParserUtil.getRemoteURL(buildURL));
        JenkinsMaster jenkinsMaster = JenkinsMaster.getInstance(matcher.group("master"));
        this.setJenkinsMaster(jenkinsMaster);
        this.setJenkinsCohort(jenkinsMaster.getJenkinsCohort());
        this.setJobName(matcher.group("jobName"));
        this.loadParametersFromBuildJSONObject();
        this.reset();
        JSONObject buildJSONObject = this.getBuildJSONObject("result,queueId,url");
        Build.Invocation invocation = new Build.Invocation(this, jenkinsMaster, buildJSONObject.getLong("queueId"));
        invocation.setBuildURL(buildJSONObject.getString("url"));
        this.addInvocation(invocation);
        String result = buildJSONObject.optString("result");
        if (!JenkinsResultsParserUtil.isNullOrEmpty(result)) {
            this.fromCompletedBuild = this.isFromCompletedBuild();
            this.setResult(result);
            this.setStatus("completed");
        } else {
            this.setStatus("running");
        }
    }

    private void _setInvocationURL(String invocationURL) {
        if (this.getBuildURL() != null) {
            return;
        }
        try {
            invocationURL = JenkinsResultsParserUtil.decode(invocationURL);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException("Unable to decode " + invocationURL, unsupportedEncodingException);
        }
        Matcher invocationURLMatcher = _invocationURLPattern.matcher(invocationURL);
        if (!invocationURLMatcher.find()) {
            throw new RuntimeException("Invalid invocation URL");
        }
        this.setJobName(invocationURLMatcher.group("jobName"));
        JenkinsCohort jenkinsCohort = JenkinsCohort.getInstance(invocationURLMatcher.group("cohortName"));
        this.loadParametersFromQueryString(invocationURL);
        String masterId = invocationURLMatcher.group("masterId");
        if (JenkinsResultsParserUtil.isInteger(masterId)) {
            this.setJenkinsMaster(JenkinsMaster.getInstance(jenkinsCohort.getName() + "-" + masterId));
        }
        this.setStatus("starting");
    }

    static {
        _TOKENS_HIGH_PRIORITY_CONTENT = new String[]{"compileJSP", "SourceFormatter.format", "Unable to compile JSPs"};
        _buildURLMultiPattern = new MultiPattern(JenkinsResultsParserUtil.combine("\\w+://(?<master>[^/]+)/+job/+(?<jobName>[^/]+(/label=[^/]+)?)/", "(?<buildNumber>\\d+)/?"));
        _invocationURLPattern = Pattern.compile(JenkinsResultsParserUtil.combine("\\w+://(?<cohortName>test-\\d+)(-(?<masterId>\\d+))?", "(\\.liferay\\.com)?/+job\\/+(?<jobName>[^\\/]+).*\\/", "buildWithParameters\\?(?<queryString>.*)"));
        _testrayAttachmentURLPattern = Pattern.compile("\\[beanshell\\] Uploaded (?<url>https://testray.liferay.com/[^\\s]+)");
        _testrayS3ObjectURLPattern = Pattern.compile(JenkinsResultsParserUtil.combine("\\[beanshell\\] Created S3 Object (?<url>", "https://storage.cloud.google.com/[^\\s?]+).*"));
        Properties properties = null;
        try {
            properties = JenkinsResultsParserUtil.getBuildProperties();
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to get build properties", ioException);
        }
        _NAME_JENKINS_REPORT_TIME_ZONE = properties.getProperty("jenkins.report.time.zone");
    }

    public static class DefaultBranchInformation
    implements Build.BranchInformation {
        private String _branchInformationString;
        private final Build _build;
        private final String _repositoryType;

        @Override
        public String getCachedRemoteGitRefName() {
            return JenkinsResultsParserUtil.combine("cache-", this.getReceiverUsername(), "-", this.getUpstreamBranchSHA(), "-", this.getOriginName(), "-", this.getSenderBranchSHA());
        }

        @Override
        public String getOriginName() {
            String regex;
            String branchInformationString = this._getBranchInformationString();
            if (branchInformationString.matches(regex = "[\\S\\s]*github.origin.name=(.+)\\n[\\S\\s]*")) {
                return branchInformationString.replaceAll(regex, "$1");
            }
            return null;
        }

        @Override
        public Integer getPullRequestNumber() {
            String regex;
            String branchInformationString = this._getBranchInformationString();
            if (branchInformationString.matches(regex = "[\\S\\s]*github.pull.request.number=(\\d+)\\n[\\S\\s]*")) {
                return Integer.valueOf(branchInformationString.replaceAll(regex, "$1"));
            }
            return 0;
        }

        @Override
        public String getReceiverUsername() {
            String regex;
            String branchInformationString = this._getBranchInformationString();
            if (branchInformationString.matches(regex = "[\\S\\s]*github.receiver.username=(.+)\\n[\\S\\s]*")) {
                return branchInformationString.replaceAll(regex, "$1");
            }
            return null;
        }

        @Override
        public String getRepositoryName() {
            Properties buildProperties;
            try {
                buildProperties = JenkinsResultsParserUtil.getBuildProperties();
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
            String repositoryType = this._repositoryType;
            if (repositoryType.equals("portal.base") || repositoryType.equals("portal.ee")) {
                repositoryType = "portal";
            }
            return JenkinsResultsParserUtil.getProperty(buildProperties, repositoryType + ".repository", this.getUpstreamBranchName());
        }

        @Override
        public String getSenderBranchName() {
            String regex;
            String branchInformationString = this._getBranchInformationString();
            if (branchInformationString.matches(regex = "[\\S\\s]*github.sender.branch.name=(.+)\\n[\\S\\s]*")) {
                return branchInformationString.replaceAll(regex, "$1");
            }
            return null;
        }

        @Override
        public String getSenderBranchSHA() {
            String regex;
            String branchInformationString = this._getBranchInformationString();
            if (branchInformationString.matches(regex = "[\\S\\s]*github.sender.branch.sha=(.+)\\n[\\S\\s]*")) {
                return branchInformationString.replaceAll(regex, "$1");
            }
            return null;
        }

        @Override
        public String getSenderBranchSHAShort() {
            String senderBranchSHA = this.getSenderBranchSHA();
            if (senderBranchSHA == null) {
                return null;
            }
            if (senderBranchSHA.length() >= 7) {
                senderBranchSHA = senderBranchSHA.substring(0, 7);
            }
            return senderBranchSHA;
        }

        @Override
        public RemoteGitRef getSenderRemoteGitRef() {
            String remoteURL = JenkinsResultsParserUtil.combine("git@github.com:", this.getSenderUsername(), "/", this.getRepositoryName(), ".git");
            return GitUtil.getRemoteGitRef(this.getSenderBranchName(), new File("."), remoteURL);
        }

        @Override
        public String getSenderUsername() {
            String regex;
            String branchInformationString = this._getBranchInformationString();
            if (branchInformationString.matches(regex = "[\\S\\s]*github.sender.username=(.+)\\n[\\S\\s]*")) {
                return branchInformationString.replaceAll(regex, "$1");
            }
            return null;
        }

        @Override
        public String getUpstreamBranchName() {
            String regex;
            String branchInformationString = this._getBranchInformationString();
            if (branchInformationString.matches(regex = "[\\S\\s]*github.upstream.branch.name=(.+)\\n[\\S\\s]*")) {
                return branchInformationString.replaceAll(regex, "$1");
            }
            return null;
        }

        @Override
        public String getUpstreamBranchSHA() {
            String regex;
            String branchInformationString = this._getBranchInformationString();
            if (branchInformationString.matches(regex = "[\\S\\s]*github.upstream.branch.sha=(.+)\\n[\\S\\s]*")) {
                return branchInformationString.replaceAll(regex, "$1");
            }
            return null;
        }

        protected DefaultBranchInformation(Build build, String repositoryType) {
            this._build = build;
            this._repositoryType = repositoryType;
        }

        private String _getBranchInformationString() {
            if (this._branchInformationString != null) {
                return this._branchInformationString;
            }
            String consoleText = this._build.getConsoleText();
            int x = -1;
            Pattern pattern = Pattern.compile(JenkinsResultsParserUtil.combine("## (http://cloud-.*/)?git.", this._repositoryType, ".properties"));
            Matcher matcher = pattern.matcher(consoleText);
            if (matcher.find()) {
                x = matcher.start();
            }
            if (x == -1) {
                return "";
            }
            int y = consoleText.indexOf("prepare.repositories.", x);
            if (y == -1) {
                y = consoleText.indexOf("Deleting:", x);
            }
            if ((y = consoleText.indexOf("\n", y)) == -1) {
                return "";
            }
            this._branchInformationString = consoleText.substring(x, y);
            return this._branchInformationString;
        }
    }

    public static class BuildDisplayNameComparator
    implements Comparator<Build> {
        private static final Pattern _pattern = Pattern.compile("(?<batchName>[^/]+)/(?<segment>\\d+)(/(?<axis>\\d+))?");

        @Override
        public int compare(Build build1, Build build2) {
            Integer segment2;
            String batchName2;
            String axisName1 = this._getAxisName(build1);
            String axisName2 = this._getAxisName(build2);
            if (JenkinsResultsParserUtil.isNullOrEmpty(axisName1) || JenkinsResultsParserUtil.isNullOrEmpty(axisName2)) {
                String displayName1 = build1.getDisplayName();
                String displayName2 = build2.getDisplayName();
                return displayName1.compareTo(displayName2);
            }
            Matcher matcher1 = _pattern.matcher(axisName1);
            Matcher matcher2 = _pattern.matcher(axisName2);
            if (!matcher1.find() || !matcher2.find()) {
                String displayName1 = build1.getDisplayName();
                String displayName2 = build2.getDisplayName();
                return displayName1.compareTo(displayName2);
            }
            String batchName1 = matcher1.group("batchName");
            if (!batchName1.equals(batchName2 = matcher2.group("batchName"))) {
                return batchName1.compareTo(batchName2);
            }
            Integer segment1 = Integer.valueOf(matcher1.group("segment"));
            if (!segment1.equals(segment2 = Integer.valueOf(matcher2.group("segment")))) {
                return segment1.compareTo(segment2);
            }
            String axisString1 = matcher1.group("axis");
            String axisString2 = matcher2.group("axis");
            if (JenkinsResultsParserUtil.isNullOrEmpty(axisString1) || JenkinsResultsParserUtil.isNullOrEmpty(axisString2)) {
                String displayName1 = build1.getDisplayName();
                String displayName2 = build2.getDisplayName();
                return displayName1.compareTo(displayName2);
            }
            Integer axis1 = Integer.valueOf(axisString1);
            Integer axis2 = Integer.valueOf(axisString2);
            return axis1.compareTo(axis2);
        }

        private String _getAxisName(Build build) {
            if (build instanceof AxisBuild) {
                AxisBuild axisBuild = (AxisBuild)build;
                return axisBuild.getAxisNumber();
            }
            if (build instanceof DownstreamBuild) {
                DownstreamBuild downstreamBuild = (DownstreamBuild)build;
                return downstreamBuild.getAxisName();
            }
            return build.getJobVariant();
        }
    }
}

