/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BuildData;
import com.liferay.jenkins.results.parser.BuildDatabase;
import com.liferay.jenkins.results.parser.BuildDatabaseUtil;
import com.liferay.jenkins.results.parser.Host;
import com.liferay.jenkins.results.parser.HostFactory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class BaseBuildData
implements BuildData {
    protected static final BuildDatabase buildDatabase = BuildDatabaseUtil.getBuildDatabase();
    private static final String[] _KEYS_REQUIRED = new String[]{"build_description", "build_number", "build_url", "cohort_name", "hostname", "jenkins_github_url", "job_name", "master_hostname", "run_id", "workspace_dir"};
    private static final Pattern _buildURLPattern = Pattern.compile(JenkinsResultsParserUtil.combine("(?<jobURL>https?://(?<masterHostname>", "(?<cohortName>test-\\d+)-\\d+)(\\.liferay\\.com)?/job/", "(?<jobName>[^/]+)/(.*/)?)(?<buildNumber>\\d+)/?"));
    private static final Pattern _gitHubBranchURLPattern = Pattern.compile("https://github.com/(?<username>[^/]+)/(?<repositoryName>[^/]+)/tree/(?<branchName>.+)");
    private Map<String, String> _buildParameters;
    private Host _host;
    private final JSONObject _jsonObject;

    public static String getJobName(String buildURL) {
        if (buildURL == null) {
            return null;
        }
        Matcher matcher = _buildURLPattern.matcher(buildURL);
        if (!matcher.find()) {
            return null;
        }
        return matcher.group("jobName");
    }

    @Override
    public File getArtifactDir() {
        return new File(this.getWorkspaceDir(), this.getRunID());
    }

    @Override
    public String getBuildDescription() {
        return this.getString("build_description");
    }

    @Override
    public Long getBuildDuration() {
        return this.optLong("build_duration", 0L);
    }

    @Override
    public String getBuildDurationString() {
        return JenkinsResultsParserUtil.toDurationString(this.getBuildDuration());
    }

    @Override
    public Integer getBuildNumber() {
        return this.optInt("build_number");
    }

    @Override
    public String getBuildParameter(String key) {
        Map<String, String> buildParameters = this.getBuildParameters();
        return buildParameters.get(key);
    }

    @Override
    public Map<String, String> getBuildParameters() {
        if (this._buildParameters != null) {
            return this._buildParameters;
        }
        JSONObject buildURLJSONObject = this._getBuildURLJSONObject();
        if (buildURLJSONObject == null) {
            throw new RuntimeException("Please set the build URL");
        }
        if (!buildURLJSONObject.has("actions")) {
            return null;
        }
        JSONArray actionsJSONArray = buildURLJSONObject.getJSONArray("actions");
        for (int i = 0; i < actionsJSONArray.length(); ++i) {
            JSONObject actionsJSONObject = actionsJSONArray.getJSONObject(i);
            if (actionsJSONObject == null || !actionsJSONObject.has("parameters")) continue;
            JSONArray parametersJSONArray = actionsJSONObject.getJSONArray("parameters");
            this._buildParameters = new HashMap<String, String>();
            for (int j = 0; j < parametersJSONArray.length(); ++j) {
                JSONObject parameterJSONObject = parametersJSONArray.getJSONObject(j);
                if (parameterJSONObject == null || !parameterJSONObject.has("name") || !parameterJSONObject.has("value")) continue;
                this._buildParameters.put(parameterJSONObject.getString("name"), parameterJSONObject.getString("value"));
            }
            return this._buildParameters;
        }
        return null;
    }

    @Override
    public String getBuildResult() {
        return this.optString("build_result", "");
    }

    @Override
    public String getBuildStatus() {
        return this.optString("build_status", "");
    }

    @Override
    public String getBuildURL() {
        return this.optString("build_url");
    }

    @Override
    public String getCohortName() {
        return this.optString("cohort_name");
    }

    @Override
    public Host getHost() {
        if (this._host != null) {
            return this._host;
        }
        String hostname = this.getHostname();
        if (hostname == null) {
            return null;
        }
        this._host = HostFactory.newHost(hostname);
        return this._host;
    }

    @Override
    public String getHostname() {
        return this.optString("hostname");
    }

    @Override
    public String getJenkinsGitHubBranchName() {
        return this.getGitHubBranchName(this.getJenkinsGitHubURL());
    }

    @Override
    public String getJenkinsGitHubRepositoryName() {
        return this.getGitHubRepositoryName(this.getJenkinsGitHubURL());
    }

    @Override
    public String getJenkinsGitHubURL() {
        return this.getString("jenkins_github_url");
    }

    @Override
    public String getJenkinsGitHubUsername() {
        return this.getGitHubUsername(this.getJenkinsGitHubURL());
    }

    @Override
    public String getJobName() {
        return this.optString("job_name");
    }

    @Override
    public String getJobURL() {
        return this.optString("job_url");
    }

    @Override
    public JSONObject getJSONObject() {
        return this._jsonObject;
    }

    @Override
    public String getMasterHostname() {
        return this.optString("master_hostname");
    }

    @Override
    public String getRunID() {
        return this.getString("run_id");
    }

    @Override
    public Long getStartTime() {
        return this.getLong("start_time");
    }

    @Override
    public String getStartTimeString() {
        return this.getFormattedDate(this.getStartTime());
    }

    @Override
    public String getUserContentRelativePath() {
        return JenkinsResultsParserUtil.combine("jobs/", this.getTopLevelJobName(), "/builds/", String.valueOf(this.getTopLevelBuildNumber()), "/");
    }

    @Override
    public File getWorkspaceDir() {
        return this.getFile("workspace_dir");
    }

    @Override
    public void setBuildDescription(String buildDescription) {
        this.put("build_description", buildDescription);
    }

    @Override
    public void setBuildDuration(Long buildDuration) {
        this.put("build_duration", buildDuration);
    }

    @Override
    public void setBuildResult(String buildResult) {
        this.put("build_result", buildResult);
    }

    @Override
    public void setBuildStatus(String buildStatus) {
        this.put("build_status", buildStatus);
    }

    @Override
    public void setBuildURL(String buildURL) {
        String currentBuildURL = this.getBuildURL();
        if (currentBuildURL != null && !currentBuildURL.isEmpty() && !currentBuildURL.equals(buildURL)) {
            throw new IllegalStateException("Build URL may not be changed");
        }
        Matcher matcher = _buildURLPattern.matcher(buildURL);
        if (!matcher.find()) {
            throw new RuntimeException("Invalid build URL " + buildURL);
        }
        this.put("build_number", Integer.valueOf(matcher.group("buildNumber")));
        this.put("build_url", buildURL);
        this.put("cohort_name", matcher.group("cohortName"));
        this.put("hostname", this._getHostname());
        this.put("job_url", matcher.group("jobURL"));
        this.put("master_hostname", matcher.group("masterHostname"));
        this.put("start_time", this._getStartTime());
        this.put("type", this.getType());
    }

    @Override
    public void setInvocationTime(Long invocationTime) {
        this.put("invocation_time", invocationTime);
    }

    @Override
    public void setJenkinsGitHubURL(String jenkinsGitHubURL) {
        this.put("jenkins_github_url", jenkinsGitHubURL);
    }

    @Override
    public void setWorkspaceDir(File workspaceDir) {
        this.put("workspace_dir", JenkinsResultsParserUtil.getCanonicalPath(workspaceDir));
    }

    protected static boolean isValidJSONObject(JSONObject jsonObject, String type) {
        if (jsonObject == null || type == null) {
            return false;
        }
        return jsonObject.has("type") && type.equals(jsonObject.getString("type"));
    }

    protected BaseBuildData(String runID, String jobName, String buildURL) {
        JSONObject jsonObject = buildDatabase.getBuildDataJSONObject(runID);
        String json = jsonObject.toString();
        if (json.equals("{}") && buildURL != null) {
            try {
                jsonObject = buildDatabase.getBuildDataJSONObject(new URL(buildURL));
                if (jsonObject.has("run_id")) {
                    runID = jsonObject.getString("run_id");
                }
            }
            catch (MalformedURLException malformedURLException) {
                throw new RuntimeException(malformedURLException);
            }
        }
        this._jsonObject = jsonObject;
        this.put("run_id", runID);
        if (jobName == null) {
            throw new RuntimeException("Please set a job name");
        }
        this.put("job_name", jobName);
        if (buildURL == null) {
            return;
        }
        this.setBuildURL(buildURL);
        if (!this.has("build_description")) {
            this.setBuildDescription(this._getDefaultBuildDescription());
        }
        this.setJenkinsGitHubURL(JenkinsResultsParserUtil.getJenkinsGitHubURL());
        this.setWorkspaceDir(DIR_WORKSPACE_DEFAULT);
        this.validateKeys(_KEYS_REQUIRED);
    }

    protected File getFile(String key) {
        return new File(this.getString(key));
    }

    protected String getFormattedDate(Long timestamp) {
        return JenkinsResultsParserUtil.toDateString(new Date(timestamp), "MMM dd, yyyy h:mm:ss a z", "US/Pacific");
    }

    protected String getGitHubBranchName(String gitHubBranchURL) {
        Matcher matcher = _gitHubBranchURLPattern.matcher(gitHubBranchURL);
        if (!matcher.find()) {
            throw new RuntimeException("Invalid GitHub Branch URL " + gitHubBranchURL);
        }
        return matcher.group("branchName");
    }

    protected String getGitHubRepositoryName(String gitHubBranchURL) {
        Matcher matcher = _gitHubBranchURLPattern.matcher(gitHubBranchURL);
        if (!matcher.find()) {
            throw new RuntimeException("Invalid GitHub Branch URL " + gitHubBranchURL);
        }
        return matcher.group("repositoryName");
    }

    protected String getGitHubUsername(String gitHubBranchURL) {
        Matcher matcher = _gitHubBranchURLPattern.matcher(gitHubBranchURL);
        if (!matcher.find()) {
            throw new RuntimeException("Invalid GitHub Branch URL " + gitHubBranchURL);
        }
        return matcher.group("username");
    }

    protected JSONArray getJSONArray(String key) {
        return this._jsonObject.getJSONArray(key);
    }

    protected JSONObject getJSONObject(String key) {
        return this._jsonObject.getJSONObject(key);
    }

    protected List<String> getList(String key) {
        JSONArray jsonArray = this.getJSONArray(key);
        ArrayList<String> list = new ArrayList<String>(jsonArray.length());
        for (int i = 0; i < jsonArray.length(); ++i) {
            list.add(jsonArray.getString(i));
        }
        return list;
    }

    protected Long getLong(String key) {
        return this._jsonObject.getLong(key);
    }

    protected String getString(String key) {
        return this._jsonObject.getString(key);
    }

    protected abstract String getType();

    protected boolean has(String key) {
        return this._jsonObject.has(key);
    }

    protected Integer optInt(String key) {
        return this._jsonObject.optInt(key);
    }

    protected Long optLong(String key, Long defaultValue) {
        return this._jsonObject.optLong(key, defaultValue.longValue());
    }

    protected String optString(String key) {
        return this._jsonObject.optString(key);
    }

    protected String optString(String key, String defaultValue) {
        return this._jsonObject.optString(key, defaultValue);
    }

    protected void put(String key, Object value) {
        this._jsonObject.put(key, value);
        BuildDatabase buildDatabase = BuildDatabaseUtil.getBuildDatabase();
        buildDatabase.putBuildData(this.getRunID(), this);
    }

    protected void validateKeys(String[] requiredKeys) {
        for (String requiredKey : requiredKeys) {
            if (this.has(requiredKey)) continue;
            throw new RuntimeException("Missing " + requiredKey);
        }
    }

    private JSONObject _getBuildURLJSONObject() {
        String buildURL = this.getBuildURL();
        if (buildURL == null) {
            return null;
        }
        try {
            return JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil.getLocalURL(buildURL + "/api/json"));
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    private String _getDefaultBuildDescription() {
        return JenkinsResultsParserUtil.combine("<a href=\"https://", this.getTopLevelMasterHostname(), ".liferay.com/userContent/", this.getUserContentRelativePath(), "jenkins-report.html\">Jenkins Report</a>");
    }

    private String _getHostname() {
        JSONObject buildURLJSONObject = this._getBuildURLJSONObject();
        if (buildURLJSONObject == null) {
            throw new RuntimeException("Please set the build URL");
        }
        return buildURLJSONObject.getString("builtOn");
    }

    private long _getStartTime() {
        JSONObject buildURLJSONObject = this._getBuildURLJSONObject();
        if (buildURLJSONObject == null) {
            throw new RuntimeException("Please set the build URL");
        }
        return buildURLJSONObject.getLong("timestamp");
    }
}

