/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BuildData;
import com.liferay.jenkins.results.parser.BuildDatabase;
import com.liferay.jenkins.results.parser.FilePropagator;
import com.liferay.jenkins.results.parser.GitRepositoryFactory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.JobFactory;
import com.liferay.jenkins.results.parser.PullRequest;
import com.liferay.jenkins.results.parser.PullRequestFactory;
import com.liferay.jenkins.results.parser.Workspace;
import com.liferay.jenkins.results.parser.WorkspaceFactory;
import com.liferay.jenkins.results.parser.WorkspaceGitRepository;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class BaseBuildDatabase
implements BuildDatabase {
    private final File _buildDatabaseFile;
    private JSONObject _jsonObject;

    @Override
    public JSONObject getBuildDataJSONObject(String key) {
        JSONObject buildsJSONObject = this._jsonObject.getJSONObject("builds");
        if (!buildsJSONObject.has(key)) {
            return new JSONObject();
        }
        return buildsJSONObject.getJSONObject(key);
    }

    @Override
    public JSONObject getBuildDataJSONObject(URL buildURL) {
        String buildURLString = buildURL.toString();
        JSONObject buildsJSONObject = this._jsonObject.getJSONObject("builds");
        for (Object key : buildsJSONObject.keySet()) {
            JSONObject buildJSONObject = buildsJSONObject.getJSONObject(key.toString());
            if (!buildJSONObject.has("build_url") || !buildURLString.equals(buildJSONObject.getString("build_url"))) continue;
            return buildJSONObject;
        }
        return new JSONObject();
    }

    @Override
    public Job getJob(String key) {
        if (!this.hasJob(key)) {
            return null;
        }
        JSONObject jobsJSONObject = this._jsonObject.getJSONObject("jobs");
        JSONObject jobJSONObject = jobsJSONObject.getJSONObject(key);
        return JobFactory.newJob(jobJSONObject);
    }

    @Override
    public JSONObject getJSONObject() {
        return new JSONObject(this._jsonObject.toString());
    }

    @Override
    public Properties getProperties(String key) {
        return this.getProperties(key, null);
    }

    @Override
    public Properties getProperties(String key, Pattern pattern) {
        Properties properties = new Properties();
        if (!this.hasProperties(key)) {
            return properties;
        }
        JSONObject propertiesJSONObject = this._jsonObject.getJSONObject("properties");
        JSONArray propertyJSONArray = propertiesJSONObject.getJSONArray(key);
        for (int i = 0; i < propertyJSONArray.length(); ++i) {
            JSONObject propertyJSONObject = propertyJSONArray.getJSONObject(i);
            String propertyName = propertyJSONObject.getString("name");
            String propertyValue = propertyJSONObject.getString("value");
            if (pattern == null) {
                properties.setProperty(propertyName, propertyValue);
                continue;
            }
            Matcher matcher = pattern.matcher(propertyName);
            if (!matcher.matches()) continue;
            properties.setProperty(propertyName, propertyValue);
        }
        return properties;
    }

    @Override
    public PullRequest getPullRequest(String key) {
        if (!this.hasPullRequest(key)) {
            throw new RuntimeException("Unable to find pull request for " + key);
        }
        JSONObject pullRequestsJSONObject = this._jsonObject.getJSONObject("pull_requests");
        JSONObject pullRequestJSONObject = pullRequestsJSONObject.getJSONObject(key);
        return PullRequestFactory.newPullRequest(pullRequestJSONObject);
    }

    @Override
    public Workspace getWorkspace(String key) {
        if (!this.hasWorkspace(key)) {
            throw new RuntimeException("Unable to find workspace");
        }
        JSONObject workspacesJSONObject = this._jsonObject.getJSONObject("workspaces");
        return WorkspaceFactory.newWorkspace(workspacesJSONObject.getJSONObject(key));
    }

    @Override
    public WorkspaceGitRepository getWorkspaceGitRepository(String key) {
        if (!this.hasWorkspaceGitRepository(key)) {
            throw new RuntimeException("Unable to find workspace repository for " + key);
        }
        JSONObject workspaceGitRepositoriesJSONObject = this._jsonObject.getJSONObject("workspace_git_repositories");
        JSONObject workspaceGitRepositoryJSONObject = workspaceGitRepositoriesJSONObject.getJSONObject(key);
        return GitRepositoryFactory.getWorkspaceGitRepository(workspaceGitRepositoryJSONObject);
    }

    @Override
    public boolean hasBuildData(String key) {
        JSONObject buildsJSONObject = this._jsonObject.getJSONObject("builds");
        return buildsJSONObject.has(key);
    }

    @Override
    public boolean hasJob(String key) {
        JSONObject jobJSONObject;
        JSONObject jobsJSONObject = this._jsonObject.getJSONObject("jobs");
        return jobsJSONObject.has(key) && (jobJSONObject = jobsJSONObject.getJSONObject(key)) != null && !jobJSONObject.isEmpty();
    }

    @Override
    public boolean hasProperties(String key) {
        JSONObject buildsJSONObject = this._jsonObject.getJSONObject("properties");
        return buildsJSONObject.has(key);
    }

    @Override
    public boolean hasPullRequest(String key) {
        JSONObject pullRequestsJSONObject = this._jsonObject.getJSONObject("pull_requests");
        return pullRequestsJSONObject.has(key);
    }

    @Override
    public boolean hasWorkspace(String key) {
        JSONObject workspacesJSONObject = this._jsonObject.getJSONObject("workspaces");
        return workspacesJSONObject.has(key);
    }

    @Override
    public boolean hasWorkspaceGitRepository(String key) {
        JSONObject workspaceGitRepositoriesJSONObject = this._jsonObject.getJSONObject("workspace_git_repositories");
        return workspaceGitRepositoriesJSONObject.has(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putBuildData(String key, BuildData buildData) {
        File file = this._buildDatabaseFile;
        synchronized (file) {
            JSONObject buildsJSONObject = this._jsonObject.getJSONObject("builds");
            buildsJSONObject.put(key, (Object)buildData.getJSONObject());
            this._writeJSONObjectFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putJob(String key, Job job) {
        JSONObject jobJSONObject = job.getJSONObject();
        File file = this._buildDatabaseFile;
        synchronized (file) {
            JSONObject jobsJSONObject = this._jsonObject.getJSONObject("jobs");
            jobsJSONObject.put(key, (Object)jobJSONObject);
            this._writeJSONObjectFile();
        }
    }

    @Override
    public void putProperties(String key, File propertiesFile) {
        this.putProperties(key, propertiesFile, true);
    }

    @Override
    public void putProperties(String key, File propertiesFile, boolean writeFile) {
        this.putProperties(key, JenkinsResultsParserUtil.getProperties(propertiesFile), writeFile);
    }

    @Override
    public void putProperties(String key, Properties properties) {
        this.putProperties(key, properties, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putProperties(String key, Properties properties, boolean writeFile) {
        File file = this._buildDatabaseFile;
        synchronized (file) {
            JSONObject propertiesJSONObject = this._jsonObject.getJSONObject("properties");
            propertiesJSONObject.put(key, (Object)this._toJSONArray(properties));
            if (writeFile) {
                this._writeJSONObjectFile();
            }
        }
    }

    @Override
    public void putProperty(String key, String propertyName, String propertyValue) {
        this.putProperty(key, propertyName, propertyValue, true);
    }

    @Override
    public synchronized void putProperty(String key, String propertyName, String propertyValue, boolean writeFile) {
        Properties properties = this.getProperties(key);
        properties.setProperty(propertyName, propertyValue);
        this.putProperties(key, properties, writeFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putPullRequest(String key, PullRequest pullRequest) {
        if (!JenkinsResultsParserUtil.isCINode()) {
            return;
        }
        File file = this._buildDatabaseFile;
        synchronized (file) {
            JSONObject pullRequestsJSONObject = this._jsonObject.getJSONObject("pull_requests");
            pullRequestsJSONObject.put(key, (Object)pullRequest.getJSONObject());
            this._writeJSONObjectFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putWorkspace(String key, Workspace workspace) {
        File file = this._buildDatabaseFile;
        synchronized (file) {
            JSONObject workspacesJSONObject = this._jsonObject.getJSONObject("workspaces");
            workspacesJSONObject.put(key, (Object)workspace.getJSONObject());
            this._writeJSONObjectFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putWorkspaceGitRepository(String key, WorkspaceGitRepository workspaceGitRepository) {
        File file = this._buildDatabaseFile;
        synchronized (file) {
            JSONObject workspaceGitRepositoriesJSONObject = this._jsonObject.getJSONObject("workspace_git_repositories");
            workspaceGitRepositoriesJSONObject.put(key, (Object)workspaceGitRepository.getJSONObject());
            this._writeJSONObjectFile();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FilePropagator rsyncBuildDatabaseFile(List<String> distNodes, String distPath, String preDistCommand, String postDistCommand, int threadCount) {
        if (!JenkinsResultsParserUtil.isCINode()) {
            return null;
        }
        File file = this._buildDatabaseFile;
        synchronized (file) {
            File tempBuildDatabaseFile = new File(JenkinsResultsParserUtil.combine(System.getProperty("java.io.tmpdir"), "/", String.valueOf(this._buildDatabaseFile.hashCode()), "/", this._buildDatabaseFile.getName()));
            try {
                JenkinsResultsParserUtil.write(this._buildDatabaseFile, this._jsonObject.toString());
                JenkinsResultsParserUtil.copy(this._buildDatabaseFile, tempBuildDatabaseFile);
                String srcPath = JenkinsResultsParserUtil.combine(JenkinsResultsParserUtil.getHostName(System.getenv("HOSTNAME")), ":", tempBuildDatabaseFile.getParent());
                FilePropagator filePropagator = new FilePropagator(new String[]{tempBuildDatabaseFile.getName()}, srcPath, distPath, distNodes);
                filePropagator.setPreDistCommand(preDistCommand);
                filePropagator.setPostDistCommand(postDistCommand);
                filePropagator.start(threadCount);
                FilePropagator filePropagator2 = filePropagator;
                return filePropagator2;
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
            finally {
                if (tempBuildDatabaseFile.exists()) {
                    JenkinsResultsParserUtil.delete(tempBuildDatabaseFile);
                }
            }
        }
    }

    @Override
    public void writeFilteredPropertiesToFile(String destFilePath, Pattern pattern, String key) {
        String propertyValue;
        Properties properties = this.getProperties(key, pattern);
        StringBuilder sb = new StringBuilder();
        sb.append("## Autogenerated\n");
        for (String propertyName : properties.stringPropertyNames()) {
            propertyValue = JenkinsResultsParserUtil.getProperty(properties, propertyName);
            if (JenkinsResultsParserUtil.isNullOrEmpty(propertyValue)) continue;
            sb.append(propertyName);
            sb.append("=");
            propertyValue = properties.getProperty(propertyName);
            if (JenkinsResultsParserUtil.isWindows() && propertyValue.startsWith("/") && !propertyValue.startsWith("/c/")) {
                sb.append("C:");
            }
            sb.append(propertyValue);
            sb.append("\n");
        }
        try {
            JenkinsResultsParserUtil.write(destFilePath, sb.toString());
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        sb = new StringBuilder();
        if (JenkinsResultsParserUtil.isWindows()) {
            sb.append("#!C:/Program Files/Git/bin/sh.exe\n");
        } else {
            sb.append("#!/bin/bash\n");
        }
        sb.append("## Autogenerated\n");
        for (String propertyName : properties.stringPropertyNames()) {
            propertyValue = JenkinsResultsParserUtil.getProperty(properties, propertyName);
            if (JenkinsResultsParserUtil.isNullOrEmpty(propertyValue)) continue;
            sb.append("export ");
            sb.append(propertyName);
            sb.append("=");
            if (JenkinsResultsParserUtil.isWindows() && propertyValue.startsWith("/") && !propertyValue.startsWith("/c/")) {
                sb.append("C:");
            }
            sb.append(JenkinsResultsParserUtil.escapeForBash(propertyValue));
            sb.append("\n");
        }
        try {
            JenkinsResultsParserUtil.write(destFilePath + ".sh", sb.toString());
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    @Override
    public void writePropertiesToFile(String destFilePath, String key) {
        this.writeFilteredPropertiesToFile(destFilePath, null, key);
    }

    protected BaseBuildDatabase(File baseDir) {
        this._buildDatabaseFile = new File(baseDir, "build-database.json");
        this._readBuildDatabaseFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _readBuildDatabaseFile() {
        File file = this._buildDatabaseFile;
        synchronized (file) {
            if (this._buildDatabaseFile.exists()) {
                try {
                    this._jsonObject = new JSONObject(JenkinsResultsParserUtil.read(this._buildDatabaseFile));
                }
                catch (IOException ioException) {
                    throw new RuntimeException(ioException);
                }
            } else {
                this._jsonObject = new JSONObject();
            }
            if (!this._jsonObject.has("builds")) {
                this._jsonObject.put("builds", (Object)new JSONObject());
            }
            if (!this._jsonObject.has("jobs")) {
                this._jsonObject.put("jobs", (Object)new JSONObject());
            }
            if (!this._jsonObject.has("properties")) {
                this._jsonObject.put("properties", (Object)new JSONObject());
            }
            if (!this._jsonObject.has("pull_requests")) {
                this._jsonObject.put("pull_requests", (Object)new JSONObject());
            }
            if (!this._jsonObject.has("workspace_git_repositories")) {
                this._jsonObject.put("workspace_git_repositories", (Object)new JSONObject());
            }
            if (!this._jsonObject.has("workspaces")) {
                this._jsonObject.put("workspaces", (Object)new JSONObject());
            }
            this._writeJSONObjectFile();
        }
    }

    private JSONArray _toJSONArray(Properties properties) {
        JSONArray jsonArray = new JSONArray();
        int i = 0;
        for (String propertyName : properties.stringPropertyNames()) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("name", (Object)propertyName).put("value", (Object)properties.getProperty(propertyName));
            jsonArray.put(i, (Object)jsonObject);
            ++i;
        }
        return jsonArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void _writeJSONObjectFile() {
        File file = this._buildDatabaseFile;
        synchronized (file) {
            try {
                JenkinsResultsParserUtil.write(this._buildDatabaseFile, this._jsonObject.toString());
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
        }
    }
}

