/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BuildReport;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.JobReport;
import com.liferay.jenkins.results.parser.StopWatchRecordsGroup;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONObject;

public abstract class BaseBuildReport
implements BuildReport {
    protected JSONObject buildReportJSONObject;
    private static final Pattern _buildURLPattern = Pattern.compile("(?<jobURL>https?://(?<masterHostname>test-\\d+-\\d+)(\\.liferay\\.com)?/job/(?<jobName>[^/]+))(/AXIS_VARIABLE=(?<axisVariable>\\d+))?/(?<buildNumber>\\d+)");
    private JSONObject _buildJSONObject;
    private final URL _buildURL;
    private JobReport _jobReport;
    private Date _startDate;

    @Override
    public int getBuildNumber() {
        Matcher matcher = _buildURLPattern.matcher(String.valueOf(this.getBuildURL()));
        if (!matcher.find()) {
            throw new RuntimeException("Invalid Build URL: " + this.getBuildURL());
        }
        return Integer.parseInt(matcher.group("buildNumber"));
    }

    @Override
    public JSONObject getBuildReportJSONObject() {
        if (this.buildReportJSONObject != null && !JenkinsResultsParserUtil.isNullOrEmpty(this.buildReportJSONObject.optString("result"))) {
            return this.buildReportJSONObject;
        }
        JSONObject buildJSONObject = this.getBuildJSONObject();
        this.buildReportJSONObject = new JSONObject();
        this.buildReportJSONObject.put("duration", buildJSONObject.get("duration")).put("result", buildJSONObject.get("result")).put("startTime", buildJSONObject.get("timestamp"));
        return this.buildReportJSONObject;
    }

    @Override
    public URL getBuildURL() {
        return this._buildURL;
    }

    @Override
    public long getDuration() {
        JSONObject buildReportJSONObject = this.getBuildReportJSONObject();
        return buildReportJSONObject.getLong("duration");
    }

    @Override
    public String getJobName() {
        Matcher matcher = _buildURLPattern.matcher(String.valueOf(this.getBuildURL()));
        if (!matcher.find()) {
            throw new RuntimeException("Invalid Build URL: " + this.getBuildURL());
        }
        return matcher.group("jobName");
    }

    @Override
    public JobReport getJobReport() {
        if (this._jobReport != null) {
            return this._jobReport;
        }
        Matcher matcher = _buildURLPattern.matcher(String.valueOf(this.getBuildURL()));
        if (!matcher.find()) {
            throw new RuntimeException("Invalid Build URL: " + this.getBuildURL());
        }
        try {
            this._jobReport = JobReport.getInstance(new URL(matcher.group("jobURL")));
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
        return this._jobReport;
    }

    @Override
    public String getResult() {
        JSONObject buildReportJSONObject = this.getBuildReportJSONObject();
        return buildReportJSONObject.getString("result");
    }

    @Override
    public Date getStartDate() {
        if (this._startDate != null) {
            return this._startDate;
        }
        JSONObject buildJSONObject = this.getBuildJSONObject();
        this._startDate = new Date(buildJSONObject.getLong("timestamp"));
        return this._startDate;
    }

    @Override
    public StopWatchRecordsGroup getStopWatchRecordsGroup() {
        return new StopWatchRecordsGroup(this.getBuildReportJSONObject());
    }

    protected BaseBuildReport(JSONObject buildReportJSONObject) {
        this.buildReportJSONObject = buildReportJSONObject;
        String buildURLString = buildReportJSONObject.getString("buildURL");
        Matcher matcher = _buildURLPattern.matcher(buildURLString);
        if (!matcher.find()) {
            throw new RuntimeException("Invalid Build URL: " + buildURLString);
        }
        try {
            this._buildURL = new URL(JenkinsResultsParserUtil.combine("https://", matcher.group("masterHostname"), ".liferay.com/job/", matcher.group("jobName"), "/", matcher.group("buildNumber")));
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    protected BaseBuildReport(JSONObject buildJSONObject, JobReport jobReport) {
        this._buildJSONObject = buildJSONObject;
        this._jobReport = jobReport;
        String buildURLString = buildJSONObject.getString("url");
        Matcher matcher = _buildURLPattern.matcher(buildURLString);
        if (!matcher.find()) {
            throw new RuntimeException("Invalid Build URL: " + buildURLString);
        }
        try {
            this._buildURL = new URL(JenkinsResultsParserUtil.combine("https://", matcher.group("masterHostname"), ".liferay.com/job/", matcher.group("jobName"), "/", matcher.group("buildNumber")));
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    protected BaseBuildReport(String buildURLString) {
        Matcher matcher = _buildURLPattern.matcher(buildURLString);
        if (!matcher.find()) {
            throw new RuntimeException("Invalid Build URL: " + buildURLString);
        }
        try {
            this._buildURL = new URL(JenkinsResultsParserUtil.combine("https://", matcher.group("masterHostname"), ".liferay.com/job/", matcher.group("jobName"), "/", matcher.group("buildNumber")));
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    protected BaseBuildReport(URL buildURL) {
        this(String.valueOf(buildURL));
    }

    protected JSONObject getBuildJSONObject() {
        if (this._buildJSONObject != null) {
            return this._buildJSONObject;
        }
        try {
            this._buildJSONObject = JenkinsResultsParserUtil.toJSONObject(this.getBuildURL() + "/api/json");
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        return this._buildJSONObject;
    }

    protected void setStartDate(Date startDate) {
        this._startDate = startDate;
    }
}

