/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BuildData;
import com.liferay.jenkins.results.parser.BuildRunner;
import com.liferay.jenkins.results.parser.Host;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.JobFactory;
import com.liferay.jenkins.results.parser.RemoteExecutor;
import com.liferay.jenkins.results.parser.Workspace;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class BaseBuildRunner<T extends BuildData>
implements BuildRunner<T> {
    private static final long _MILLISECONDS_PER_DAY = 86400000L;
    private final T _buildData;
    private final Job _job;
    private List<JSONObject> _previousBuildJSONObjects;

    @Override
    public T getBuildData() {
        return this._buildData;
    }

    @Override
    public void run() {
        this.updateBuildDescription();
        this.setUpWorkspace();
    }

    @Override
    public void setUp() {
    }

    @Override
    public void tearDown() {
        this.cleanUpHostServices();
        this.tearDownWorkspace();
    }

    protected BaseBuildRunner(T buildData) {
        this._buildData = buildData;
        this._job = JobFactory.newJob(this._buildData);
    }

    protected void cleanUpHostServices() {
        Host host = this._buildData.getHost();
        host.cleanUpServices();
    }

    protected Job getJob() {
        return this._job;
    }

    protected List<JSONObject> getPreviousBuildJSONObjects() {
        if (this._previousBuildJSONObjects != null) {
            return this._previousBuildJSONObjects;
        }
        this._previousBuildJSONObjects = new ArrayList<JSONObject>();
        T buildData = this.getBuildData();
        try {
            JSONObject jsonObject = JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil.getLocalURL(buildData.getJobURL()) + "api/json");
            JSONArray buildsJSONArray = jsonObject.getJSONArray("builds");
            for (int i = 0; i < buildsJSONArray.length(); ++i) {
                JSONObject buildJSONObject = buildsJSONArray.getJSONObject(i);
                this._previousBuildJSONObjects.add(JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil.getLocalURL(buildJSONObject.getString("url") + "api/json")));
            }
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        return this._previousBuildJSONObjects;
    }

    protected void keepJenkinsBuild(boolean keepLogs) {
        JenkinsResultsParserUtil.keepJenkinsBuild(keepLogs, this._buildData.getBuildNumber(), this._buildData.getJobName(), this._buildData.getMasterHostname());
    }

    protected void publishToUserContentDir(File file) {
        if (!JenkinsResultsParserUtil.isCINode()) {
            return;
        }
        String userContentRelativePath = this._buildData.getUserContentRelativePath();
        userContentRelativePath = userContentRelativePath.replace(")", "\\)");
        userContentRelativePath = userContentRelativePath.replace("(", "\\(");
        RemoteExecutor remoteExecutor = new RemoteExecutor();
        int returnCode = remoteExecutor.execute(1, new String[]{this._buildData.getMasterHostname()}, new String[]{"mkdir -p /opt/java/jenkins/userContent/" + userContentRelativePath});
        if (returnCode != 0) {
            throw new RuntimeException("Unable to create target directory");
        }
        int maxRetries = 3;
        int retries = 0;
        while (retries < maxRetries) {
            try {
                ++retries;
                String command = JenkinsResultsParserUtil.combine("time timeout 1200 rsync -Ipqrs --chmod=go=rx ", JenkinsResultsParserUtil.getCanonicalPath(file), " ", this._buildData.getTopLevelMasterHostname(), ":/opt/java/jenkins/userContent/", userContentRelativePath);
                JenkinsResultsParserUtil.executeBashCommands(command);
                break;
            }
            catch (IOException | TimeoutException exception) {
                if (retries == maxRetries) {
                    throw new RuntimeException("Unable to send " + file.getName(), exception);
                }
                System.out.println("Unable to execute bash commands, retrying... ");
                exception.printStackTrace();
                JenkinsResultsParserUtil.sleep(3000L);
            }
        }
    }

    protected void retirePreviousBuilds() {
        long allowedBuildAge = 604800000L;
        String allowedBuildAgeInDays = System.getenv("ALLOWED_BUILD_AGE_IN_DAYS");
        if (allowedBuildAgeInDays != null && !allowedBuildAgeInDays.isEmpty()) {
            allowedBuildAge = (long)Integer.parseInt(allowedBuildAgeInDays) * 86400000L;
        }
        long allowedBuildStartTime = JenkinsResultsParserUtil.getCurrentTimeMillis() - allowedBuildAge;
        for (JSONObject previousBuildJSONObject : this.getPreviousBuildJSONObjects()) {
            long previousBuildStartTime = previousBuildJSONObject.getLong("timestamp");
            if (previousBuildStartTime > allowedBuildStartTime) continue;
            try {
                JSONObject injectedEnvVarsJSONObject = JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil.getLocalURL(previousBuildJSONObject.getString("url") + "/injectedEnvVars/api/json"));
                JSONObject envMapJSONObject = injectedEnvVarsJSONObject.getJSONObject("envMap");
                JenkinsResultsParserUtil.keepJenkinsBuild(false, Integer.valueOf(envMapJSONObject.getString("BUILD_NUMBER")), envMapJSONObject.getString("JOB_NAME"), envMapJSONObject.getString("HOSTNAME"));
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
        }
    }

    protected void setUpWorkspace() {
        Workspace workspace = this.getWorkspace();
        workspace.setUp();
    }

    protected void tearDownWorkspace() {
        Workspace workspace = this.getWorkspace();
        workspace.tearDown();
    }

    protected void updateBuildDescription() {
        JenkinsResultsParserUtil.updateBuildDescription(this._buildData.getBuildDescription(), this._buildData.getBuildNumber(), this._buildData.getJobName(), this._buildData.getMasterHostname());
    }
}

