/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.AxisBuild;
import com.liferay.jenkins.results.parser.BatchBuild;
import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.BuildUpdater;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.JenkinsSlave;
import com.liferay.jenkins.results.parser.NotificationUtil;
import com.liferay.jenkins.results.parser.ParentBuild;
import com.liferay.jenkins.results.parser.ReinvokeRule;
import com.liferay.jenkins.results.parser.SlaveOfflineRule;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import java.util.ArrayList;

public abstract class BaseBuildUpdater
implements BuildUpdater {
    private final Build _build;

    @Override
    public Build getBuild() {
        return this._build;
    }

    @Override
    public void reset() {
    }

    @Override
    public void update() {
        String status = this._build.getStatus();
        if (status.equals("completed")) {
            this.runCompleted();
        } else if (status.equals("missing")) {
            this.runMissing();
        } else if (status.equals("queued")) {
            this.runQueued();
        } else if (status.equals("reporting")) {
            this.runReporting();
        } else if (status.equals("running")) {
            this.runRunning();
        } else if (status.equals("starting")) {
            this.runStarting();
        }
    }

    protected BaseBuildUpdater(Build build) {
        this._build = build;
    }

    protected abstract boolean isBuildCompleted();

    protected abstract boolean isBuildFailing();

    protected abstract boolean isBuildQueued();

    protected abstract boolean isBuildRunning();

    protected void runCompleted() {
        this._build.setStatus("completed");
    }

    protected void runMissing() {
        if (this.isBuildQueued()) {
            this._build.setStatus("queued");
            this.runQueued();
            return;
        }
        if (this.isBuildRunning()) {
            this._build.setStatus("running");
            this.runRunning();
            return;
        }
        if (this.isBuildCompleted()) {
            this._build.setStatus("completed");
            return;
        }
        if (!this._build.hasMaximumInvocationCount()) {
            this._build.setStatus("starting");
            this._build.reset();
            this.runStarting();
            return;
        }
        this.runReporting();
    }

    protected void runQueued() {
        if (this.isBuildQueued()) {
            return;
        }
        if (this.isBuildRunning()) {
            this._build.setStatus("running");
            this.runRunning();
            return;
        }
        if (this.isBuildCompleted()) {
            this._build.setStatus("completed");
            return;
        }
        this._build.setStatus("missing");
    }

    protected void runReporting() {
        if (this.isBuildFailing()) {
            this._isApplySlaveOfflineRules();
            if (this._isApplyReinvokeRules()) {
                this._build.setStatus("queued");
                return;
            }
        }
        this.runCompleted();
    }

    protected void runRunning() {
        if (!this.isBuildCompleted()) {
            this._build.setStatus("running");
            return;
        }
        this._build.setStatus("reporting");
        this.runReporting();
    }

    protected void runStarting() {
        Build.Invocation previousInvocation = this._build.getPreviousInvocation();
        if (previousInvocation != null) {
            this.reinvoke();
        } else {
            this.invoke();
        }
        this._build.setStatus("queued");
    }

    private boolean _isApplyReinvokeRules() {
        Build build = this.getBuild();
        if (build instanceof AxisBuild || build instanceof ParentBuild) {
            return false;
        }
        if (this.isBuildCompleted() && !this.isBuildFailing() || !this.isBuildCompleted() || build.isFromArchive() || build.hasMaximumInvocationCount()) {
            return false;
        }
        for (ReinvokeRule reinvokeRule : ReinvokeRule.getReinvokeRules()) {
            if (!reinvokeRule.matches(build)) continue;
            this._reinvoke(reinvokeRule);
            return true;
        }
        return false;
    }

    private boolean _isApplySlaveOfflineRules() {
        Build build = this.getBuild();
        if (build instanceof BatchBuild) {
            return false;
        }
        if (this.isBuildCompleted() && !this.isBuildFailing() || !this.isBuildCompleted() || build.isFromArchive()) {
            return false;
        }
        JenkinsSlave jenkinsSlave = build.getJenkinsSlave();
        if (jenkinsSlave == null) {
            return false;
        }
        jenkinsSlave.update();
        if (jenkinsSlave.isOffline()) {
            return false;
        }
        ArrayList<SlaveOfflineRule> slaveOfflineRules = new ArrayList<SlaveOfflineRule>(SlaveOfflineRule.getSlaveOfflineRules());
        for (SlaveOfflineRule slaveOfflineRule : slaveOfflineRules) {
            if (!slaveOfflineRule.matches(build)) continue;
            this._takeSlaveOffline(slaveOfflineRule);
            return true;
        }
        return false;
    }

    private void _reinvoke(ReinvokeRule reinvokeRule) {
        Build build = this.getBuild();
        if (build instanceof AxisBuild || build instanceof ParentBuild || build.hasMaximumInvocationCount()) {
            return;
        }
        Build parentBuild = build.getParentBuild();
        if (parentBuild == null) {
            return;
        }
        String parentBuildStatus = parentBuild.getStatus();
        if (!parentBuildStatus.equals("running") || !JenkinsResultsParserUtil.isCINode() || build.isFromCompletedBuild()) {
            return;
        }
        if (reinvokeRule != null && !build.isFromArchive()) {
            String notificationRecipients;
            String message = JenkinsResultsParserUtil.combine(reinvokeRule.getName(), " failure detected at ", build.getBuildURL(), ". This build will be reinvoked.\n\n", reinvokeRule.toString(), "\n\n");
            System.out.println(message);
            TopLevelBuild topLevelBuild = build.getTopLevelBuild();
            if (topLevelBuild != null) {
                message = JenkinsResultsParserUtil.combine(message, "Top Level Build URL: ", topLevelBuild.getBuildURL());
            }
            if ((notificationRecipients = reinvokeRule.getNotificationRecipients()) != null && !notificationRecipients.isEmpty()) {
                NotificationUtil.sendEmail(message, "jenkins", "Build reinvoked", reinvokeRule.notificationRecipients);
            }
        }
        this.reinvoke();
    }

    private void _takeSlaveOffline(SlaveOfflineRule slaveOfflineRule) {
        Build build = this.getBuild();
        if (slaveOfflineRule == null || build.isFromArchive()) {
            return;
        }
        slaveOfflineRule.takeSlaveOffline(build);
    }
}

