/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.GitCommit;
import java.util.Date;
import java.util.Objects;
import org.json.JSONObject;

public abstract class BaseGitCommit
implements GitCommit {
    protected Long commitTime;
    protected String emailAddress;
    protected String message;
    private final String _gitRepositoryName;
    private final String _sha;
    private final GitCommit.Type _type;

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BaseGitCommit)) {
            return false;
        }
        return Objects.equals(this.hashCode(), object.hashCode());
    }

    @Override
    public String getAbbreviatedSHA() {
        return this._sha.substring(0, 7);
    }

    @Override
    public Date getCommitDate() {
        if (this.commitTime == null) {
            this.initCommitTime();
        }
        return new Date(this.commitTime);
    }

    @Override
    public String getEmailAddress() {
        if (this.emailAddress == null) {
            this.initEmailAddress();
        }
        return this.emailAddress;
    }

    @Override
    public String getGitRepositoryName() {
        return this._gitRepositoryName;
    }

    @Override
    public String getMessage() {
        if (this.message == null) {
            this.initMessage();
        }
        return this.message;
    }

    @Override
    public String getSHA() {
        return this._sha;
    }

    @Override
    public GitCommit.Type getType() {
        return this._type;
    }

    public int hashCode() {
        String json = String.valueOf(this.toJSONObject());
        return json.hashCode();
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("commitTime", (Object)this.commitTime).put("emailAddress", (Object)this.emailAddress).put("message", (Object)this.message).put("sha", (Object)this._sha);
        return jsonObject;
    }

    protected BaseGitCommit(String gitRepositoryName, String sha, GitCommit.Type type) {
        this._gitRepositoryName = gitRepositoryName;
        this._sha = sha;
        this._type = type;
    }

    protected BaseGitCommit(String emailAddress, String gitRepositoryName, String message, String sha, GitCommit.Type type, long commitTime) {
        this._gitRepositoryName = gitRepositoryName;
        this._sha = sha;
        this._type = type;
        this.emailAddress = emailAddress;
        this.message = message;
        this.commitTime = commitTime;
    }

    protected abstract void initCommitTime();

    protected abstract void initEmailAddress();

    protected abstract void initMessage();
}

