/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.BuildFactory;
import com.liferay.jenkins.results.parser.HistoryUtil;
import com.liferay.jenkins.results.parser.JenkinsCohort;
import com.liferay.jenkins.results.parser.JenkinsMaster;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.JenkinsSlave;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.JobHistory;
import com.liferay.jenkins.results.parser.ParallelExecutor;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import com.liferay.jenkins.results.parser.PortalTestClassJob;
import com.liferay.jenkins.results.parser.TestSuiteJob;
import com.liferay.jenkins.results.parser.job.property.GlobJobProperty;
import com.liferay.jenkins.results.parser.job.property.JobProperty;
import com.liferay.jenkins.results.parser.job.property.JobPropertyFactory;
import com.liferay.jenkins.results.parser.test.batch.TestBatch;
import com.liferay.jenkins.results.parser.test.clazz.group.AxisTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.BatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.FunctionalBatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.FunctionalSegmentTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.SegmentTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.TestClassGroupFactory;
import java.io.File;
import java.io.IOException;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class BaseJob
implements Job {
    protected List<BatchTestClassGroup> batchTestClassGroups;
    protected final List<JobProperty> jobProperties = new ArrayList<JobProperty>();
    protected final List<File> jobPropertiesFiles = new ArrayList<File>();
    protected JSONObject jsonObject;
    private static final String[] _JUNIT_BATCH_NAMES = new String[]{"integration-jdk8", "modules-integration", "modules-unit", "unit"};
    private static final Integer _THREAD_COUNT = 10;
    private static final ExecutorService _executorService = JenkinsResultsParserUtil.getNewThreadPoolExecutor(_THREAD_COUNT, true);
    private Set<String> _batchNames;
    private final Job.BuildProfile _buildProfile;
    private String _companyDefaultLocale;
    private Document _configDocument;
    private List<BatchTestClassGroup> _dependentBatchTestClassGroups;
    private final Map<String, List<String>> _distNodesMap = new HashMap<String, List<String>>();
    private boolean _initializeJobProperties;
    private JobHistory _jobHistory;
    private final String _jobName;
    private Boolean _jUnitTestFileModifiedOnly;
    private Boolean _testAnalyticsCloud;

    @Override
    public int getAxisCount() {
        List<AxisTestClassGroup> axisTestClassGroups = this.getAxisTestClassGroups();
        if (axisTestClassGroups == null) {
            return 0;
        }
        return axisTestClassGroups.size();
    }

    @Override
    public AxisTestClassGroup getAxisTestClassGroup(String axisName) {
        ArrayList<AxisTestClassGroup> axisTestClassGroups = new ArrayList<AxisTestClassGroup>();
        axisTestClassGroups.addAll(this.getAxisTestClassGroups());
        axisTestClassGroups.addAll(this.getDependentAxisTestClassGroups());
        for (AxisTestClassGroup axisTestClassGroup : axisTestClassGroups) {
            if (!Objects.equals(axisName, axisTestClassGroup.getAxisName())) continue;
            return axisTestClassGroup;
        }
        return null;
    }

    @Override
    public List<AxisTestClassGroup> getAxisTestClassGroups() {
        ArrayList<AxisTestClassGroup> axisTestClassGroups = new ArrayList<AxisTestClassGroup>();
        for (BatchTestClassGroup batchTestClassGroup : this.getBatchTestClassGroups()) {
            axisTestClassGroups.addAll(batchTestClassGroup.getAxisTestClassGroups());
        }
        return axisTestClassGroups;
    }

    @Override
    public Set<String> getBatchNames() {
        if (this._batchNames != null) {
            return this._batchNames;
        }
        this._batchNames = Collections.synchronizedSet(new TreeSet());
        for (BatchTestClassGroup batchTestClassGroup : this.getBatchTestClassGroups()) {
            this._batchNames.add(batchTestClassGroup.getBatchName());
        }
        return this._batchNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BatchTestClassGroup> getBatchTestClassGroups() {
        List<JobProperty> list = this.jobProperties;
        synchronized (list) {
            if (this.batchTestClassGroups != null) {
                return this.batchTestClassGroups;
            }
            this.batchTestClassGroups = Collections.synchronizedList(new ArrayList());
            if (this.jsonObject != null && this.jsonObject.has("batches")) {
                JSONArray batchesJSONArray = this.jsonObject.getJSONArray("batches");
                for (int i = 0; i < batchesJSONArray.length(); ++i) {
                    JSONObject batchJSONObject = batchesJSONArray.getJSONObject(i);
                    if (batchJSONObject == null) continue;
                    this.batchTestClassGroups.add(TestClassGroupFactory.newBatchTestClassGroup((Job)this, batchJSONObject));
                }
                return this.batchTestClassGroups;
            }
            this.batchTestClassGroups.addAll(this.getBatchTestClassGroups(this.getRawBatchNames()));
            return this.batchTestClassGroups;
        }
    }

    @Override
    public List<Build> getBuildHistory(JenkinsMaster jenkinsMaster) {
        JSONObject jobJSONObject = this.getJobJSONObject(jenkinsMaster, "builds[number]");
        JSONArray buildsJSONArray = jobJSONObject.getJSONArray("builds");
        ArrayList<Build> builds = new ArrayList<Build>(buildsJSONArray.length());
        for (int i = 0; i < buildsJSONArray.length(); ++i) {
            JSONObject buildJSONObject = buildsJSONArray.getJSONObject(i);
            builds.add(BuildFactory.newBuild(JenkinsResultsParserUtil.combine(jenkinsMaster.getURL(), "/job/", this.getJobName(), "/", String.valueOf(buildJSONObject.getInt("number"))), null));
        }
        return builds;
    }

    @Override
    public Job.BuildProfile getBuildProfile() {
        return this._buildProfile;
    }

    @Override
    public String getCompanyDefaultLocale() {
        if (this._companyDefaultLocale != null) {
            return this._companyDefaultLocale;
        }
        JobProperty jobProperty = this.getJobProperty("test.batch.company.default.locale");
        String jobPropertyValue = jobProperty.getValue();
        if (jobPropertyValue != null) {
            this.recordJobProperty(jobProperty);
            this._companyDefaultLocale = jobPropertyValue;
            return this._companyDefaultLocale;
        }
        return null;
    }

    @Override
    public List<AxisTestClassGroup> getDependentAxisTestClassGroups() {
        ArrayList<AxisTestClassGroup> axisTestClassGroups = new ArrayList<AxisTestClassGroup>();
        for (BatchTestClassGroup batchTestClassGroup : this.getDependentBatchTestClassGroups()) {
            axisTestClassGroups.addAll(batchTestClassGroup.getAxisTestClassGroups());
        }
        return axisTestClassGroups;
    }

    @Override
    public Set<String> getDependentBatchNames() {
        TreeSet<String> batchNames = new TreeSet<String>();
        for (BatchTestClassGroup batchTestClassGroup : this.getDependentBatchTestClassGroups()) {
            batchNames.add(batchTestClassGroup.getBatchName());
        }
        return batchNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BatchTestClassGroup> getDependentBatchTestClassGroups() {
        List<JobProperty> list = this.jobProperties;
        synchronized (list) {
            if (this._dependentBatchTestClassGroups != null) {
                return this._dependentBatchTestClassGroups;
            }
            this._dependentBatchTestClassGroups = Collections.synchronizedList(new ArrayList());
            if (this.jsonObject != null && this.jsonObject.has("smoke_batches")) {
                JSONArray smokeBatchesJSONArray = this.jsonObject.getJSONArray("smoke_batches");
                for (int i = 0; i < smokeBatchesJSONArray.length(); ++i) {
                    JSONObject smokeBatchJSONObject = smokeBatchesJSONArray.getJSONObject(i);
                    if (smokeBatchJSONObject == null) continue;
                    this._dependentBatchTestClassGroups.add(TestClassGroupFactory.newBatchTestClassGroup((Job)this, smokeBatchJSONObject));
                }
                return this._dependentBatchTestClassGroups;
            }
            this._dependentBatchTestClassGroups.addAll(this.getBatchTestClassGroups(this.getRawDependentBatchNames()));
            return this._dependentBatchTestClassGroups;
        }
    }

    @Override
    public Set<String> getDependentSegmentNames() {
        TreeSet<String> segmentNames = new TreeSet<String>();
        for (SegmentTestClassGroup segmentTestClassGroup : this.getDependentSegmentTestClassGroups()) {
            segmentNames.add(segmentTestClassGroup.getSegmentName());
        }
        return segmentNames;
    }

    @Override
    public List<SegmentTestClassGroup> getDependentSegmentTestClassGroups() {
        ArrayList<SegmentTestClassGroup> segmentTestClassGroups = new ArrayList<SegmentTestClassGroup>();
        for (BatchTestClassGroup batchTestClassGroup : this.getDependentBatchTestClassGroups()) {
            segmentTestClassGroups.addAll(batchTestClassGroup.getSegmentTestClassGroups());
        }
        return segmentTestClassGroups;
    }

    @Override
    public List<String> getDistNodes() {
        ArrayList<String> distNodes = new ArrayList<String>();
        for (String networkName : this.getNetworkNames()) {
            if (JenkinsResultsParserUtil.isNullOrEmpty(networkName)) continue;
            distNodes.addAll(this.getDistNodes(networkName));
        }
        return distNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getDistNodes(String networkName) {
        Map<String, List<String>> map = this._distNodesMap;
        synchronized (map) {
            List<String> distNodes = this._distNodesMap.get(networkName);
            if (distNodes != null) {
                return distNodes;
            }
            distNodes = new ArrayList<String>();
            try {
                List<JenkinsMaster> jenkinsMasters = JenkinsResultsParserUtil.getJenkinsMasters(JenkinsResultsParserUtil.getBuildProperties(), this._getSlaveRAMMinimumDefault(), this._getSlavesPerHostDefault(), JenkinsResultsParserUtil.getCohortName(), networkName);
                int axisCount = this.getAxisCount();
                int distNodeAxisCount = this._getDistNodeAxisCount();
                int distNodeCount = axisCount / distNodeAxisCount;
                Set<String> networkNames = this.getNetworkNames();
                distNodeCount /= networkNames.size();
                if (axisCount % distNodeAxisCount > 0) {
                    ++distNodeCount;
                }
                distNodeCount = Math.min(distNodeCount, jenkinsMasters.size());
                distNodeCount = Math.max(distNodeCount, this._getDistNodeCountMinimum());
                List<JenkinsSlave> jenkinsSlaves = JenkinsResultsParserUtil.getReachableJenkinsSlaves(jenkinsMasters, distNodeCount);
                for (JenkinsSlave jenkinsSlave : jenkinsSlaves) {
                    distNodes.add(jenkinsSlave.getName());
                }
                return distNodes;
            }
            catch (IOException ioException) {
                return new ArrayList<String>();
            }
        }
    }

    @Override
    public Set<String> getDistRequiredBatchNames() {
        if (!this.isStandaloneBatchEnabled()) {
            return this.getBatchNames();
        }
        TreeSet<String> batchNames = new TreeSet<String>();
        JobProperty jobProperty = this.getJobProperty("test.batch.names.standalone");
        Set<String> standaloneTestBatchNames = this.getSetFromString(jobProperty.getValue());
        for (BatchTestClassGroup batchTestClassGroup : this.getBatchTestClassGroups()) {
            String batchName = batchTestClassGroup.getBatchName();
            if (standaloneTestBatchNames.contains(batchName)) continue;
            batchNames.add(batchName);
        }
        return batchNames;
    }

    @Override
    public Set<String> getDistRequiredSegmentNames() {
        if (!this.isStandaloneBatchEnabled()) {
            return this.getSegmentNames();
        }
        TreeSet<String> segmentNames = new TreeSet<String>();
        JobProperty jobProperty = this.getJobProperty("test.batch.names.standalone");
        Set<String> standaloneTestBatchNames = this.getSetFromString(jobProperty.getValue());
        for (SegmentTestClassGroup segmentTestClassGroup : this.getSegmentTestClassGroups()) {
            if (standaloneTestBatchNames.contains(segmentTestClassGroup.getBatchName())) continue;
            segmentNames.add(segmentTestClassGroup.getSegmentName());
        }
        return segmentNames;
    }

    @Override
    public Job.DistType getDistType() {
        return Job.DistType.CI;
    }

    @Override
    public Set<String> getDistTypes() {
        JobProperty jobProperty = this.getJobProperty("test.batch.dist.app.servers");
        return this.getSetFromString(jobProperty.getValue());
    }

    @Override
    public Set<String> getDistTypesExcludingTomcat() {
        TreeSet<String> distTypesExcludingTomcat = new TreeSet<String>(this.getDistTypes());
        distTypesExcludingTomcat.remove("tomcat");
        return distTypesExcludingTomcat;
    }

    @Override
    public Set<JenkinsCohort> getJenkinsCohorts() {
        return Collections.singleton(JenkinsResultsParserUtil.getJenkinsCohort());
    }

    @Override
    public JobHistory getJobHistory() {
        if (this._jobHistory != null) {
            return this._jobHistory;
        }
        this._jobHistory = HistoryUtil.getJobHistory(this);
        return this._jobHistory;
    }

    @Override
    public String getJobName() {
        return this._jobName;
    }

    @Override
    public List<File> getJobPropertiesFiles() {
        return this.jobPropertiesFiles;
    }

    @Override
    public List<String> getJobPropertyOptions() {
        ArrayList<String> jobPropertyOptions = new ArrayList<String>();
        jobPropertyOptions.add(String.valueOf((Object)this.getBuildProfile()));
        String jobName = this.getJobName();
        jobPropertyOptions.add(jobName);
        if (jobName.contains("(")) {
            jobPropertyOptions.add(jobName.substring(0, jobName.indexOf("(")));
        }
        jobPropertyOptions.removeAll(Collections.singleton(null));
        return jobPropertyOptions;
    }

    @Override
    public String getJobURL(JenkinsMaster jenkinsMaster) {
        return JenkinsResultsParserUtil.combine(jenkinsMaster.getURL(), "/job/", this._jobName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JSONObject getJSONObject() {
        List<JobProperty> list = this.jobProperties;
        synchronized (list) {
            String testSuiteName;
            if (this.jsonObject != null) {
                return this.jsonObject;
            }
            this.jsonObject = new JSONObject();
            List<BatchTestClassGroup> batchTestClassGroups = this.getBatchTestClassGroups();
            if (batchTestClassGroups != null && !batchTestClassGroups.isEmpty()) {
                JSONArray batchesJSONArray = new JSONArray();
                for (BatchTestClassGroup batchTestClassGroup : batchTestClassGroups) {
                    batchesJSONArray.put((Object)batchTestClassGroup.getJSONObject());
                }
                this.jsonObject.put("batches", (Object)batchesJSONArray);
            }
            this.jsonObject.put("build_profile", (Object)String.valueOf((Object)this.getBuildProfile())).put("company_default_locale", (Object)this.getCompanyDefaultLocale()).put("job_name", (Object)this.getJobName()).put("job_properties", this._getJobPropertiesMap()).put("job_property_options", this.getJobPropertyOptions());
            List<BatchTestClassGroup> dependentBatchTestClassGroups = this.getDependentBatchTestClassGroups();
            if (dependentBatchTestClassGroups != null && !dependentBatchTestClassGroups.isEmpty()) {
                JSONArray smokeBatchesJSONArray = new JSONArray();
                for (BatchTestClassGroup batchTestClassGroup : dependentBatchTestClassGroups) {
                    smokeBatchesJSONArray.put((Object)batchTestClassGroup.getJSONObject());
                }
                this.jsonObject.put("smoke_batches", (Object)smokeBatchesJSONArray);
            }
            if ((testSuiteName = this.getTestSuiteName()) != null) {
                this.jsonObject.put("test_suite_name", (Object)testSuiteName);
            }
            return this.jsonObject;
        }
    }

    @Override
    public Set<String> getNetworkNames() {
        HashSet<String> networkNames = new HashSet<String>();
        for (JenkinsCohort jenkinsCohort : this.getJenkinsCohorts()) {
            networkNames.addAll(jenkinsCohort.getNetworkNames());
        }
        networkNames.removeAll(Collections.singleton(null));
        return networkNames;
    }

    @Override
    public Set<String> getSegmentNames() {
        TreeSet<String> segmentNames = new TreeSet<String>();
        for (SegmentTestClassGroup segmentTestClassGroup : this.getSegmentTestClassGroups()) {
            segmentNames.add(segmentTestClassGroup.getSegmentName());
        }
        return segmentNames;
    }

    @Override
    public List<SegmentTestClassGroup> getSegmentTestClassGroups() {
        ArrayList<SegmentTestClassGroup> segmentTestClassGroups = new ArrayList<SegmentTestClassGroup>();
        for (BatchTestClassGroup batchTestClassGroup : this.getBatchTestClassGroups()) {
            segmentTestClassGroups.addAll(batchTestClassGroup.getSegmentTestClassGroups());
        }
        return segmentTestClassGroups;
    }

    @Override
    public Set<String> getStandaloneBatchNames() {
        if (!this.isStandaloneBatchEnabled()) {
            return Collections.emptySet();
        }
        TreeSet<String> batchNames = new TreeSet<String>();
        JobProperty jobProperty = this.getJobProperty("test.batch.names.standalone");
        Set<String> standaloneTestBatchNames = this.getSetFromString(jobProperty.getValue());
        for (BatchTestClassGroup batchTestClassGroup : this.getBatchTestClassGroups()) {
            String batchName = batchTestClassGroup.getBatchName();
            if (!standaloneTestBatchNames.contains(batchName)) continue;
            batchNames.add(batchName);
        }
        return batchNames;
    }

    @Override
    public Set<String> getStandaloneSegmentNames() {
        if (!this.isStandaloneBatchEnabled()) {
            return Collections.emptySet();
        }
        TreeSet<String> segmentNames = new TreeSet<String>();
        JobProperty jobProperty = this.getJobProperty("test.batch.names.standalone");
        Set<String> standaloneTestBatchNames = this.getSetFromString(jobProperty.getValue());
        for (SegmentTestClassGroup segmentTestClassGroup : this.getSegmentTestClassGroups()) {
            if (!standaloneTestBatchNames.contains(segmentTestClassGroup.getBatchName())) continue;
            segmentNames.add(segmentTestClassGroup.getSegmentName());
        }
        return segmentNames;
    }

    @Override
    public String getTestPropertiesContent() {
        HashMap<String, Properties> propertiesMap = new HashMap<String, Properties>();
        ArrayList<BatchTestClassGroup> batchTestClassGroups = new ArrayList<BatchTestClassGroup>(this.getBatchTestClassGroups());
        batchTestClassGroups.addAll(this.getDependentBatchTestClassGroups());
        for (BatchTestClassGroup batchTestClassGroup : batchTestClassGroups) {
            Properties batchProperties = new Properties();
            batchProperties.setProperty("test.batch.cohort.name", batchTestClassGroup.getCohortName());
            batchProperties.setProperty("test.batch.job.name", batchTestClassGroup.getBatchJobName());
            batchProperties.setProperty("test.batch.maximum.slaves.per.host", String.valueOf(batchTestClassGroup.getMaximumSlavesPerHost()));
            batchProperties.setProperty("test.batch.minimum.slave.ram", String.valueOf(batchTestClassGroup.getMinimumSlaveRAM()));
            batchProperties.setProperty("test.batch.slave.label", batchTestClassGroup.getSlaveLabel());
            if (batchTestClassGroup instanceof FunctionalBatchTestClassGroup) {
                FunctionalBatchTestClassGroup functionalBatchTestClassGroup = (FunctionalBatchTestClassGroup)batchTestClassGroup;
                String testBatchRunPropertyQuery = functionalBatchTestClassGroup.getTestBatchRunPropertyQuery();
                if (testBatchRunPropertyQuery != null) {
                    batchProperties.setProperty("test.batch.run.property.query", testBatchRunPropertyQuery);
                }
            } else {
                batchProperties.setProperty("test.batch.size", String.valueOf(batchTestClassGroup.getAxisCount()));
            }
            if (this.isDownstreamEnabled()) {
                batchProperties.setProperty("test.downstream.job.name", batchTestClassGroup.getDownstreamJobName());
            }
            propertiesMap.put(batchTestClassGroup.getBatchName(), batchProperties);
            for (int i = 0; i < batchTestClassGroup.getSegmentCount(); ++i) {
                Properties segmentProperties = new Properties();
                SegmentTestClassGroup segmentTestClassGroup = batchTestClassGroup.getSegmentTestClassGroup(i);
                segmentProperties.setProperty("test.batch.cohort.name", segmentTestClassGroup.getCohortName());
                segmentProperties.setProperty("test.batch.job.name", segmentTestClassGroup.getBatchJobName());
                segmentProperties.setProperty("test.batch.maximum.slaves.per.host", String.valueOf(segmentTestClassGroup.getMaximumSlavesPerHost()));
                segmentProperties.setProperty("test.batch.minimum.slave.ram", String.valueOf(segmentTestClassGroup.getMinimumSlaveRAM()));
                segmentProperties.setProperty("test.batch.name", segmentTestClassGroup.getBatchName());
                segmentProperties.setProperty("test.batch.size", String.valueOf(segmentTestClassGroup.getAxisCount()));
                segmentProperties.setProperty("test.batch.slave.label", segmentTestClassGroup.getSlaveLabel());
                String testCasePropertiesContent = segmentTestClassGroup.getTestCasePropertiesContent();
                if (testCasePropertiesContent != null) {
                    testCasePropertiesContent = testCasePropertiesContent.replaceAll("\n", "\\${line.separator}");
                    segmentProperties.setProperty("test.case.properties", testCasePropertiesContent);
                }
                if (this.isDownstreamEnabled()) {
                    segmentProperties.setProperty("test.downstream.job.name", segmentTestClassGroup.getDownstreamJobName());
                }
                if (segmentTestClassGroup instanceof FunctionalSegmentTestClassGroup) {
                    segmentProperties.setProperty("run.test.case.method.group", String.valueOf(i));
                }
                propertiesMap.put(segmentTestClassGroup.getSegmentName(), segmentProperties);
            }
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry propertiesEntry : propertiesMap.entrySet()) {
            Properties properties = (Properties)propertiesEntry.getValue();
            for (String propertyName : properties.stringPropertyNames()) {
                sb.append(propertyName);
                sb.append("[");
                sb.append((String)propertiesEntry.getKey());
                sb.append("]=");
                sb.append(properties.getProperty(propertyName));
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public String getTestSuiteName() {
        if (this instanceof TestSuiteJob) {
            TestSuiteJob testSuiteJob = (TestSuiteJob)((Object)this);
            return testSuiteJob.getTestSuiteName();
        }
        return null;
    }

    @Override
    public int getTimeoutMinutes(JenkinsMaster jenkinsMaster) {
        return JenkinsResultsParserUtil.getJobTimeoutMinutes(jenkinsMaster, this.getJobName());
    }

    @Override
    public boolean isDownstreamEnabled() {
        JobProperty jobProperty = this.getJobProperty("test.batch.downstream.enabled");
        String downstreamEnabled = jobProperty.getValue();
        return downstreamEnabled != null && downstreamEnabled.equals("true");
    }

    @Override
    public boolean isJUnitTestsModifiedOnly() {
        if (this._jUnitTestFileModifiedOnly != null) {
            return this._jUnitTestFileModifiedOnly;
        }
        if (!(this instanceof PortalTestClassJob)) {
            this._jUnitTestFileModifiedOnly = false;
            return this._jUnitTestFileModifiedOnly;
        }
        List<PathMatcher> jUnitIncludePathMatchers = this._getJUnitIncludePathMatchers();
        if (jUnitIncludePathMatchers.isEmpty()) {
            this._jUnitTestFileModifiedOnly = false;
            return this._jUnitTestFileModifiedOnly;
        }
        PortalTestClassJob portalTestClassJob = (PortalTestClassJob)((Object)this);
        PortalGitWorkingDirectory portalGitWorkingDirectory = portalTestClassJob.getPortalGitWorkingDirectory();
        List<File> modifiedFilesList = portalGitWorkingDirectory.getModifiedFilesList();
        if (modifiedFilesList.isEmpty()) {
            this._jUnitTestFileModifiedOnly = false;
            return this._jUnitTestFileModifiedOnly;
        }
        for (File modifiedFile : modifiedFilesList) {
            if (JenkinsResultsParserUtil.isFileIncluded(null, jUnitIncludePathMatchers, modifiedFile)) continue;
            this._jUnitTestFileModifiedOnly = false;
            return this._jUnitTestFileModifiedOnly;
        }
        this._jUnitTestFileModifiedOnly = true;
        return this._jUnitTestFileModifiedOnly;
    }

    @Override
    public boolean isSegmentEnabled() {
        JobProperty jobProperty = this.getJobProperty("test.batch.segment.enabled");
        String segmentEnabled = jobProperty.getValue();
        return segmentEnabled != null && segmentEnabled.equals("true");
    }

    @Override
    public boolean isStandaloneBatchEnabled() {
        return false;
    }

    @Override
    public boolean isValidationRequired() {
        return false;
    }

    @Override
    public boolean testAnalyticsCloud() {
        for (BatchTestClassGroup batchTestClassGroup : this.getBatchTestClassGroups()) {
            if (!batchTestClassGroup.testAnalyticsCloud()) continue;
            this._testAnalyticsCloud = true;
            return this._testAnalyticsCloud;
        }
        this._testAnalyticsCloud = false;
        return this._testAnalyticsCloud;
    }

    @Override
    public boolean testHotfixChanges() {
        JobProperty jobProperty = this.getJobProperty("test.hotfix.changes");
        if (jobProperty != null) {
            this.recordJobProperty(jobProperty);
            return Boolean.parseBoolean(jobProperty.getValue());
        }
        return false;
    }

    @Override
    public boolean testJaCoCoCodeCoverage() {
        JobProperty jobProperty = this.getJobProperty("test.jacoco.code.coverage");
        if (jobProperty != null) {
            this.recordJobProperty(jobProperty);
            return Boolean.parseBoolean(jobProperty.getValue());
        }
        return false;
    }

    @Override
    public boolean testReleaseBundle() {
        JobProperty jobProperty = this.getJobProperty("test.release.bundle");
        if (jobProperty != null) {
            this.recordJobProperty(jobProperty);
            return Boolean.parseBoolean(jobProperty.getValue());
        }
        return false;
    }

    @Override
    public boolean testRelevantChanges() {
        JobProperty jobProperty = this.getJobProperty("test.relevant.changes");
        if (jobProperty != null) {
            this.recordJobProperty(jobProperty);
            return Boolean.parseBoolean(jobProperty.getValue());
        }
        return false;
    }

    @Override
    public boolean testRelevantChangesInStable() {
        JobProperty jobProperty = this.getJobProperty("test.relevant.changes.in.stable");
        if (jobProperty != null) {
            this.recordJobProperty(jobProperty);
            return Boolean.parseBoolean(jobProperty.getValue());
        }
        return false;
    }

    protected BaseJob(Job.BuildProfile buildProfile, String jobName) {
        this._buildProfile = buildProfile;
        this._jobName = jobName;
    }

    protected BaseJob(JSONObject jsonObject) {
        this.jsonObject = jsonObject;
        this._buildProfile = Job.BuildProfile.getByString(jsonObject.getString("build_profile"));
        this._companyDefaultLocale = jsonObject.optString("company_default_locale");
        this._jobName = jsonObject.getString("job_name");
    }

    protected List<BatchTestClassGroup> getBatchTestClassGroups(List<TestBatch> testBatches) {
        if (testBatches == null || testBatches.isEmpty()) {
            return new ArrayList<BatchTestClassGroup>();
        }
        long start = JenkinsResultsParserUtil.getCurrentTimeMillis();
        System.out.println(JenkinsResultsParserUtil.combine("Started creating ", String.valueOf(testBatches.size()), " batch test class groups at ", JenkinsResultsParserUtil.toDateString(new Date(start))));
        ArrayList callables = new ArrayList();
        String testSuiteName = this.getTestSuiteName();
        final BaseJob job = this;
        HashMap<Object, ArrayList<1>> testBaseDirCallablesMap = new HashMap<Object, ArrayList<1>>();
        for (final TestBatch testBatch : testBatches) {
            Object testBaseDir = null;
            final String batchName = testBatch.getName();
            JobProperty jobProperty = this.getJobProperty("test.base.dir", testSuiteName, batchName);
            if (jobProperty != null && !JenkinsResultsParserUtil.isNullOrEmpty(jobProperty.getValue())) {
                testBaseDir = new File(jobProperty.getValue());
            }
            Callable<BatchTestClassGroup> callable = new Callable<BatchTestClassGroup>(){
                private final Integer _pauseRetryCount = 2;
                private final Integer _pauseRetryDuration = 5000;

                @Override
                public BatchTestClassGroup call() throws Exception {
                    for (int i = 0; i < this._pauseRetryCount; ++i) {
                        try {
                            return this._call();
                        }
                        catch (Exception exception) {
                            String message = exception.getMessage();
                            if (message != null && message.contains("Errors found in Playwright tests")) {
                                throw exception;
                            }
                            System.out.println(JenkinsResultsParserUtil.combine("[", batchName, "] Retry creating a ", "test class group in ", String.valueOf(this._pauseRetryDuration / 1000), " seconds"));
                            JenkinsResultsParserUtil.sleep(this._pauseRetryDuration.intValue());
                            continue;
                        }
                    }
                    return this._call();
                }

                private BatchTestClassGroup _call() throws Exception {
                    long start = JenkinsResultsParserUtil.getCurrentTimeMillis();
                    System.out.println(JenkinsResultsParserUtil.combine("[", batchName, "] Started batch test class ", "group at ", JenkinsResultsParserUtil.toDateString(new Date(start))));
                    BatchTestClassGroup batchTestClassGroup = TestClassGroupFactory.newBatchTestClassGroup(job, testBatch);
                    long duration = JenkinsResultsParserUtil.getCurrentTimeMillis() - start;
                    System.out.println(JenkinsResultsParserUtil.combine("[", batchName, "] Completed batch test class ", "group in ", JenkinsResultsParserUtil.toDurationString(duration), " at ", JenkinsResultsParserUtil.toDateString(new Date())));
                    if (batchTestClassGroup.getAxisCount() <= 0) {
                        return null;
                    }
                    return batchTestClassGroup;
                }
            };
            if (testBaseDir == null) {
                callables.add(callable);
                continue;
            }
            ArrayList<1> testBaseDirCallables = (ArrayList<1>)testBaseDirCallablesMap.get(testBaseDir);
            if (testBaseDirCallables == null) {
                testBaseDirCallables = new ArrayList<1>();
                testBaseDirCallablesMap.put(testBaseDir, testBaseDirCallables);
            }
            testBaseDirCallables.add(callable);
            testBaseDirCallablesMap.put(testBaseDir, testBaseDirCallables);
        }
        ParallelExecutor parallelExecutor = new ParallelExecutor(callables, _executorService, "getBatchTestClassGroups");
        List<BatchTestClassGroup> batchTestClassGroups = null;
        try {
            batchTestClassGroups = parallelExecutor.execute();
            for (List testBaseDirCallables : testBaseDirCallablesMap.values()) {
                parallelExecutor = new ParallelExecutor(testBaseDirCallables, _executorService, "getBatchTestClassGroups2");
                batchTestClassGroups.addAll(parallelExecutor.execute());
            }
        }
        catch (TimeoutException timeoutException) {
            throw new RuntimeException(timeoutException);
        }
        batchTestClassGroups.removeAll(Collections.singleton(null));
        System.out.println(JenkinsResultsParserUtil.combine("Completed creating ", String.valueOf(batchTestClassGroups.size()), " batch test class groups in ", JenkinsResultsParserUtil.toDurationString(JenkinsResultsParserUtil.getCurrentTimeMillis() - start), " at ", JenkinsResultsParserUtil.toDateString(new Date())));
        return batchTestClassGroups;
    }

    protected List<BatchTestClassGroup> getBatchTestClassGroups(Set<String> rawBatchNames) {
        List<BatchTestClassGroup> batchTestClassGroups;
        if (rawBatchNames == null || rawBatchNames.isEmpty()) {
            return new ArrayList<BatchTestClassGroup>();
        }
        long start = JenkinsResultsParserUtil.getCurrentTimeMillis();
        System.out.println(JenkinsResultsParserUtil.combine("Started creating ", String.valueOf(rawBatchNames.size()), " batch test class groups at ", JenkinsResultsParserUtil.toDateString(new Date(start))));
        ArrayList callables = new ArrayList();
        String testSuiteName = this.getTestSuiteName();
        final BaseJob job = this;
        HashMap<Object, ArrayList<2>> testBaseDirCallablesMap = new HashMap<Object, ArrayList<2>>();
        for (final String batchName : rawBatchNames) {
            Object testBaseDir = null;
            JobProperty jobProperty = this.getJobProperty("test.base.dir", testSuiteName, batchName);
            if (jobProperty != null && !JenkinsResultsParserUtil.isNullOrEmpty(jobProperty.getValue())) {
                testBaseDir = new File(jobProperty.getValue());
            }
            Callable<BatchTestClassGroup> callable = new Callable<BatchTestClassGroup>(){
                private final Integer _pauseRetryCount = 2;
                private final Integer _pauseRetryDuration = 5000;

                @Override
                public BatchTestClassGroup call() throws Exception {
                    for (int i = 0; i < this._pauseRetryCount; ++i) {
                        try {
                            return this._call();
                        }
                        catch (Exception exception) {
                            String message = exception.getMessage();
                            if (message != null && message.contains("Errors found in Playwright tests")) {
                                throw exception;
                            }
                            System.out.println(JenkinsResultsParserUtil.combine("[", batchName, "] Retry creating a ", "test class group in ", String.valueOf(this._pauseRetryDuration / 1000), " seconds."));
                            JenkinsResultsParserUtil.sleep(this._pauseRetryDuration.intValue());
                            continue;
                        }
                    }
                    return this._call();
                }

                private BatchTestClassGroup _call() throws Exception {
                    long start = JenkinsResultsParserUtil.getCurrentTimeMillis();
                    System.out.println(JenkinsResultsParserUtil.combine("[", batchName, "] Started batch test class ", "group at ", JenkinsResultsParserUtil.toDateString(new Date(start))));
                    BatchTestClassGroup batchTestClassGroup = TestClassGroupFactory.newBatchTestClassGroup(batchName, job);
                    long duration = JenkinsResultsParserUtil.getCurrentTimeMillis() - start;
                    System.out.println(JenkinsResultsParserUtil.combine("[", batchName, "] Completed batch test class ", "group in ", JenkinsResultsParserUtil.toDurationString(duration), " at ", JenkinsResultsParserUtil.toDateString(new Date())));
                    if (batchTestClassGroup.getAxisCount() <= 0) {
                        return null;
                    }
                    return batchTestClassGroup;
                }
            };
            if (testBaseDir == null) {
                callables.add(callable);
                continue;
            }
            ArrayList<2> testBaseDirCallables = (ArrayList<2>)testBaseDirCallablesMap.get(testBaseDir);
            if (testBaseDirCallables == null) {
                testBaseDirCallables = new ArrayList<2>();
                testBaseDirCallablesMap.put(testBaseDir, testBaseDirCallables);
            }
            testBaseDirCallables.add(callable);
            testBaseDirCallablesMap.put(testBaseDir, testBaseDirCallables);
        }
        ParallelExecutor parallelExecutor = new ParallelExecutor(callables, _executorService, "getBatchTestClassGroups");
        try {
            batchTestClassGroups = parallelExecutor.execute();
            if (parallelExecutor.hasFailedTask()) {
                throw new RuntimeException("Unable to create batch test class groups");
            }
            for (List testBaseDirCallables : testBaseDirCallablesMap.values()) {
                parallelExecutor = new ParallelExecutor(testBaseDirCallables, _executorService, "getBatchTestClassGroups2");
                batchTestClassGroups.addAll(parallelExecutor.execute());
                if (!parallelExecutor.hasFailedTask()) continue;
                throw new RuntimeException("Unable to create batch test class groups");
            }
        }
        catch (TimeoutException timeoutException) {
            throw new RuntimeException(timeoutException);
        }
        batchTestClassGroups.removeAll(Collections.singleton(null));
        System.out.println(JenkinsResultsParserUtil.combine("Completed creating ", String.valueOf(batchTestClassGroups.size()), " batch test class groups in ", JenkinsResultsParserUtil.toDurationString(JenkinsResultsParserUtil.getCurrentTimeMillis() - start), " at ", JenkinsResultsParserUtil.toDateString(new Date())));
        return batchTestClassGroups;
    }

    protected Document getConfigDocument(JenkinsMaster jenkinsMaster) throws DocumentException, IOException {
        if (this._configDocument == null) {
            this._configDocument = JenkinsResultsParserUtil.getJobConfigDocument(jenkinsMaster, this.getJobName());
        }
        return this._configDocument;
    }

    protected JSONObject getJobJSONObject(JenkinsMaster jenkinsMaster, String tree) {
        if (this.getJobURL(jenkinsMaster) == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(JenkinsResultsParserUtil.getLocalURL(this.getJobURL(jenkinsMaster)));
        sb.append("/api/json?pretty");
        if (tree != null) {
            sb.append("&tree=");
            sb.append(tree);
        }
        try {
            return JenkinsResultsParserUtil.toJSONObject(sb.toString(), false);
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to get job JSON", ioException);
        }
    }

    protected JobProperty getJobProperty(String basePropertyName) {
        return JobPropertyFactory.newJobProperty(basePropertyName, null, null, this, null, null, true);
    }

    protected JobProperty getJobProperty(String basePropertyName, boolean useBasePropertyName) {
        return JobPropertyFactory.newJobProperty(basePropertyName, null, null, this, null, null, useBasePropertyName);
    }

    protected JobProperty getJobProperty(String basePropertyName, String testSuiteName, String batchName) {
        return JobPropertyFactory.newJobProperty(basePropertyName, testSuiteName, batchName, this, null, null, true);
    }

    protected JobProperty getJobProperty(String basePropertyName, String testSuiteName, String batchName, JobProperty.Type type) {
        return JobPropertyFactory.newJobProperty(basePropertyName, testSuiteName, batchName, this, null, type, true);
    }

    protected Set<String> getRawBatchNames() {
        JobProperty jobProperty = this.getJobProperty("test.batch.names");
        this.recordJobProperty(jobProperty);
        return this.getSetFromString(jobProperty.getValue());
    }

    protected Set<String> getRawDependentBatchNames() {
        JobProperty jobProperty = this.getJobProperty("test.batch.names.smoke");
        this.recordJobProperty(jobProperty);
        return this.getSetFromString(jobProperty.getValue());
    }

    protected Set<String> getSetFromString(String string) {
        TreeSet<String> set = new TreeSet<String>();
        if (JenkinsResultsParserUtil.isNullOrEmpty(string)) {
            return set;
        }
        for (String item : StringUtils.split((String)string, (String)",")) {
            if (item.startsWith("#")) continue;
            set.add(item.trim());
        }
        return set;
    }

    protected List<TestBatch> getTestBatches() {
        return new ArrayList<TestBatch>();
    }

    protected void recordJobProperties(Set<JobProperty> jobProperties) {
        for (JobProperty jobProperty : jobProperties) {
            this.recordJobProperty(jobProperty);
        }
    }

    protected void recordJobProperty(JobProperty jobProperty) {
        if (jobProperty == null || this.jobProperties.contains(jobProperty)) {
            return;
        }
        this.jobProperties.add(jobProperty);
    }

    private int _getDistNodeAxisCount() {
        try {
            String distNodeAxisCount = JenkinsResultsParserUtil.getBuildProperty("dist.node.axis.count");
            if (JenkinsResultsParserUtil.isInteger(distNodeAxisCount)) {
                return Integer.parseInt(distNodeAxisCount);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 25;
    }

    private int _getDistNodeCountMinimum() {
        try {
            String distNodeCountMinimum = JenkinsResultsParserUtil.getBuildProperty("dist.node.count.minimum");
            if (JenkinsResultsParserUtil.isInteger(distNodeCountMinimum)) {
                return Integer.parseInt(distNodeCountMinimum);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Properties> _getJobPropertiesMap() {
        List<JobProperty> list = this.jobProperties;
        synchronized (list) {
            if (!this._initializeJobProperties) {
                this.getBatchTestClassGroups();
                this.getDependentBatchTestClassGroups();
                this._initializeJobProperties = true;
            }
        }
        TreeMap<String, Properties> jobPropertiesMap = new TreeMap<String, Properties>();
        for (JobProperty jobProperty : this.jobProperties) {
            String jobPropertyValue;
            if (jobProperty == null || (jobPropertyValue = jobProperty.getValue()) == null) continue;
            String propertiesFilePath = jobProperty.getPropertiesFilePath();
            Properties properties = (Properties)jobPropertiesMap.get(propertiesFilePath);
            if (properties == null) {
                properties = new Properties();
            }
            properties.setProperty(jobProperty.getName(), jobPropertyValue);
            jobPropertiesMap.put(propertiesFilePath, properties);
        }
        return jobPropertiesMap;
    }

    private List<PathMatcher> _getJUnitIncludePathMatchers() {
        ArrayList<PathMatcher> jUnitIncludePathMatchers = new ArrayList<PathMatcher>();
        String testSuiteName = this.getTestSuiteName();
        if (testSuiteName == null) {
            testSuiteName = "default";
        }
        for (String jUnitBatchName : _JUNIT_BATCH_NAMES) {
            String jobPropertyValue;
            JobProperty jobProperty = this.getJobProperty("test.batch.class.names.filter", testSuiteName, jUnitBatchName, JobProperty.Type.INCLUDE_GLOB);
            if (!(jobProperty instanceof GlobJobProperty) || (jobPropertyValue = jobProperty.getValue()) == null) continue;
            GlobJobProperty globJobProperty = (GlobJobProperty)jobProperty;
            jUnitIncludePathMatchers.addAll(globJobProperty.getPathMatchers());
        }
        return jUnitIncludePathMatchers;
    }

    private int _getSlaveRAMMinimumDefault() {
        try {
            String slaveRAMMinimumDefault = JenkinsResultsParserUtil.getBuildProperty("slave.ram.minimum.default");
            if (JenkinsResultsParserUtil.isInteger(slaveRAMMinimumDefault)) {
                return Integer.parseInt(slaveRAMMinimumDefault);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 16;
    }

    private int _getSlavesPerHostDefault() {
        try {
            String slavesPerHostDefault = JenkinsResultsParserUtil.getBuildProperty("slaves.per.host.default");
            if (JenkinsResultsParserUtil.isInteger(slavesPerHostDefault)) {
                return Integer.parseInt(slavesPerHostDefault);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 2;
    }
}

