/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseBuild;
import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.BuildFactory;
import com.liferay.jenkins.results.parser.Dom4JUtil;
import com.liferay.jenkins.results.parser.DownstreamBuild;
import com.liferay.jenkins.results.parser.JenkinsMaster;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.NotificationUtil;
import com.liferay.jenkins.results.parser.ParallelExecutor;
import com.liferay.jenkins.results.parser.ParentBuild;
import com.liferay.jenkins.results.parser.TestResult;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Element;

public abstract class BaseParentBuild
extends BaseBuild
implements ParentBuild {
    private static final Pattern _buildURLPattern = Pattern.compile("http[s]?\\:\\/\\/(?<hostname>[^\\/]+)\\/.*");
    private List<Build> _downstreamBuilds;

    @Override
    public void addDownstreamBuilds(Map<String, String> urlAxisNames) {
        if (urlAxisNames.isEmpty()) {
            return;
        }
        final BaseParentBuild thisBuild = this;
        ArrayList callables = new ArrayList(urlAxisNames.size());
        for (Map.Entry<String, String> urlEntry : urlAxisNames.entrySet()) {
            String url = urlEntry.getKey();
            try {
                url = JenkinsResultsParserUtil.getLocalURL(JenkinsResultsParserUtil.decode(url));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new IllegalArgumentException("Unable to decode " + url, unsupportedEncodingException);
            }
            if (this.hasBuildURL(url)) continue;
            final String axisName = urlEntry.getValue();
            final String buildURL = url;
            Matcher matcher = _buildURLPattern.matcher(buildURL);
            String hostname = null;
            if (matcher.matches()) {
                hostname = matcher.group("hostname");
            }
            ParallelExecutor.SequentialCallable<Build> callable = new ParallelExecutor.SequentialCallable<Build>(hostname){

                @Override
                public Build call() {
                    try {
                        return BuildFactory.newBuild(buildURL, thisBuild, axisName);
                    }
                    catch (RuntimeException runtimeException) {
                        if (!BaseParentBuild.this.isFromArchive()) {
                            NotificationUtil.sendSlackNotification(runtimeException.getMessage() + "\nBuild URL: " + thisBuild.getBuildURL(), "ci-notifications", "Build object failure");
                        }
                        return null;
                    }
                }
            };
            callables.add(callable);
        }
        ParallelExecutor parallelExecutor = new ParallelExecutor(callables, true, this.getExecutorService(), "addDownstreamBuilds");
        try {
            this.addDownstreamBuilds(parallelExecutor.execute(1800L));
        }
        catch (TimeoutException timeoutException) {
            throw new RuntimeException(timeoutException);
        }
    }

    @Override
    public void addDownstreamBuilds(String ... urls) {
        HashMap<String, String> urlAxisNames = new HashMap<String, String>();
        for (String url : urls) {
            urlAxisNames.put(url, null);
        }
        this.addDownstreamBuilds(urlAxisNames);
    }

    @Override
    public int getDownstreamBuildCount(String status) {
        return this.getDownstreamBuildCount(null, status);
    }

    @Override
    public int getDownstreamBuildCount(String result, String status) {
        List<Build> downstreamBuilds = this.getDownstreamBuilds(result, status);
        return downstreamBuilds.size();
    }

    @Override
    public List<Build> getDownstreamBuilds() {
        if (this._downstreamBuilds != null) {
            return new ArrayList<Build>(this._downstreamBuilds);
        }
        this._downstreamBuilds = new ArrayList<Build>();
        return new ArrayList<Build>(this._downstreamBuilds);
    }

    @Override
    public List<Build> getDownstreamBuilds(String status) {
        return this.getDownstreamBuilds(null, status);
    }

    @Override
    public List<Build> getDownstreamBuilds(String result, String status) {
        List<Build> filteredDownstreamBuilds = Collections.synchronizedList(new ArrayList());
        List<Build> downstreamBuilds = this.getDownstreamBuilds();
        if (result == null && status == null) {
            filteredDownstreamBuilds.addAll(downstreamBuilds);
            return filteredDownstreamBuilds;
        }
        for (Build downstreamBuild : downstreamBuilds) {
            if (status != null && !status.equals(downstreamBuild.getStatus()) || result != null && !result.equals(downstreamBuild.getResult())) continue;
            filteredDownstreamBuilds.add(downstreamBuild);
        }
        return filteredDownstreamBuilds;
    }

    @Override
    public Long getLatestStartTimestamp() {
        Long latestStartTimestamp = this.getStartTime();
        if (latestStartTimestamp == null) {
            return null;
        }
        for (Build downstreamBuild : this.getDownstreamBuilds(null)) {
            Long downstreamBuildLatestStartTimestamp = null;
            if (downstreamBuild instanceof ParentBuild) {
                ParentBuild parentBuild = (ParentBuild)downstreamBuild;
                downstreamBuildLatestStartTimestamp = parentBuild.getLatestStartTimestamp();
            } else {
                downstreamBuildLatestStartTimestamp = downstreamBuild.getStartTime();
            }
            if (downstreamBuildLatestStartTimestamp == null) {
                return null;
            }
            latestStartTimestamp = Math.max(latestStartTimestamp, downstreamBuildLatestStartTimestamp);
        }
        return latestStartTimestamp;
    }

    @Override
    public Build getLongestDelayedDownstreamBuild() {
        List<Build> downstreamBuilds = this.getDownstreamBuilds(null);
        if (downstreamBuilds.isEmpty()) {
            return this;
        }
        Build longestDelayedBuild = downstreamBuilds.get(0);
        Iterator<Build> iterator = downstreamBuilds.iterator();
        while (iterator.hasNext()) {
            Build downstreamBuild;
            Build longestDelayedDownstreamBuild = downstreamBuild = iterator.next();
            if (downstreamBuild instanceof ParentBuild) {
                ParentBuild parentBuild = (ParentBuild)downstreamBuild;
                longestDelayedDownstreamBuild = parentBuild.getLongestDelayedDownstreamBuild();
            }
            if (downstreamBuild.getDelayTime() > longestDelayedDownstreamBuild.getDelayTime()) {
                longestDelayedDownstreamBuild = downstreamBuild;
            }
            if (longestDelayedDownstreamBuild.getDelayTime() <= longestDelayedBuild.getDelayTime()) continue;
            longestDelayedBuild = longestDelayedDownstreamBuild;
        }
        return longestDelayedBuild;
    }

    @Override
    public Build getLongestRunningDownstreamBuild() {
        Build longestRunningDownstreamBuild = null;
        for (Build downstreamBuild : this.getDownstreamBuilds(null)) {
            if (longestRunningDownstreamBuild != null && downstreamBuild.getDuration() <= longestRunningDownstreamBuild.getDuration()) continue;
            longestRunningDownstreamBuild = downstreamBuild;
        }
        return longestRunningDownstreamBuild;
    }

    @Override
    public List<Build> getModifiedDownstreamBuilds() {
        return this.getModifiedDownstreamBuildsByStatus(null);
    }

    @Override
    public List<Build> getModifiedDownstreamBuildsByStatus(String status) {
        ArrayList<Build> modifiedDownstreamBuilds = new ArrayList<Build>();
        for (Build downstreamBuild : this.getDownstreamBuilds()) {
            ParentBuild parentBuild;
            if (downstreamBuild.isBuildModified()) {
                modifiedDownstreamBuilds.add(downstreamBuild);
                continue;
            }
            if (!(downstreamBuild instanceof ParentBuild) || !(parentBuild = (ParentBuild)downstreamBuild).hasModifiedDownstreamBuilds()) continue;
            modifiedDownstreamBuilds.add(parentBuild);
        }
        if (status != null) {
            modifiedDownstreamBuilds.retainAll(this.getDownstreamBuilds(status));
        }
        return modifiedDownstreamBuilds;
    }

    @Override
    public List<TestResult> getTestResults(String testStatus) {
        ArrayList<TestResult> testResults = new ArrayList<TestResult>();
        for (Build downstreamBuild : this.getDownstreamBuilds(null)) {
            List<TestResult> downstreamTestResults = downstreamBuild.getTestResults(testStatus);
            if (downstreamTestResults == null) continue;
            testResults.addAll(downstreamTestResults);
        }
        return testResults;
    }

    @Override
    public long getTotalDuration() {
        long totalDuration = this.getDuration();
        for (Build downstreamBuild : JenkinsResultsParserUtil.flatten(this.getDownstreamBuilds(null))) {
            totalDuration += downstreamBuild.getDuration();
        }
        return totalDuration;
    }

    @Override
    public int getTotalSlavesUsedCount() {
        return this.getTotalSlavesUsedCount(null, false);
    }

    @Override
    public int getTotalSlavesUsedCount(String status, boolean modifiedBuildsOnly) {
        return this.getTotalSlavesUsedCount(status, modifiedBuildsOnly, false);
    }

    @Override
    public int getTotalSlavesUsedCount(String status, boolean modifiedBuildsOnly, boolean ignoreCurrentBuild) {
        int totalSlavesUsedCount = 1;
        if (ignoreCurrentBuild || modifiedBuildsOnly && !this.isBuildModified() || status != null && !status.equals(this.getStatus())) {
            totalSlavesUsedCount = 0;
        }
        List<Build> downstreamBuilds = modifiedBuildsOnly ? this.getModifiedDownstreamBuildsByStatus(status) : this.getDownstreamBuilds(status);
        return totalSlavesUsedCount + downstreamBuilds.size();
    }

    @Override
    public List<TestResult> getUniqueFailureTestResults() {
        ArrayList<TestResult> uniqueFailureTestResults = new ArrayList<TestResult>();
        for (Build downstreamBuild : this.getFailedDownstreamBuilds()) {
            uniqueFailureTestResults.addAll(downstreamBuild.getUniqueFailureTestResults());
        }
        return uniqueFailureTestResults;
    }

    @Override
    public List<TestResult> getUpstreamJobFailureTestResults() {
        ArrayList<TestResult> upstreamFailureTestResults = new ArrayList<TestResult>();
        for (Build downstreamBuild : this.getFailedDownstreamBuilds()) {
            upstreamFailureTestResults.addAll(downstreamBuild.getUpstreamJobFailureTestResults());
        }
        return upstreamFailureTestResults;
    }

    @Override
    public boolean hasBuildURL(String buildURL) {
        if (super.hasBuildURL(buildURL)) {
            return true;
        }
        for (Build downstreamBuild : this.getDownstreamBuilds()) {
            if (!downstreamBuild.hasBuildURL(buildURL)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasDownstreamBuilds() {
        return this.getDownstreamBuildCount(null, null) > 0;
    }

    @Override
    public boolean hasModifiedDownstreamBuilds() {
        for (Build downstreamBuild : this.getDownstreamBuilds()) {
            ParentBuild parentBuild;
            if (downstreamBuild.isBuildModified()) {
                return true;
            }
            if (!(downstreamBuild instanceof ParentBuild) || !(parentBuild = (ParentBuild)downstreamBuild).hasModifiedDownstreamBuilds()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void removeDownstreamBuild(Build build) {
        if (this._downstreamBuilds == null) {
            this.getDownstreamBuilds();
        }
        this._downstreamBuilds.remove(build);
    }

    @Override
    public String replaceBuildURL(String text) {
        if (JenkinsResultsParserUtil.isNullOrEmpty(text)) {
            return text;
        }
        text = super.replaceBuildURL(text);
        Iterator<Build> iterator = this.getDownstreamBuilds("complete").iterator();
        while (iterator.hasNext()) {
            Build downstreamBuild;
            Build downstreamBaseBuild = downstreamBuild = iterator.next();
            text = downstreamBaseBuild.replaceBuildURL(text);
        }
        return super.replaceBuildURL(text);
    }

    @Override
    public void reset() {
        super.reset();
        if (this._downstreamBuilds != null) {
            this._downstreamBuilds.clear();
        }
    }

    @Override
    public void update() {
        if (this.skipUpdate()) {
            return;
        }
        List<Build> downstreamBuilds = this.getDownstreamBuilds(null);
        ArrayList callables = new ArrayList();
        for (final Build downstreamBuild : downstreamBuilds) {
            String status = downstreamBuild.getStatus();
            if (status.equals("completed")) continue;
            JenkinsMaster jenkinsMaster = downstreamBuild.getJenkinsMaster();
            ParallelExecutor.SequentialCallable<Object> callable = new ParallelExecutor.SequentialCallable<Object>(jenkinsMaster.getName()){

                @Override
                public Object call() {
                    downstreamBuild.update();
                    return null;
                }
            };
            callables.add(callable);
        }
        ParallelExecutor parallelExecutor = new ParallelExecutor(callables, this.getExecutorService(), "update");
        try {
            if (Objects.equals(this.getJobName(), "test-portal-release")) {
                parallelExecutor.execute(14400L);
            } else {
                parallelExecutor.execute();
            }
        }
        catch (TimeoutException timeoutException) {
            throw new RuntimeException(timeoutException);
        }
        this.findDownstreamBuilds();
        super.update();
    }

    protected BaseParentBuild(String url) {
        super(url);
    }

    protected BaseParentBuild(String url, Build parentBuild) {
        super(url, parentBuild);
    }

    protected void addDownstreamBuilds(Collection<Build> builds) {
        if (builds == null) {
            return;
        }
        builds.removeAll(Collections.singleton(null));
        if (this._downstreamBuilds == null) {
            this.getDownstreamBuilds();
        }
        this._downstreamBuilds.addAll(builds);
    }

    protected void addDownstreamBuildsTimelineData(Build.TimelineData timelineData) {
        for (Build downstreamBuild : this.getDownstreamBuilds(null)) {
            downstreamBuild.addTimelineData(timelineData);
        }
    }

    protected abstract void findDownstreamBuilds();

    @Override
    protected List<Callable<Object>> getArchiveCallables() {
        List<Callable<Object>> archiveCallables = super.getArchiveCallables();
        List<Build> downstreamBuilds = this.getDownstreamBuilds();
        if (downstreamBuilds != null && !downstreamBuilds.isEmpty()) {
            for (Build downstreamBuild : downstreamBuilds) {
                if (!(downstreamBuild instanceof BaseBuild)) continue;
                BaseBuild downstreamBaseBuild = (BaseBuild)downstreamBuild;
                archiveCallables.addAll(downstreamBaseBuild.getArchiveCallables());
            }
        }
        return archiveCallables;
    }

    protected int getDownstreamBuildCountByResult(String result) {
        List<Build> downstreamBuilds = this.getDownstreamBuilds(null);
        if (result == null) {
            return downstreamBuilds.size();
        }
        int count = 0;
        for (Build downstreamBuild : downstreamBuilds) {
            String downstreamBuildResult = downstreamBuild.getResult();
            if (!Objects.equals(downstreamBuildResult, result)) continue;
            ++count;
        }
        return count;
    }

    protected List<Element> getDownstreamBuildMessageElements(List<Build> downstreamBuilds) {
        ArrayList callables = new ArrayList();
        for (final Build downstreamBuild : downstreamBuilds) {
            JenkinsMaster jenkinsMaster = downstreamBuild.getJenkinsMaster();
            ParallelExecutor.SequentialCallable<Element> callable = new ParallelExecutor.SequentialCallable<Element>(jenkinsMaster.getName()){

                @Override
                public Element call() {
                    return downstreamBuild.getGitHubMessageElement();
                }
            };
            callables.add(callable);
        }
        ParallelExecutor parallelExecutor = new ParallelExecutor(callables, this.getExecutorService(), "getDownstreamBuildMessages");
        try {
            return parallelExecutor.execute();
        }
        catch (TimeoutException timeoutException) {
            throw new RuntimeException(timeoutException);
        }
    }

    protected List<Build> getFailedDownstreamBuilds() {
        ArrayList<Build> failedDownstreamBuilds = new ArrayList<Build>();
        failedDownstreamBuilds.addAll(this.getDownstreamBuilds("ABORTED", null));
        failedDownstreamBuilds.addAll(this.getDownstreamBuilds("MISSING", null));
        failedDownstreamBuilds.addAll(this.getDownstreamBuilds("FAILURE", null));
        failedDownstreamBuilds.addAll(this.getDownstreamBuilds("UNSTABLE", null));
        return failedDownstreamBuilds;
    }

    @Override
    protected List<Element> getJenkinsReportTableRowElements(String result, String status) {
        List<Element> tableRowElements = super.getJenkinsReportTableRowElements(result, status);
        List<Build> builds = this.getDownstreamBuilds(result, status);
        Collections.sort(builds, new BaseBuild.BuildDisplayNameComparator());
        String batchName = null;
        for (Build build : builds) {
            DownstreamBuild downstreamBuild;
            String downstreamBatchName;
            if (!(build instanceof BaseBuild)) continue;
            if (build instanceof DownstreamBuild && !Objects.equals(batchName, downstreamBatchName = (downstreamBuild = (DownstreamBuild)build).getBatchName())) {
                tableRowElements.add(Dom4JUtil.getNewElement("th", null, downstreamBatchName));
                batchName = downstreamBatchName;
            }
            BaseBuild baseBuild = (BaseBuild)build;
            tableRowElements.addAll(baseBuild.getJenkinsReportTableRowElements(result, status));
        }
        return tableRowElements;
    }

    @Override
    protected boolean skipUpdate() {
        boolean skipUpdate = super.skipUpdate();
        return skipUpdate && !this.hasModifiedDownstreamBuilds();
    }

    protected void sortDownstreamBuilds() {
        Collections.sort(this._downstreamBuilds, new BaseBuild.BuildDisplayNameComparator());
    }
}

