/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.DownstreamBuildReport;
import com.liferay.jenkins.results.parser.TestClassReport;
import com.liferay.jenkins.results.parser.TestReport;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseTestClassReport
implements TestClassReport {
    private final DownstreamBuildReport _downstreamBuildReport;
    private final String _testClassName;
    private final List<TestReport> _testReports = new ArrayList<TestReport>();

    @Override
    public void addTestReport(TestReport testReport) {
        this._testReports.add(testReport);
    }

    @Override
    public DownstreamBuildReport getDownstreamBuildReport() {
        return this._downstreamBuildReport;
    }

    @Override
    public long getDuration() {
        long duration = 0L;
        for (TestReport testReport : this.getTestReports()) {
            long testReportDuration = testReport.getDuration();
            if (testReportDuration < 0L) continue;
            duration += testReportDuration;
        }
        return duration;
    }

    @Override
    public long getOverheadDuration() {
        DownstreamBuildReport downstreamBuildReport = this.getDownstreamBuildReport();
        long overheadDuration = downstreamBuildReport.getDuration();
        for (TestReport testReport : downstreamBuildReport.getTestReports()) {
            overheadDuration -= testReport.getDuration();
        }
        if (overheadDuration <= 0L) {
            return 0L;
        }
        return overheadDuration;
    }

    @Override
    public String getStatus() {
        for (TestReport testReport : this.getTestReports()) {
            String status = testReport.getStatus();
            if (status.equals("REGRESSION") || status.equals("FAILED")) {
                return "FAILED";
            }
            if (status.equals("FIXED") || status.equals("PASSED") || status.equals("SKIPPED")) continue;
            throw new RuntimeException("Invalid status " + status);
        }
        return "PASSED";
    }

    @Override
    public String getTestClassName() {
        return this._testClassName;
    }

    @Override
    public List<TestReport> getTestReports() {
        return this._testReports;
    }

    @Override
    public String getTestTaskName() {
        if (this._testReports.isEmpty()) {
            return null;
        }
        TestReport testReport = this._testReports.get(0);
        if (testReport == null) {
            return null;
        }
        return testReport.getTestTaskName();
    }

    protected BaseTestClassReport(DownstreamBuildReport downstreamBuildReport, String testClassName) {
        this._downstreamBuildReport = downstreamBuildReport;
        this._testClassName = testClassName;
    }
}

