/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.Dom4JUtil;
import com.liferay.jenkins.results.parser.DownstreamBuild;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.TestClassResult;
import com.liferay.jenkins.results.parser.TestHistory;
import com.liferay.jenkins.results.parser.TestResult;
import com.liferay.jenkins.results.parser.TestResultFactory;
import com.liferay.jenkins.results.parser.test.clazz.JUnitTestClass;
import com.liferay.jenkins.results.parser.test.clazz.TestClass;
import com.liferay.jenkins.results.parser.test.clazz.group.AxisTestClassGroup;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.dom4j.Element;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class BaseTestClassResult
implements TestClassResult {
    private final Build _build;
    private final long _duration;
    private Status _status;
    private final JSONObject _suiteJSONObject;
    private TestClass _testClass;
    private final Map<String, TestResult> _testResults = new TreeMap<String, TestResult>();

    @Override
    public Build getBuild() {
        return this._build;
    }

    @Override
    public String getClassName() {
        List<TestResult> testResults = this.getTestResults();
        if (testResults.isEmpty()) {
            return this._suiteJSONObject.getString("name");
        }
        TestResult testResult = testResults.get(0);
        return testResult.getClassName();
    }

    @Override
    public long getDuration() {
        return this._duration;
    }

    @Override
    public Element getGitHubElement() {
        return this.getGitHubElement(null);
    }

    @Override
    public Element getGitHubElement(Boolean uniqueFailures) {
        Element downstreamBuildListItemElement = Dom4JUtil.getNewElement("details", null, new Object[0]);
        Element summaryElement = Dom4JUtil.getNewElement("summary", downstreamBuildListItemElement, new Object[0]);
        summaryElement.add(Dom4JUtil.getNewAnchorElement(this.getTestClassReportURL(), this.getClassName()));
        TestHistory testHistory = this.getTestHistory();
        if (testHistory != null) {
            summaryElement.addText(" - ");
            summaryElement.add(Dom4JUtil.getNewAnchorElement(testHistory.getTestrayCaseResultURL(), JenkinsResultsParserUtil.combine("Failed ", String.valueOf(testHistory.getFailureCount()), " of last ", String.valueOf(testHistory.getTestCount()))));
        }
        ArrayList<Element> failureElements = new ArrayList<Element>();
        for (TestResult testResult : this.getTestResults()) {
            if (!testResult.isFailing() || uniqueFailures != null && (!uniqueFailures.booleanValue() || !testResult.isUniqueFailure()) && (uniqueFailures.booleanValue() || testResult.isUniqueFailure())) continue;
            failureElements.add(Dom4JUtil.getNewAnchorElement(testResult.getTestReportURL(), testResult.getTestName()));
        }
        if (failureElements.isEmpty()) {
            return null;
        }
        Element failuresElement = Dom4JUtil.getNewElement("div", downstreamBuildListItemElement, new Object[0]);
        Dom4JUtil.getOrderedListElement(failureElements, failuresElement, 5);
        return downstreamBuildListItemElement;
    }

    @Override
    public String getPackageName() {
        String className = this.getClassName();
        int x = className.lastIndexOf(".");
        if (x < 0) {
            return "(root)";
        }
        return className.substring(0, x);
    }

    @Override
    public String getSimpleClassName() {
        String className = this.getClassName();
        int x = className.lastIndexOf(".");
        return className.substring(x + 1);
    }

    @Override
    public String getStatus() {
        if (this._status != null) {
            return this._status.toString();
        }
        this._status = Status.PASSED;
        for (TestResult testResult : this.getTestResults()) {
            Status status = Status.valueOf(testResult.getStatus());
            if (this._status.getPriority() <= status.getPriority()) continue;
            this._status = status;
        }
        return this._status.toString();
    }

    @Override
    public TestClass getTestClass() {
        if (this._testClass != null) {
            return this._testClass;
        }
        Build build = this.getBuild();
        if (!(build instanceof DownstreamBuild)) {
            return null;
        }
        DownstreamBuild downstreamBuild = (DownstreamBuild)build;
        AxisTestClassGroup axisTestClassGroup = downstreamBuild.getAxisTestClassGroup();
        if (axisTestClassGroup == null) {
            return null;
        }
        String className = this.getClassName();
        for (TestClass testClass : axisTestClassGroup.getTestClasses()) {
            JUnitTestClass jUnitTestClass;
            if (!(testClass instanceof JUnitTestClass) || !Objects.equals(className, (jUnitTestClass = (JUnitTestClass)testClass).getTestClassName())) continue;
            this._testClass = testClass;
            return this._testClass;
        }
        return null;
    }

    @Override
    public String getTestClassReportURL() {
        StringBuilder sb = new StringBuilder();
        Build build = this.getBuild();
        sb.append(build.getBuildURL());
        sb.append("testReport/");
        String packageName = this.getPackageName();
        sb.append(packageName.replaceAll("/", "_"));
        sb.append("/");
        sb.append(this.getSimpleClassName());
        String testClassReportURL = sb.toString();
        if (testClassReportURL.startsWith("http")) {
            try {
                return JenkinsResultsParserUtil.encode(testClassReportURL);
            }
            catch (MalformedURLException | URISyntaxException exception) {
                System.out.println("Unable to encode the test report " + testClassReportURL);
            }
        }
        return testClassReportURL;
    }

    @Override
    public TestHistory getTestHistory() {
        TestClass testClass = this.getTestClass();
        if (testClass == null) {
            return null;
        }
        return testClass.getTestHistory();
    }

    @Override
    public TestResult getTestResult(String testName) {
        return this._testResults.get(testName);
    }

    @Override
    public List<TestResult> getTestResults() {
        return new ArrayList<TestResult>(this._testResults.values());
    }

    @Override
    public boolean isFailing() {
        Status status = Status.valueOf(this.getStatus());
        return status != Status.FIXED && status != Status.PASSED && status != Status.SKIPPED;
    }

    @Override
    public boolean isSkipped() {
        Status status = Status.valueOf(this.getStatus());
        return status == Status.SKIPPED;
    }

    protected BaseTestClassResult(Build build, JSONObject suiteJSONObject) {
        if (suiteJSONObject == null) {
            throw new RuntimeException("Please set suiteJSONObject");
        }
        this._build = build;
        this._suiteJSONObject = suiteJSONObject;
        this._duration = (long)(suiteJSONObject.getDouble("duration") * 1000.0);
        if (!suiteJSONObject.has("cases")) {
            return;
        }
        JSONArray casesJSONArray = suiteJSONObject.getJSONArray("cases");
        for (int i = 0; i < casesJSONArray.length(); ++i) {
            JSONObject caseJSONObject = casesJSONArray.getJSONObject(i);
            TestResult testResult = TestResultFactory.newTestResult(build, caseJSONObject);
            this._testResults.put(testResult.getTestName(), testResult);
        }
    }

    private static enum Status {
        ABORTED(1),
        FAILED(2),
        FIXED(6),
        PASSED(7),
        REGRESSION(3),
        SKIPPED(5),
        UNSTABLE(4);

        private final Integer _priority;

        public Integer getPriority() {
            return this._priority;
        }

        private Status(Integer priority) {
            this._priority = priority;
        }
    }
}

