/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseBuildData;
import com.liferay.jenkins.results.parser.BuildData;
import com.liferay.jenkins.results.parser.BuildDataFactory;
import com.liferay.jenkins.results.parser.JenkinsMaster;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.JenkinsSlave;
import com.liferay.jenkins.results.parser.TopLevelBuildData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public abstract class BaseTopLevelBuildData
extends BaseBuildData
implements TopLevelBuildData {
    private static final String[] _KEYS_REQUIRED = new String[]{"dist_nodes", "dist_path", "top_level_run_id"};

    @Override
    public void addDownstreamBuildData(BuildData buildData) {
        String downstreamRunIDs = this.optString("downstream_run_ids");
        downstreamRunIDs = downstreamRunIDs == null ? buildData.getRunID() : downstreamRunIDs + "," + buildData.getRunID();
        this.put("downstream_run_ids", downstreamRunIDs);
    }

    @Override
    public List<String> getDistNodes() {
        String distNodes = this.optString("dist_nodes");
        if (distNodes == null) {
            return null;
        }
        return Arrays.asList(distNodes.split(","));
    }

    @Override
    public String getDistPath() {
        return this.optString("dist_path");
    }

    @Override
    public List<BuildData> getDownstreamBuildDataList() {
        ArrayList<BuildData> downstreamBuildDataList = new ArrayList<BuildData>();
        String downstreamRunIDs = this.optString("downstream_run_ids");
        if (downstreamRunIDs == null) {
            return downstreamBuildDataList;
        }
        for (String downstreamRunID : downstreamRunIDs.split(",")) {
            if (downstreamRunID == null || downstreamRunID.isEmpty()) continue;
            downstreamBuildDataList.add(BuildDataFactory.newBatchBuildData(downstreamRunID, this.getJobName() + "-batch", null));
        }
        return downstreamBuildDataList;
    }

    @Override
    public TopLevelBuildData getTopLevelBuildData() {
        return this;
    }

    @Override
    public Integer getTopLevelBuildNumber() {
        return this.getBuildNumber();
    }

    @Override
    public Map<String, String> getTopLevelBuildParameters() {
        return this.getBuildParameters();
    }

    @Override
    public String getTopLevelJobName() {
        return this.getJobName();
    }

    @Override
    public String getTopLevelMasterHostname() {
        return this.getMasterHostname();
    }

    @Override
    public String getTopLevelRunID() {
        return this.getRunID();
    }

    @Override
    public void setDistNodes(List<String> distNodes) {
        if (distNodes == null) {
            throw new RuntimeException("Dist nodes is null");
        }
        this.put("dist_nodes", JenkinsResultsParserUtil.join(",", distNodes));
    }

    protected BaseTopLevelBuildData(String runID, String jobName, String buildURL) {
        super(BaseTopLevelBuildData._getDefaultRunID(runID), jobName, buildURL);
        this.put("dist_nodes", this._getDistNodes());
        this.put("dist_path", this._getDistPath());
        this.put("top_level_run_id", this.getRunID());
        this.validateKeys(_KEYS_REQUIRED);
    }

    private static String _getDefaultRunID(String runID) {
        if (runID != null) {
            return runID;
        }
        return "top_level_" + JenkinsResultsParserUtil.getDistinctTimeStamp();
    }

    private String _getDistNodes() {
        if (!JenkinsResultsParserUtil.isCINode()) {
            return "";
        }
        Properties buildProperties = null;
        try {
            buildProperties = JenkinsResultsParserUtil.getBuildProperties(false);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        List<JenkinsMaster> jenkinsMasters = JenkinsResultsParserUtil.getJenkinsMasters(buildProperties, JenkinsMaster.getSlaveRAMMinimumDefault(), JenkinsMaster.getSlavesPerHostDefault(), this.getCohortName());
        ArrayList<String> distNodes = new ArrayList<String>(jenkinsMasters.size());
        block2: for (JenkinsMaster jenkinsMaster : jenkinsMasters) {
            for (int retries = 0; retries <= jenkinsMaster.getOnlineJenkinsSlavesCount(); ++retries) {
                JenkinsSlave randomJenkinsSlave = jenkinsMaster.getRandomJenkinsSlave();
                if (randomJenkinsSlave == null || randomJenkinsSlave.isOffline() || !randomJenkinsSlave.isReachable()) continue;
                distNodes.add(randomJenkinsSlave.getName());
                continue block2;
            }
        }
        return StringUtils.join(distNodes, (String)",");
    }

    private String _getDistPath() {
        return JenkinsResultsParserUtil.combine(JenkinsResultsParserUtil.getJenkinsDistRootPath(), "/", this.getMasterHostname(), "/", this.getJobName(), "/", String.valueOf(this.getBuildNumber()), "/dist");
    }
}

