/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseBuildReport;
import com.liferay.jenkins.results.parser.BuildReportFactory;
import com.liferay.jenkins.results.parser.DownstreamBuildReport;
import com.liferay.jenkins.results.parser.JenkinsMaster;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.JobReport;
import com.liferay.jenkins.results.parser.StopWatchRecord;
import com.liferay.jenkins.results.parser.StopWatchRecordsGroup;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import com.liferay.jenkins.results.parser.TopLevelBuildReport;
import com.liferay.jenkins.results.parser.testray.TestrayS3Bucket;
import com.liferay.jenkins.results.parser.testray.TestrayS3Object;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class BaseTopLevelBuildReport
extends BaseBuildReport
implements TopLevelBuildReport {
    private static final Map<String, Pattern> _variablePatterns = new HashMap<String, Pattern>();
    private List<DownstreamBuildReport> _downstreamBuildReports;

    @Override
    public Map<String, String> getBuildParameters() {
        HashMap<String, String> buildParameters = new HashMap<String, String>();
        JSONObject buildReportJSONObject = this.getBuildReportJSONObject();
        if (!buildReportJSONObject.has("buildParameters")) {
            return buildParameters;
        }
        JSONObject buildParametersJSONObject = buildReportJSONObject.getJSONObject("buildParameters");
        for (String key : buildParametersJSONObject.keySet()) {
            buildParameters.put(key, buildParametersJSONObject.getString(key));
        }
        return buildParameters;
    }

    @Override
    public URL getBuildReportJSONTestrayURL() {
        JobReport jobReport = this.getJobReport();
        JenkinsMaster jenkinsMaster = jobReport.getJenkinsMaster();
        try {
            return new URL(JenkinsResultsParserUtil.combine("https://storage.cloud.google.com/testray-results/", this.getStartYearMonth(), "/", jenkinsMaster.getName(), "/", jobReport.getJobName(), "/", String.valueOf(this.getBuildNumber()), "/build-report.json.gz"));
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    @Override
    public URL getBuildReportJSONUserContentURL() {
        JobReport jobReport = this.getJobReport();
        JenkinsMaster jenkinsMaster = jobReport.getJenkinsMaster();
        try {
            return new URL(JenkinsResultsParserUtil.combine("https://", jenkinsMaster.getName(), ".liferay.com/userContent/jobs/", jobReport.getJobName(), "/builds/", String.valueOf(this.getBuildNumber()), "/build-report.json.gz"));
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    @Override
    public TestrayS3Object getBuildReportTestrayS3Object() {
        JobReport jobReport = this.getJobReport();
        JenkinsMaster jenkinsMaster = jobReport.getJenkinsMaster();
        TestrayS3Bucket testrayS3Bucket = TestrayS3Bucket.getInstance();
        return testrayS3Bucket.getTestrayS3Object(JenkinsResultsParserUtil.combine(this.getStartYearMonth(), "/", jenkinsMaster.getName(), "/", jobReport.getJobName(), "/", String.valueOf(this.getBuildNumber()), "/build-report.json.gz"));
    }

    @Override
    public List<DownstreamBuildReport> getDownstreamBuildReports() {
        if (this._downstreamBuildReports != null) {
            return this._downstreamBuildReports;
        }
        this._downstreamBuildReports = new ArrayList<DownstreamBuildReport>();
        JSONObject buildReportJSONObject = this.getBuildReportJSONObject();
        JSONArray batchesJSONArray = buildReportJSONObject.optJSONArray("batches");
        if (batchesJSONArray == null) {
            return this._downstreamBuildReports;
        }
        for (int i = 0; i < batchesJSONArray.length(); ++i) {
            JSONObject batchJSONObject = batchesJSONArray.optJSONObject(i);
            if (batchJSONObject == null) continue;
            String batchName = batchJSONObject.optString("batchName");
            JSONArray buildsJSONArray = batchJSONObject.optJSONArray("builds");
            if (JenkinsResultsParserUtil.isNullOrEmpty(batchName) || buildsJSONArray == null) continue;
            for (int j = 0; j < buildsJSONArray.length(); ++j) {
                this._downstreamBuildReports.add(BuildReportFactory.newDownstreamBuildReport(batchName, buildsJSONArray.getJSONObject(j), this));
            }
        }
        this._downstreamBuildReports.removeAll(Collections.singleton(null));
        return this._downstreamBuildReports;
    }

    @Override
    public URL getTestResultsJSONUserContentURL() {
        JobReport jobReport = this.getJobReport();
        try {
            return new URL(JenkinsResultsParserUtil.combine("https://test-1-0.liferay.com/userContent/testResults/", jobReport.getJobName(), "/builds/", String.valueOf(this.getBuildNumber()), "/test.results.json"));
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    @Override
    public String getTestSuiteName() {
        JSONObject buildReportJSONObject = this.getBuildReportJSONObject();
        return buildReportJSONObject.optString("testSuiteName");
    }

    @Override
    public long getTopLevelActiveDuration() {
        long topLevelPassiveBuildDuration = this.getTopLevelPassiveDuration();
        if (topLevelPassiveBuildDuration == 0L) {
            return 0L;
        }
        return this.getDuration() - topLevelPassiveBuildDuration;
    }

    @Override
    public long getTopLevelPassiveDuration() {
        StopWatchRecordsGroup stopWatchRecordsGroup = this.getStopWatchRecordsGroup();
        if (stopWatchRecordsGroup == null) {
            return 0L;
        }
        StopWatchRecord waitForInvokedJobsStopWatchRecord = stopWatchRecordsGroup.get("wait.for.invoked.jobs");
        StopWatchRecord waitForInvokedSmokeJobsStopWatchRecord = stopWatchRecordsGroup.get("wait.for.invoked.smoke.jobs");
        if (waitForInvokedJobsStopWatchRecord != null || waitForInvokedSmokeJobsStopWatchRecord != null) {
            long topLevelPassiveBuildDuration = 0L;
            if (waitForInvokedJobsStopWatchRecord != null) {
                topLevelPassiveBuildDuration += waitForInvokedJobsStopWatchRecord.getDuration().longValue();
            }
            if (waitForInvokedSmokeJobsStopWatchRecord != null) {
                topLevelPassiveBuildDuration += waitForInvokedSmokeJobsStopWatchRecord.getDuration().longValue();
            }
            return topLevelPassiveBuildDuration;
        }
        StopWatchRecord invokeDownstreamBuildsStopWatchRecord = stopWatchRecordsGroup.get("invoke.downstream.builds");
        if (invokeDownstreamBuildsStopWatchRecord != null) {
            return invokeDownstreamBuildsStopWatchRecord.getDuration();
        }
        return 0L;
    }

    protected BaseTopLevelBuildReport(JSONObject buildReportJSONObject) {
        super(buildReportJSONObject);
        this.setStartDate(new Date(buildReportJSONObject.getLong("startTime")));
    }

    protected BaseTopLevelBuildReport(JSONObject buildJSONObject, JobReport jobReport) {
        super(buildJSONObject, jobReport);
        this.setStartDate(new Date(buildJSONObject.getLong("timestamp")));
    }

    protected BaseTopLevelBuildReport(TopLevelBuild topLevelBuild) {
        super(topLevelBuild.getBuildURL());
        this.setStartDate(new Date(topLevelBuild.getStartTime()));
    }

    protected BaseTopLevelBuildReport(URL buildURL) {
        super(buildURL);
    }

    protected JSONObject getBuildReportJSONObject(JSONObject buildResultJSONObject) {
        String startTimeString;
        if (!(buildResultJSONObject != null && buildResultJSONObject.has("duration") && buildResultJSONObject.has("result") && buildResultJSONObject.has("stopWatchRecords"))) {
            return null;
        }
        JSONObject buildReportJSONObject = new JSONObject();
        buildReportJSONObject.put("batches", (Object)this._getBatchesJSONArray(buildResultJSONObject)).put("buildURL", (Object)String.valueOf(this.getBuildURL())).put("duration", buildResultJSONObject.get("duration")).put("result", buildResultJSONObject.get("result"));
        long startTime = buildResultJSONObject.optLong("startTime", 0L);
        if (startTime == 0L && (startTimeString = this._getVariableFromJenkinsConsole("TOP_LEVEL_START_TIME")) != null && startTimeString.matches("\\d+")) {
            startTime = Integer.parseInt(startTimeString);
        }
        if (startTime == 0L) {
            StopWatchRecordsGroup stopWatchRecordsGroup = new StopWatchRecordsGroup(buildResultJSONObject);
            StopWatchRecord stopWatchRecord = stopWatchRecordsGroup.get("start.current.job");
            if (stopWatchRecord == null) {
                return null;
            }
            startTime = stopWatchRecord.getStartTimestamp();
        }
        buildReportJSONObject.put("startTime", startTime).put("status", (Object)"completed").put("stopWatchRecords", buildResultJSONObject.get("stopWatchRecords"));
        String testSuiteName = this._getTestSuiteNameFromBuildResult(buildResultJSONObject);
        if (JenkinsResultsParserUtil.isNullOrEmpty(testSuiteName)) {
            testSuiteName = this._getVariableFromJenkinsConsole("CI_TEST_SUITE");
        }
        buildReportJSONObject.put("testSuiteName", (Object)testSuiteName);
        return buildReportJSONObject;
    }

    protected abstract File getJenkinsConsoleLocalFile();

    protected String getStartYearMonth() {
        return JenkinsResultsParserUtil.toDateString(this.getStartDate(), "yyyy-MM", "America/Los_Angeles");
    }

    private JSONArray _getBatchesJSONArray(JSONObject buildResultJSONObject) {
        JSONArray batchResultsJSONArray = buildResultJSONObject.optJSONArray("batchResults");
        if (batchResultsJSONArray == null || batchResultsJSONArray.isEmpty()) {
            return new JSONArray();
        }
        HashMap batchJSONObjectsMap = new HashMap();
        for (int i = 0; i < batchResultsJSONArray.length(); ++i) {
            JSONObject batchResultJSONObject = batchResultsJSONArray.optJSONObject(i);
            if (batchResultJSONObject == null) continue;
            String batchName = batchResultJSONObject.getString("jobVariant");
            ArrayList<JSONObject> batchJSONObjects = (ArrayList<JSONObject>)batchJSONObjectsMap.get(batchName = batchName.replaceAll("([^/]+)/.*", "$1"));
            if (batchJSONObjects == null) {
                batchJSONObjects = new ArrayList<JSONObject>();
                batchJSONObjectsMap.put(batchName, batchJSONObjects);
            }
            if (batchResultJSONObject.has("buildResults")) {
                JSONArray buildResultsJSONArray = batchResultJSONObject.getJSONArray("buildResults");
                for (int j = 0; j < buildResultsJSONArray.length(); ++j) {
                    batchJSONObjects.add(buildResultsJSONArray.getJSONObject(j));
                }
                continue;
            }
            batchJSONObjects.add(batchResultJSONObject);
        }
        JSONArray batchesJSONArray = new JSONArray();
        for (Map.Entry batchJSONObjectsEntry : batchJSONObjectsMap.entrySet()) {
            JSONObject batchJSONObject = new JSONObject();
            batchJSONObject.put("batchName", batchJSONObjectsEntry.getKey());
            JSONArray buildsJSONArray = new JSONArray();
            for (JSONObject jsonObject : (List)batchJSONObjectsEntry.getValue()) {
                if (!jsonObject.has("buildURL") || !jsonObject.has("duration") || !jsonObject.has("result") || !jsonObject.has("stopWatchRecords")) continue;
                JSONObject buildJSONObject = new JSONObject();
                buildJSONObject.put("axisName", jsonObject.opt("axisName")).put("buildURL", jsonObject.get("buildURL")).put("duration", jsonObject.get("duration")).put("result", jsonObject.get("result"));
                long startTime = jsonObject.optLong("startTime", 0L);
                if (startTime == 0L) {
                    StopWatchRecordsGroup stopWatchRecordsGroup = new StopWatchRecordsGroup(jsonObject);
                    StopWatchRecord stopWatchRecord = stopWatchRecordsGroup.get("start.current.job");
                    if (stopWatchRecord == null) {
                        stopWatchRecord = stopWatchRecordsGroup.get("run.current.job");
                    }
                    if (stopWatchRecord == null) continue;
                    startTime = stopWatchRecord.getStartTimestamp();
                }
                buildJSONObject.put("startTime", startTime).put("status", (Object)"completed").put("stopWatchRecords", jsonObject.get("stopWatchRecords")).put("testResults", (Object)new JSONArray());
                buildsJSONArray.put((Object)buildJSONObject);
            }
            batchJSONObject.put("builds", (Object)buildsJSONArray);
            batchesJSONArray.put((Object)batchJSONObject);
        }
        return batchesJSONArray;
    }

    private String _getTestSuiteNameFromBuildResult(JSONObject buildResultJSONObject) {
        String testSuiteName = buildResultJSONObject.optString("testSuiteName");
        if (!JenkinsResultsParserUtil.isNullOrEmpty(testSuiteName)) {
            return testSuiteName;
        }
        JSONArray batchResultsJSONArray = buildResultJSONObject.optJSONArray("batchResults");
        if (batchResultsJSONArray == null) {
            return null;
        }
        for (int i = 0; i < batchResultsJSONArray.length(); ++i) {
            JSONObject batchResultJSONObject = batchResultsJSONArray.getJSONObject(i);
            testSuiteName = batchResultJSONObject.optString("testSuiteName");
            if (JenkinsResultsParserUtil.isNullOrEmpty(testSuiteName)) continue;
            return testSuiteName;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String _getVariableFromJenkinsConsole(String variableName) {
        File jenkinsConsoleLocalFile = this.getJenkinsConsoleLocalFile();
        if (jenkinsConsoleLocalFile == null || !jenkinsConsoleLocalFile.exists()) {
            return null;
        }
        Pattern pattern = this._getVariablePattern(variableName);
        BufferedReader bufferedReader = null;
        FileReader fileReader = null;
        try {
            String line;
            fileReader = new FileReader(jenkinsConsoleLocalFile);
            bufferedReader = new BufferedReader(fileReader);
            long start = JenkinsResultsParserUtil.getCurrentTimeMillis();
            while ((line = bufferedReader.readLine()) != null) {
                long end = JenkinsResultsParserUtil.getCurrentTimeMillis();
                long duration = end - start;
                if (duration >= 5000L) {
                    break;
                }
                Matcher matcher = pattern.matcher(line);
                if (!matcher.find()) continue;
                String string = matcher.group("variableValue");
                return string;
            }
        }
        catch (Exception exception) {
            String string = null;
            return string;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException ioException) {
                    ioException.printStackTrace();
                }
            }
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (IOException ioException) {
                    ioException.printStackTrace();
                }
            }
        }
        return null;
    }

    private Pattern _getVariablePattern(String variableName) {
        Pattern variablePattern = _variablePatterns.get(variableName);
        if (variablePattern == null) {
            variablePattern = Pattern.compile(variableName + "=(?<variableValue>[^\\s]+)");
            _variablePatterns.put(variableName, variablePattern);
        }
        return variablePattern;
    }
}

