/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.AxisBuild;
import com.liferay.jenkins.results.parser.BaseBuild;
import com.liferay.jenkins.results.parser.BaseParentBuild;
import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.BuildDatabase;
import com.liferay.jenkins.results.parser.Dom4JUtil;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.TestClassResult;
import com.liferay.jenkins.results.parser.TestResult;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import com.liferay.jenkins.results.parser.failure.message.generator.ClosedChannelExceptionFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.FailureMessageGenerator;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Element;
import org.json.JSONArray;
import org.json.JSONObject;

public class BatchBuild
extends BaseParentBuild {
    protected final String batchName;
    private static final FailureMessageGenerator[] _FAILURE_MESSAGE_GENERATORS = new FailureMessageGenerator[]{new ClosedChannelExceptionFailureMessageGenerator()};
    private static final ExecutorService _executorService = JenkinsResultsParserUtil.getNewThreadPoolExecutor(10, true);
    private static final Pattern _jobVariantPattern = Pattern.compile("(?<batchName>[^/]+)(/.*)?");
    private Element _gitHubMessageElement;

    @Override
    public void addTimelineData(Build.TimelineData timelineData) {
        this.addDownstreamBuildsTimelineData(timelineData);
    }

    @Override
    public URL getArtifactsBaseURL() {
        TopLevelBuild topLevelBuild = this.getTopLevelBuild();
        StringBuilder sb = new StringBuilder();
        sb.append(topLevelBuild.getArtifactsBaseURL());
        sb.append("/");
        sb.append(this.getParameterValue("JOB_VARIANT"));
        try {
            return new URL(sb.toString());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public String getBatchName() {
        return this.batchName;
    }

    @Override
    public String getBuildName() {
        String buildName = this.getJobVariant();
        if (JenkinsResultsParserUtil.isNullOrEmpty(buildName)) {
            buildName = this.getJobName();
        }
        return buildName;
    }

    public List<AxisBuild> getDownstreamAxisBuilds() {
        ArrayList<AxisBuild> downstreamAxisBuilds = new ArrayList<AxisBuild>();
        List<Build> downstreamBuilds = this.getDownstreamBuilds(null);
        for (Build downstreamBuild : downstreamBuilds) {
            if (!(downstreamBuild instanceof AxisBuild)) continue;
            downstreamAxisBuilds.add((AxisBuild)downstreamBuild);
        }
        Collections.sort(downstreamAxisBuilds, new BaseBuild.BuildDisplayNameComparator());
        return downstreamAxisBuilds;
    }

    @Override
    public Element getGitHubMessageElement() {
        this.sortDownstreamBuilds();
        Element messageElement = super.getGitHubMessageElement();
        if (messageElement == null) {
            return null;
        }
        String result = this.getResult();
        if (result.equals("ABORTED") && this.getDownstreamBuildCount(null) == 0) {
            this._gitHubMessageElement = messageElement;
            return this._gitHubMessageElement;
        }
        List<Build> failedDownstreamBuilds = this.getFailedDownstreamBuilds();
        List<Element> downstreamBuildMessageElements = this.getDownstreamBuildMessageElements(failedDownstreamBuilds);
        if (result.equals("FAILURE") && downstreamBuildMessageElements.isEmpty()) {
            this._gitHubMessageElement = messageElement;
            return this._gitHubMessageElement;
        }
        ArrayList<Element> failureElements = new ArrayList<Element>();
        ArrayList<Element> upstreamJobFailureElements = new ArrayList<Element>();
        for (Build failedDownstreamBuild : failedDownstreamBuilds) {
            Element gitHubMessageUpstreamJobFailureElement;
            Element gitHubMessageElement = failedDownstreamBuild.getGitHubMessageElement();
            if (gitHubMessageElement != null) {
                failureElements.add(gitHubMessageElement);
            }
            if ((gitHubMessageUpstreamJobFailureElement = failedDownstreamBuild.getGitHubMessageUpstreamJobFailureElement()) == null) continue;
            upstreamJobFailureElements.add(gitHubMessageUpstreamJobFailureElement);
        }
        if (!upstreamJobFailureElements.isEmpty()) {
            this.upstreamJobFailureMessageElement = this.getGitHubMessageElement(true);
            Dom4JUtil.getOrderedListElement(upstreamJobFailureElements, this.upstreamJobFailureMessageElement, 4);
        }
        Dom4JUtil.getOrderedListElement(failureElements, messageElement, 4);
        if (failureElements.size() >= 4) {
            Dom4JUtil.getNewElement("strong", messageElement, "Click ", Dom4JUtil.getNewAnchorElement(this.getBuildURL() + "testReport", "here"), " for more failures.");
        }
        if (failureElements.isEmpty()) {
            return null;
        }
        this._gitHubMessageElement = messageElement;
        return this._gitHubMessageElement;
    }

    @Override
    public Long getInvokedTime() {
        if (this.invokedTime != null) {
            return this.invokedTime;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\\s*\\[echo\\]\\s*");
        sb.append(Pattern.quote(this.getJobName()));
        String jobVariant = this.getJobVariant();
        if (jobVariant != null && !jobVariant.isEmpty()) {
            sb.append("/");
            sb.append(Pattern.quote(jobVariant));
        }
        sb.append("\\s*invoked time: (?<invokedTime>[^\\n]*)");
        Pattern pattern = Pattern.compile(sb.toString());
        Build parentBuild = this.getParentBuild();
        String parentConsoleText = parentBuild.getConsoleText();
        for (String line : parentConsoleText.split("\n")) {
            Matcher matcher = pattern.matcher(line);
            if (!matcher.find()) continue;
            Properties buildProperties = null;
            try {
                buildProperties = JenkinsResultsParserUtil.getBuildProperties();
            }
            catch (IOException ioException) {
                throw new RuntimeException("Unable to get build properties", ioException);
            }
            SimpleDateFormat sdf = new SimpleDateFormat(buildProperties.getProperty("jenkins.report.date.format"));
            Date date = null;
            try {
                date = sdf.parse(matcher.group("invokedTime"));
            }
            catch (ParseException parseException) {
                throw new RuntimeException("Unable to get invoked time", parseException);
            }
            this.invokedTime = date.getTime();
            return this.invokedTime;
        }
        return this.getStartTime();
    }

    @Override
    public Map<String, String> getMetricLabels() {
        Map<String, String> metricLabels = super.getMetricLabels();
        metricLabels.put("job_type", this.batchName);
        return metricLabels;
    }

    @Override
    public synchronized List<TestClassResult> getTestClassResults() {
        ArrayList<TestClassResult> testClassResults = new ArrayList<TestClassResult>();
        for (AxisBuild axisBuild : this.getDownstreamAxisBuilds()) {
            testClassResults.addAll(axisBuild.getTestClassResults());
        }
        return testClassResults;
    }

    @Override
    public synchronized List<TestResult> getTestResults() {
        ArrayList<TestResult> testResults = new ArrayList<TestResult>();
        for (AxisBuild axisBuild : this.getDownstreamAxisBuilds()) {
            testResults.addAll(axisBuild.getTestResults());
        }
        return testResults;
    }

    @Override
    public long getTotalDuration() {
        long totalDuration = super.getTotalDuration();
        return totalDuration - this.getDuration();
    }

    @Override
    public int getTotalSlavesUsedCount() {
        return this.getTotalSlavesUsedCount(null, false);
    }

    @Override
    public int getTotalSlavesUsedCount(String status, boolean modifiedBuildsOnly) {
        return this.getTotalSlavesUsedCount(status, modifiedBuildsOnly, true);
    }

    @Override
    public void saveBuildURLInBuildDatabase() {
        BuildDatabase buildDatabase = this.getBuildDatabase();
        buildDatabase.putProperty("build-urls.properties", this.getBatchName(), this.getBuildURL(), false);
    }

    protected BatchBuild(String url) {
        this(url, null);
    }

    protected BatchBuild(String url, TopLevelBuild topLevelBuild) {
        super(url, topLevelBuild);
        String jobVariant = this.getJobVariant();
        if (jobVariant != null && !jobVariant.isEmpty()) {
            Matcher matcher = _jobVariantPattern.matcher(jobVariant);
            if (!matcher.matches()) {
                throw new RuntimeException(JenkinsResultsParserUtil.combine("Unable to find batch name of batch build from ", "job variant '", jobVariant, "'. Job variant must match pattern '", _jobVariantPattern.pattern(), "'."));
            }
            this.batchName = matcher.group("batchName");
        } else {
            this.batchName = null;
        }
    }

    @Override
    protected void findDownstreamBuilds() {
        JSONArray runsJSONArray;
        ArrayList<String> downstreamBuildURLs = new ArrayList<String>();
        JSONObject buildJSONObject = this.getBuildJSONObject("runs[number,url]");
        if (buildJSONObject != null && buildJSONObject.has("runs") && (runsJSONArray = buildJSONObject.getJSONArray("runs")) != null) {
            for (int i = 0; i < runsJSONArray.length(); ++i) {
                String url;
                JSONObject runJSONObject = runsJSONArray.getJSONObject(i);
                if (runJSONObject.getInt("number") != this.getBuildNumber() || this.hasBuildURL(url = runJSONObject.getString("url")) || downstreamBuildURLs.contains(url)) continue;
                downstreamBuildURLs.add(url);
            }
        }
        this.addDownstreamBuilds(downstreamBuildURLs.toArray(new String[0]));
    }

    protected AxisBuild getAxisBuild(String axisVariable) {
        for (AxisBuild downstreamAxisBuild : this.getDownstreamAxisBuilds()) {
            if (!axisVariable.equals(downstreamAxisBuild.getAxisVariable())) continue;
            return downstreamAxisBuild;
        }
        return null;
    }

    @Override
    protected ExecutorService getExecutorService() {
        return _executorService;
    }

    @Override
    protected Element getFailureMessageElement() {
        for (FailureMessageGenerator failureMessageGenerator : this.getFailureMessageGenerators()) {
            Element failureMessage = failureMessageGenerator.getMessageElement(this);
            if (failureMessage == null) continue;
            return failureMessage;
        }
        return null;
    }

    @Override
    protected FailureMessageGenerator[] getFailureMessageGenerators() {
        return _FAILURE_MESSAGE_GENERATORS;
    }

    @Override
    protected Element getGitHubMessageJobResultsElement() {
        return this.getGitHubMessageJobResultsElement(false);
    }

    @Override
    protected Element getGitHubMessageJobResultsElement(boolean showCommonFailuresCount) {
        String result = this.getResult();
        int failCount = this.getDownstreamBuildCountByResult("FAILURE");
        int successCount = this.getDownstreamBuildCountByResult("SUCCESS");
        if (result.equals("UNSTABLE")) {
            failCount = this.getTestCountByStatus("FAILURE");
            successCount = this.getTestCountByStatus("SUCCESS");
            if (this.isCompareToUpstream()) {
                List<TestResult> upstreamJobFailureTestResults = this.getUpstreamJobFailureTestResults();
                int upstreamFailCount = upstreamJobFailureTestResults.size();
                failCount = showCommonFailuresCount ? upstreamFailCount : (failCount -= upstreamFailCount);
            }
        }
        return Dom4JUtil.getNewElement("div", null, Dom4JUtil.getNewElement("h6", null, "Job Results:"), Dom4JUtil.getNewElement("p", null, String.valueOf(successCount), JenkinsResultsParserUtil.getNounForm(successCount, " Tests", " Test"), " Passed.", Dom4JUtil.getNewElement("br"), String.valueOf(failCount), JenkinsResultsParserUtil.getNounForm(failCount, " Tests", " Test"), " Failed."));
    }

    @Override
    protected String getJenkinsReportBuildInfoCellElementTagName() {
        return "th";
    }

    @Override
    protected List<Element> getJenkinsReportTableRowElements(String result, String status) {
        ArrayList<Element> tableRowElements = new ArrayList<Element>();
        tableRowElements.add(this.getJenkinsReportTableRowElement());
        for (AxisBuild downstreamAxisBuild : this.getDownstreamAxisBuilds()) {
            tableRowElements.addAll(downstreamAxisBuild.getJenkinsReportTableRowElements(downstreamAxisBuild.getResult(), downstreamAxisBuild.getStatus()));
        }
        return tableRowElements;
    }

    @Override
    protected int getTestCountByStatus(String status) {
        JSONObject testReportJSONObject = this.getTestReportJSONObject(false);
        int failCount = testReportJSONObject.getInt("failCount");
        if (status.equals("SUCCESS")) {
            int totalCount = testReportJSONObject.getInt("totalCount");
            int skipCount = testReportJSONObject.getInt("skipCount");
            return totalCount - skipCount - failCount;
        }
        if (status.equals("FAILURE")) {
            return failCount;
        }
        throw new IllegalArgumentException("Invalid status: " + status);
    }
}

