/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.JobHistory;
import com.liferay.jenkins.results.parser.TestHistory;
import com.liferay.jenkins.results.parser.TestTaskHistory;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class BatchHistory {
    private final long _averageDuration;
    private final String _batchName;
    private final JobHistory _jobHistory;
    private final Map<String, TestHistory> _testHistories = new HashMap<String, TestHistory>();
    private final Map<String, TestTaskHistory> _testTaskHistories = new HashMap<String, TestTaskHistory>();

    public long getAverageDuration() {
        return this._averageDuration;
    }

    public String getBatchName() {
        return this._batchName;
    }

    public JobHistory getJobHistory() {
        return this._jobHistory;
    }

    public TestHistory getTestHistory(String key) {
        return this._testHistories.get(key);
    }

    public TestTaskHistory getTestTaskHistory(String key) {
        return this._testTaskHistories.get(key);
    }

    protected BatchHistory(JobHistory jobHistory, JSONObject jsonObject) {
        JSONArray testTasksJSONArray;
        this._jobHistory = jobHistory;
        this._averageDuration = jsonObject.optLong("averageDuration");
        this._batchName = jsonObject.getString("batchName");
        JSONArray testsJSONArray = jsonObject.optJSONArray("tests");
        if (testsJSONArray != null && !testsJSONArray.isEmpty()) {
            for (int i = 0; i < testsJSONArray.length(); ++i) {
                TestHistory testHistory = new TestHistory(this, testsJSONArray.getJSONObject(i));
                this._testHistories.put(testHistory.getTestName(), testHistory);
            }
        }
        if ((testTasksJSONArray = jsonObject.optJSONArray("testTasks")) != null && !testTasksJSONArray.isEmpty()) {
            for (int i = 0; i < testTasksJSONArray.length(); ++i) {
                TestTaskHistory testTaskHistory = new TestTaskHistory(this, testTasksJSONArray.getJSONObject(i));
                this._testTaskHistories.put(testTaskHistory.getTestTaskName(), testTaskHistory);
            }
        }
    }
}

