/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public class BufferedProcess
extends Process {
    private static final long _MILLIS_EXECUTION_TIME_MIN = 10L;
    private final Process _process;
    private final InputStreamBuffer _standardErrorInputStreamBuffer;
    private final InputStreamBuffer _standardOutInputStreamBuffer;

    public BufferedProcess(int bufferSize, Process process) {
        this._process = process;
        this._standardErrorInputStreamBuffer = new InputStreamBuffer(bufferSize, process.getErrorStream());
        this._standardErrorInputStreamBuffer.start();
        this._standardOutInputStreamBuffer = new InputStreamBuffer(bufferSize, process.getInputStream());
        this._standardOutInputStreamBuffer.start();
    }

    @Override
    public void destroy() {
        this._process.destroy();
    }

    @Override
    public int exitValue() {
        int exitValue = this._process.exitValue();
        JenkinsResultsParserUtil.sleep(10L);
        return exitValue;
    }

    @Override
    public InputStream getErrorStream() {
        return this._standardErrorInputStreamBuffer.toInputStream();
    }

    @Override
    public InputStream getInputStream() {
        return this._standardOutInputStreamBuffer.toInputStream();
    }

    @Override
    public OutputStream getOutputStream() {
        return this._process.getOutputStream();
    }

    @Override
    public int waitFor() throws InterruptedException {
        JenkinsResultsParserUtil.sleep(10L);
        return this._process.waitFor();
    }

    private class InputStreamBuffer
    extends Thread {
        private final byte[] _buffer;
        private int _index;
        private final InputStream _inputStream;
        private int _totalBytesRead;

        public InputStreamBuffer(int bufferSize, InputStream inputStream) {
            this._inputStream = inputStream;
            this._buffer = new byte[bufferSize];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            try {
                byte[] bytes = new byte[Math.min(256, this._buffer.length)];
                int bytesRead = 0;
                this._index = 0;
                while (bytesRead != -1) {
                    bytesRead = this._inputStream.read(bytes);
                    if (bytesRead <= 0) continue;
                    int spaceAvailable = this._buffer.length - this._index;
                    if (bytesRead > spaceAvailable) {
                        int spaceNeeded = bytesRead - spaceAvailable;
                        this._makeSpace(spaceNeeded);
                    }
                    byte[] byArray = this._buffer;
                    // MONITORENTER : this._buffer
                    System.arraycopy(bytes, 0, this._buffer, this._index, bytesRead);
                    this._index += bytesRead;
                    this._totalBytesRead += bytesRead;
                    // MONITOREXIT : byArray
                }
                return;
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
        }

        public InputStream toInputStream() {
            byte[] bytes = null;
            if (this._totalBytesRead > this._buffer.length) {
                String message = JenkinsResultsParserUtil.combine("[Truncated ", String.valueOf(this._totalBytesRead - this._buffer.length), " bytes] \n...");
                byte[] messageBytes = message.getBytes();
                bytes = new byte[messageBytes.length + this._index];
                System.arraycopy(messageBytes, 0, bytes, 0, messageBytes.length);
                System.arraycopy(this._buffer, 0, bytes, messageBytes.length, this._index);
            } else {
                bytes = Arrays.copyOf(this._buffer, this._index);
            }
            return new ByteArrayInputStream(bytes);
        }

        private void _makeSpace(int spacesNeeded) {
            if (this._index - spacesNeeded < 0) {
                throw new IllegalArgumentException(JenkinsResultsParserUtil.combine("Unable to shift buffer content left ", String.valueOf(spacesNeeded), " spaces"));
            }
            System.arraycopy(this._buffer, spacesNeeded, this._buffer, 0, this._index - spacesNeeded);
            this._index -= spacesNeeded;
        }
    }
}

