/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseBuild;
import com.liferay.jenkins.results.parser.BuildDatabase;
import com.liferay.jenkins.results.parser.JenkinsCohort;
import com.liferay.jenkins.results.parser.JenkinsMaster;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.JenkinsSlave;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.RemoteGitRef;
import com.liferay.jenkins.results.parser.SlaveOfflineRule;
import com.liferay.jenkins.results.parser.StopWatchRecordsGroup;
import com.liferay.jenkins.results.parser.TestClassResult;
import com.liferay.jenkins.results.parser.TestResult;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;
import org.json.JSONObject;

public interface Build {
    public static final String DEPENDENCIES_URL_TOKEN = "${dependencies.url}";

    public void addInvocation(Invocation var1);

    public void addTimelineData(TimelineData var1);

    public void archive();

    public void archive(String var1);

    public String getArchiveName();

    public String getArchivePath();

    public File getArchiveRootDir();

    public URL getArtifactsBaseURL();

    public List<String> getBadBuildURLs();

    public String getBaseGitRepositoryName();

    public String getBaseGitRepositorySHA(String var1);

    public String getBatchName(String var1);

    public String getBranchName();

    public BuildDatabase getBuildDatabase();

    public String getBuildDescription();

    public String getBuildDirPath();

    public JSONObject getBuildJSONObject();

    public JSONObject getBuildJSONObject(String var1);

    public String getBuildName();

    public int getBuildNumber();

    public Job.BuildProfile getBuildProfile();

    public String getBuildURL();

    public String getBuildURLRegex();

    public String getConsoleText();

    public Invocation getCurrentInvocation();

    public Long getDelayTime();

    public int getDepth();

    public String getDisplayName();

    public long getDuration();

    public String getFailureMessage();

    public Element getGitHubMessageBuildAnchorElement();

    public Element getGitHubMessageElement();

    public Element getGitHubMessageUpstreamJobFailureElement();

    public Map<String, String> getInjectedEnvironmentVariablesMap() throws IOException;

    public String getInvocationURL();

    public int getInvokedBatchSize();

    public Long getInvokedTime();

    public JenkinsCohort getJenkinsCohort();

    public JenkinsMaster getJenkinsMaster();

    public JenkinsSlave getJenkinsSlave();

    public Job getJob();

    public String getJobName();

    public String getJobURL();

    public String getJobVariant();

    public TestResult getLongestRunningTest();

    public int getMaximumSlavesPerHost();

    public Map<String, String> getMetricLabels();

    public int getMinimumSlaveRAM();

    public Map<String, String> getParameters();

    public String getParameterValue(String var1);

    public Build getParentBuild();

    public Invocation getPreviousInvocation();

    public String getResult();

    public Map<String, String> getStartPropertiesTempMap();

    public Long getStartTime();

    public String getStatus();

    public long getStatusAge();

    public long getStatusDuration(String var1);

    public Map<String, String> getStopPropertiesTempMap();

    public StopWatchRecordsGroup getStopWatchRecordsGroup();

    public TestClassResult getTestClassResult(String var1);

    public List<TestClassResult> getTestClassResults();

    public List<URL> getTestrayAttachmentURLs();

    public String getTestrayBuildDateString();

    public List<URL> getTestrayS3AttachmentURLs();

    public JSONObject getTestReportJSONObject(boolean var1);

    public List<TestResult> getTestResults();

    public List<TestResult> getTestResults(String var1);

    public String getTestSuiteName();

    public TopLevelBuild getTopLevelBuild();

    public List<TestResult> getUniqueFailureTestResults();

    public List<TestResult> getUpstreamJobFailureTestResults();

    public boolean hasBuildURL(String var1);

    public boolean hasDownstreamBuilds();

    public boolean hasGenericCIFailure();

    public boolean hasMaximumInvocationCount();

    public boolean isBuildModified();

    public boolean isCompareToUpstream();

    public boolean isCompleted();

    public boolean isFailing();

    public boolean isFromArchive();

    public boolean isFromCompletedBuild();

    public boolean isUniqueFailure();

    public String replaceBuildURL(String var1);

    public void reset();

    public void saveBuildURLInBuildDatabase();

    public void setArchiveName(String var1);

    public void setArchiveRootDir(File var1);

    public void setBuildURL(String var1);

    public void setCompareToUpstream(boolean var1);

    public void setJenkinsCohort(JenkinsCohort var1);

    public void setJenkinsMaster(JenkinsMaster var1);

    public void setResult(String var1);

    public void setStatus(String var1);

    public void takeSlaveOffline(SlaveOfflineRule var1);

    public void update();

    public static class TimelineData {
        private final long _duration;
        private final long _startTime;
        private final TimelineDataPoint[] _timeline;

        protected TimelineData(int size, TopLevelBuild topLevelBuild) {
            if (topLevelBuild != topLevelBuild.getTopLevelBuild()) {
                throw new IllegalArgumentException("Nested top level builds are invalid");
            }
            if (size < 1) {
                throw new IllegalArgumentException("Invalid size " + size);
            }
            this._duration = topLevelBuild.getDuration();
            this._startTime = topLevelBuild.getStartTime();
            this._timeline = new TimelineDataPoint[size];
            for (int i = 0; i < size; ++i) {
                this._timeline[i] = new TimelineDataPoint((int)((long)i * (this._duration / (long)this._timeline.length)));
            }
            topLevelBuild.addTimelineData(this);
        }

        protected void addTimelineData(BaseBuild build) {
            int startIndex;
            Long buildInvokedTime = build.getInvokedTime();
            if (buildInvokedTime == null) {
                return;
            }
            this._timeline[this._getIndex(buildInvokedTime)]._invocationsCount++;
            Long buildStartTime = build.getStartTime();
            if (buildStartTime == null) {
                return;
            }
            int endIndex = this._getIndex(buildStartTime + build.getDuration());
            for (int i = startIndex = this._getIndex(buildStartTime); i <= endIndex; ++i) {
                this._timeline[i]._slaveUsageCount++;
            }
        }

        protected int[] getIndexData() {
            int[] indexes = new int[this._timeline.length];
            for (int i = 0; i < this._timeline.length; ++i) {
                indexes[i] = this._timeline[i]._index;
            }
            return indexes;
        }

        protected int[] getInvocationsData() {
            int[] invocationsData = new int[this._timeline.length];
            for (int i = 0; i < this._timeline.length; ++i) {
                invocationsData[i] = this._timeline[i]._invocationsCount;
            }
            return invocationsData;
        }

        protected int[] getSlaveUsageData() {
            int[] slaveUsageData = new int[this._timeline.length];
            for (int i = 0; i < this._timeline.length; ++i) {
                slaveUsageData[i] = this._timeline[i]._slaveUsageCount;
            }
            return slaveUsageData;
        }

        private int _getIndex(long timestamp) {
            int index = (int)((timestamp - this._startTime) * (long)this._timeline.length / this._duration);
            if (index >= this._timeline.length) {
                return this._timeline.length - 1;
            }
            if (index < 0) {
                return 0;
            }
            return index;
        }

        private static class TimelineDataPoint {
            private final int _index;
            private int _invocationsCount;
            private int _slaveUsageCount;

            private TimelineDataPoint(int index) {
                this._index = index;
            }
        }
    }

    public static class Invocation {
        private final Build _build;
        private String _buildURL;
        private JenkinsMaster _jenkinsMaster;
        private long _queueId;

        public Invocation(Build build) {
            this._build = build;
        }

        public Invocation(Build build, JenkinsMaster jenkinsMaster) {
            this._build = build;
            this._jenkinsMaster = jenkinsMaster;
        }

        public Invocation(Build build, JenkinsMaster jenkinsMaster, long queueId) {
            this._build = build;
            this._jenkinsMaster = jenkinsMaster;
            this._queueId = queueId;
        }

        public String getBuildURL() {
            if (JenkinsResultsParserUtil.isURL(this._buildURL)) {
                return this._buildURL;
            }
            this._buildURL = JenkinsResultsParserUtil.getBuildURL(this._build.getJobName(), this.getJenkinsMaster(), this.getQueueId());
            return this._buildURL;
        }

        public JenkinsMaster getJenkinsMaster() {
            return this._jenkinsMaster;
        }

        public long getQueueId() {
            return this._queueId;
        }

        public void setBuildURL(String buildURL) {
            this._buildURL = buildURL;
        }

        public void setJenkinsMaster(JenkinsMaster jenkinsMaster) {
            this._jenkinsMaster = jenkinsMaster;
        }

        public void setQueueId(long queueId) {
            this._queueId = queueId;
        }
    }

    public static interface BranchInformation {
        public String getCachedRemoteGitRefName();

        public String getOriginName();

        public Integer getPullRequestNumber();

        public String getReceiverUsername();

        public String getRepositoryName();

        public String getSenderBranchName();

        public String getSenderBranchSHA();

        public String getSenderBranchSHAShort();

        public RemoteGitRef getSenderRemoteGitRef();

        public String getSenderUsername();

        public String getUpstreamBranchName();

        public String getUpstreamBranchSHA();
    }
}

