/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BatchBuildData;
import com.liferay.jenkins.results.parser.BuildData;
import com.liferay.jenkins.results.parser.DefaultBatchBuildData;
import com.liferay.jenkins.results.parser.DefaultTopLevelBuildData;
import com.liferay.jenkins.results.parser.PortalBatchBuildData;
import com.liferay.jenkins.results.parser.PortalTestSuiteUpstreamControllerBuildData;
import com.liferay.jenkins.results.parser.PortalTopLevelBuildData;
import com.liferay.jenkins.results.parser.TopLevelBuildData;

public class BuildDataFactory {
    public static BatchBuildData newBatchBuildData(String runID, String jobName, String buildURL) {
        if (jobName.contains("portal") || jobName.contains("root-cause-analysis-tool")) {
            return new PortalBatchBuildData(runID, jobName, buildURL);
        }
        return new DefaultBatchBuildData(runID, jobName, buildURL);
    }

    public static BuildData newBuildData(String runID, String jobName, String buildURL) {
        if (jobName.endsWith("-batch")) {
            return BuildDataFactory.newBatchBuildData(runID, jobName, buildURL);
        }
        return BuildDataFactory.newTopLevelBuildData(runID, jobName, buildURL);
    }

    public static TopLevelBuildData newTopLevelBuildData(String runID, String jobName, String buildURL) {
        if (jobName.contains("test-portal-testsuite-upstream-controller") || jobName.contains("test-portal-upstream-controller")) {
            return new PortalTestSuiteUpstreamControllerBuildData(runID, jobName, buildURL);
        }
        if (jobName.contains("portal") || jobName.contains("root-cause-analysis-tool") || jobName.equals("test-poshi-release")) {
            return new PortalTopLevelBuildData(runID, jobName, buildURL);
        }
        return new DefaultTopLevelBuildData(runID, jobName, buildURL);
    }
}

