/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseBuildData;
import com.liferay.jenkins.results.parser.BaseBuildRunner;
import com.liferay.jenkins.results.parser.BuildData;
import com.liferay.jenkins.results.parser.BuildRunner;
import com.liferay.jenkins.results.parser.DefaultPortalBatchBuildRunner;
import com.liferay.jenkins.results.parser.GenerateReportsBuildRunner;
import com.liferay.jenkins.results.parser.GenerateReportsControllerBuildRunner;
import com.liferay.jenkins.results.parser.MethodLogger;
import com.liferay.jenkins.results.parser.PortalBatchBuildData;
import com.liferay.jenkins.results.parser.PortalTestSuiteUpstreamControllerBuildData;
import com.liferay.jenkins.results.parser.PortalTestSuiteUpstreamControllerBuildRunner;
import com.liferay.jenkins.results.parser.PortalTestSuiteUpstreamControllerSingleSuiteBuildRunner;
import com.liferay.jenkins.results.parser.PortalTopLevelBuildData;
import com.liferay.jenkins.results.parser.PortalUpstreamControllerSingleSuiteBuildRunner;
import com.liferay.jenkins.results.parser.PoshiReleasePortalTopLevelBuildRunner;
import com.liferay.jenkins.results.parser.QAWebsitesControllerBuildRunner;
import com.liferay.jenkins.results.parser.RootCauseAnalysisBatchBuildRunner;
import com.liferay.jenkins.results.parser.RootCauseAnalysisToolTopLevelBuildRunner;
import com.liferay.jenkins.results.parser.TestResultsConsistencyReportControllerBuildRunner;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BuildRunnerFactory {
    private static final Pattern _jobNamePattern = Pattern.compile("[^\\(]+\\((?<upstreamBranchName>[^_]+)(_(?<testSuiteName>[^\\)]+))?\\)");

    public static BuildRunner<?> newBuildRunner(BuildData buildData) {
        String jobName = buildData.getJobName();
        BaseBuildRunner buildRunner = null;
        if (jobName.equals("generate-reports")) {
            buildRunner = new GenerateReportsBuildRunner(buildData);
        }
        if (jobName.equals("generate-reports-controller")) {
            buildRunner = new GenerateReportsControllerBuildRunner(buildData);
        }
        if (jobName.equals("root-cause-analysis-tool")) {
            buildRunner = new RootCauseAnalysisToolTopLevelBuildRunner((PortalTopLevelBuildData)buildData);
        }
        if (buildRunner == null && jobName.equals("root-cause-analysis-tool-batch")) {
            buildRunner = new RootCauseAnalysisBatchBuildRunner<PortalBatchBuildData>((PortalBatchBuildData)buildData);
        }
        if (buildRunner == null && jobName.startsWith("test-portal-testsuite-upstream-controller(")) {
            Matcher matcher = _jobNamePattern.matcher(jobName);
            buildRunner = matcher.find() && matcher.group("testSuiteName") != null ? new PortalTestSuiteUpstreamControllerSingleSuiteBuildRunner<PortalTestSuiteUpstreamControllerBuildData>((PortalTestSuiteUpstreamControllerBuildData)buildData) : new PortalTestSuiteUpstreamControllerBuildRunner<PortalTestSuiteUpstreamControllerBuildData>((PortalTestSuiteUpstreamControllerBuildData)buildData);
        }
        if (buildRunner == null && jobName.startsWith("test-portal-upstream-controller(")) {
            buildRunner = new PortalUpstreamControllerSingleSuiteBuildRunner<PortalTestSuiteUpstreamControllerBuildData>((PortalTestSuiteUpstreamControllerBuildData)buildData);
        }
        if (buildRunner == null && jobName.equals("test-poshi-release")) {
            buildRunner = new PoshiReleasePortalTopLevelBuildRunner((PortalTopLevelBuildData)buildData);
        }
        if (buildRunner == null && (jobName.startsWith("test-qa-websites-functional-daily-controller") || jobName.startsWith("test-qa-websites-functional-weekly-controller"))) {
            buildRunner = new QAWebsitesControllerBuildRunner(buildData);
        }
        if (buildRunner == null && jobName.startsWith("test-results-consistency-report-controller")) {
            buildRunner = new TestResultsConsistencyReportControllerBuildRunner<BaseBuildData>((BaseBuildData)buildData);
        }
        if (buildRunner == null && jobName.contains("-batch")) {
            buildRunner = new DefaultPortalBatchBuildRunner((PortalBatchBuildData)buildData);
        }
        if (buildRunner == null) {
            throw new RuntimeException("Invalid build data " + buildData);
        }
        return (BuildRunner)Proxy.newProxyInstance(BuildRunner.class.getClassLoader(), new Class[]{BuildRunner.class}, (InvocationHandler)new MethodLogger(buildRunner));
    }
}

