/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BuildReportFactory;
import com.liferay.jenkins.results.parser.DownstreamBuildReport;
import com.liferay.jenkins.results.parser.JenkinsCohort;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.ParallelExecutor;
import com.liferay.jenkins.results.parser.TopLevelBuildReport;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.FileUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class CISystemStatusReportUtil {
    private static final File _CI_SYSTEM_STATUS_REPORT_DIR;
    private static final int _DAYS_PER_WEEK = 7;
    private static final String[] _NODE_METRIC_NAMES;
    private static final File _TESTRAY_LOGS_DIR;
    private static final File _TMP_BASE_DIR;
    private static final Properties _buildProperties;
    private static final List<String> _dateStrings;
    private static final ExecutorService _executorService;
    private static final HashMap<LocalDate, List<Result>> _results;

    public static void appendNodeHistoryDataToJavaScriptFile(String filePath) throws IOException {
        StringBuilder sb = new StringBuilder();
        JSONObject jsonObject = null;
        LocalDate localDate = JenkinsResultsParserUtil.getLocalDate(System.currentTimeMillis());
        long durationDays = CISystemStatusReportUtil._getReportDurationDays();
        localDate = localDate.minusDays(durationDays - 1L);
        for (String dateString : JenkinsResultsParserUtil.getDateStrings(durationDays, localDate)) {
            File nodeDataFile = new File(_TMP_BASE_DIR, dateString + "/node.json");
            if (!nodeDataFile.exists()) {
                System.out.println("Node data not available in: " + nodeDataFile);
                continue;
            }
            if (jsonObject == null) {
                jsonObject = JenkinsResultsParserUtil.toJSONObject("file://" + nodeDataFile.getPath());
                continue;
            }
            CISystemStatusReportUtil._mergeJSONArraysInJSONObjects(jsonObject, JenkinsResultsParserUtil.toJSONObject("file://" + nodeDataFile.getPath()), _NODE_METRIC_NAMES);
        }
        sb.append("\nvar nodeHistoryData = ");
        sb.append(jsonObject);
        sb.append(";");
        JenkinsResultsParserUtil.append(new File(filePath), sb.toString());
    }

    public static void copyBaseReportFiles(String filePath) throws IOException {
        FileUtils.copyDirectory((File)_CI_SYSTEM_STATUS_REPORT_DIR, (File)new File(filePath));
    }

    public static void writeJenkinsDataJavaScriptFile(String filePath) throws IOException {
        JenkinsCohort jenkinsCohort = JenkinsCohort.getInstance(JenkinsResultsParserUtil.getBuildProperty("ci.system.status.report.jenkins.cohort"));
        jenkinsCohort.writeDataJavaScriptFile(filePath);
        CISystemStatusReportUtil.appendNodeHistoryDataToJavaScriptFile(filePath);
    }

    public static void writeTestrayDataJavaScriptFile(String filePath, String jobName, final String testSuiteName) throws IOException {
        ArrayList callables = new ArrayList();
        List<File> buildReportJSONFiles = CISystemStatusReportUtil._getBuildReportJSONFiles(jobName);
        for (final File buildReportJSONFile : buildReportJSONFiles) {
            callables.add(new Callable<File>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public File call() throws Exception {
                    File end3;
                    LocalDate localDate;
                    TopLevelBuildReport topLevelBuildReport;
                    long start;
                    block7: {
                        block6: {
                            start = JenkinsResultsParserUtil.getCurrentTimeMillis();
                            JSONObject buildReportJSONObject = JenkinsResultsParserUtil.toJSONObject("file://" + buildReportJSONFile.getPath());
                            topLevelBuildReport = BuildReportFactory.newTopLevelBuildReport(buildReportJSONObject);
                            if (topLevelBuildReport != null && Objects.equals(testSuiteName, topLevelBuildReport.getTestSuiteName())) break block6;
                            File file = null;
                            long end2 = JenkinsResultsParserUtil.getCurrentTimeMillis();
                            System.out.println(JenkinsResultsParserUtil.combine(JenkinsResultsParserUtil.getCanonicalPath(buildReportJSONFile), " processed in ", JenkinsResultsParserUtil.toDurationString(end2 - start)));
                            return file;
                        }
                        localDate = JenkinsResultsParserUtil.getLocalDate(topLevelBuildReport.getStartDate());
                        if (_results.containsKey(localDate)) break block7;
                        File end2 = null;
                        long end3 = JenkinsResultsParserUtil.getCurrentTimeMillis();
                        System.out.println(JenkinsResultsParserUtil.combine(JenkinsResultsParserUtil.getCanonicalPath(buildReportJSONFile), " processed in ", JenkinsResultsParserUtil.toDurationString(end3 - start)));
                        return end2;
                    }
                    try {
                        List results = (List)_results.get(localDate);
                        results.add(new Result(topLevelBuildReport));
                        end3 = buildReportJSONFile;
                    }
                    catch (Exception exception) {
                        File file;
                        try {
                            RuntimeException runtimeException = new RuntimeException(JenkinsResultsParserUtil.getCanonicalPath(buildReportJSONFile), exception);
                            runtimeException.printStackTrace();
                            file = null;
                        }
                        catch (Throwable throwable) {
                            long end4 = JenkinsResultsParserUtil.getCurrentTimeMillis();
                            System.out.println(JenkinsResultsParserUtil.combine(JenkinsResultsParserUtil.getCanonicalPath(buildReportJSONFile), " processed in ", JenkinsResultsParserUtil.toDurationString(end4 - start)));
                            throw throwable;
                        }
                        long end5 = JenkinsResultsParserUtil.getCurrentTimeMillis();
                        System.out.println(JenkinsResultsParserUtil.combine(JenkinsResultsParserUtil.getCanonicalPath(buildReportJSONFile), " processed in ", JenkinsResultsParserUtil.toDurationString(end5 - start)));
                        return file;
                    }
                    long end6 = JenkinsResultsParserUtil.getCurrentTimeMillis();
                    System.out.println(JenkinsResultsParserUtil.combine(JenkinsResultsParserUtil.getCanonicalPath(buildReportJSONFile), " processed in ", JenkinsResultsParserUtil.toDurationString(end6 - start)));
                    return end3;
                }
            });
        }
        ParallelExecutor parallelExecutor = new ParallelExecutor(callables, _executorService, "writeTestrayDataJavaScriptFile");
        try {
            parallelExecutor.execute();
        }
        catch (TimeoutException timeoutException) {
            throw new RuntimeException(timeoutException);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("var relevantSuiteBuildData = ");
        sb.append(CISystemStatusReportUtil._getRelevantSuiteBuildDataJSONObject());
        sb.append("\nvar topLevelTotalBuildDurationData = ");
        sb.append(CISystemStatusReportUtil._getTopLevelTotalBuildDurationJSONObject());
        sb.append("\nvar topLevelActiveBuildDurationData = ");
        sb.append(CISystemStatusReportUtil._getTopLevelActiveBuildDurationJSONObject());
        sb.append("\nvar downstreamBuildDurationData = ");
        sb.append(CISystemStatusReportUtil._getDownstreamBuildDurationJSONObject());
        sb.append("\nvar testrayDataGeneratedDate = new Date(");
        sb.append(JenkinsResultsParserUtil.getCurrentTimeMillis());
        sb.append(");");
        sb.append("\nvar successRateData = ");
        sb.append(CISystemStatusReportUtil._getSuccessRateDataJSONArray());
        sb.append(";");
        JenkinsResultsParserUtil.write(filePath, sb.toString());
    }

    protected static String getPercentage(Integer dividend, Integer divisor) {
        double quotient = 0.0;
        if (divisor != 0) {
            quotient = (double)dividend.intValue() / (double)divisor.intValue();
        }
        DecimalFormat decimalFormat = new DecimalFormat("###.##%");
        return decimalFormat.format(quotient);
    }

    private static List<File> _getBuildReportJSONFiles(String jobName) {
        ArrayList<File> buildReportJSONFiles = new ArrayList<File>();
        for (String dateString : _dateStrings) {
            Process process;
            File testrayLogsDateDir = new File(_TESTRAY_LOGS_DIR, dateString);
            if (!testrayLogsDateDir.exists()) continue;
            try {
                process = JenkinsResultsParserUtil.executeBashCommands(true, _TESTRAY_LOGS_DIR, 3600000L, JenkinsResultsParserUtil.combine("find ", dateString, "/*/", JenkinsResultsParserUtil.escapeForBash(jobName), "/*/build-report.json -mtime -15"));
            }
            catch (IOException | TimeoutException exception) {
                continue;
            }
            int exitValue = process.exitValue();
            if (exitValue != 0) continue;
            String output = null;
            try {
                output = JenkinsResultsParserUtil.readInputStream(process.getInputStream());
                output = output.replace("Finished executing Bash commands.\n", "");
                output = output.trim();
            }
            catch (IOException ioException) {
                continue;
            }
            if (JenkinsResultsParserUtil.isNullOrEmpty(output)) continue;
            for (String buildReportJSONFilePath : output.split("\n")) {
                buildReportJSONFiles.add(new File(_TESTRAY_LOGS_DIR, buildReportJSONFilePath));
            }
        }
        return buildReportJSONFiles;
    }

    private static JSONObject _getDownstreamBuildDurationJSONObject() {
        JSONObject datesDurationsJSONObject = new JSONObject();
        JSONArray datesJSONArray = new JSONArray();
        JSONArray durationsJSONArray = new JSONArray();
        ArrayList<LocalDate> localDates = new ArrayList<LocalDate>(_results.keySet());
        Collections.sort(localDates);
        for (LocalDate localDate : localDates) {
            ArrayList<Long> durations = new ArrayList<Long>();
            for (Result result : _results.get(localDate)) {
                durations.addAll(result.getDownstreamDuration());
            }
            durations.removeAll(Collections.singleton(null));
            if (durations.isEmpty()) {
                datesJSONArray.put((Object)localDate.toString());
            } else {
                String meanDuration = JenkinsResultsParserUtil.combine("mean: ", JenkinsResultsParserUtil.toDurationString(JenkinsResultsParserUtil.getAverage(durations)));
                datesJSONArray.put((Object)new String[]{localDate.toString(), meanDuration});
            }
            Collections.sort(durations);
            durationsJSONArray.put(durations);
        }
        datesDurationsJSONObject.put("dates", (Object)datesJSONArray).put("durations", (Object)durationsJSONArray);
        return datesDurationsJSONObject;
    }

    private static JSONObject _getRelevantSuiteBuildDataJSONObject() {
        JSONObject relevantSuiteBuildDataJSONObject = new JSONObject();
        JSONArray datesJSONArray = new JSONArray();
        JSONArray failedBuildsJSONArray = new JSONArray();
        JSONArray passedBuildsJSONArray = new JSONArray();
        JSONArray unstableBuildsJSONArray = new JSONArray();
        ArrayList<LocalDate> localDates = new ArrayList<LocalDate>(_results.keySet());
        Collections.sort(localDates);
        for (LocalDate localDate : localDates) {
            int failedBuilds = 0;
            int passedBuilds = 0;
            int unstableBuilds = 0;
            for (Result result : _results.get(localDate)) {
                String topLevelResult = result.getTopLevelResult();
                if (topLevelResult.equals("FAILURE")) {
                    ++failedBuilds;
                    continue;
                }
                if (topLevelResult.equals("SUCCESS")) {
                    ++passedBuilds;
                    continue;
                }
                if (!topLevelResult.equals("APPROVED")) continue;
                ++unstableBuilds;
            }
            datesJSONArray.put((Object)localDate.toString());
            failedBuildsJSONArray.put(failedBuilds);
            passedBuildsJSONArray.put(passedBuilds);
            unstableBuildsJSONArray.put(unstableBuilds);
        }
        relevantSuiteBuildDataJSONObject.put("dates", (Object)datesJSONArray).put("failed", (Object)failedBuildsJSONArray).put("succeeded", (Object)passedBuildsJSONArray).put("unstable", (Object)unstableBuildsJSONArray);
        return relevantSuiteBuildDataJSONObject;
    }

    private static long _getReportDurationDays() {
        String reportDurationDays = _buildProperties.getProperty("report.duration.days");
        return Long.parseLong(reportDurationDays);
    }

    private static JSONArray _getSuccessRateDataJSONArray() {
        JSONArray successRateDataJSONArray = new JSONArray();
        JSONArray titlesJSONArray = new JSONArray();
        titlesJSONArray.put((Object)"Time Period");
        titlesJSONArray.put((Object)"Adjusted Success Rate");
        titlesJSONArray.put((Object)"Success Rate");
        titlesJSONArray.put((Object)"Builds Run");
        successRateDataJSONArray.put((Object)titlesJSONArray);
        LocalDateTime currentLocalDateTime = LocalDateTime.now(ZoneOffset.UTC);
        successRateDataJSONArray.put((Object)CISystemStatusReportUtil._getSuccessRateJSONArray("Last 24 Hours", currentLocalDateTime.minusDays(1L), currentLocalDateTime));
        successRateDataJSONArray.put((Object)CISystemStatusReportUtil._getSuccessRateJSONArray("Last 7 Days", currentLocalDateTime.minusDays(7L), currentLocalDateTime));
        successRateDataJSONArray.put((Object)CISystemStatusReportUtil._getSuccessRateJSONArray("Previous 7 Days", currentLocalDateTime.minusDays(14L), currentLocalDateTime.minusDays(7L)));
        return successRateDataJSONArray;
    }

    private static JSONArray _getSuccessRateJSONArray(String title, LocalDateTime startLocalDateTime, LocalDateTime endLocalDateTime) {
        if (startLocalDateTime.compareTo(endLocalDateTime) >= 0) {
            throw new IllegalArgumentException("Start time must preceed end time");
        }
        HashSet<LocalDate> localDates = new HashSet<LocalDate>();
        int i = 0;
        while (startLocalDateTime.compareTo(endLocalDateTime.minusDays(i)) <= 0) {
            LocalDateTime localDateTime = endLocalDateTime.minusDays(i);
            localDates.add(localDateTime.toLocalDate());
            ++i;
        }
        int failedBuilds = 0;
        int passedBuilds = 0;
        int unstableBuilds = 0;
        for (LocalDate localDate : localDates) {
            for (Result result : _results.get(localDate)) {
                LocalDateTime localDateTime = JenkinsResultsParserUtil.getLocalDateTime(result.getTopLevelStartDate());
                if (startLocalDateTime.compareTo(localDateTime) >= 0 || endLocalDateTime.compareTo(localDateTime) <= 0) continue;
                String topLevelResult = result.getTopLevelResult();
                if (topLevelResult.equals("FAILURE")) {
                    ++failedBuilds;
                    continue;
                }
                if (topLevelResult.equals("SUCCESS")) {
                    ++passedBuilds;
                    continue;
                }
                if (!topLevelResult.equals("APPROVED")) continue;
                ++unstableBuilds;
            }
        }
        int totalBuilds = failedBuilds + passedBuilds + unstableBuilds;
        JSONArray successRateJSONArray = new JSONArray();
        successRateJSONArray.put((Object)title);
        successRateJSONArray.put((Object)CISystemStatusReportUtil.getPercentage(passedBuilds + unstableBuilds, totalBuilds));
        successRateJSONArray.put((Object)CISystemStatusReportUtil.getPercentage(passedBuilds, totalBuilds));
        successRateJSONArray.put(totalBuilds);
        return successRateJSONArray;
    }

    private static JSONObject _getTopLevelActiveBuildDurationJSONObject() {
        JSONObject jsonObject = new JSONObject();
        JSONArray datesJSONArray = new JSONArray();
        JSONArray durationsJSONArray = new JSONArray();
        ArrayList<LocalDate> dates = new ArrayList<LocalDate>(_results.keySet());
        Collections.sort(dates);
        for (LocalDate date : dates) {
            ArrayList<Long> durations = new ArrayList<Long>();
            for (Result result : _results.get(date)) {
                long duration = result.getTopLevelActiveDuration();
                if (duration < 0L) continue;
                durations.add(duration);
            }
            durations.removeAll(Collections.singleton(null));
            if (durations.isEmpty()) {
                datesJSONArray.put((Object)date.toString());
            } else {
                String meanDuration = JenkinsResultsParserUtil.combine("mean: ", JenkinsResultsParserUtil.toDurationString(JenkinsResultsParserUtil.getAverage(durations)));
                datesJSONArray.put((Object)new String[]{date.toString(), meanDuration});
            }
            Collections.sort(durations);
            durationsJSONArray.put(durations);
        }
        jsonObject.put("dates", (Object)datesJSONArray).put("durations", (Object)durationsJSONArray);
        return jsonObject;
    }

    private static JSONObject _getTopLevelTotalBuildDurationJSONObject() {
        JSONObject jsonObject = new JSONObject();
        JSONArray datesJSONArray = new JSONArray();
        JSONArray durationsJSONArray = new JSONArray();
        ArrayList<LocalDate> dates = new ArrayList<LocalDate>(_results.keySet());
        Collections.sort(dates);
        for (LocalDate date : dates) {
            ArrayList<Long> durations = new ArrayList<Long>();
            for (Result result : _results.get(date)) {
                long duration = result.getTopLevelDuration();
                if (duration < 0L) continue;
                durations.add(duration);
            }
            durations.removeAll(Collections.singleton(null));
            if (durations.isEmpty()) {
                datesJSONArray.put((Object)date.toString());
            } else {
                String meanDuration = JenkinsResultsParserUtil.combine("mean: ", JenkinsResultsParserUtil.toDurationString(JenkinsResultsParserUtil.getAverage(durations)));
                datesJSONArray.put((Object)new String[]{date.toString(), meanDuration});
            }
            Collections.sort(durations);
            durationsJSONArray.put(durations);
        }
        jsonObject.put("dates", (Object)datesJSONArray).put("durations", (Object)durationsJSONArray);
        return jsonObject;
    }

    private static void _mergeJSONArraysInJSONObjects(JSONObject jsonObject1, JSONObject jsonObject2, String[] keys) {
        for (String key : keys) {
            JSONArray jsonArray = jsonObject1.getJSONArray(key);
            jsonArray.putAll(jsonObject2.getJSONArray(key));
        }
    }

    static {
        _NODE_METRIC_NAMES = new String[]{"idle_nodes", "occupied_nodes", "offline_nodes", "online_nodes", "queued_builds", "timestamps"};
        _dateStrings = new ArrayList<String>();
        _executorService = JenkinsResultsParserUtil.getNewThreadPoolExecutor(20, true);
        _results = new HashMap<LocalDate, List<Result>>(){
            {
                LocalDate localDate = LocalDate.now(ZoneOffset.UTC);
                for (int i = 0; i <= 14; ++i) {
                    this.put(localDate.minusDays(i), new ArrayList());
                }
            }
        };
        for (LocalDate localDate : _results.keySet()) {
            String dateString = localDate.format(DateTimeFormatter.ofPattern("yyyy-MM"));
            if (_dateStrings.contains(dateString)) continue;
            _dateStrings.add(dateString);
        }
        _buildProperties = new Properties(){
            {
                try {
                    this.putAll((Map<?, ?>)JenkinsResultsParserUtil.getBuildProperties());
                }
                catch (IOException ioException) {
                    throw new RuntimeException(ioException);
                }
            }
        };
        _CI_SYSTEM_STATUS_REPORT_DIR = new File(_buildProperties.getProperty("ci.system.status.report.dir"));
        _TESTRAY_LOGS_DIR = new File(_buildProperties.getProperty("google.cloud.bucket.local.dir[testray]"));
        _TMP_BASE_DIR = new File(_buildProperties.getProperty("archive.ci.build.data.tmp.dir"), "nodes");
    }

    private static class Result {
        private final List<Long> _downstreamDurations = new ArrayList<Long>();
        private final Long _topLevelActiveDuration;
        private final Long _topLevelDuration;
        private final String _topLevelResult;
        private final Date _topLevelStartDate;

        public List<Long> getDownstreamDuration() {
            return this._downstreamDurations;
        }

        public Long getTopLevelActiveDuration() {
            return this._topLevelActiveDuration;
        }

        public Long getTopLevelDuration() {
            return this._topLevelDuration;
        }

        public String getTopLevelResult() {
            return this._topLevelResult;
        }

        public Date getTopLevelStartDate() {
            return this._topLevelStartDate;
        }

        private Result(TopLevelBuildReport topLevelBuildReport) {
            this._topLevelActiveDuration = topLevelBuildReport.getTopLevelActiveDuration();
            this._topLevelDuration = topLevelBuildReport.getDuration();
            this._topLevelResult = topLevelBuildReport.getResult();
            this._topLevelStartDate = topLevelBuildReport.getStartDate();
            for (DownstreamBuildReport downstreamBuildReport : topLevelBuildReport.getDownstreamBuildReports()) {
                long downstreamDuration = downstreamBuildReport.getDuration();
                if (downstreamDuration <= 0L) continue;
                this._downstreamDurations.add(downstreamDuration);
            }
        }
    }
}

