/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeoutException;

public class CloudStorageSyncUtil {
    public static final String GCP_BUCKET_PATH_JENKINS_CI_DATA = "gs://jenkins-ci-data";
    public static final String GCP_BUCKET_PATH_PATCHER_SHARED = "gs://patcher-shared";
    public static final String GCP_BUCKET_PATH_TESTRAY_RESULTS = "gs://testray-results";
    private static final Properties _buildProperties = new Properties(){
        {
            try {
                this.putAll((Map<?, ?>)JenkinsResultsParserUtil.getBuildProperties());
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
        }
    };

    public static void copyGCPFile(String source, String destination) {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(CloudStorageSyncUtil._getGCPAuthenticationCommand(source, destination));
        StringBuilder sb = new StringBuilder();
        sb.append("gcloud storage cp ");
        sb.append(source);
        sb.append(" ");
        sb.append(destination);
        commands.add(sb.toString());
        CloudStorageSyncUtil._executeCommands(commands.toArray(new String[0]));
    }

    public static void syncGCPFiles(String source, String destination) {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(CloudStorageSyncUtil._getGCPAuthenticationCommand(source, destination));
        StringBuilder sb = new StringBuilder();
        sb.append("gcloud storage rsync --recursive ");
        sb.append(source);
        sb.append(" ");
        sb.append(destination);
        commands.add(sb.toString());
        CloudStorageSyncUtil._executeCommands(commands.toArray(new String[0]));
    }

    private static void _executeCommands(String ... commands) {
        try {
            Process process = JenkinsResultsParserUtil.executeBashCommands(600000L, commands);
            System.out.println(JenkinsResultsParserUtil.readInputStream(process.getInputStream()));
            if (process.exitValue() != 0) {
                System.out.println(JenkinsResultsParserUtil.readInputStream(process.getErrorStream()));
                throw new RuntimeException("Unable to sync directories");
            }
        }
        catch (IOException | TimeoutException exception) {
            System.out.println("Unable to sync directories");
            throw new RuntimeException(exception);
        }
    }

    private static String _getGCPAuthenticationCommand(String source, String destination) {
        StringBuilder sb = new StringBuilder();
        sb.append("gcloud auth activate-service-account --key-file ");
        if (source.startsWith(GCP_BUCKET_PATH_JENKINS_CI_DATA) || destination.startsWith(GCP_BUCKET_PATH_JENKINS_CI_DATA)) {
            sb.append(_buildProperties.getProperty("google.application.crendential.file[jenkins]"));
            return sb.toString();
        }
        if (source.startsWith(GCP_BUCKET_PATH_PATCHER_SHARED) || destination.startsWith(GCP_BUCKET_PATH_PATCHER_SHARED)) {
            sb.append(_buildProperties.getProperty("google.application.crendential.file[patcher]"));
            return sb.toString();
        }
        if (source.startsWith(GCP_BUCKET_PATH_TESTRAY_RESULTS) || destination.startsWith(GCP_BUCKET_PATH_TESTRAY_RESULTS)) {
            sb.append(_buildProperties.getProperty("google.application.crendential.file[testray]"));
            return sb.toString();
        }
        return null;
    }
}

